#!/usr/bin/env python3

import gi
gi.require_version('Gtk', '3.0')
from gi.repository import Gtk

class InfoDialog(Gtk.Window):
    def __init__(self, parent, package_name, info_type, info_text):
        super().__init__(title=f"{info_type} for {package_name}")
        self.set_transient_for(parent)
        self.set_modal(True)
        self.set_default_size(500, 400)
        self.set_position(Gtk.WindowPosition.CENTER_ON_PARENT)

        vbox = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=6)
        vbox.set_border_width(6)

        scrolled_window = Gtk.ScrolledWindow()
        scrolled_window.set_hexpand(True)
        scrolled_window.set_vexpand(True)

        textview = Gtk.TextView()
        textview.set_editable(False)
        textview.set_cursor_visible(False)
        buffer = textview.get_buffer()
        buffer.set_text(info_text)

        scrolled_window.add(textview)
        vbox.pack_start(scrolled_window, True, True, 0)

        close_button = Gtk.Button.new_from_icon_name("", Gtk.IconSize.BUTTON)
        close_button.set_label("❌️ Close")
        close_button.connect("clicked", lambda x: self.destroy())

        vbox.pack_start(close_button, False, False, 0)

        self.add(vbox)
        self.show_all()
