%define distrib UfficioZero
%define version 2026
%define rel 1
%define distname UfficioZero
%define distsuffix UfficioZero
%define distribution UfficioZero
%define lc_distro %(echo %{distribution} | tr "A-Z" "a-z")

%define product_vendor UfficioZero
%define product_distribution %distribution
%define product_type Basic
%define product_version %version
%define product_branch Stable
%define product_release 2026
%define product_arch %{_target_cpu}
%define product_product Free

%define product_id vendor=%product_vendor,distribution=%product_distribution,type=%product_type,version=%product_version,branch=%product_branch,release=%product_release,arch=%product_arch,product=%product_product

#Maintain backwards compatibility here
%define mandriva_release %version
%define mandriva_branch %distrib
%define mandriva_arch %_target_cpu
%define mandriva_os %_target_os
%define realversion %version
%define mdkver %(echo %version)00
%define macrofile %build_sysmacrospath

Summary:	UfficioZero release file
Name:		UfficioZero-release
Version:	%version
Release:	%mkrel %rel
License:	GPL3
URL:		https://www.ufficiozero.org
Group:		System/Configuration/Other
Source:		%name.tar.xz
Source1:	10%name.sh
Source2:	10%name.csh
Obsoletes:	rawhide-release redhat-release mandrake-release mandrakelinux-release mandriva-release mandriva-release-One pclinuxos-release
Provides:	redhat-release rawhide-release mandrake-release mandrakelinux-release mandriva-release mandriva-release-One pclinuxos-release UfficioZero-release
# Generic Provides for package managers to identify distribution release versions
Provides:	system-release
Provides:	system-release(%{version})
Provides:	system-release(releasever) = %{version}
BuildRoot:	%{_tmppath}/%{name}-root


%description
UfficioZero Linux release file.

%prep
%setup -q -n %{name}

# check that CREDITS file is in UTF-8, fail otherwise
if iconv -f utf-8 -t utf-8 < CREDITS > /dev/null
then
	true
else
	echo "the CREDITS file *MUST* be encoded in UTF-8"
	echo "please fix it before continuing"
	false
fi

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p %buildroot/etc
echo "UfficioZero release %{realversion} (%{distrib}) for %{_target_cpu}" > $RPM_BUILD_ROOT/etc/UfficioZero-release
ln -sf UfficioZero-release $RPM_BUILD_ROOT/etc/redhat-release
ln -sf UfficioZero-release $RPM_BUILD_ROOT/etc/mandrake-release
ln -sf UfficioZero-release $RPM_BUILD_ROOT/etc/release
ln -sf UfficioZero-release $RPM_BUILD_ROOT/etc/mandrakelinux-release
ln -sf UfficioZero-release $RPM_BUILD_ROOT/etc/mandriva-release
ln -sf UfficioZero-release $RPM_BUILD_ROOT/etc/release
echo "%{version} %{rel} %{distname}" > $RPM_BUILD_ROOT/etc/version

cat > %buildroot/etc/product.id << EOF
%product_id
EOF

# Generate standardized cross-distro os-release file for os-prober and other tools
# N.B.: Derivatives should adjust ID_LIKE to be `ID_LIKE="pclinuxos mandriva"`
mkdir -p %{buildroot}%{_prefix}/lib
cat >%{buildroot}%{_prefix}/lib/os-release <<EOF
NAME="%{distribution}"
VERSION="%{version}"
ID=%{lc_distro}
VERSION_ID=%{version}
ID_LIKE="mandriva"
PRETTY_NAME="%{distribution} %{version}"
ANSI_COLOR="1;37"
HOME_URL="https://www.ufficiozero.org/"
SUPPORT_URL="https://www.ufficiozero.org/"
EOF

# Compatibility symlink
ln -sr %{buildroot}%{_prefix}/lib/os-release %{buildroot}%{_sysconfdir}/os-release


mkdir -p %buildroot%_sys_macros_dir
cat > %buildroot%macrofile <<EOF
%%distribution      %distribution
%%mandriva_release  %mandriva_release
%%mandriva_branch   %mandriva_branch
%%mandriva_arch     %mandriva_arch
%%mandriva_os       %mandriva_os
%%mandriva_class    %%(. %_sysconfdir/sysconfig/system; echo \$META_CLASS)
%%mdkver            %mdkver
%%mdvver            %mdkver
%%mdkversion        %mdkver
%%distsuffix        %distsuffix

# productid variable
%%product_id %product_id

%%product_vendor        %product_vendor
%%product_distribution  %product_distribution
%%product_type          %product_type
%%product_version       %product_version
%%product_branch        %product_branch
%%product_release       %product_release
%%product_arch          %product_arch
%%product_product       %product_product

%{?unstable}
EOF

##temp hack make the rpmbuild system happy
ln -sf %macrofile $RPM_BUILD_ROOT/etc/rpm/macros.d/mandriva-release.macros

mkdir -p %buildroot/etc/sysconfig
cat > %buildroot/etc/sysconfig/system <<EOF
CLASS=beginner
SECURITY=3
LIBSAFE=no
META_CLASS=desktop
EOF

mkdir -p %buildroot%_sysconfdir/profile.d
install -m755 %SOURCE1 %SOURCE2 %buildroot%_sysconfdir/profile.d


%clean
rm -rf $RPM_BUILD_ROOT


%pre
rm -rf /etc/sysconfig/system

%posttrans
if [ ! -f /etc/sysconfig/system ]; then
cat > /etc/sysconfig/system <<EOF
CLASS=beginner
SECURITY=3
LIBSAFE=no
META_CLASS=desktop
EOF
fi

%files
%defattr(-,root,root)
%doc CREDITS release-notes.txt LICENSE.md
/etc/mandrake-release
/etc/mandrakelinux-release
/etc/redhat-release
/etc/mandriva-release
/etc/UfficioZero-release
/etc/release
/etc/version
/etc/product.id
/usr/lib/os-release
/etc/os-release
/etc/profile.d/10%name.sh
/etc/profile.d/10%name.csh
/etc/sysconfig/system
/etc/rpm/macros.d/mandriva-release.macros
%macrofile


%changelog
* Mon Dec 15 2025 adrianomorselli <dev@ufficiozero.org> 2026-1ufficiozero2025
- new release

* Fri Dec 18 2024 adrianomorselli <dev@ufficiozero.org> 2025-1ufficiozero2024
-  new release

* Fri Dec 1 2023 adrianomorselli <dev@ufficiozero.org> 2024-1ufficiozero2023
- It is time for a new release

* Tue Apr 18 2023 adrianomorselli <dev@ufficiozero.org> 2023-2ufficiozero2023
- add gpl3 license

* Thu Dec 01 2022 adrianomorselli <dev@ufficiozero.org> 2023-1ufficiozero2022
- new year

* Thu Dec 02 2021 adrianomorselli <dev@ufficiozero.org> 2022-4ufficiozero2021
- it's time for new year

* Wed Nov 10 2021 adrianomorselli <dev@ufficiozero.org> 2021-3ufficiozero2021
- we need os-release for mylivecd

* Mon Dec 21 2020 adrianomorselli <adrianomorselli> 2021-1UfficioZero2021
- 1st create for UfficioZero
