#!/usr/bin/env python3

import gi
import subprocess
import os
import sys
import threading

os.environ['GTK_THEME'] = 'Adwaita'  # Forza tema GTK

gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GdkPixbuf, GLib

class AppInstaller(Gtk.Window):
    def __init__(self):
        Gtk.Window.__init__(self, title="UfficioZero Flatpak Installer")
        self.set_default_size(900, 600)

        self.categories = {
            "Scuola Primaria": [
                {
                    "name": "GCompris",
                    "description": "Suite educativa con oltre 100 attività per imparare giocando.",
                    "icon": "icons/GCompris.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.gcompris"
                },
                {
                    "name": "Kalgebra",
                    "description": "Calcolatrice grafica per algebra e funzioni.",
                    "icon": "icons/Kalgebra.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kalgebra"
                },
                {
                    "name": "Blinken",
                    "description": "Gioco di memoria con sequenze luminose.",
                    "icon": "icons/Blinken.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.blinken"
                },
                {
                    "name": "KBruch",
                    "description": "Esercizi interattivi per imparare e praticare le frazioni.",
                    "icon": "icons/KBruch.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kbruch"
                },
                {
                    "name": "KGeography",
                    "description": "Esplora e impara la geografia con mappe interattive e quiz sui paesi.",
                    "icon": "icons/KGeography.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kgeography"
                },
                {
                    "name": "KLettres",
                    "description": "Impara le lettere e i suoni di diverse lingue in modo semplice e divertente.",
                    "icon": "icons/KLettres.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.klettres"
                },
                {
                    "name": "KTurtle",
                    "description": "Un modo divertente per muovere i primi passi nella programmazione disegnando con la tartaruga.",
                    "icon": "icons/KTurtle.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kturtle"
                },
                {
                    "name": "TuxGuitar",
                    "description": "TuxGuitar è un editor di tablature gratuito e open-source, che consente di creare, modificare e convertire spartiti e tablature per chitarra, supportando diversi formati tra cui Guitar Pro e MIDI.",
                    "icon": "icons/TuxGuitar.png",
                    "command": "flatpak install -y --noninteractive flathub ar.com.tuxguitar.TuxGuitar"
                },
              
                {
                    "name": "MuseScore",
                    "description": "MuseScore è un potente software open source per scrivere, ascoltare, stampare e condividere spartiti musicali in modo facile e professionale.",
                    "icon": "icons/MuseScore.png",
                    "command": "flatpak install -y --noninteractive flathub org.musescore.MuseScore"
                },
                {
                    "name": "Fablemaker",
                    "description": "Entra nel mondo delle favole di Esopo e crea storie interattive personalizzando testi, suoni e immagini.",
                    "icon": "icons/Fablemaker.png",
                    "command": "flatpak install -y --noninteractive flathub com.endlessnetwork.fablemaker"
                },
                {
                    "name": "The White House",
                    "description": "Scopri i segreti della città colorandola con la programmazione in CSS: impara divertendoti tra oggetti nascosti e indizi da svelare",
                    "icon": "icons/TheWhiteHouse.png",
                    "command": "flatpak install -y --noninteractive flathub com.endlessnetwork.whitehouse"
                },
                {
                    "name": "Tux Paint",
                    "description": "Tux Paint è un programma di disegno pensato per bambini dai 3 ai 12 anni, con interfaccia semplice, effetti sonori divertenti e un simpatico pinguino guida.",
                    "icon": "icons/TuxPaint.png",
                    "command": "flatpak install -y --noninteractive flathub org.tuxpaint.Tuxpaint"
                },
                {
                    "name": "Fretboard",
                    "description": "Scopri e prova accordi di chitarra su un manico interattivo, ideale per principianti e chitarristi esperti.",
                    "icon": "icons/Fretboard.png",
                    "command": "flatpak install -y --noninteractive flathub dev.bragefuglseth.Fretboard"
                },
                {
                    "name": "Keypunch",
                    "description": "Allena la digitazione veloce e precisa con esercizi mirati, testi personalizzabili e supporto multilingue.",
                    "icon": "icons/Keypunch.png",
                    "command": "flatpak install -y --noninteractive flathub dev.bragefuglseth.Keypunch"
                },
                {
                    "name": "Nootka",
                    "description": "Applicazione interattiva per imparare a leggere le note musicali e suonare spartiti classici, con esercizi personalizzabili, riconoscimento accurato delle melodie in tempo reale e supporto per diversi strumenti musicali.",
                    "icon": "icons/Nootka.png",
                    "command": "flatpak install -y --noninteractive flathub net.sf.nootka"
                },
            ],

            "Scuola Secondaria di Primo Grado": [
                {
                    "name": "Artikulate",
                    "description": "Allena la pronuncia in lingue straniere confrontando la tua voce con registrazioni di madrelingua.",
                    "icon": "icons/Artikulate.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.artikulate"
                },
                {
                    "name": "Kalgebra",
                    "description": "Calcolatrice grafica per algebra e funzioni.",
                    "icon": "icons/Kalgebra.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kalgebra"
                },
                {
                    "name": "KBruch",
                    "description": "Esercizi interattivi per imparare e praticare le frazioni.",
                    "icon": "icons/KBruch.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kbruch"
                },
                {
                    "name": "KGeography",
                    "description": "Esplora e impara la geografia con mappe interattive e quiz sui paesi.",
                    "icon": "icons/KGeography.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kgeography"
                },
                {
                    "name": "Cantor",
                    "description": "Interfaccia grafica per fare calcoli matematici e statistici con software come Python, R, Octave e altri ancora",
                    "icon": "icons/Cantor.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.cantor"
                },
                {
                    "name": "Kalzium",
                    "description": "Tavola periodica interattiva con dati, simulazioni, spettro degli elementi e strumenti per la chimica.",
                    "icon": "icons/Kalzium.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kalzium"
                },
                {
                    "name": "Kig",
                    "description": "Esplora e costruisci figure geometriche interattive per imparare e insegnare la geometria dinamicamente.",
                    "icon": "icons/Kig.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kig"
                },
                {
                    "name": "Geogebra",
                    "description": "Disegna grafici, risolvi equazioni e costruisci figure dinamiche per scoprire la matematica in modo visivo",
                    "icon": "icons/Geogebra.png",
                    "command": "flatpak install -y --noninteractive flathub org.geogebra.GeoGebra"
                },
                {
                    "name": "KStars",
                    "description": "Simula il cielo notturno in tempo reale dal tuo desktop, esplora stelle, pianeti e fenomeni astronomici ovunque ti trovi.",
                    "icon": "icons/KStars.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kstars"
                },
                {
                    "name": "Minuet",
                    "description": "Allena l’orecchio musicale con esercizi su intervalli, accordi e scale per migliorare teoria e percezione musicale.",
                    "icon": "icons/Minuet.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.minuet"
                },
                {
                    "name": "MuseScore",
                    "description": "MuseScore è un potente software open source per scrivere, ascoltare, stampare e condividere spartiti musicali in modo facile e professionale.",
                    "icon": "icons/MuseScore.png",
                    "command": "flatpak install -y --noninteractive flathub org.musescore.MuseScore"
                },
                {
                    "name": "KTurtle",
                    "description": "Un modo divertente per muovere i primi passi nella programmazione disegnando con la tartaruga.",
                    "icon": "icons/KTurtle.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kturtle"
                },
                {
                    "name": "TuxGuitar",
                    "description": "TuxGuitar è un editor di tablature gratuito e open-source, che consente di creare, modificare e convertire spartiti e tablature per chitarra, supportando diversi formati tra cui Guitar Pro e MIDI.",
                    "icon": "icons/TuxGuitar.png",
                    "command": "flatpak install -y --noninteractive flathub ar.com.tuxguitar.TuxGuitar"
                },         
                {
                    "name": "Kanagram",
                    "description": "Gioco educativo di anagrammi dove riordinare le lettere per formare parole, con aiuti, livelli personalizzabili e interfaccia adatta per gli alunni.",
                    "icon": "icons/Kanagram.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kanagram"
                },
                {
                    "name": "The Passage",
                    "description": "Un'avventura a scorrimento dove hackerare è la chiave per superare ostacoli e scoprire il bunker nascosto.",
                    "icon": "icons/ThePassage.png",
                    "command": "flatpak install -y --noninteractive flathub com.endlessnetwork.passage"
                },
                {
                    "name": "Dragon’s Apprentice",
                    "description": "Esplora, risolvi enigmi e risveglia il potere del drago per sconfiggere le forze oscure.",
                    "icon": "icons/DragonsApprentice.png",
                    "command": "flatpak install -y --noninteractive flathub com.endlessnetwork.dragonsapprentice"
                },
                {
                    "name": "Fretboard",
                    "description": "Scopri e prova accordi di chitarra su un manico interattivo, ideale per principianti e chitarristi esperti.",
                    "icon": "icons/Fretboard.png",
                    "command": "flatpak install -y --noninteractive flathub dev.bragefuglseth.Fretboard"
                },
                {
                    "name": "Keypunch",
                    "description": "Allena la digitazione veloce e precisa con esercizi mirati, testi personalizzabili e supporto multilingue.",
                    "icon": "icons/Keypunch.png",
                    "command": "flatpak install -y --noninteractive flathub dev.bragefuglseth.Keypunch"
                },
                {
                    "name": "Nootka",
                    "description": "Applicazione interattiva per imparare a leggere le note musicali e suonare spartiti classici, con esercizi personalizzabili, riconoscimento accurato delle melodie in tempo reale e supporto per diversi strumenti musicali.",
                    "icon": "icons/Nootka.png",
                    "command": "flatpak install -y --noninteractive flathub net.sf.nootka"
                },
                
            ],

            "Scuola Secondaria di Secondo Grado": [
                
                {
                    "name": "Artikulate",
                    "description": "Allena la pronuncia in lingue straniere confrontando la tua voce con registrazioni di madrelingua.",
                    "icon": "icons/Artikulate.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.artikulate"
                },
               
                {
                    "name": "Kalgebra",
                    "description": "Calcolatrice grafica per algebra e funzioni.",
                    "icon": "icons/Kalgebra.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kalgebra"
                },
                {
                    "name": "KGeography",
                    "description": "Esplora e impara la geografia con mappe interattive e quiz sui paesi.",
                    "icon": "icons/KGeography.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kgeography"
                },
                {
                    "name": "Avogadro",
                    "description": "Avogadro è un editor molecolare open source avanzato per modellare e visualizzare strutture chimiche, ideale per chimica computazionale, bioinformatica e scienza dei materiali.",
                    "icon": "icons/Avogadro.png",
                    "command": "flatpak install -y --noninteractive flathub org.openchemistry.Avogadro2"
                },
                {
                    "name": "Cantor",
                    "description": "Interfaccia grafica per fare calcoli matematici e statistici con software come Python, R, Octave e altri ancora",
                    "icon": "icons/Cantor.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.cantor"
                },
                {
                    "name": "Kalzium",
                    "description": "Tavola periodica interattiva con dati, simulazioni, spettro degli elementi e strumenti per la chimica.",
                    "icon": "icons/Kalzium.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kalzium"
                },
                {
                    "name": "LibreCAD",
                    "description": "Crea progetti tecnici in 2D con precisione: LibreCAD è l'app CAD open source ideale per piante, componenti e disegni tecnici.",
                    "icon": "icons/LibreCAD.png",
                    "command": "flatpak install -y --noninteractive flathub org.librecad.librecad"
                },
                {
                    "name": "Kig",
                    "description": "Esplora e costruisci figure geometriche interattive per imparare e insegnare la geometria dinamicamente.",
                    "icon": "icons/Kig.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kig"
                },
                {
                    "name": "Geogebra",
                    "description": "Disegna grafici, risolvi equazioni e costruisci figure dinamiche per scoprire la matematica in modo visivo",
                    "icon": "icons/Geogebra.png",
                    "command": "flatpak install -y --noninteractive flathub org.geogebra.GeoGebra"
                },
                {
                    "name": "QGIS",
                    "description": "Sistema GIS open source per analizzare, visualizzare e gestire dati geografici su mappe interattive.",
                    "icon": "icons/QGIS.png",
                    "command": "flatpak install -y --noninteractive flathub org.qgis.qgis"
                },
                {
                    "name": "Minuet",
                    "description": "Allena l’orecchio musicale con esercizi su intervalli, accordi e scale per migliorare teoria e percezione musicale.",
                    "icon": "icons/Minuet.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.minuet"
                },
                {
                    "name": "KmPlot",
                    "description": "Strumento versatile per disegnare, analizzare e personalizzare grafici di funzioni matematiche.",
                    "icon": "icons/KmPlot.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kmplot"
                },
                {
                    "name": "LabPlot",
                    "description": "Software open source per la creazione di grafici e l’analisi dei dati.",
                    "icon": "icons/LabPlot.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.labplot2"
                },
                {
                    "name": "The Passage",
                    "description": "Un'avventura a scorrimento dove hackerare è la chiave per superare ostacoli e scoprire il bunker nascosto.",
                    "icon": "icons/ThePassage.png",
                    "command": "flatpak install -y --noninteractive flathub com.endlessnetwork.passage"
                },
                {
                    "name": "Dragon’s Apprentice",
                    "description": "Esplora, risolvi enigmi e risveglia il potere del drago per sconfiggere le forze oscure.",
                    "icon": "icons/DragonsApprentice.png",
                    "command": "flatpak install -y --noninteractive flathub com.endlessnetwork.dragonsapprentice"
                },
                {
                    "name": "Fretboard",
                    "description": "Scopri e prova accordi di chitarra su un manico interattivo, ideale per principianti e chitarristi esperti.",
                    "icon": "icons/Fretboard.png",
                    "command": "flatpak install -y --noninteractive flathub dev.bragefuglseth.Fretboard"
                },
                {
                    "name": "KTurtle",
                    "description": "Un modo divertente per muovere i primi passi nella programmazione disegnando con la tartaruga.",
                    "icon": "icons/KTurtle.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kturtle"
                },
                {
                    "name": "Keypunch",
                    "description": "Allena la digitazione veloce e precisa con esercizi mirati, testi personalizzabili e supporto multilingue.",
                    "icon": "icons/Keypunch.png",
                    "command": "flatpak install -y --noninteractive flathub dev.bragefuglseth.Keypunch"
                },
            ],

            "Università": [
                {
                    "name": "Gramps",
                    "description": "Organizza e analizza ricerche genealogiche con strumenti professionali per tracciare persone, eventi e relazioni familiari in modo dettagliato.",
                    "icon": "icons/Gramps.png",
                    "command": "flatpak install -y --noninteractive flathub org.gramps_project.Gramps"
                },
                {
                    "name": "QGIS",
                    "description": "Sistema GIS open source per analizzare, visualizzare e gestire dati geografici su mappe interattive.",
                    "icon": "icons/QGIS.png",
                    "command": "flatpak install -y --noninteractive flathub org.qgis.qgis"
                },
                {
                    "name": "Gephi",
                    "description": "Visualizza e studia reti complesse, come relazioni sociali o dati scientifici, con strumenti di analisi avanzati.",
                    "icon": "icons/Gephi.png",
                    "command": "flatpak install -y --noninteractive flathub org.gephi.Gephi"
                },
                {
                    "name": "Tropy",
                    "description": "Gestisci e descrivi le tue fonti fotografiche d’archivio in modo organizzato ed efficiente, con uno strumento pensato per ricercatori.",
                    "icon": "icons/Tropy.png",
                    "command": "flatpak install -y --noninteractive flathub org.tropy.Tropy"
                },
                {
                    "name": "Geogebra",
                    "description": "Disegna grafici, risolvi equazioni e costruisci figure dinamiche per scoprire la matematica in modo visivo",
                    "icon": "icons/Geogebra.png",
                    "command": "flatpak install -y --noninteractive flathub org.geogebra.GeoGebra"
                },
                {
                    "name": "Zotero",
                    "description": " Gestisci e condividi le tue fonti di ricerca con Zotero: raccogli, organizza, cita e collabora in modo semplice ed efficace.",
                    "icon": "icons/Zotero.png",
                    "command": "flatpak install -y --noninteractive flathub org.zotero.Zotero"
                },
                {
                    "name": "Alexandria",
                    "description": "Lettore minimalista per EPUB, Kindle e fumetti, con segnalibri, temi e annotazioni.",
                    "icon": "icons/Alexandria.png",
                    "command": "flatpak install -y --noninteractive flathub io.github.btpf.alexandria"
                },
                {
                    "name": "Avogadro",
                    "description": "Avogadro è un editor molecolare open source avanzato per modellare e visualizzare strutture chimiche, ideale per chimica computazionale, bioinformatica e scienza dei materiali.",
                    "icon": "icons/Avogadro.png",
                    "command": "flatpak install -y --noninteractive flathub org.openchemistry.Avogadro2"
                },
                {
                    "name": "Code::Blocks",
                    "description": "Ambiente di sviluppo integrato per C, C++ e Fortran, estendibile e compatibile con più compilatori",
                    "icon": "icons/CodeBlocks.png",
                    "command": "flatpak install -y --noninteractive flathub org.codeblocks.codeblocks"
                },
                {
                    "name": "KmPlot",
                    "description": "Strumento versatile per disegnare, analizzare e personalizzare grafici di funzioni matematiche.",
                    "icon": "icons/KmPlot.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kmplot"
                },
                {
                    "name": "LabPlot",
                    "description": "Software open source per la creazione di grafici e l’analisi dei dati.",
                    "icon": "icons/LabPlot.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.labplot2"
                },
                {
                    "name": "GPS Correlate",
                    "description": "GPS Correlate aggiunge automaticamente le coordinate GPS alle foto, sincronizzando l'orario dello scatto con i dati di tracciamento di un dispositivo GPS.",
                    "icon": "icons/GPSCorrelate.png",
                    "command": "flatpak install -y --noninteractive flathub io.github.dfandrich.gpscorrelate"
                },
                {
                    "name": "Manuskript",
                    "description": "Ambiente di scrittura open-source per sviluppare trame, personaggi e capitoli in modo strutturato, con modalità senza distrazioni e strumenti di esportazione.",
                    "icon": "icons/Manuskript.png",
                    "command": "flatpak install -y --noninteractive flathub ch.theologeek.Manuskript"
                },
                {
                    "name": "Texmaker",
                    "description": "Editor LaTeX completo con anteprima PDF integrata, evidenziazione della sintassi e strumenti matematici.",
                    "icon": "icons/Texmaker.png",
                    "command": "flatpak install -y --noninteractive flathub net.xm1math.Texmaker"
                },
                {
                    "name": "GNUOctave",
                    "description": "Ambiente interattivo per calcoli numerici avanzati: GNU Octave è un potente linguaggio simile a Matlab per algebra lineare, grafici, equazioni differenziali e molto altro.",
                    "icon": "icons/GNUOctave.png",
                    "command": "flatpak install -y --noninteractive flathub org.octave.Octave"
                },
                {
                    "name": "Geany",
                    "description": " IDE veloce e leggero con evidenziazione della sintassi, completamento automatico e supporto per molti linguaggi, ideale per ambienti minimali.",
                    "icon": "icons/Geany.png",
                    "command": "flatpak install -y --noninteractive flathub org.geany.Geany"
                },
                {
                    "name": "Kalgebra",
                    "description": "Calcolatrice grafica per algebra e funzioni.",
                    "icon": "icons/Kalgebra.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kalgebra"
                },
                {
                    "name": "Jabref",
                    "description": "JabRef è un'applicazione open source per la gestione di database bibliografici BibTeX e biblatex: ideale per ricercatori, studenti e accademici che vogliono ordinare, citare e trovare facilmente le proprie fonti.",
                    "icon": "icons/Jabref.png",
                    "command": "flatpak install -y --noninteractive flathub org.jabref.jabref"
                },
                {
                    "name": "Cantor",
                    "description": "Interfaccia grafica per fare calcoli matematici e statistici con software come Python, R, Octave e altri ancora",
                    "icon": "icons/Cantor.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.cantor"
                },
                {
                    "name": "Qucs",
                    "description": "Qucs-S è un simulatore di circuiti con interfaccia grafica che supporta SPICE e altri motori di simulazione, ideale per progettare e analizzare circuiti elettronici.",
                    "icon": "icons/Qucs.png",
                    "command": "flatpak install -y --noninteractive flathub io.github.ra3xdh.qucs_s"
                },
                {
                    "name": "PyMOL",
                    "description": "Visualizza e analizza strutture molecolari in 3D con PyMOL, lo strumento open source ideale per la biologia strutturale e la generazione di immagini scientifiche di alta qualità.",
                    "icon": "icons/PyMOL.png",
                    "command": "flatpak install -y --noninteractive flathub org.pymol.PyMOL"
                },
                
                {
                    "name": "LibreCAD",
                    "description": "Crea progetti tecnici in 2D con precisione: LibreCAD è l'app CAD open source ideale per piante, componenti e disegni tecnici.",
                    "icon": "icons/LibreCAD.png",
                    "command": "flatpak install -y --noninteractive flathub org.librecad.librecad"
                },
                {
                    "name": "Rocs",
                    "description": "IDE per la teoria dei grafi: con Rocs puoi creare, visualizzare e analizzare algoritmi su grafi in modo intuitivo usando JavaScript, ideale per studenti e appassionati.",
                    "icon": "icons/Rocs.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.rocs"
                },
                {
                    "name": "Freeplane",
                    "description": "Crea mappe mentali per organizzare idee, gestire progetti e visualizzare conoscenze in modo chiaro ed efficace con Freeplane",
                    "icon": "icons/Freeplane.png",
                    "command": "flatpak install -y --noninteractive flathub org.freeplane.App"
                },
                {
                    "name": "gImageReader",
                    "description": "Interfaccia grafica per Tesseract-OCR: importa immagini e PDF, riconosce il testo e lo esporta in vari formati, con supporto a scansioni, spell check e creazione di documenti ODT o PDF.",
                    "icon": "icons/gImageReader.png",
                    "command": "flatpak install -y --noninteractive flathub io.github.manisandro.gImageReader"
                },
                {
                    "name": "OCRFeeder",
                    "description": "Suite completa per OCR e riconoscimento del layout: analizza immagini e PDF, rileva testi e grafica, e li trasforma in documenti modificabili con un'interfaccia GTK intuitiva.",
                    "icon": "icons/OCRFeeder.png",
                    "command": "flatpak install -y --noninteractive flathub org.gnome.OCRFeeder"
                },
                {
                    "name": "Kalzium",
                    "description": "Tavola periodica interattiva con dati, simulazioni, spettro degli elementi e strumenti per la chimica.",
                    "icon": "icons/Kalzium.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kalzium"
                },
                {
                    "name": "VSCodium",
                    "description": "Ambiente di sviluppo open source e rispettoso della privacy, basato su Visual Studio Code ma senza tracciamenti.",
                    "icon": "icons/VSCodium.png",
                    "command": "flatpak install -y --noninteractive flathub com.vscodium.codium"
                },
                {
                    "name": "Scilab",
                    "description": "Ambiente scientifico completo per calcoli numerici: Scilab offre strumenti per simulazione, visualizzazione 2D/3D, controllo, statistica e modellazione di sistemi dinamici con Xcos.",
                    "icon": "icons/Scilab.png",
                    "command": "flatpak install -y --noninteractive flathub org.scilab.Scilab"
                },
                {
                    "name": "GNU PSPP",
                    "description": "Alternativa libera a SPSS per l’analisi statistica di dati campionari, PSPP supporta regressioni, test, ANOVA e molto altro, senza limiti o licenze da acquistare.",
                    "icon": "icons/GNUPSPP.png",
                    "command": "flatpak install -y --noninteractive flathub org.gnu.pspp"
                },
                {
                    "name": "KBibTeX",
                    "description": "Gestisci le tue bibliografie LaTeX con facilità: KBibTeX consente di modificare, importare, esportare e visualizzare citazioni in diversi formati, con integrazione a editor LaTeX e database online",
                    "icon": "icons/KBibTeX.png",
                    "command": "flatpak install -y --noninteractive flathub org.kde.kbibtex"
                },
                {
                    "name": "Fretboard",
                    "description": "Scopri e prova accordi di chitarra su un manico interattivo, ideale per principianti e chitarristi esperti.",
                    "icon": "icons/Fretboard.png",
                    "command": "flatpak install -y --noninteractive flathub dev.bragefuglseth.Fretboard"
                },
                {
                    "name": "Keypunch",
                    "description": "Allena la digitazione veloce e precisa con esercizi mirati, testi personalizzabili e supporto multilingue.",
                    "icon": "icons/Keypunch.png",
                    "command": "flatpak install -y --noninteractive flathub dev.bragefuglseth.Keypunch"
                },
                {
                    "name": "Zettlr",
                    "description": "Zettlr è un editor Markdown moderno, flessibile e open source, ideale per scrittori, ricercatori e giornalisti: supporta Zettelkasten, citazioni con Zotero e BibTeX, temi personalizzabili e un potente motore di ricerca interno",
                    "icon": "icons/Zettlr.png",
                    "command": "flatpak install -y --noninteractive flathub com.zettlr.Zettlr"
                },
            ],

            "Strumenti per docenti": [
                {
                    "name": "OpenBoard",
                    "description": "OpenBoard è una lavagna interattiva open source per scuole e università, ideale per l’insegnamento con LIM o in configurazioni a doppio schermo con penna e proiettore.",
                    "icon": "icons/OpenBoard.png",
                    "command": "flatpak install -y --noninteractive flathub ch.openboard.OpenBoard"
                },
                {
                    "name": "Freeplane",
                    "description": "Crea mappe mentali per organizzare idee, gestire progetti e visualizzare conoscenze in modo chiaro ed efficace con Freeplane",
                    "icon": "icons/Freeplane.png",
                    "command": "flatpak install -y --noninteractive flathub org.freeplane.App"
                },
                {
                    "name": "Solanum",
                    "description": "Solanum ti aiuta a bilanciare lavoro e pause usando la tecnica del pomodoro: 4 sessioni di lavoro intervallate da pause brevi e una lunga.",
                    "icon": "icons/Solanum.png",
                    "command": "flatpak install -y --noninteractive flathub org.gnome.Solanum"
                },
                
                {
                    "name": "Zettlr",
                    "description": "Zettlr è un editor Markdown moderno, flessibile e open source, ideale per scrittori, ricercatori e giornalisti: supporta Zettelkasten, citazioni con Zotero e BibTeX, temi personalizzabili e un potente motore di ricerca interno",
                    "icon": "icons/Zettlr.png",
                    "command": "flatpak install -y --noninteractive flathub com.zettlr.Zettlr"
                },
                
                
                {
                    "name": "Rustdesk",
                    "description": "RustDesk è una soluzione open source per il controllo remoto sicuro e multipiattaforma, con connessioni P2P cifrate e possibilità di auto-hosting dei dati.",
                    "icon": "icons/Rustdesk.png",
                    "command": "flatpak install -y --noninteractive flathub com.rustdesk.RustDesk"
                    
                },
            ]
        }

        self.selected_commands = []
        self.current_category = "Scuola Primaria"
        self.checkboxes = []

        self.build_ui()

    def build_ui(self):
        vbox = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=6)
        self.add(vbox)

        category_bar = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=6)
        for cat in self.categories.keys():
            button = Gtk.Button(label=cat)
            button.connect("clicked", self.change_category, cat)
            category_bar.pack_start(button, False, False, 0)
        vbox.pack_start(category_bar, False, False, 0)

        self.scrolled = Gtk.ScrolledWindow()
        self.flowbox = Gtk.FlowBox()
        self.flowbox.set_max_children_per_line(4)
        self.flowbox.set_selection_mode(Gtk.SelectionMode.NONE)
        self.scrolled.add(self.flowbox)
        vbox.pack_start(self.scrolled, True, True, 0)

        self.progress = Gtk.ProgressBar()
        vbox.pack_start(self.progress, False, False, 0)

        self.install_button = Gtk.Button(label="Installa Selezionati")
        self.install_button.connect("clicked", self.install_selected)
        vbox.pack_start(self.install_button, False, False, 5)

        self.load_apps(self.current_category)

    def change_category(self, widget, category):
        self.current_category = category
        self.load_apps(category)

    def load_apps(self, category):
        ICON_BASE_PATH = "/usr/share/eduflatpak/icons"
    
        for child in self.flowbox.get_children():
            self.flowbox.remove(child)

        self.checkboxes = []

        for app in self.categories[category]:
            icon_filename = os.path.basename(app["icon"])		
            icon_path = os.path.join(ICON_BASE_PATH, icon_filename)
            
            if not os.path.exists(icon_path):
            	icon_path = os.path.join(ICON_BASE_PATH, "default_icon.png")

            try:
                pixbuf = GdkPixbuf.Pixbuf.new_from_file_at_size(icon_path, 96, 96)
            except Exception as e:
                print(f"Errore caricamento icona {icon_path}: {e}")
                pixbuf = GdkPixbuf.Pixbuf.new_from_file_at_size("icons/default_icon.png", 96, 96)

            image = Gtk.Image.new_from_pixbuf(pixbuf)
            name_label = Gtk.Label(label=app["name"])
            name_label.set_xalign(0.5)
            desc_label = Gtk.Label(label=app["description"])
            desc_label.set_line_wrap(True)
            desc_label.set_xalign(0.5)
            desc_label.set_max_width_chars(30)

            toggle = Gtk.Switch()
            toggle.app_data = app
            self.checkboxes.append(toggle)

            toggle_box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=6)
            toggle_box.pack_start(Gtk.Label(label="Installa"), False, False, 0)
            toggle_box.pack_start(toggle, False, False, 0)

            app_box = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=6, margin=10)
            app_box.set_size_request(200, 220)
            app_box.pack_start(image, False, False, 0)
            app_box.pack_start(name_label, False, False, 0)
            app_box.pack_start(desc_label, False, False, 0)
            app_box.pack_start(toggle_box, False, False, 0)

            frame = Gtk.Frame()
            frame.add(app_box)
            self.flowbox.add(frame)

        self.show_all()

    def install_selected(self, widget):
        self.selected_commands = [cb.app_data["command"] for cb in self.checkboxes if cb.get_active()]
        if not self.selected_commands:
            self.show_dialog("Nessuna app selezionata.")
            return

        self.run_next_install()

    def run_next_install(self):
        if not self.selected_commands:
            self.progress.set_fraction(0)
            self.close_wait_dialog()
            self.show_dialog("Installazioni completate.")
            return

        command = self.selected_commands.pop(0)
        self.progress.set_fraction(0.1)
        self.show_wait_dialog("Installazione in corso...")
        GLib.timeout_add(100, self.install_command, command)

    def install_command(self, command):
        process = subprocess.Popen(
            command,
            shell=True,
            stdout=subprocess.PIPE,
            stderr=subprocess.STDOUT,
            text=True
        )

        def read_output():
            for line in iter(process.stdout.readline, ''):
                print(line.strip())
                GLib.idle_add(self.progress.pulse)
            process.stdout.close()
            process.wait()
            GLib.idle_add(self.close_wait_dialog)
            GLib.idle_add(self.run_next_install)

        threading.Thread(target=read_output).start()
        return False

    def show_dialog(self, message):
        dialog = Gtk.MessageDialog(parent=self, flags=0,
                                   message_type=Gtk.MessageType.INFO,
                                   buttons=Gtk.ButtonsType.OK,
                                   text=message)
        dialog.run()
        dialog.destroy()

    def show_wait_dialog(self, message):
        self.wait_dialog = Gtk.Dialog(title="Attendere", parent=self, flags=0)
        self.wait_dialog.set_modal(True)
        self.wait_dialog.set_default_size(300, 100)

        box = self.wait_dialog.get_content_area()
        label = Gtk.Label(label=message)
        spinner = Gtk.Spinner()
        spinner.start()

        box.pack_start(label, True, True, 10)
        box.pack_start(spinner, True, True, 10)

        self.wait_dialog.show_all()

    def close_wait_dialog(self):
        if hasattr(self, 'wait_dialog'):
            self.wait_dialog.destroy()
            del self.wait_dialog

if __name__ == "__main__":
    

    win = AppInstaller()
    win.connect("destroy", Gtk.main_quit)
    win.show_all()
    Gtk.main()
