/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

public final class Equalizer {
    public static final float BAND_NOT_PRESENT = Float.NEGATIVE_INFINITY;
    public static final Equalizer PASS_THRU_EQ = new Equalizer();
    private static final int BANDS = 32;
    private final float[] settings = new float[32];

    public void setFrom(float[] fArray) {
        this.reset();
        int n = fArray.length > 32 ? 32 : fArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.settings[n2] = this.limit(fArray[n2]);
            ++n2;
        }
    }

    public void setFrom(EQFunction eQFunction) {
        this.reset();
        int n = 32;
        int n2 = 0;
        while (n2 < n) {
            this.settings[n2] = this.limit(eQFunction.getBand(n2));
            ++n2;
        }
    }

    public void setFrom(Equalizer equalizer) {
        if (equalizer != this) {
            this.setFrom(equalizer.settings);
        }
    }

    public void reset() {
        int n = 0;
        while (n < 32) {
            this.settings[n] = 0.0f;
            ++n;
        }
    }

    public int getBandCount() {
        return this.settings.length;
    }

    public float setBand(int n, float f) {
        float f2 = 0.0f;
        if (n >= 0 && n < 32) {
            f2 = this.settings[n];
            this.settings[n] = this.limit(f);
        }
        return f2;
    }

    public float getBand(int n) {
        float f = 0.0f;
        if (n >= 0 && n < 32) {
            f = this.settings[n];
        }
        return f;
    }

    private float limit(float f) {
        if (f == Float.NEGATIVE_INFINITY) {
            return f;
        }
        if (f > 1.0f) {
            return 1.0f;
        }
        if (f < -1.0f) {
            return -1.0f;
        }
        return f;
    }

    float[] getBandFactors() {
        float[] fArray = new float[32];
        int n = 0;
        int n2 = 32;
        while (n < n2) {
            fArray[n] = this.getBandFactor(this.settings[n]);
            ++n;
        }
        return fArray;
    }

    float getBandFactor(float f) {
        if (f == Float.NEGATIVE_INFINITY) {
            return 0.0f;
        }
        float f2 = (float)Math.pow(2.0, f);
        return f2;
    }

    public Equalizer() {
    }

    public Equalizer(float[] fArray) {
        this.setFrom(fArray);
    }

    public Equalizer(EQFunction eQFunction) {
        this.setFrom(eQFunction);
    }

    public static abstract class EQFunction {
        public float getBand(int n) {
            return 0.0f;
        }
    }
}

