/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import configuration.TLanguage;
import database.DBTasks;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ImportDatabaseFrame
extends JFrame {
    private JPanel contentPane;
    private JTextField textFieldPath;
    private JProgressBar progressBarStatus;
    private JFrame mainFrame;
    private JCheckBox chckbxReemplazar;

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ImportDatabaseFrame importDatabaseFrame = new ImportDatabaseFrame();
                    importDatabaseFrame.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public ImportDatabaseFrame() {
        TLanguage.initLanguage("spanish");
        this.mainFrame = this;
        this.setTitle(TLanguage.getString("IMPORT_DATABASE_FRAME.TITLE"));
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 450, 176);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), TLanguage.getString("IMPORT_DATABASE_FRAME.SELECT_SOURCE_FILE"), 4, 2, null, new Color(0, 0, 0)));
        this.contentPane.add(jPanel);
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        JButton jButton = new JButton(TLanguage.getString("IMPORT_DATABASE_FRAME.SELECT"));
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(1);
                int n = jFileChooser.showOpenDialog(ImportDatabaseFrame.this.contentPane);
                if (n == 0) {
                    ImportDatabaseFrame.this.textFieldPath.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        jPanel.add(jButton);
        this.textFieldPath = new JTextField();
        this.textFieldPath.setEditable(false);
        jPanel.add(this.textFieldPath);
        this.textFieldPath.setColumns(24);
        JPanel jPanel2 = new JPanel();
        this.contentPane.add(jPanel2);
        jPanel2.setLayout(new FlowLayout(1, 5, 5));
        this.chckbxReemplazar = new JCheckBox(TLanguage.getString("IMPORT_DATABASE_FRAME.REPLACE"));
        jPanel2.add(this.chckbxReemplazar);
        JPanel jPanel3 = new JPanel();
        this.contentPane.add(jPanel3);
        JButton jButton2 = new JButton(TLanguage.getString("IMPORT_DATABASE_FRAME.IMPORT"));
        jButton2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (ImportDatabaseFrame.this.textFieldPath.getText().equals("")) {
                    JOptionPane.showMessageDialog(ImportDatabaseFrame.this.contentPane, TLanguage.getString("IMPORT_DATABASE_FRAME.DIRECTORY_MUST_BE_SELECTED_WARNING"));
                } else {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ImportDatabaseFrame.this.mainFrame.setEnabled(false);
                            DBTasks.importDB(ImportDatabaseFrame.this.textFieldPath.getText(), ImportDatabaseFrame.this.progressBarStatus, ImportDatabaseFrame.this.chckbxReemplazar.isSelected());
                            JOptionPane.showMessageDialog(ImportDatabaseFrame.this.contentPane, TLanguage.getString("IMPORT_DATABASE_FRAME.IMPORT_OK"));
                            ImportDatabaseFrame.this.mainFrame.setEnabled(true);
                        }
                    });
                    thread.start();
                }
            }
        });
        jPanel3.setLayout(new FlowLayout(1, 5, 5));
        jPanel3.add(jButton2);
        JPanel jPanel4 = new JPanel();
        this.contentPane.add(jPanel4);
        this.progressBarStatus = new JProgressBar();
        this.progressBarStatus.setPreferredSize(new Dimension(420, 30));
        jPanel4.add(this.progressBarStatus);
    }
}

