/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import configuration.TLanguage;
import database.DB;
import database.DBTasks;
import dialogs.AddImageFrame;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class ExportSearchFrame
extends JDialog {
    private JPanel contentPane;
    private JTextField term1TextField;
    private JTextField term2TextField;
    private JTextField term3TextField;
    private JTextField imageNameTextField;
    private DefaultTableModel imageTableModel;
    private String[] imageTableHeader;
    private JTable table;
    private JComboBox AndOr1ComboBox;
    private JComboBox AndOr2ComboBox;
    public static final int IS_INTEGRATED = 0;
    private int mode = -1;
    private String selectedImageName;
    private ExportSearchFrame mainFrame;
    private JProgressBar progressBar;
    private String queryLoaded;

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ExportSearchFrame exportSearchFrame = new ExportSearchFrame();
                    exportSearchFrame.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public ExportSearchFrame(int n) {
        this.mode = n;
        this.init();
    }

    public ExportSearchFrame() {
        this.init();
    }

    private void init() {
        JButton jButton;
        TLanguage.initLanguage("spanish");
        this.imageTableHeader = new String[]{TLanguage.getString("EXPORT_SEARCH_FRAME.TITLE"), TLanguage.getString("EXPORT_SEARCH_FRAME.FILENAME"), TLanguage.getString("EXPORT_SEARCH_FRAME.ASSOCIATED_TERMS")};
        this.mainFrame = this;
        this.setTitle(TLanguage.getString("EXPORT_SEARCH_FRAME.TITLE"));
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 720, 430);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(null, TLanguage.getString("EXPORT_SEARCH_FRAME.KEY_TERMS"), 4, 2, null, null));
        this.contentPane.add(jPanel);
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.term1TextField = new JTextField();
        jPanel.add(this.term1TextField);
        this.term1TextField.setColumns(10);
        this.AndOr1ComboBox = new JComboBox();
        this.AndOr1ComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{TLanguage.getString("EXPORT_SEARCH_FRAME.AND"), TLanguage.getString("EXPORT_SEARCH_FRAME.OR")}));
        jPanel.add(this.AndOr1ComboBox);
        this.term2TextField = new JTextField();
        jPanel.add(this.term2TextField);
        this.term2TextField.setColumns(10);
        this.AndOr2ComboBox = new JComboBox();
        this.AndOr2ComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{TLanguage.getString("EXPORT_SEARCH_FRAME.AND"), TLanguage.getString("EXPORT_SEARCH_FRAME.OR")}));
        jPanel.add(this.AndOr2ComboBox);
        this.term3TextField = new JTextField();
        this.term3TextField.setColumns(10);
        jPanel.add(this.term3TextField);
        JButton jButton2 = new JButton(TLanguage.getString("EXPORT_SEARCH_FRAME.FIND"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!ExportSearchFrame.this.term1TextField.getText().equals("")) {
                    String string = "SELECT COUNT(*) AS row_count, GROUP_CONCAT(main.word) AS terms, main.nameNN AS name FROM main WHERE main.name IN (SELECT main.name FROM main WHERE word LIKE '%" + ExportSearchFrame.this.term1TextField.getText() + "%') ";
                    if (!ExportSearchFrame.this.term2TextField.getText().equals("")) {
                        string = string + (ExportSearchFrame.this.AndOr1ComboBox.getSelectedIndex() == 0 ? " AND " : " OR ");
                        string = string + "main.name IN (SELECT main.name FROM main WHERE word LIKE '%" + ExportSearchFrame.this.term2TextField.getText() + "%')";
                    }
                    if (!ExportSearchFrame.this.term3TextField.getText().equals("")) {
                        string = string + (ExportSearchFrame.this.AndOr2ComboBox.getSelectedIndex() == 0 ? " AND " : " OR ");
                        string = string + "main.name IN (SELECT main.name FROM main WHERE word LIKE '%" + ExportSearchFrame.this.term3TextField.getText() + "%')";
                    }
                    string = string + " GROUP BY main.name";
                    ExportSearchFrame.this.queryLoaded = string;
                    try {
                        DB dB = DB.getInstance();
                        ResultSet resultSet = dB.query(string);
                        ExportSearchFrame.this.prepareTermsTable(resultSet);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("EXPORT_SEARCH_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING"), TLanguage.getString("EXPORT_SEARCH_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                }
            }
        });
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new TitledBorder(null, TLanguage.getString("EXPORT_SEARCH_FRAME.BY_IMAGE_NAME"), 4, 2, null, null));
        this.contentPane.add(jPanel2);
        JLabel jLabel = new JLabel(TLanguage.getString("EXPORT_SEARCH_FRAME.NAME"));
        jPanel2.add(jLabel);
        this.imageNameTextField = new JTextField();
        jPanel2.add(this.imageNameTextField);
        this.imageNameTextField.setColumns(30);
        JButton jButton3 = new JButton(TLanguage.getString("EXPORT_SEARCH_FRAME.FIND"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ExportSearchFrame.this.imageNameTextField.getText().length() >= 3) {
                    try {
                        DB dB = DB.getInstance();
                        String string = "SELECT COUNT(*) AS row_count, GROUP_CONCAT(main.word) AS terms, main.nameNN AS name FROM main WHERE main.name LIKE '%" + ExportSearchFrame.this.imageNameTextField.getText() + "%' GROUP BY nameNN";
                        ExportSearchFrame.this.queryLoaded = string;
                        ResultSet resultSet = dB.query(string);
                        ExportSearchFrame.this.prepareTermsTable(resultSet);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("EXPORT_SEARCH_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING"), TLanguage.getString("EXPORT_SEARCH_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                }
            }
        });
        jPanel2.add(jButton3);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.setBorder(new TitledBorder(null, TLanguage.getString("EXPORT_SEARCH_FRAME.RESULTS"), 4, 2, null, null));
        this.contentPane.add(jPanel3);
        this.imageTableModel = new DefaultTableModel(new Object[0][], this.imageTableHeader){

            @Override
            public Class<?> getColumnClass(int n) {
                if (n == 0) {
                    return Icon.class;
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.table = new JTable(this.imageTableModel);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getY() / ExportSearchFrame.this.table.getRowHeight();
                String string = (String)ExportSearchFrame.this.table.getValueAt(n, 1);
                ExportSearchFrame.this.selectedImageName = string;
                if (mouseEvent.getClickCount() == 2) {
                    if (ExportSearchFrame.this.mode == 0) {
                        ExportSearchFrame.this.mainFrame.dispose();
                    } else {
                        AddImageFrame addImageFrame = new AddImageFrame(string);
                        addImageFrame.setVisible(true);
                        addImageFrame.pack();
                    }
                }
            }
        });
        this.table.setRowHeight(50);
        this.table.setSize(new Dimension(500, 100));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jPanel3.add(jScrollPane);
        JPanel jPanel4 = new JPanel();
        this.contentPane.add(jPanel4);
        if (this.mode == 0) {
            jButton = new JButton(TLanguage.getString("EXPORT_SEARCH_FRAME.INSERT"));
            jPanel4.add(jButton);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExportSearchFrame.this.selectedImageName == null) {
                        JOptionPane.showMessageDialog(null, TLanguage.getString("EXPORT_SEARCH_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING"), TLanguage.getString("EXPORT_SEARCH_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                    } else {
                        ExportSearchFrame.this.mainFrame.dispose();
                    }
                }
            });
        }
        jButton = new JButton(TLanguage.getString("EXPORT_SEARCH_FRAME.CANCEL"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportSearchFrame.this.mainFrame.dispose();
            }
        });
        JButton jButton4 = new JButton(TLanguage.getString("EXPORT_SEARCH_FRAME.EXPORT_SEARCH"));
        jPanel4.add(jButton4);
        jPanel4.add(jButton);
        JPanel jPanel5 = new JPanel();
        this.contentPane.add(jPanel5);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ExportSearchFrame.this.queryLoaded == null) {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("EXPORT_SEARCH_FRAME.YOU_SHOULD_SELECT_AN_IMAGE"), TLanguage.getString("EXPORT_SEARCH_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                } else {
                    final JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileSelectionMode(1);
                    int n = jFileChooser.showOpenDialog(ExportSearchFrame.this.contentPane);
                    if (n == 0) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                ExportSearchFrame.this.mainFrame.setEnabled(false);
                                DBTasks.exportDB(jFileChooser.getSelectedFile().getAbsolutePath(), ExportSearchFrame.this.progressBar, ExportSearchFrame.this.queryLoaded);
                                JOptionPane.showMessageDialog(ExportSearchFrame.this.contentPane, TLanguage.getString("EXPORT_SEARCH_FRAME.IMPORT_OK"));
                                ExportSearchFrame.this.mainFrame.setEnabled(true);
                            }
                        }).start();
                    }
                }
            }
        });
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(680, 30));
        jPanel5.add(this.progressBar);
    }

    private void prepareTermsTable(ResultSet resultSet) {
        try {
            this.imageTableModel.setDataVector((Object[][])null, this.imageTableHeader);
            String string = DB.getInstance().getImagesPath();
            while (resultSet.next()) {
                BufferedImage bufferedImage = ImageIO.read(new File(string + File.separator + resultSet.getString("name")));
                Image image = bufferedImage.getScaledInstance(50, 50, 50);
                ImageIcon imageIcon = new ImageIcon(image);
                this.imageTableModel.addRow(new Object[]{imageIcon, resultSet.getString("name"), resultSet.getString("terms")});
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getSelectedImageName() {
        return this.selectedImageName;
    }
}

