/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import configuration.TLanguage;
import database.DBTasks;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ExportDatabaseFrame
extends JFrame {
    private JPanel contentPane;
    private JTextField textFieldPath;
    private JProgressBar progressBarStatus;
    private JFrame mainFrame;

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ExportDatabaseFrame exportDatabaseFrame = new ExportDatabaseFrame();
                    exportDatabaseFrame.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public ExportDatabaseFrame() {
        TLanguage.initLanguage("spanish");
        this.mainFrame = this;
        this.setTitle(TLanguage.getString("EXPORT_DATABASE_FRAME.TITLE"));
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 450, 176);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), TLanguage.getString("EXPORT_DATABASE_FRAME.SELECT_DESTINATION_PATH"), 4, 2, null, new Color(0, 0, 0)));
        this.contentPane.add(jPanel);
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        JButton jButton = new JButton(TLanguage.getString("EXPORT_DATABASE_FRAME.SELECT"));
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(1);
                int n = jFileChooser.showOpenDialog(ExportDatabaseFrame.this.contentPane);
                if (n == 0) {
                    ExportDatabaseFrame.this.textFieldPath.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        jPanel.add(jButton);
        this.textFieldPath = new JTextField();
        this.textFieldPath.setEditable(false);
        jPanel.add(this.textFieldPath);
        this.textFieldPath.setColumns(24);
        JPanel jPanel2 = new JPanel();
        this.contentPane.add(jPanel2);
        JButton jButton2 = new JButton(TLanguage.getString("EXPORT_DATABASE_FRAME.EXPORT"));
        jButton2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (ExportDatabaseFrame.this.textFieldPath.getText().equals("")) {
                    JOptionPane.showMessageDialog(ExportDatabaseFrame.this.contentPane, TLanguage.getString("EXPORT_DATABASE_FRAME.DIRECTORY_MUST_BE_SELECTED_WARNING"));
                } else {
                    System.out.println("Exporting to " + ExportDatabaseFrame.this.textFieldPath.getText());
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ExportDatabaseFrame.this.mainFrame.setEnabled(false);
                            DBTasks.exportDB(ExportDatabaseFrame.this.textFieldPath.getText(), ExportDatabaseFrame.this.progressBarStatus);
                            JOptionPane.showMessageDialog(ExportDatabaseFrame.this.contentPane, TLanguage.getString("EXPORT_DATABASE_FRAME.EXPORT_OK"));
                            ExportDatabaseFrame.this.mainFrame.setEnabled(true);
                        }
                    });
                    thread.start();
                }
            }
        });
        jPanel2.setLayout(new FlowLayout(1, 5, 5));
        jPanel2.add(jButton2);
        JPanel jPanel3 = new JPanel();
        this.contentPane.add(jPanel3);
        this.progressBarStatus = new JProgressBar();
        this.progressBarStatus.setPreferredSize(new Dimension(420, 30));
        jPanel3.add(this.progressBarStatus);
    }
}

