/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import components.ThumbnailPanel;
import configuration.TLanguage;
import database.DB;
import database.DBTasks;
import database.ImageManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class AddImageFrame
extends JDialog {
    private JPanel contentPane;
    private JTextField imageTextField;
    private JPanel panel_1;
    private DefaultTableModel termTableModel;
    private JButton addRowTable;
    private JButton removeRowTable;
    private JTable termTable;
    private boolean replaceImage = false;
    private AddImageFrame mainFrame;
    private String nameNN = null;

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AddImageFrame addImageFrame = new AddImageFrame();
                    addImageFrame.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public AddImageFrame() {
        this.init();
    }

    public AddImageFrame(String string) {
        this.nameNN = string;
        this.init();
    }

    public void init() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        TLanguage.initLanguage("spanish");
        this.mainFrame = this;
        if (this.nameNN == null) {
            this.setTitle(TLanguage.getString("ADD_IMAGE_FRAME.TITLE"));
        } else {
            this.setTitle(TLanguage.getString("ADD_IMAGE_FRAME.EDIT_IMAGE_TITLE") + " " + this.nameNN);
        }
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 450, 300);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(null, TLanguage.getString("ADD_IMAGE_FRAME.IMAGE"), 4, 2, null, null));
        this.contentPane.add(jPanel);
        this.imageTextField = new JTextField();
        this.imageTextField.setEditable(false);
        this.imageTextField.setColumns(24);
        JButton jButton = new JButton(TLanguage.getString("ADD_IMAGE_FRAME.SELECT"));
        if (this.nameNN != null) {
            jButton.setEnabled(false);
        }
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Images", "jpg", "gif", "png", "bmp");
                jFileChooser.setFileFilter(fileNameExtensionFilter);
                ThumbnailPanel thumbnailPanel = new ThumbnailPanel(jFileChooser);
                jFileChooser.addPropertyChangeListener(thumbnailPanel);
                jFileChooser.setAccessory(thumbnailPanel);
                int n = jFileChooser.showOpenDialog(AddImageFrame.this.contentPane);
                if (n == 0) {
                    AddImageFrame.this.imageTextField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                    try {
                        DB dB = DB.getInstance();
                        PreparedStatement preparedStatement = dB.prepareStatement("SELECT word, language.name AS language, type.name AS type FROM main, language, type WHERE main.name = ? AND main.idL = language.id AND main.idT = type.id");
                        preparedStatement.setString(1, new File(jFileChooser.getSelectedFile().getAbsolutePath()).getName());
                        ResultSet resultSet = preparedStatement.executeQuery();
                        if (resultSet.isBeforeFirst()) {
                            int n2 = JOptionPane.showConfirmDialog(null, TLanguage.getString("ADD_IMAGE_FRAME.REPLACE_IMAGE_WARNING"), TLanguage.getString("ADD_IMAGE_FRAME.REPLACE_IMAGE_WARNING_TITLE"), 0);
                            AddImageFrame.this.replaceImage = n2 == 0;
                        }
                        while (resultSet.next() && AddImageFrame.this.replaceImage) {
                            Object[] objectArray = new Object[]{resultSet.getString("word"), resultSet.getString("language"), resultSet.getString("type")};
                            AddImageFrame.this.termTableModel.addRow(objectArray);
                        }
                        AddImageFrame.this.removeRowTable.setEnabled(true);
                        AddImageFrame.this.addRowTable.setEnabled(true);
                        dB.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
            }
        });
        GroupLayout groupLayout = new GroupLayout(jPanel);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(3).addComponent(this.imageTextField, -2, -1, -2).addGap(5).addComponent(jButton)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imageTextField, -2, -1, -2).addComponent(jButton))));
        jPanel.setLayout(groupLayout);
        this.panel_1 = new JPanel();
        this.panel_1.setBorder(new TitledBorder(null, TLanguage.getString("ADD_IMAGE_FRAME.ASSOCIATED_TERMS"), 4, 2, null, null));
        this.contentPane.add(this.panel_1);
        Object[] objectArray = new Object[]{TLanguage.getString("ADD_IMAGE_FRAME.TERM"), TLanguage.getString("ADD_IMAGE_FRAME.LANGUAGE"), TLanguage.getString("ADD_IMAGE_FRAME.TYPE")};
        this.termTableModel = new DefaultTableModel((Object[][])null, objectArray);
        this.panel_1.setLayout(new BorderLayout(0, 0));
        this.termTable = new JTable(this.termTableModel);
        TableColumn tableColumn = this.termTable.getColumnModel().getColumn(1);
        JComboBox<String> jComboBox = new JComboBox<String>();
        try {
            object4 = DB.getInstance();
            object3 = ((DB)object4).query("SELECT name FROM language ORDER BY id ASC");
            while (object3.next()) {
                jComboBox.addItem(object3.getString("name"));
            }
            ((DB)object4).close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        object4 = this.termTable.getColumnModel().getColumn(2);
        object3 = new JComboBox();
        try {
            object2 = DB.getInstance();
            object = ((DB)object2).query("SELECT name FROM type ORDER BY id ASC");
            while (object.next()) {
                ((JComboBox)object3).addItem(object.getString("name"));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        ((TableColumn)object4).setCellEditor(new DefaultCellEditor((JComboBox<?>)object3));
        this.termTable.setSelectionMode(0);
        this.termTable.setBackground(Color.WHITE);
        this.termTable.setGridColor(Color.GRAY);
        this.termTable.setSize(new Dimension(100, 200));
        object2 = new JScrollPane(this.termTable);
        this.panel_1.add((Component)object2);
        object = new JPanel();
        this.panel_1.add((Component)object, "South");
        this.removeRowTable = new JButton("-");
        this.removeRowTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddImageFrame.this.termTableModel.removeRow(AddImageFrame.this.termTable.getSelectedRow());
            }
        });
        this.removeRowTable.setPreferredSize(new Dimension(20, 20));
        this.removeRowTable.setEnabled(false);
        this.addRowTable = new JButton("+");
        this.addRowTable.setEnabled(false);
        this.addRowTable.setPreferredSize(new Dimension(20, 20));
        this.addRowTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AddImageFrame.this.nameNN == null && AddImageFrame.this.imageTextField.getText().equals("")) {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("ADD_IMAGE_FRAME.IMAGE_NOT_SELECTED_WARNING"), TLanguage.getString("ADD_IMAGE_FRAME.IMAGE_NOT_SELECTED_WARNING_TITLE"), 2);
                } else {
                    AddImageFrame.this.termTableModel.addRow(new Object[0]);
                }
            }
        });
        FlowLayout flowLayout = new FlowLayout(2, 5, 5);
        ((Container)object).setLayout(flowLayout);
        ((Container)object).add(this.addRowTable);
        ((Container)object).add(this.removeRowTable);
        JPanel jPanel2 = new JPanel();
        this.contentPane.add(jPanel2);
        JButton jButton2 = new JButton(TLanguage.getString("ADD_IMAGE_FRAME.SAVE_CHANGES"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Vector<Vector> vector = AddImageFrame.this.termTableModel.getDataVector();
                    if (vector.size() > 0) {
                        Object object;
                        Iterator<Vector> iterator = vector.iterator();
                        boolean bl = false;
                        while (iterator.hasNext() && !bl) {
                            object = iterator.next();
                            if (!((Vector)object).get(0).equals("") && !((Vector)object).get(1).equals("") && !((Vector)object).get(2).equals("")) continue;
                            bl = true;
                        }
                        if (bl) {
                            JOptionPane.showMessageDialog(null, TLanguage.getString("ADD_IMAGE_FRAME.ALL_TERMS_ASSIGNED_WARNING"), TLanguage.getString("ADD_IMAGE_FRAME.ALL_TERMS_ASSIGNED_WARNING_TITLE"), 2);
                        } else {
                            if (AddImageFrame.this.nameNN == null) {
                                if (AddImageFrame.this.replaceImage) {
                                    object = AddImageFrame.this.imageTextField.getText().substring(AddImageFrame.this.imageTextField.getText().lastIndexOf(File.separator) + 1);
                                    ImageManager.delete((String)object);
                                    ImageManager.add(AddImageFrame.this.imageTextField.getText());
                                } else {
                                    object = ImageManager.add(AddImageFrame.this.imageTextField.getText());
                                }
                                AddImageFrame.this.saveChanges((String)object);
                            } else {
                                AddImageFrame.this.saveChanges(AddImageFrame.this.nameNN);
                            }
                            JOptionPane.showMessageDialog(null, TLanguage.getString("ADD_IMAGE_FRAME.CHANGES_DONE_WARNING"), TLanguage.getString("ADD_IMAGE_FRAME.CHANGES_DONE_WARNING_TITLE"), 1);
                            AddImageFrame.this.mainFrame.dispose();
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, TLanguage.getString("ADD_IMAGE_FRAME.IMAGE_NOT_SELECTED_WARNING"), TLanguage.getString("ADD_IMAGE_FRAME.IMAGE_NOT_SELECTED_WARNING_TITLE"), 2);
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        });
        jPanel2.add(jButton2);
        JButton jButton3 = new JButton(TLanguage.getString("ADD_IMAGE_FRAME.CANCEL_CHANGES"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddImageFrame.this.mainFrame.dispose();
            }
        });
        jPanel2.add(jButton3);
        if (this.nameNN != null) {
            try {
                DB dB = DB.getInstance();
                PreparedStatement preparedStatement = dB.prepareStatement("SELECT word, language.name AS language, type.name AS type FROM main, language, type WHERE main.name = ? AND main.idL = language.id AND main.idT = type.id");
                preparedStatement.setString(1, this.nameNN);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    Object[] objectArray2 = new Object[]{resultSet.getString("word"), resultSet.getString("language"), resultSet.getString("type")};
                    this.termTableModel.addRow(objectArray2);
                }
                this.removeRowTable.setEnabled(true);
                this.addRowTable.setEnabled(true);
                dB.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    private void saveChanges(String string) throws SQLException {
        String string2 = "DELETE FROM main WHERE name = '" + string + "'";
        DB dB = DB.getInstance();
        dB.update(string2);
        dB.close();
        Vector<Vector> vector = this.termTableModel.getDataVector();
        vector = this.termTableModel.getDataVector();
        for (Vector vector2 : vector) {
            DBTasks.addImageDB(string, (String)vector2.get(1), (String)vector2.get(2), (String)vector2.get(0));
        }
    }
}

