/*
 * Decompiled with CFR 0.152.
 */
package database;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class ConfigManager {
    public static String KEY_LOG_FILENAME = "log.name";
    private static String VALUE_LOG_FILENAME = "log.dat";
    public static String KEY_LOG_STATE = "log.state";
    private static String VALUE_LOG_STATE = "0";
    public static String KEY_DB_FILENAME = "database.name";
    private static String VALUE_DB_FILENAME = "AraSuite.db";
    public static String KEY_IMAGE_FOLDER = "images.path";
    public static String VALUE_IMAGE_FOLDER = "images";
    public static String KEY_ROOT_PATH = "root.path";
    private String ROOT_PATH = System.getProperty("os.name").toLowerCase().contains("windows") ? ".\\" : "./";
    private final String CONFIG_FILE_NAME = "config.properties";
    private static ConfigManager instance;

    private ConfigManager() {
        File file = new File(this.ROOT_PATH);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!new File(this.ROOT_PATH + "conf" + File.separator + "config.properties").exists()) {
            this.createConfigFile();
        }
    }

    private void createConfigFile() {
        try {
            Properties properties = new Properties();
            properties.setProperty(KEY_LOG_FILENAME, VALUE_LOG_FILENAME);
            properties.setProperty(KEY_LOG_STATE, VALUE_LOG_STATE);
            properties.setProperty(KEY_DB_FILENAME, VALUE_DB_FILENAME);
            properties.setProperty(KEY_ROOT_PATH, this.ROOT_PATH);
            properties.setProperty(KEY_IMAGE_FOLDER, VALUE_IMAGE_FOLDER);
            File file = new File(this.ROOT_PATH + "conf" + File.separator + "config.properties");
            file.createNewFile();
            properties.store(new FileOutputStream(file), "Default properties created.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static ConfigManager getInstance() {
        if (instance == null) {
            instance = new ConfigManager();
        }
        return instance;
    }

    public String getProperty(String string) throws FileNotFoundException, IOException {
        File file = new File(this.ROOT_PATH + "conf" + File.separator + "config.properties");
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        return properties.getProperty(string);
    }

    public void setProperty(String string, String string2) throws FileNotFoundException, IOException {
        File file = new File(this.ROOT_PATH + "conf" + File.separator + "config.properties");
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        properties.setProperty(string, string2);
        properties.store(new FileOutputStream(file), "");
    }
}

