/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.player;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;
import javazoom.jl.player.Mp3EventListener;
import javazoom.jl.player.ThreadedPlayer;

public class Mp3Player {
    Mp3EventListener interestedParty;
    private ThreadedPlayer player = null;
    private Thread playerThread = null;

    public Mp3Player() {
        System.out.println("Creating mp3 player..\n");
    }

    public void addMp3Listener(Mp3EventListener mp3EventListener) {
        this.interestedParty = mp3EventListener;
    }

    public void play(String string) throws IOException, JavaLayerException {
        if (this.player != null) {
            this.player.close();
        }
        System.out.println("Playing " + string + "...");
        InputStream inputStream = this.getInputStream(string);
        AudioDevice audioDevice = this.getAudioDevice();
        this.player = new ThreadedPlayer(inputStream, audioDevice);
        this.player.addMp3Listener(this.interestedParty);
        this.playerThread = new Thread(this.player);
        this.playerThread.start();
    }

    public void pause() {
        if (this.player != null && this.playerThread.isAlive()) {
            this.player.pause();
        }
    }

    public void stop() {
        if (this.player != null) {
            this.player.stop();
        }
        this.player = null;
    }

    private InputStream getInputStream(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        return bufferedInputStream;
    }

    private AudioDevice getAudioDevice() throws JavaLayerException {
        return FactoryRegistry.systemRegistry().createAudioDevice();
    }
}

