/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import configuration.TLanguage;
import database.DB;
import dialogs.AddImageFrame;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class FindImageFrame
extends JDialog {
    private JPanel contentPane;
    private JTextField term1TextField;
    private JTextField term2TextField;
    private JTextField term3TextField;
    private JTextField imageNameTextField;
    private DefaultTableModel imageTableModel;
    private String[] imageTableHeader;
    private JTable table;
    private JComboBox AndOr1ComboBox;
    private JComboBox AndOr2ComboBox;
    public static final int IS_INTEGRATED = 0;
    private int mode = -1;
    private String selectedImageName;
    private FindImageFrame mainFrame;

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    FindImageFrame findImageFrame = new FindImageFrame();
                    findImageFrame.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public FindImageFrame(int n) {
        this.mode = n;
        this.init();
    }

    public FindImageFrame() {
        this.init();
    }

    private void init() {
        JButton jButton;
        TLanguage.initLanguage("spanish");
        this.imageTableHeader = new String[]{TLanguage.getString("FIND_IMAGE_FRAME.TITLE"), TLanguage.getString("FIND_IMAGE_FRAME.FILENAME"), TLanguage.getString("FIND_IMAGE_FRAME.ASSOCIATED_TERMS")};
        this.mainFrame = this;
        this.setTitle(TLanguage.getString("FIND_IMAGE_FRAME.TITLE"));
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 720, 430);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(null, TLanguage.getString("FIND_IMAGE_FRAME.KEY_TERMS"), 4, 2, null, null));
        this.contentPane.add(jPanel);
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.term1TextField = new JTextField();
        jPanel.add(this.term1TextField);
        this.term1TextField.setColumns(10);
        this.AndOr1ComboBox = new JComboBox();
        this.AndOr1ComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{TLanguage.getString("FIND_IMAGE_FRAME.AND"), TLanguage.getString("FIND_IMAGE_FRAME.OR")}));
        jPanel.add(this.AndOr1ComboBox);
        this.term2TextField = new JTextField();
        jPanel.add(this.term2TextField);
        this.term2TextField.setColumns(10);
        this.AndOr2ComboBox = new JComboBox();
        this.AndOr2ComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{TLanguage.getString("FIND_IMAGE_FRAME.AND"), TLanguage.getString("FIND_IMAGE_FRAME.OR")}));
        jPanel.add(this.AndOr2ComboBox);
        this.term3TextField = new JTextField();
        this.term3TextField.setColumns(10);
        jPanel.add(this.term3TextField);
        JButton jButton2 = new JButton(TLanguage.getString("FIND_IMAGE_FRAME.FIND"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!FindImageFrame.this.term1TextField.getText().equals("")) {
                    String string = "SELECT GROUP_CONCAT(main.word) AS terms, main.nameNN AS name FROM main WHERE main.name IN (SELECT main.name FROM main WHERE word LIKE '%" + FindImageFrame.this.term1TextField.getText() + "%') ";
                    if (!FindImageFrame.this.term2TextField.getText().equals("")) {
                        string = string + (FindImageFrame.this.AndOr1ComboBox.getSelectedIndex() == 0 ? " AND " : " OR ");
                        string = string + "main.name IN (SELECT main.name FROM main WHERE word LIKE '%" + FindImageFrame.this.term2TextField.getText() + "%')";
                    }
                    if (!FindImageFrame.this.term3TextField.getText().equals("")) {
                        string = string + (FindImageFrame.this.AndOr2ComboBox.getSelectedIndex() == 0 ? " AND " : " OR ");
                        string = string + "main.name IN (SELECT main.name FROM main WHERE word LIKE '%" + FindImageFrame.this.term3TextField.getText() + "%')";
                    }
                    string = string + " GROUP BY main.name";
                    try {
                        DB dB = DB.getInstance();
                        ResultSet resultSet = dB.query(string);
                        FindImageFrame.this.prepareTermsTable(resultSet);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING"), TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                }
            }
        });
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new TitledBorder(null, TLanguage.getString("FIND_IMAGE_FRAME.BY_IMAGE_NAME"), 4, 2, null, null));
        this.contentPane.add(jPanel2);
        JLabel jLabel = new JLabel(TLanguage.getString("FIND_IMAGE_FRAME.NAME"));
        jPanel2.add(jLabel);
        this.imageNameTextField = new JTextField();
        jPanel2.add(this.imageNameTextField);
        this.imageNameTextField.setColumns(30);
        JButton jButton3 = new JButton(TLanguage.getString("FIND_IMAGE_FRAME.FIND"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FindImageFrame.this.imageNameTextField.getText().length() >= 3) {
                    try {
                        DB dB = DB.getInstance();
                        String string = "SELECT GROUP_CONCAT(main.word) AS terms, main.nameNN AS name FROM main WHERE main.name LIKE '%" + FindImageFrame.this.imageNameTextField.getText() + "%' GROUP BY nameNN";
                        ResultSet resultSet = dB.query(string);
                        FindImageFrame.this.prepareTermsTable(resultSet);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING"), TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                }
            }
        });
        jPanel2.add(jButton3);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.setBorder(new TitledBorder(null, TLanguage.getString("FIND_IMAGE_FRAME.RESULTS"), 4, 2, null, null));
        this.contentPane.add(jPanel3);
        this.imageTableModel = new DefaultTableModel(new Object[0][], this.imageTableHeader){

            @Override
            public Class<?> getColumnClass(int n) {
                if (n == 0) {
                    return Icon.class;
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.table = new JTable(this.imageTableModel);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getY() / FindImageFrame.this.table.getRowHeight();
                String string = (String)FindImageFrame.this.table.getValueAt(n, 1);
                FindImageFrame.this.selectedImageName = string;
                if (mouseEvent.getClickCount() == 2) {
                    if (FindImageFrame.this.mode == 0) {
                        FindImageFrame.this.mainFrame.dispose();
                    } else {
                        AddImageFrame addImageFrame = new AddImageFrame(string);
                        addImageFrame.setVisible(true);
                        addImageFrame.pack();
                    }
                }
            }
        });
        this.table.setRowHeight(50);
        this.table.setSize(new Dimension(500, 100));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jPanel3.add(jScrollPane);
        JPanel jPanel4 = new JPanel();
        this.contentPane.add(jPanel4);
        if (this.mode == 0) {
            jButton = new JButton(TLanguage.getString("FIND_IMAGE_FRAME.INSERT"));
            jPanel4.add(jButton);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (FindImageFrame.this.selectedImageName == null) {
                        JOptionPane.showMessageDialog(null, TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING"), TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                    } else {
                        FindImageFrame.this.mainFrame.dispose();
                    }
                }
            });
        }
        jButton = new JButton(TLanguage.getString("FIND_IMAGE_FRAME.MODIFY"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FindImageFrame.this.selectedImageName == null) {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("FIND_IMAGE_FRAME.YOU_SHOULD_SELECT_AN_IMAGE"), TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                } else {
                    AddImageFrame addImageFrame = new AddImageFrame(FindImageFrame.this.selectedImageName);
                    addImageFrame.setVisible(true);
                    addImageFrame.pack();
                }
            }
        });
        jPanel4.add(jButton);
        JButton jButton4 = new JButton(TLanguage.getString("FIND_IMAGE_FRAME.DELETE"));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FindImageFrame.this.selectedImageName == null) {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("FIND_IMAGE_FRAME.YOU_SHOULD_SELECT_AN_IMAGE"), TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                }
            }
        });
        jPanel4.add(jButton4);
        JButton jButton5 = new JButton(TLanguage.getString("FIND_IMAGE_FRAME.CANCEL"));
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindImageFrame.this.mainFrame.dispose();
            }
        });
        jPanel4.add(jButton5);
    }

    private void prepareTermsTable(ResultSet resultSet) {
        try {
            this.imageTableModel.setDataVector((Object[][])null, this.imageTableHeader);
            String string = DB.getInstance().getImagesPath();
            while (resultSet.next()) {
                BufferedImage bufferedImage = ImageIO.read(new File(string + File.separator + resultSet.getString("name")));
                Image image = bufferedImage.getScaledInstance(50, 50, 50);
                ImageIcon imageIcon = new ImageIcon(image);
                this.imageTableModel.addRow(new Object[]{imageIcon, resultSet.getString("name"), resultSet.getString("terms")});
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getSelectedImageName() {
        return this.selectedImageName;
    }
}

