/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.DB;
import database.ImageManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class DBTasks {
    private static void createTablesDB() {
        try {
            DB dB = DB.getInstance();
            dB.update("DROP TABLE IF EXISTS main;");
            String string = "CREATE TABLE main (word VARCHAR(50), idL INTEGER, idT INTEGER, name VARCHAR(50), nameNN VARCHAR(50))";
            dB.update(string);
            dB.update("DROP TABLE IF EXISTS language;");
            string = "CREATE TABLE IF NOT EXISTS language(id INTEGER PRIMARY KEY,name VARCHAR(45) NOT NULL)";
            dB.update(string);
            dB.update("DROP TABLE IF EXISTS type;");
            string = "CREATE TABLE IF NOT EXISTS type (id INTEGER PRIMARY KEY,name VARCHAR(45) NOT NULL)";
            dB.update(string);
            dB.update("CREATE UNIQUE INDEX main_index ON main (word, idL, idT, name, nameNN)");
            dB.close();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.out.println(exception.toString());
        }
    }

    public static void addImageDB(String string, String string2, String string3, String string4) {
        try {
            String string5;
            DB dB = DB.getInstance();
            int n = 0;
            int n2 = 0;
            ResultSet resultSet = dB.query("select id from language where name=\"" + string2 + "\"");
            while (resultSet.next()) {
                n = resultSet.getInt("id");
            }
            resultSet.close();
            resultSet = dB.query("select id from type where name=\"" + string3 + "\"");
            while (resultSet.next()) {
                n2 = resultSet.getInt("id");
            }
            resultSet.close();
            String string6 = string5 = string.substring(string.lastIndexOf(File.separator) + 1);
            PreparedStatement preparedStatement = dB.prepareStatement("INSERT OR IGNORE INTO main (word, idL, idT, name, nameNN) VALUES (?,?,?,?,?)");
            preparedStatement.setString(1, string4.toLowerCase());
            preparedStatement.setInt(2, n);
            preparedStatement.setInt(3, n2);
            preparedStatement.setString(4, string5);
            preparedStatement.setString(5, string6);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            dB.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void importDB(String string, JProgressBar jProgressBar, boolean bl) {
        try {
            DB dB = DB.getInstance();
            long l = System.currentTimeMillis();
            String string2 = string + File.separator;
            File file = new File(string2);
            String[] stringArray = file.list();
            File file2 = new File(string + File.separator + "images.xml");
            if (!file2.exists()) {
                JOptionPane.showMessageDialog(null, "No se encuentra el fichero XML", "Error", 0);
            } else {
                long l2;
                SAXBuilder sAXBuilder = new SAXBuilder(false);
                Document document = sAXBuilder.build(file2);
                Element element = document.getRootElement();
                List list = element.getChildren("image");
                Iterator iterator = list.iterator();
                List list2 = element.getChild("languages").getChildren("language");
                Iterator iterator2 = list2.iterator();
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                while (iterator2.hasNext()) {
                    Element element2 = (Element)iterator2.next();
                    hashMap.put(element2.getText(), n);
                    PreparedStatement preparedStatement = dB.prepareStatement("INSERT OR IGNORE INTO language (id,name) VALUES (?,?)");
                    preparedStatement.setInt(1, n);
                    preparedStatement.setString(2, element2.getText());
                    preparedStatement.executeUpdate();
                    preparedStatement.close();
                    ++n;
                }
                dB.activateTransactions();
                int n4 = 0;
                jProgressBar.setMinimum(n4);
                jProgressBar.setMaximum(list.size());
                jProgressBar.setStringPainted(true);
                jProgressBar.setValue(n4);
                while (iterator.hasNext()) {
                    String string3;
                    l2 = System.currentTimeMillis();
                    jProgressBar.setValue(n4++);
                    jProgressBar.repaint();
                    Element element3 = (Element)iterator.next();
                    String string4 = element3.getAttributeValue("id");
                    List list3 = element3.getChildren("language");
                    Iterator iterator3 = list3.iterator();
                    if (!DBTasks.exists(stringArray, string4)) continue;
                    String string5 = string2.concat(string4);
                    if (bl && new File(DB.getInstance().getImagesPath() + File.separator + string4).exists()) {
                        ImageManager.delete(string4);
                        string3 = "DELETE FROM main WHERE nameNN = '" + string4 + "'";
                        dB.update(string3);
                    }
                    string3 = ImageManager.add(string5);
                    string4 = string3.substring(string3.lastIndexOf(File.separator) + 1);
                    while (iterator3.hasNext()) {
                        Element element4 = (Element)iterator3.next();
                        String string6 = element4.getAttributeValue("id");
                        List list4 = element4.getChildren("word");
                        for (Element element5 : list4) {
                            PreparedStatement preparedStatement;
                            String string7 = element5.getAttributeValue("type");
                            if (!hashMap2.containsKey(string7)) {
                                hashMap2.put(string7, n2);
                                preparedStatement = dB.prepareStatement("INSERT OR IGNORE INTO type (id,name) VALUES (?,?)");
                                preparedStatement.setInt(1, n2);
                                preparedStatement.setString(2, string7);
                                preparedStatement.executeUpdate();
                                preparedStatement.close();
                                ++n2;
                            }
                            preparedStatement = dB.prepareStatement("INSERT OR IGNORE INTO main (word, idL, idT, name, nameNN) VALUES (?,?,?,?,?)");
                            preparedStatement.setString(1, element5.getText().toLowerCase());
                            preparedStatement.setInt(2, (Integer)hashMap.get(string6));
                            preparedStatement.setInt(3, (Integer)hashMap2.get(string7));
                            preparedStatement.setString(4, string4);
                            preparedStatement.setString(5, string4);
                            preparedStatement.executeUpdate();
                            preparedStatement.close();
                            if (n3 > 5000 && (System.currentTimeMillis() - l2) / (long)n3 > 100L) {
                                l2 = System.currentTimeMillis();
                                dB.executeQueries();
                                n3 = 0;
                                continue;
                            }
                            ++n3;
                        }
                    }
                }
                dB.executeQueries();
                dB.close();
                l2 = System.currentTimeMillis() - l;
                System.out.println("El tiempo total es :" + l2 + " milisegundos");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void exportDB(String string, JProgressBar jProgressBar) {
        DBTasks.exportDB(string, jProgressBar, "SELECT DISTINCT name FROM main ORDER BY name");
    }

    public static void exportDB(String string, JProgressBar jProgressBar, String string2) {
        try {
            Object object;
            Object object2;
            int n;
            DB dB = DB.getInstance();
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
            long l = System.currentTimeMillis();
            Element element = new Element("database");
            Element element2 = new Element("languages");
            ResultSet resultSet = dB.query("select * from language order by id");
            while (resultSet.next()) {
                n = resultSet.getInt("id");
                object2 = resultSet.getString("name");
                hashMap.put(n, (String)object2);
                object = new Element("language");
                ((Element)object).setText((String)object2);
                element2.addContent((Content)object);
            }
            element.addContent(element2);
            resultSet = dB.query("select * from type order by id");
            while (resultSet.next()) {
                n = resultSet.getInt("id");
                object2 = resultSet.getString("name");
                hashMap2.put(n, (String)object2);
            }
            resultSet = dB.query(string2);
            n = 0;
            jProgressBar.setMinimum(n);
            jProgressBar.setMaximum(resultSet.getInt("row_count"));
            jProgressBar.setStringPainted(true);
            while (resultSet.next()) {
                object2 = resultSet.getString("name");
                object = new Element("image");
                ((Element)object).setAttribute("id", (String)object2);
                ResultSet resultSet2 = dB.query("select distinct idL from main where name = \"" + (String)object2 + "\" order by idL");
                while (resultSet2.next()) {
                    int n2 = resultSet2.getInt("idL");
                    Element element3 = new Element("language");
                    element3.setAttribute("id", (String)hashMap.get(n2));
                    ResultSet resultSet3 = dB.query("select * from main where name = \"" + (String)object2 + "\" and idL = " + n2 + " order by idT");
                    while (resultSet3.next()) {
                        int n3 = resultSet3.getInt("idT");
                        String string3 = resultSet3.getString("word");
                        Element element4 = new Element("word");
                        element4.setAttribute("type", (String)hashMap2.get(n3));
                        element4.setText(string3);
                        element3.addContent(element4);
                        String string4 = dB.getImagesPath() + File.separator + (String)object2;
                        String string5 = string + File.separator + (String)object2;
                        try {
                            FileChannel fileChannel = new FileInputStream(string4).getChannel();
                            FileChannel fileChannel2 = new FileOutputStream(string5).getChannel();
                            fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size());
                            fileChannel.close();
                            fileChannel2.close();
                        }
                        catch (IOException iOException) {
                            System.out.println(iOException.getMessage());
                            System.out.println(iOException.toString());
                        }
                    }
                    resultSet3.close();
                    ((Element)object).addContent(element3);
                }
                resultSet2.close();
                element.addContent((Content)object);
                jProgressBar.setValue(n++);
            }
            resultSet.close();
            dB.close();
            object2 = new XMLOutputter(Format.getPrettyFormat());
            object = new FileOutputStream(string + File.separator + "images.xml");
            ((XMLOutputter)object2).output(element, (OutputStream)object);
            ((OutputStream)object).flush();
            ((FileOutputStream)object).close();
            long l2 = System.currentTimeMillis() - l;
            System.out.println("El tiempo total es :" + l2 / 1000L + " segundos");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static boolean exists(String[] stringArray, String string) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length && !bl; ++i) {
            bl = string.equals(stringArray[i]);
        }
        return bl;
    }
}

