/*
 * Decompiled with CFR 0.152.
 */
package database;

import configuration.TConfiguration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DB {
    protected Connection con;
    private static DB instance;
    private static Statement s;
    private static PreparedStatement ps;

    private DB() {
        try {
            Class.forName("org.sqlite.JDBC");
            this.con = DriverManager.getConnection("jdbc:sqlite:" + TConfiguration.getDatabasePath());
            this.createTablesDB();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static DB getInstance() throws SQLException {
        if (instance == null) {
            try {
                instance = new DB();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new SQLException();
            }
        }
        return instance;
    }

    public ResultSet query(String string) throws SQLException {
        s = this.con.createStatement();
        ResultSet resultSet = null;
        resultSet = s.executeQuery(string);
        return resultSet;
    }

    public int update(String string) throws SQLException {
        s = this.con.createStatement();
        int n = 0;
        n = s.executeUpdate(string);
        return n;
    }

    public void close() throws SQLException {
        this.con.close();
        this.con = null;
        instance = null;
    }

    public void activateTransactions() throws SQLException {
        this.con.setAutoCommit(false);
    }

    public void executeQueries() throws SQLException {
        this.con.setAutoCommit(true);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        ps = this.con.prepareStatement(string);
        return ps;
    }

    public void executeBatch(String string) throws SQLException {
        s = this.con.createStatement();
        s.addBatch(string);
        s.executeBatch();
    }

    public String getImagesPath() throws FileNotFoundException, IOException {
        return TConfiguration.getImagesPath();
    }

    private void createTablesDB() {
        try {
            String string = "CREATE TABLE IF NOT EXISTS main (word VARCHAR(50), idL INTEGER, idT INTEGER, name VARCHAR(50), nameNN VARCHAR(50))";
            this.update(string);
            string = "CREATE TABLE IF NOT EXISTS language(id INTEGER PRIMARY KEY,name VARCHAR(45) NOT NULL)";
            this.update(string);
            string = "CREATE TABLE IF NOT EXISTS type (id INTEGER PRIMARY KEY,name VARCHAR(45) NOT NULL)";
            this.update(string);
            this.update("CREATE UNIQUE INDEX IF NOT EXISTS main_index ON main (word, idL, idT, name, nameNN)");
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.out.println(exception.toString());
        }
    }
}

