/*
 * Decompiled with CFR 0.152.
 */
package configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

public class TConfiguration {
    private static final String configPath = File.separator + "conf" + File.separator + "conf.properties";
    private static Properties p;
    private static final String KEY_DATABASE = "database.name";
    private static final String VALUE_DATABASE;
    private static final String KEY_IMAGEPATH = "image.path";
    private static final String VALUE_IMAGEPATH;
    private static final String KEY_LANGUAGE = "language";
    private static final String VALUE_LANGUAGE = "spanish";

    public static String getDatabasePath() {
        return TConfiguration.getProperty(KEY_DATABASE);
    }

    public static String getImagesPath() {
        return TConfiguration.getProperty(KEY_IMAGEPATH);
    }

    public static String getLanguage() {
        return TConfiguration.getProperty(KEY_LANGUAGE);
    }

    private static void setProperty(String string, String string2) {
        TConfiguration.checkConfigurationFile();
        p.setProperty(string, string2);
    }

    private static String getProperty(String string) {
        TConfiguration.checkConfigurationFile();
        return p.getProperty(string);
    }

    private static void checkConfigurationFile() {
        if (p == null) {
            try {
                String string = null;
                string = System.getProperty("os.name").toLowerCase().contains("win") ? System.getProperty("user.home") + File.separator + "arasuite" : (System.getProperty("os.name").toLowerCase().contains("mac") ? System.getProperty("user.home") + File.separator + ".arasuite" : System.getProperty("user.home") + File.separator + "arasuite");
                System.out.println(string);
                URL uRL = TConfiguration.class.getResource(string + configPath);
                if (uRL == null) {
                    File file = new File(string + File.separator + "conf");
                    file.mkdirs();
                    System.out.println(file.getAbsolutePath());
                    File file2 = new File(string + configPath);
                    System.out.println(file2.getAbsolutePath());
                    file2.createNewFile();
                    p = new Properties();
                    p.load(new FileInputStream(file2));
                    p.setProperty(KEY_DATABASE, string + VALUE_DATABASE);
                    p.setProperty(KEY_IMAGEPATH, string + VALUE_IMAGEPATH);
                    p.setProperty(KEY_LANGUAGE, VALUE_LANGUAGE);
                    p.store(new FileOutputStream(file2), "Default properties created.");
                } else {
                    p = new Properties();
                    try {
                        p.load(new FileInputStream(new File(uRL.getPath())));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    static {
        VALUE_DATABASE = File.separator + "AraSuite.db";
        VALUE_IMAGEPATH = File.separator + "images";
    }
}

