/*
 * Decompiled with CFR 0.152.
 */
package araword.gui;

import araword.G;
import araword.classes.AWElement;
import araword.classes.AWTextField;
import araword.classes.HeaderFooter;
import araword.configuration.TLanguage;
import araword.db.DBManagement;
import araword.utils.ScreenImage;
import araword.utils.TFileHandler;
import araword.utils.TextUtils;
import com.itextpdf.text.Document;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import database.DB;
import dialogs.InsertWordImageFrame;
import dialogs.mainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.DefaultStyledDocument;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.InputSource;

public class MenuFunctions {
    private static final int ZIP_BUFFER_SIZE = 2048;
    private static String tempDirectoryPath;
    private static File tempDirectory;

    static {
        tempDirectory = new File(TFileHandler.getCurrentDirectory(), "temp");
        tempDirectoryPath = tempDirectory.getAbsolutePath();
        tempDirectory.mkdirs();
    }

    public static void fileOpen() {
        try {
            JFileChooser fc = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter(TLanguage.getString("ARAWORD_DOCUMENTS"), "awd", "awz");
            fc.setFileFilter(filter);
            fc.setAcceptAllFileFilterUsed(false);
            if (fc.showOpenDialog(G.textZone) == 0) {
                G.elementList.clear();
                G.textZone.setText("");
                File fileXML = fc.getSelectedFile();
                String extension = fileXML.getName().substring(fileXML.getName().length() - 4, fileXML.getName().length());
                System.out.println("****FILE OPEN****");
                System.out.println("extension=" + extension);
                if (extension.equals(".awd")) {
                    MenuFunctions.fileOpenAWD(fileXML);
                }
                if (extension.equals(".awz")) {
                    MenuFunctions.fileOpenAWZ(fileXML, tempDirectory);
                }
            }
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
    }

    public static void fileOpenAWZ(File srcFile, File dstDir) throws IOException {
        System.out.println("OPEN AWZ");
        byte[] buffer = new byte[2048];
        ZipFile zipFile = new ZipFile(srcFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            int bytes;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                File newDirectory = new File(entry.getName());
                if (newDirectory.exists()) continue;
                newDirectory.mkdirs();
                continue;
            }
            File newFile = new File(dstDir, entry.getName().replace('\\', '/'));
            File newFileDir = newFile.getParentFile();
            if (!newFileDir.exists()) {
                newFileDir.mkdirs();
            }
            InputStream in = zipFile.getInputStream(entry);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newFile));
            while ((bytes = in.read(buffer)) >= 0) {
                ((OutputStream)out).write(buffer, 0, bytes);
            }
            in.close();
            ((OutputStream)out).close();
        }
        zipFile.close();
        G.activeDocumentFileName = srcFile.getAbsolutePath();
        File AWDFile = new File(dstDir, "base.awd");
        System.out.println("UNZIP en =" + AWDFile.getAbsolutePath());
        MenuFunctions.fileOpenAWD(AWDFile);
    }

    public static void fileOpenAWD(File fileXML) {
        final JProgressBar pb = new JProgressBar(0, 100);
        pb.setPreferredSize(new Dimension(175, 20));
        pb.setString(TLanguage.getString("ESPERA"));
        pb.setStringPainted(true);
        pb.setValue(0);
        JLabel label = new JLabel(TLanguage.getString("ESPERA"));
        JPanel center_panel = new JPanel();
        center_panel.add(label);
        center_panel.add(pb);
        final JDialog dialog = new JDialog(null, TLanguage.getString("ESPERA"));
        dialog.getContentPane().add((Component)center_panel, "Center");
        dialog.pack();
        dialog.setVisible(true);
        dialog.setLocationRelativeTo(null);
        dialog.setLocation(150, 125);
        dialog.toFront();
        final File f = fileXML;
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                System.out.println("****** BackGround");
                MenuFunctions.backgroundOpenAWD(f, pb);
                return null;
            }

            @Override
            public void done() {
                Toolkit.getDefaultToolkit().beep();
                System.out.println("******* Done!");
                dialog.dispose();
                MenuFunctions.deleteTempDirectory();
                try {
                    for (AWElement elem2 : G.elementList) {
                        if (elem2.getType() == 0) {
                            G.textZone.insertComponent(elem2);
                            continue;
                        }
                        G.textZone.getStyledDocument().insertString(G.textZone.getStyledDocument().getLength(), elem2.getSeparator(), null);
                    }
                    G.textZone.revalidate();
                    G.elementList.get(0).getTextField().requestFocusInWindow();
                }
                catch (Exception exc) {
                    System.out.println(exc);
                }
            }
        };
        worker.execute();
    }

    public static void backgroundOpenAWD(File fileXML, JProgressBar pb) {
        try {
            String language;
            System.out.println("PATH=" + fileXML.getAbsolutePath());
            SAXBuilder builder = new SAXBuilder(false);
            InputSource is = new InputSource("file:///" + fileXML.getCanonicalPath());
            is.setEncoding("UTF-8");
            org.jdom.Document docXML = builder.build(is);
            Element root = docXML.getRootElement();
            Element preferencesElement = root.getChild("preferences");
            List list = preferencesElement.getChildren("documentLanguage");
            for (Element element : list) {
                language = element.getText();
                if (language == null) continue;
                G.documentLanguage = language;
            }
            list = preferencesElement.getChildren("imagesSize");
            for (Element element : list) {
                language = element.getText();
                if (language == null) continue;
                G.imagesSize = Integer.parseInt(language);
                ImageIcon image2 = new ImageIcon("resources/404.jpg");
                G.notFound = new ImageIcon(image2.getImage().getScaledInstance(1, G.imagesSize, 0));
            }
            list = preferencesElement.getChildren("font");
            Iterator l = list.iterator();
            while (l.hasNext()) {
                String name2;
                String name = "";
                int size = 12;
                boolean bold = false;
                boolean italic = false;
                Element element = (Element)l.next();
                List list2 = element.getChildren("name");
                for (Element element2 : list2) {
                    name2 = element2.getText();
                    if (name2 == null) continue;
                    name = name2;
                }
                list2 = element.getChildren("size");
                for (Element element2 : list2) {
                    name2 = element2.getText();
                    if (name2 == null) continue;
                    size = Integer.parseInt(name2);
                }
                list2 = element.getChildren("bold");
                for (Element element2 : list2) {
                    name2 = element2.getText();
                    if (name2 == null) continue;
                    bold = name2.equals("yes");
                }
                list2 = element.getChildren("italic");
                for (Element element2 : list2) {
                    name2 = element2.getText();
                    if (name2 == null) continue;
                    italic = name2.equals("yes");
                }
                int style = 0;
                if (bold) {
                    style ^= 1;
                }
                if (italic) {
                    style ^= 2;
                }
                G.font = new Font(name, style, size);
            }
            list = preferencesElement.getChildren("color");
            for (Element e : list) {
                Element r = e.getChild("r");
                int red = Integer.parseInt(r.getText());
                Element g = e.getChild("g");
                int green = Integer.parseInt(g.getText());
                Element b = e.getChild("b");
                int blue = Integer.parseInt(b.getText());
                G.color = new Color(red, green, blue);
            }
            list = preferencesElement.getChildren("textBelowPictogram");
            for (Element element : list) {
                String language2 = element.getText();
                if (language2 == null) continue;
                G.textBelowPictogram = language2.equals("yes");
            }
            String input = String.valueOf(fileXML.getParent()) + File.separator + "exportbbdd";
            DBManagement.importDB2(input, pb, false);
            int pos = 0;
            Element contentElement = root.getChild("content");
            list = contentElement.getChildren("AWElement");
            for (Element element : list) {
                AWElement newElem;
                String type = element.getAttributeValue("type");
                if (type.equals("pictogram")) {
                    newElem = null;
                    String word = "";
                    int numPictogram = 0;
                    boolean visibleImage = true;
                    boolean visibleBorder = true;
                    String wordSearchBD = "";
                    List list2 = element.getChildren("word");
                    word = list2.isEmpty() ? "" : ((Element)list2.iterator().next()).getText();
                    list2 = element.getChildren("numPictogram");
                    numPictogram = list2.isEmpty() ? 0 : Integer.parseInt(((Element)list2.iterator().next()).getText());
                    list2 = element.getChildren("visibleImage");
                    visibleImage = list2.isEmpty() ? true : ((Element)list2.iterator().next()).getText().equals("no");
                    list2 = element.getChildren("visibleBorder");
                    visibleBorder = list2.isEmpty() ? true : ((Element)list2.iterator().next()).getText().equals("no");
                    list2 = element.getChildren("wordSearchBD");
                    wordSearchBD = list2.isEmpty() ? "" : ((Element)list2.iterator().next()).getText();
                    list2 = element.getChildren("namePicto");
                    String namePicto = "";
                    if (!list2.isEmpty()) {
                        namePicto = ((Element)list2.iterator().next()).getText();
                        numPictogram = wordSearchBD.equals("") ? DBManagement.searchnumPictoOnDB(word, namePicto) : DBManagement.searchnumPictoOnDB(wordSearchBD, namePicto);
                    }
                    newElem = wordSearchBD.equals("") ? AWElement.createPictogramElement(pos, word, numPictogram, visibleImage, visibleBorder, true, "") : AWElement.createPictogramElement(pos, word, numPictogram, visibleImage, visibleBorder, false, wordSearchBD);
                    G.elementList.add(newElem);
                    ++pos;
                    continue;
                }
                if (type.equals("separator")) {
                    newElem = null;
                    String whichSeparator = element.getText();
                    if (whichSeparator.equals("ws")) {
                        newElem = AWElement.createSeparatorElement(pos, "  ");
                    } else if (whichSeparator.equals("nl")) {
                        newElem = AWElement.createSeparatorElement(pos, "\n");
                    } else if (whichSeparator.equals("tab")) {
                        newElem = AWElement.createSeparatorElement(pos, "\t");
                    } else {
                        System.out.println("Something wrong loading file, pos: " + pos);
                    }
                    G.elementList.add(newElem);
                    ++pos;
                    continue;
                }
                System.out.println("Something wrong loading file, pos: " + pos);
            }
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
    }

    private static void fileSaveCommonAWZ(File zipFile) throws IOException {
        final JProgressBar pb = new JProgressBar(0, 100);
        pb.setPreferredSize(new Dimension(175, 20));
        pb.setString(TLanguage.getString("ESPERA"));
        pb.setStringPainted(true);
        pb.setValue(0);
        JLabel label = new JLabel(TLanguage.getString("ESPERA"));
        JPanel center_panel = new JPanel();
        center_panel.add(label);
        center_panel.add(pb);
        final JDialog dialog = new JDialog(null, TLanguage.getString("ESPERA"));
        dialog.getContentPane().add((Component)center_panel, "Center");
        dialog.pack();
        dialog.setVisible(true);
        dialog.setLocationRelativeTo(null);
        dialog.setLocation(150, 125);
        dialog.toFront();
        final File zipFileBG = zipFile;
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                System.out.println("****** BackGround");
                System.out.println("GRABAR ZIP");
                System.out.println("TEMP DIR=" + tempDirectoryPath);
                System.out.println("FileName=" + zipFileBG.getName());
                MenuFunctions.cleanTempDirectory();
                File fileInTemp = new File(tempDirectoryPath, "base");
                MenuFunctions.fileSaveCommonAWD(fileInTemp, pb);
                System.out.println("voy a zipear");
                try {
                    MenuFunctions.zip(tempDirectory, zipFileBG);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                MenuFunctions.deleteTempDirectory();
                return null;
            }

            @Override
            public void done() {
                Toolkit.getDefaultToolkit().beep();
                System.out.println("******* Done!");
                dialog.dispose();
            }
        };
        worker.execute();
    }

    private static void fileSaveCommonAWD(File file, JProgressBar pb) {
        System.out.println("=============== FILESAVECOMMONAWD =============");
        try {
            Element document = new Element("document");
            Element preferences = new Element("preferences");
            Element documentLanguage = new Element("documentLanguage");
            documentLanguage.addContent(G.documentLanguage);
            preferences.addContent((Content)documentLanguage);
            Element imagesSize = new Element("imagesSize");
            imagesSize.addContent(Integer.toString(G.imagesSize));
            preferences.addContent((Content)imagesSize);
            Element font = new Element("font");
            Element name = new Element("name");
            name.addContent(G.font.getName());
            font.addContent((Content)name);
            Element size = new Element("size");
            size.addContent(Integer.toString(G.font.getSize()));
            font.addContent((Content)size);
            Element bold = new Element("bold");
            if (G.font.isBold()) {
                bold.addContent("yes");
            } else {
                bold.addContent("no");
            }
            font.addContent((Content)bold);
            Element italic = new Element("italic");
            if (G.font.isItalic()) {
                italic.addContent("yes");
            } else {
                italic.addContent("no");
            }
            font.addContent((Content)italic);
            preferences.addContent((Content)font);
            Element color = new Element("color");
            Element r = new Element("r");
            r.addContent(Integer.toString(G.color.getRed()));
            color.addContent((Content)r);
            Element g = new Element("g");
            g.addContent(Integer.toString(G.color.getGreen()));
            color.addContent((Content)g);
            Element b = new Element("b");
            b.addContent(Integer.toString(G.color.getBlue()));
            color.addContent((Content)b);
            preferences.addContent((Content)color);
            Element textBelowPictogram = new Element("textBelowPictogram");
            if (G.textBelowPictogram) {
                textBelowPictogram.addContent("yes");
            } else {
                textBelowPictogram.addContent("no");
            }
            preferences.addContent((Content)textBelowPictogram);
            ArrayList<String> customs = new ArrayList<String>();
            ArrayList<String> customsWords = new ArrayList<String>();
            System.out.println("**CReACION LISTAS CUSTOMS*****");
            Element content = new Element("content");
            for (AWElement elem : G.elementList) {
                Element AWElement2 = new Element("AWElement");
                if (elem.getType() == 0) {
                    AWElement2.setAttribute("type", "pictogram");
                    Element word = new Element("word");
                    word.setText(elem.getTextField().getText());
                    AWElement2.addContent((Content)word);
                    if (elem.getImageName().length() > 0) {
                        Element namePictogram = new Element("namePicto");
                        namePictogram.setText(elem.getImageName());
                        AWElement2.addContent((Content)namePictogram);
                    }
                    if (!elem.isVisibleImage()) {
                        Element visibleImage = new Element("visibleImage");
                        visibleImage.setText("no");
                        AWElement2.addContent((Content)visibleImage);
                    }
                    if (!elem.isVisibleBorder()) {
                        Element visibleBorder = new Element("visibleBorder");
                        visibleBorder.setText("no");
                        AWElement2.addContent((Content)visibleBorder);
                    }
                    if (elem.getImageName().length() > 0) {
                        customs.add(elem.getImageName());
                    }
                    if (!elem.isSearchImageOnBD()) {
                        Element wordSearchBD;
                        System.out.println("***SEARCH IMAGE on DB");
                        System.out.println(elem.getWordSearchBD());
                        System.out.println(elem.getInfinitive());
                        if (elem.getInfinitive() != null) {
                            wordSearchBD = new Element("wordSearchBD");
                            wordSearchBD.setText(elem.getWordSearchBD());
                            AWElement2.addContent((Content)wordSearchBD);
                            if (elem.getImageName().length() > 0) {
                                customsWords.add(AWElement.filter(elem.getInfinitive()));
                            }
                        } else {
                            wordSearchBD = new Element("wordSearchBD");
                            wordSearchBD.setText(elem.getWordSearchBD());
                            AWElement2.addContent((Content)wordSearchBD);
                            if (elem.getImageName().length() > 0) {
                                customsWords.add(AWElement.filter(elem.getWordSearchBD()));
                            }
                        }
                    } else if (elem.getInfinitive() != null) {
                        if (elem.getImageName().length() > 0) {
                            customsWords.add(AWElement.filter(elem.getInfinitive()));
                        }
                    } else if (elem.getImageName().length() > 0) {
                        customsWords.add(AWElement.filter(elem.getTextField().getText()));
                    }
                } else {
                    AWElement2.setAttribute("type", "separator");
                    if (elem.getSeparator().equals("  ")) {
                        AWElement2.setText("ws");
                    } else if (elem.getSeparator().equals("\n")) {
                        AWElement2.setText("nl");
                    } else if (elem.getSeparator().equals("\t")) {
                        AWElement2.setText("tab");
                    } else {
                        System.out.println("Problem saving file");
                    }
                }
                content.addContent((Content)AWElement2);
            }
            document.addContent((Content)preferences);
            document.addContent((Content)content);
            System.out.println("aqui ocurre el error");
            org.jdom.Document doc = new org.jdom.Document(document);
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
            FileOutputStream f = null;
            f = file.getCanonicalPath().endsWith(".awd") ? new FileOutputStream(file.getCanonicalPath()) : new FileOutputStream(String.valueOf(file.getCanonicalPath()) + ".awd");
            out.output(doc, (OutputStream)f);
            f.flush();
            f.close();
            System.out.println("ya ha ocurrido el error");
            if (customs.size() > 0) {
                System.out.println("exportar base de datos");
                System.out.println("Customs=" + customs);
                System.out.println("CustomsWords=" + customsWords);
                DBManagement.exportPictosAWZ(String.valueOf(file.getParent()) + File.separator + "exportbbdd", G.documentLanguage, customs, customsWords, pb);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    private static void fileSaveCommon() {
        try {
            JFileChooser fc = new JFileChooser();
            FileNameExtensionFilter filter1 = new FileNameExtensionFilter(TLanguage.getString("ARAWORD_DOCUMENTS"), "awz");
            fc.addChoosableFileFilter(filter1);
            fc.setFileFilter(filter1);
            fc.setAcceptAllFileFilterUsed(false);
            if (fc.showSaveDialog(G.textZone) == 0) {
                String withExtension = fc.getSelectedFile().getAbsolutePath();
                if (!withExtension.toLowerCase().endsWith(".awz")) {
                    withExtension = String.valueOf(withExtension) + ".awz";
                }
                File file = new File(withExtension);
                G.activeDocumentFileName = file.getAbsolutePath();
                MenuFunctions.fileSaveCommonAWZ(file);
            }
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
    }

    public static void fileSave() {
        try {
            boolean isValid = false;
            for (AWElement elem2 : G.elementList) {
                if (elem2.getType() != 0 || elem2.getTextField().getText().equals("")) continue;
                isValid = true;
                break;
            }
            if (!isValid) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("FILE_MENU_SAVE_UNABLE_SAVE_EMPTY_FILE"));
            } else if (G.activeDocumentFileName.equals("")) {
                MenuFunctions.fileSaveCommon();
            } else {
                System.out.println("****** BARRA DE TITULO*******");
                System.out.println(G.activeDocumentFileName);
                MenuFunctions.fileSaveCommonAWZ(new File(G.activeDocumentFileName));
            }
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
    }

    public static void fileSaveAs() {
        try {
            boolean isValid = false;
            for (AWElement elem2 : G.elementList) {
                if (elem2.getType() != 0 || elem2.getTextField().getText().equals("")) continue;
                isValid = true;
                break;
            }
            if (!isValid) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("FILE_MENU_SAVE_UNABLE_SAVE_EMPTY_FILE"));
            } else {
                MenuFunctions.fileSaveCommon();
            }
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
    }

    public static void fileExport() {
        block33: {
            try {
                boolean isValid = false;
                for (AWElement elem2 : G.elementList) {
                    if (elem2.getType() != 0 || elem2.getTextField().getText().equals("")) continue;
                    isValid = true;
                    break;
                }
                if (!isValid) {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("FILE_MENU_SAVE_UNABLE_SAVE_EMPTY_FILE"));
                    break block33;
                }
                try {
                    JFileChooser fc = new JFileChooser();
                    FileNameExtensionFilter filter2 = new FileNameExtensionFilter(TLanguage.getString("PDF_FILES"), "pdf");
                    fc.addChoosableFileFilter(filter2);
                    FileNameExtensionFilter filter3 = new FileNameExtensionFilter(TLanguage.getString("BMP_FILES"), "bmp");
                    fc.addChoosableFileFilter(filter3);
                    FileNameExtensionFilter filter4 = new FileNameExtensionFilter(TLanguage.getString("JPG_FILES"), "jpg");
                    fc.addChoosableFileFilter(filter4);
                    fc.setFileFilter(filter4);
                    fc.setAcceptAllFileFilterUsed(false);
                    if (fc.showSaveDialog(G.textZone) != 0) break block33;
                    File file = fc.getSelectedFile();
                    if (fc.getFileFilter() == filter2) {
                        Document document = new Document(PageSize.A4);
                        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(String.valueOf(file.getCanonicalPath()) + "Pag1.pdf"));
                        document.open();
                        PdfContentByte cb = writer.getDirectContent();
                        JTextPane tempTP = new JTextPane();
                        tempTP.setSize((int)PageSize.A4.getWidth(), (int)PageSize.A4.getHeight());
                        tempTP.setMinimumSize(new Dimension((int)PageSize.A4.getWidth(), (int)PageSize.A4.getHeight()));
                        tempTP.setMaximumSize(new Dimension((int)PageSize.A4.getWidth(), (int)PageSize.A4.getHeight()));
                        tempTP.setPreferredSize(new Dimension((int)PageSize.A4.getWidth(), (int)PageSize.A4.getHeight()));
                        tempTP.setMargin(new Insets(10, 10, 10, 10));
                        int numPixelsHor = (int)PageSize.A4.getWidth();
                        int numPixelsVer = (int)PageSize.A4.getHeight();
                        int numPixelsHorConsumed = 0;
                        int numPixelsVerConsumed = (int)G.elementList.get(0).getSize().getHeight();
                        int pxPerTab = 56;
                        int pxPerSpace = 10;
                        int numPages = 1;
                        boolean justReadNewLine = false;
                        int pxPerNewLine = 15;
                        for (AWElement elem : G.elementList) {
                            JScrollPane scrollPane;
                            JDialog dlg;
                            Graphics2D g2;
                            if (elem.getType() == 0) {
                                justReadNewLine = false;
                                if ((numPixelsHorConsumed = (int)((double)numPixelsHorConsumed + elem.getSize().getWidth())) > numPixelsHor) {
                                    numPixelsVerConsumed = (int)((double)numPixelsVerConsumed + elem.getSize().getHeight());
                                    numPixelsHorConsumed = (int)elem.getSize().getWidth();
                                }
                                if (numPixelsVerConsumed > numPixelsVer) {
                                    numPixelsVerConsumed = (int)elem.getSize().getHeight();
                                    g2 = cb.createGraphics(PageSize.A4.getWidth(), PageSize.A4.getHeight(), true, 0.95f);
                                    dlg = new JDialog();
                                    scrollPane = new JScrollPane(tempTP);
                                    dlg.getContentPane().add((Component)scrollPane, "Center");
                                    dlg.pack();
                                    tempTP.print(g2);
                                    g2.dispose();
                                    document.close();
                                    document = new Document(PageSize.A4);
                                    writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(String.valueOf(file.getCanonicalPath()) + "Pag" + ++numPages + ".pdf"));
                                    document.open();
                                    cb = writer.getDirectContent();
                                    tempTP.setText("");
                                    tempTP.setStyledDocument(new DefaultStyledDocument());
                                }
                                tempTP.insertComponent((AWElement)TextUtils.copy(elem));
                                continue;
                            }
                            if (elem.getSeparator().equals("\n")) {
                                numPixelsVerConsumed = justReadNewLine ? (numPixelsVerConsumed += pxPerNewLine) : (int)((double)numPixelsVerConsumed + elem.getSize().getHeight());
                                justReadNewLine = true;
                                numPixelsHorConsumed = 0;
                                if (numPixelsVerConsumed > numPixelsVer) {
                                    numPixelsVerConsumed = (int)elem.getSize().getHeight();
                                    g2 = cb.createGraphics(PageSize.A4.getWidth(), PageSize.A4.getHeight(), true, 0.95f);
                                    dlg = new JDialog();
                                    scrollPane = new JScrollPane(tempTP);
                                    dlg.getContentPane().add((Component)scrollPane, "Center");
                                    dlg.pack();
                                    tempTP.print(g2);
                                    g2.dispose();
                                    document.close();
                                    document = new Document(PageSize.A4);
                                    writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(String.valueOf(file.getCanonicalPath()) + "Pag" + ++numPages + ".pdf"));
                                    document.open();
                                    cb = writer.getDirectContent();
                                    tempTP.setText("");
                                    tempTP.setStyledDocument(new DefaultStyledDocument());
                                }
                            } else if (elem.getSeparator().equals("\t")) {
                                if ((numPixelsHorConsumed += pxPerTab) > numPixelsHor) {
                                    numPixelsVerConsumed = (int)((double)numPixelsVerConsumed + elem.getSize().getHeight());
                                    numPixelsHorConsumed = pxPerTab;
                                }
                                if (numPixelsVerConsumed > numPixelsVer) {
                                    numPixelsVerConsumed = (int)elem.getSize().getHeight();
                                    g2 = cb.createGraphics(PageSize.A4.getWidth(), PageSize.A4.getHeight(), true, 0.95f);
                                    dlg = new JDialog();
                                    scrollPane = new JScrollPane(tempTP);
                                    dlg.getContentPane().add((Component)scrollPane, "Center");
                                    dlg.pack();
                                    tempTP.print(g2);
                                    g2.dispose();
                                    document.close();
                                    document = new Document(PageSize.A4);
                                    writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(String.valueOf(file.getCanonicalPath()) + "Pag" + ++numPages + ".pdf"));
                                    document.open();
                                    cb = writer.getDirectContent();
                                    tempTP.setText("");
                                    tempTP.setStyledDocument(new DefaultStyledDocument());
                                }
                            } else if (elem.getSeparator().equals("  ")) {
                                if ((numPixelsHorConsumed += pxPerSpace) > numPixelsHor) {
                                    numPixelsVerConsumed = (int)((double)numPixelsVerConsumed + elem.getSize().getHeight());
                                    numPixelsHorConsumed = pxPerSpace;
                                }
                                if (numPixelsVerConsumed > numPixelsVer) {
                                    numPixelsVerConsumed = (int)elem.getSize().getHeight();
                                    g2 = cb.createGraphics(PageSize.A4.getWidth(), PageSize.A4.getHeight(), true, 0.95f);
                                    dlg = new JDialog();
                                    scrollPane = new JScrollPane(tempTP);
                                    dlg.getContentPane().add((Component)scrollPane, "Center");
                                    dlg.pack();
                                    tempTP.print(g2);
                                    g2.dispose();
                                    document.close();
                                    document = new Document(PageSize.A4);
                                    writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(String.valueOf(file.getCanonicalPath()) + "Pag" + ++numPages + ".pdf"));
                                    document.open();
                                    cb = writer.getDirectContent();
                                    tempTP.setText("");
                                    tempTP.setStyledDocument(new DefaultStyledDocument());
                                }
                            } else {
                                System.out.println("Wrong element saving PDF");
                            }
                            tempTP.getStyledDocument().insertString(tempTP.getStyledDocument().getLength(), elem.getSeparator(), null);
                        }
                        Graphics2D g2 = cb.createGraphics(PageSize.A4.getWidth(), PageSize.A4.getHeight());
                        JDialog dlg = new JDialog();
                        JScrollPane scrollPane = new JScrollPane(tempTP);
                        dlg.getContentPane().add((Component)scrollPane, "Center");
                        dlg.pack();
                        tempTP.print(g2);
                        g2.dispose();
                        document.close();
                        try {
                            ArrayList<InputStream> pdfs = new ArrayList<InputStream>();
                            int i = 1;
                            while (i <= numPages) {
                                String withExtension = file.getCanonicalPath();
                                if (withExtension.toLowerCase().endsWith(".pdf")) {
                                    withExtension = withExtension.substring(0, withExtension.length() - 4);
                                }
                                pdfs.add(new FileInputStream(String.valueOf(withExtension) + "Pag" + i + ".pdf"));
                                ++i;
                            }
                            String withExtension = file.getCanonicalPath();
                            if (!withExtension.toLowerCase().endsWith(".pdf")) {
                                withExtension = String.valueOf(withExtension) + ".pdf";
                            }
                            FileOutputStream output = new FileOutputStream(withExtension);
                            TextUtils.concatPDFs(pdfs, output, true);
                            int i2 = 1;
                            while (i2 <= numPages) {
                                ((InputStream)pdfs.get(i2 - 1)).close();
                                withExtension = file.getCanonicalPath();
                                if (withExtension.toLowerCase().endsWith(".pdf")) {
                                    withExtension = withExtension.substring(0, withExtension.length() - 4);
                                }
                                File f = new File(String.valueOf(withExtension) + "Pag" + i2 + ".pdf");
                                f.delete();
                                ++i2;
                            }
                            break block33;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break block33;
                    }
                    if (fc.getFileFilter() == filter3) {
                        String withExtension = file.getCanonicalPath();
                        if (!withExtension.toLowerCase().endsWith(".bmp")) {
                            withExtension = String.valueOf(withExtension) + ".bmp";
                        }
                        ScreenImage.writeImage(ScreenImage.createImage(G.textZone), withExtension);
                        break block33;
                    }
                    if (fc.getFileFilter() == filter4) {
                        String withExtension = file.getCanonicalPath();
                        if (!withExtension.toLowerCase().endsWith(".jpg")) {
                            withExtension = String.valueOf(withExtension) + ".jpg";
                        }
                        ScreenImage.writeImage(ScreenImage.createImage(G.textZone), withExtension);
                        break block33;
                    }
                    System.out.println("fileExport problem: wrong filter selected");
                }
                catch (Exception exc) {
                    System.out.println(exc);
                }
            }
            catch (Exception exc) {
                System.out.println(exc);
            }
        }
    }

    public static void filePDFExport() {
        block28: {
            System.out.println("@@@ entro en file PDFExport");
            double pictoRatio = 1.5;
            try {
                boolean isValid = false;
                for (AWElement elem2 : G.elementList) {
                    if (elem2.getType() != 0 || elem2.getTextField().getText().equals("")) continue;
                    isValid = true;
                    break;
                }
                if (!isValid) {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("FILE_MENU_SAVE_UNABLE_SAVE_EMPTY_FILE"));
                    break block28;
                }
                try {
                    JFileChooser fc = new JFileChooser();
                    FileNameExtensionFilter filter2 = new FileNameExtensionFilter(TLanguage.getString("PDF_FILES"), "pdf");
                    fc.addChoosableFileFilter(filter2);
                    fc.setFileFilter(filter2);
                    fc.setAcceptAllFileFilterUsed(false);
                    if (fc.showSaveDialog(G.textZone) != 0) break block28;
                    String withExtension = fc.getSelectedFile().getAbsolutePath();
                    if (withExtension.toLowerCase().endsWith(".pdf")) {
                        withExtension = withExtension.substring(0, withExtension.length() - 4);
                    }
                    File file = new File(withExtension);
                    if (fc.getFileFilter() == filter2) {
                        Document document = new Document(PageSize.A4);
                        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(String.valueOf(file.getCanonicalPath()) + "Pag1.pdf"));
                        HeaderFooter event = new HeaderFooter();
                        writer.setBoxSize("art", new Rectangle(36.0f, 54.0f, 559.0f, 788.0f));
                        writer.setPageEvent((PdfPageEvent)event);
                        document.open();
                        PdfContentByte cb = writer.getDirectContent();
                        JTextPane tempTP = new JTextPane();
                        tempTP.setSize((int)PageSize.A4.getWidth(), (int)PageSize.A4.getHeight());
                        tempTP.setMinimumSize(new Dimension((int)PageSize.A4.getWidth(), (int)PageSize.A4.getHeight()));
                        tempTP.setMaximumSize(new Dimension((int)PageSize.A4.getWidth(), (int)PageSize.A4.getHeight()));
                        tempTP.setPreferredSize(new Dimension((int)PageSize.A4.getWidth(), (int)PageSize.A4.getHeight()));
                        tempTP.setMargin(new Insets(20, 20, 10, 10));
                        int numPixelsHor = (int)PageSize.A4.getWidth();
                        int numPixelsVer = (int)PageSize.A4.getHeight() - 100;
                        System.out.println("A4: altura=" + numPixelsHor + "* anchura=" + numPixelsVer);
                        int pictoSize = G.imagesSize = (int)((double)G.imagesSize * 2.0);
                        int picLine = 0;
                        int numPixelsHorConsumed = 0;
                        int numPixelsVerConsumed = (int)((double)pictoSize * pictoRatio);
                        int pxPerTab = 56;
                        int pxPerSpace = 10;
                        int numPages = 1;
                        boolean justReadNewLine = false;
                        int pxPerNewLine = 15;
                        System.out.println("Tama\u00c3\u00b1o pico=" + pictoSize);
                        int numElements = G.elementList.size();
                        int i = 0;
                        while (i < numElements) {
                            JScrollPane scrollPane;
                            JDialog dlg;
                            Graphics2D g2;
                            AWElement elem = G.elementList.get(i);
                            if (elem.getType() == 0) {
                                justReadNewLine = false;
                                if ((numPixelsHorConsumed += pictoSize) > numPixelsHor || ++picLine > G.numPictosLinePDF) {
                                    numPixelsVerConsumed = (int)((double)numPixelsVerConsumed + (double)pictoSize * pictoRatio);
                                    numPixelsHorConsumed = pictoSize;
                                    picLine = 1;
                                }
                                if (numPixelsVerConsumed > numPixelsVer) {
                                    numPixelsVerConsumed = pictoSize;
                                    numPixelsHorConsumed = pictoSize;
                                    picLine = 1;
                                    g2 = cb.createGraphics(PageSize.A4.getWidth(), PageSize.A4.getHeight(), true, 0.95f);
                                    dlg = new JDialog();
                                    scrollPane = new JScrollPane(tempTP);
                                    dlg.getContentPane().add((Component)scrollPane, "Center");
                                    dlg.pack();
                                    tempTP.print(g2);
                                    g2.dispose();
                                    document.close();
                                    document = new Document(PageSize.A4);
                                    writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(String.valueOf(file.getCanonicalPath()) + "Pag" + ++numPages + ".pdf"));
                                    writer.setBoxSize("art", new Rectangle(36.0f, 54.0f, 559.0f, 788.0f));
                                    writer.setPageEvent((PdfPageEvent)event);
                                    document.open();
                                    cb = writer.getDirectContent();
                                    tempTP.setText("");
                                    tempTP.setStyledDocument(new DefaultStyledDocument());
                                }
                                AWElement newElem = null;
                                newElem = AWElement.createPDFPrevPictogramElement(i, elem.getTextField().getText(), elem.getNumPictogram(), elem.isVisibleImage(), elem.isVisibleBorder(), elem.isSearchImageOnBD(), elem.getWordSearchBD(), false);
                                tempTP.insertComponent(newElem);
                            } else {
                                if (elem.getSeparator().equals("\n")) {
                                    numPixelsVerConsumed = justReadNewLine ? (numPixelsVerConsumed += pxPerNewLine) : (int)((double)numPixelsVerConsumed + (double)G.imagesSize * pictoRatio);
                                    justReadNewLine = true;
                                    numPixelsHorConsumed = 0;
                                    picLine = 0;
                                    if (numPixelsVerConsumed > numPixelsVer) {
                                        numPixelsVerConsumed = (int)((double)G.imagesSize * pictoRatio);
                                        g2 = cb.createGraphics(PageSize.A4.getWidth(), PageSize.A4.getHeight(), true, 0.95f);
                                        dlg = new JDialog();
                                        scrollPane = new JScrollPane(tempTP);
                                        dlg.getContentPane().add((Component)scrollPane, "Center");
                                        dlg.pack();
                                        tempTP.print(g2);
                                        g2.dispose();
                                        document.close();
                                        document = new Document(PageSize.A4);
                                        writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(String.valueOf(file.getCanonicalPath()) + "Pag" + ++numPages + ".pdf"));
                                        writer.setBoxSize("art", new Rectangle(36.0f, 54.0f, 559.0f, 788.0f));
                                        writer.setPageEvent((PdfPageEvent)event);
                                        document.open();
                                        cb = writer.getDirectContent();
                                        tempTP.setText("");
                                        tempTP.setStyledDocument(new DefaultStyledDocument());
                                    }
                                } else if (elem.getSeparator().equals("\t")) {
                                    if ((numPixelsHorConsumed += pxPerTab) > numPixelsHor) {
                                        numPixelsVerConsumed = (int)((double)numPixelsVerConsumed + (double)G.imagesSize * pictoRatio);
                                        numPixelsHorConsumed += pxPerTab;
                                    }
                                    if (numPixelsVerConsumed > numPixelsVer) {
                                        numPixelsVerConsumed = (int)((double)G.imagesSize * pictoRatio);
                                        picLine = 0;
                                        g2 = cb.createGraphics(PageSize.A4.getWidth(), PageSize.A4.getHeight(), true, 0.95f);
                                        dlg = new JDialog();
                                        scrollPane = new JScrollPane(tempTP);
                                        dlg.getContentPane().add((Component)scrollPane, "Center");
                                        dlg.pack();
                                        tempTP.print(g2);
                                        g2.dispose();
                                        document.close();
                                        document = new Document(PageSize.A4);
                                        writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(String.valueOf(file.getCanonicalPath()) + "Pag" + ++numPages + ".pdf"));
                                        writer.setBoxSize("art", new Rectangle(36.0f, 54.0f, 559.0f, 788.0f));
                                        writer.setPageEvent((PdfPageEvent)event);
                                        document.open();
                                        cb = writer.getDirectContent();
                                        tempTP.setText("");
                                        tempTP.setStyledDocument(new DefaultStyledDocument());
                                    }
                                } else if (elem.getSeparator().equals("  ")) {
                                    if ((numPixelsHorConsumed += pxPerSpace) > numPixelsHor) {
                                        numPixelsVerConsumed = (int)((double)numPixelsVerConsumed + (double)G.imagesSize * pictoRatio);
                                        numPixelsHorConsumed = pxPerSpace;
                                        picLine = 0;
                                    }
                                    if (numPixelsVerConsumed > numPixelsVer) {
                                        numPixelsVerConsumed = (int)((double)G.imagesSize * pictoRatio);
                                        g2 = cb.createGraphics(PageSize.A4.getWidth(), PageSize.A4.getHeight(), true, 0.95f);
                                        picLine = 0;
                                        dlg = new JDialog();
                                        scrollPane = new JScrollPane(tempTP);
                                        dlg.getContentPane().add((Component)scrollPane, "Center");
                                        dlg.pack();
                                        tempTP.print(g2);
                                        g2.dispose();
                                        document.close();
                                        document = new Document(PageSize.A4);
                                        writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(String.valueOf(file.getCanonicalPath()) + "Pag" + ++numPages + ".pdf"));
                                        writer.setBoxSize("art", new Rectangle(36.0f, 54.0f, 559.0f, 788.0f));
                                        writer.setPageEvent((PdfPageEvent)event);
                                        document.open();
                                        cb = writer.getDirectContent();
                                        tempTP.setText("");
                                        tempTP.setStyledDocument(new DefaultStyledDocument());
                                    }
                                } else {
                                    System.out.println("Wrong element saving PDF");
                                }
                                tempTP.getStyledDocument().insertString(tempTP.getStyledDocument().getLength(), elem.getSeparator(), null);
                            }
                            ++i;
                        }
                        Graphics2D g2 = cb.createGraphics(PageSize.A4.getWidth(), PageSize.A4.getHeight());
                        JDialog dlg = new JDialog();
                        JScrollPane scrollPane = new JScrollPane(tempTP);
                        dlg.getContentPane().add((Component)scrollPane, "Center");
                        dlg.pack();
                        tempTP.print(g2);
                        g2.dispose();
                        document.close();
                        try {
                            ArrayList<InputStream> pdfs = new ArrayList<InputStream>();
                            int i2 = 1;
                            while (i2 <= numPages) {
                                pdfs.add(new FileInputStream(String.valueOf(file.getCanonicalPath()) + "Pag" + i2 + ".pdf"));
                                ++i2;
                            }
                            FileOutputStream output = new FileOutputStream(String.valueOf(file.getCanonicalPath()) + ".pdf");
                            TextUtils.concatPDFs(pdfs, output, true);
                            int i3 = 1;
                            while (i3 <= numPages) {
                                ((InputStream)pdfs.get(i3 - 1)).close();
                                File f = new File(String.valueOf(file.getCanonicalPath()) + "Pag" + i3 + ".pdf");
                                f.delete();
                                ++i3;
                            }
                            break block28;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break block28;
                    }
                    System.out.println("fileExport problem: wrong filter selected");
                }
                catch (Exception exc) {
                    System.out.println(exc);
                }
            }
            catch (Exception exc) {
                System.out.println(exc);
            }
        }
    }

    public static void editUndo() {
        if (G.undoList.size() == 0) {
            JOptionPane.showMessageDialog(null, TLanguage.getString("EDIT_MENU_UNDO_UNABLE_MORE_UNDO"), TLanguage.getString("WARNING"), 1);
            return;
        }
        G.redoList.add(0, TextUtils.ElementList2String(G.elementList));
        if (G.redoList.size() > 2 * G.maxUndoLevel) {
            int aux = G.redoList.size();
            int i = G.maxUndoLevel;
            while (i < aux) {
                G.redoList.remove(G.maxUndoLevel);
                ++i;
            }
            G.redoList.trimToSize();
        }
        G.elementList = TextUtils.String2ElementList(G.undoList.get(0));
        G.undoList.remove(0);
        TextUtils.regenerateTextZone();
        G.elementList.get(0).getTextField().requestFocusInWindow();
    }

    public static void editRedo() {
        if (G.redoList.size() == 0) {
            JOptionPane.showMessageDialog(null, TLanguage.getString("EDIT_MENU_REDO_UNABLE_MORE_REDO"), TLanguage.getString("WARNING"), 1);
            return;
        }
        G.undoList.add(0, TextUtils.ElementList2String(G.elementList));
        G.elementList = TextUtils.String2ElementList(G.redoList.get(0));
        G.redoList.remove(0);
        TextUtils.regenerateTextZone();
        G.elementList.get(0).getTextField().requestFocusInWindow();
    }

    public static void editCut() {
        if (G.selectionState == 2) {
            boolean fullSelection = true;
            int i = 0;
            while (i < G.indexSelectionFrom) {
                if (G.elementList.get(i).getType() == 0) {
                    fullSelection = false;
                    break;
                }
                ++i;
            }
            if (fullSelection) {
                i = G.elementList.size() - 1;
                while (i > G.indexSelectionTo) {
                    if (G.elementList.get(i).getType() == 0) {
                        fullSelection = false;
                        break;
                    }
                    --i;
                }
            }
            if (fullSelection) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("EDIT_MENU_CUT_UNABLE_CUT_ALL"), TLanguage.getString("WARNING"), 1);
            } else {
                int i2;
                String str = "";
                TextUtils.updateUndo();
                G.selectionState = 0;
                ArrayList<AWElement> eL = new ArrayList<AWElement>();
                int i3 = G.indexSelectionFrom;
                while (i3 <= G.indexSelectionTo) {
                    eL.add(G.elementList.get(i3));
                    ++i3;
                }
                str = TextUtils.ElementList2String(eL);
                StringSelection ss = new StringSelection(str);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
                if (G.indexSelectionTo == G.elementList.size() - 1) {
                    i2 = G.indexSelectionFrom;
                    while (i2 <= G.indexSelectionTo) {
                        G.elementList.remove(G.indexSelectionFrom);
                        ++i2;
                    }
                } else {
                    i2 = G.indexSelectionFrom;
                    while (i2 <= G.indexSelectionTo + 1) {
                        G.elementList.remove(G.indexSelectionFrom);
                        ++i2;
                    }
                }
                int count = G.indexSelectionFrom;
                while (count < G.elementList.size()) {
                    AWElement tmpE = G.elementList.get(count);
                    tmpE.setPosition(count);
                    ++count;
                }
                TextUtils.regenerateTextZone();
                if (!G.activeElement.getTextField().requestFocusInWindow()) {
                    Component[] myComps = G.textZone.getComponents();
                    Component realComp = ((Container)myComps[0]).getComponent(0);
                    ((AWElement)realComp).getTextField().requestFocusInWindow();
                }
            }
        }
    }

    public static void editCopy() {
        if (G.selectionState == 2) {
            int i = G.indexSelectionFrom;
            while (i <= G.indexSelectionTo) {
                G.elementList.get(i).setBackground(Color.WHITE);
                ++i;
            }
            String str = "";
            TextUtils.updateUndo();
            G.selectionState = 0;
            ArrayList<AWElement> eL = new ArrayList<AWElement>();
            int i2 = G.indexSelectionFrom;
            while (i2 <= G.indexSelectionTo) {
                eL.add(G.elementList.get(i2));
                ++i2;
            }
            str = TextUtils.ElementList2String(eL);
            StringSelection ss = new StringSelection(str);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
        }
    }

    public static void editPaste(int pastePos) {
        G.selectionState = 0;
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String text = (String)t.getTransferData(DataFlavor.stringFlavor);
                ArrayList<AWElement> aux = TextUtils.String2ElementList(text);
                G.elementList.add(pastePos, AWElement.createSeparatorElement(pastePos, "  "));
                int i = 0;
                while (i < aux.size()) {
                    G.elementList.add(pastePos + i + 1, aux.get(i));
                    ++i;
                }
                int count = pastePos;
                while (count < G.elementList.size()) {
                    AWElement tmpE = G.elementList.get(count);
                    tmpE.setPosition(count);
                    ++count;
                }
                TextUtils.regenerateTextZone();
                G.activeElement.getTextField().requestFocusInWindow();
            }
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
    }

    public static void pictogramNextImage() {
        try {
            Statement statAux;
            ResultSet rsAux;
            if (!(G.activeComponent instanceof AWTextField)) {
                return;
            }
            int numPictogram = G.activeElement.getNumPictogram();
            String str = G.activeElement.getTextField().getText().toLowerCase();
            if (!(str.equals("\u00a1") || str.equals("\u00bf") || str.equals("!") || str.equals("?"))) {
                if (str.endsWith("...")) {
                    str = str.substring(0, str.length() - 3);
                } else if (str.endsWith(",") || str.endsWith(";") || str.endsWith(":") || str.endsWith(".")) {
                    str = str.substring(0, str.length() - 1);
                }
            }
            ArrayList<String> paths = new ArrayList<String>();
            ResultSet rs = DB.getInstance().query("select * from ArawordView where word='" + str.replace("'", "''") + "'");
            while (rs.next()) {
                String name = rs.getString("name");
                paths.add(name);
            }
            if (G.documentLanguage.equals("Castellano") && (rsAux = (statAux = G.connVerbsDB.createStatement()).executeQuery("select * from verbs where form='" + str.replace("'", "''") + "'")).next()) {
                String verb = rsAux.getString("verb");
                rs = DB.getInstance().query("select * from ArawordView where word='" + verb.replace("'", "''") + "'");
                while (rs.next()) {
                    String name = rs.getString("name");
                    paths.add(name);
                }
            }
            if (!paths.isEmpty()) {
                G.activeElement.setNumPictogram((numPictogram + 1) % paths.size());
                G.activeElement.regeneratePictogram();
                G.lastPictogramWordAssociation.put(G.activeElement.getTextField().getText().toLowerCase(), G.activeElement.getNumPictogram());
            }
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
    }

    public static void pictogramCompoundSplit() {
        if (!(G.activeComponent instanceof AWTextField)) {
            return;
        }
        if (!G.activeElement.isCompound()) {
            TextUtils.updateUndo();
            int tmp = G.maxLengthCompoundWords;
            G.maxLengthCompoundWords = 6;
            if (TextUtils.checkCompoundWord()) {
                TextUtils.regenerateTextZone();
            }
            G.maxLengthCompoundWords = tmp;
        } else {
            TextUtils.updateUndo();
            TextUtils.splitWord();
        }
    }

    public static void pictogramHideImageActiveElement() {
        if (!(G.activeComponent instanceof AWTextField)) {
            return;
        }
        if (G.activeElement.isVisibleImage()) {
            G.activeElement.setVisibleImage(false);
            G.activeElement.regeneratePictogram();
        }
    }

    public static void pictogramHideImageAllElements() {
        if (!(G.activeComponent instanceof AWTextField)) {
            return;
        }
        for (AWElement elem : G.elementList) {
            if (elem.getType() != 0 || !elem.isVisibleImage()) continue;
            elem.setVisibleImage(false);
            elem.regeneratePictogram();
        }
    }

    public static void pictogramHideBorderActiveElement() {
        if (!(G.activeComponent instanceof AWTextField)) {
            return;
        }
        if (G.activeElement.isVisibleBorder()) {
            G.activeElement.setVisibleBorder(false);
            G.activeElement.regeneratePictogram();
        }
    }

    public static void pictogramHideBorderAllElements() {
        if (!(G.activeComponent instanceof AWTextField)) {
            return;
        }
        for (AWElement elem : G.elementList) {
            if (elem.getType() != 0 || !elem.isVisibleBorder()) continue;
            elem.setVisibleBorder(false);
            elem.regeneratePictogram();
        }
    }

    public static void pictogramShowImageActiveElement() {
        if (!(G.activeComponent instanceof AWTextField)) {
            return;
        }
        if (!G.activeElement.isVisibleImage()) {
            G.activeElement.setVisibleImage(true);
            G.activeElement.regeneratePictogram();
        }
    }

    public static void pictogramShowImageAllElements() {
        if (!(G.activeComponent instanceof AWTextField)) {
            return;
        }
        for (AWElement elem : G.elementList) {
            if (elem.getType() != 0 || elem.isVisibleImage()) continue;
            elem.setVisibleImage(true);
            elem.regeneratePictogram();
        }
    }

    public static void pictogramShowBorderActiveElement() {
        if (!(G.activeComponent instanceof AWTextField)) {
            return;
        }
        if (!G.activeElement.isVisibleBorder()) {
            G.activeElement.setVisibleBorder(true);
            G.activeElement.regeneratePictogram();
        }
    }

    public static void pictogramShowBorderAllElements() {
        if (!(G.activeComponent instanceof AWTextField)) {
            return;
        }
        for (AWElement elem : G.elementList) {
            if (elem.getType() != 0 || elem.isVisibleBorder()) continue;
            elem.setVisibleBorder(true);
            elem.regeneratePictogram();
        }
    }

    public static void pictogramToUpperCaseActiveElement() {
        if (!(G.activeComponent instanceof AWTextField)) {
            return;
        }
        G.activeElement.getTextField().setText(G.activeElement.getTextField().getText().toUpperCase());
        G.activeElement.regeneratePictogram();
    }

    public static void pictogramToUpperCaseAllElements() {
        if (!(G.activeComponent instanceof AWTextField)) {
            return;
        }
        for (AWElement elem : G.elementList) {
            if (elem.getType() != 0) continue;
            elem.getTextField().setText(elem.getTextField().getText().toUpperCase());
            elem.regeneratePictogram();
        }
    }

    public static void pictogramToLowerCaseActiveElement() {
        if (!(G.activeComponent instanceof AWTextField)) {
            return;
        }
        G.activeElement.getTextField().setText(G.activeElement.getTextField().getText().toLowerCase());
        G.activeElement.regeneratePictogram();
    }

    public static void pictogramToLowerCaseAllElements() {
        if (!(G.activeComponent instanceof AWTextField)) {
            return;
        }
        for (AWElement elem : G.elementList) {
            if (elem.getType() != 0) continue;
            elem.getTextField().setText(elem.getTextField().getText().toLowerCase());
            elem.regeneratePictogram();
        }
    }

    public static void pictogramChangeName() {
        if (!(G.activeComponent instanceof AWTextField)) {
            return;
        }
        if (G.activeElement.isSearchImageOnBD()) {
            G.activeElement.setSearchImageOnBD(false);
            G.activeElement.setWordSearchBD(G.activeElement.getTextField().getText());
        }
    }

    public static void pictogramNewName() {
        String imageName = G.activeElement.getImageName();
        String newTextImage = G.activeElement.getTextField().getText();
        JLabel image = new JLabel(G.activeElement.getImage().getIcon());
        if (!newTextImage.equals("") && !imageName.equals("")) {
            G.activeElement.setWordSearchBD(newTextImage);
        }
        InsertWordImageFrame f = new InsertWordImageFrame(G.applicationLanguage, image, newTextImage);
        f.setImageName(imageName);
        f.setVisible(true);
        f.pack();
    }

    public static void pictogramInsertImage() {
        mainFrame f = new mainFrame(G.applicationLanguage);
        f.setVisible(true);
        f.pack();
    }

    public static void VoiceSintesys() {
        G.ttsStrategy.play(TextUtils.getText(), G.ttsRate);
    }

    public static File getTempDirectory() {
        return tempDirectory;
    }

    public static String getTempDirectoryPath() {
        return tempDirectoryPath;
    }

    public static void deleteTempDirectory() {
        TFileHandler.deleteDirectory(tempDirectory);
    }

    public static void cleanTempDirectory() {
        TFileHandler.deleteDirectory(tempDirectory);
    }

    private static void zip(File srcDir, File dstFile) throws IOException {
        System.out.println("operacion de zipear");
        System.out.println("en " + dstFile.getAbsolutePath());
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(dstFile));
        MenuFunctions.zip(srcDir, srcDir, zos);
        zos.close();
    }

    private static void zip(File srcDir, File originSrcDir, ZipOutputStream dstStream) throws IOException {
        byte[] buffer = new byte[2048];
        int bytes = 0;
        String[] dirList = srcDir.list();
        int i = 0;
        while (i < dirList.length) {
            File file = new File(srcDir, dirList[i]);
            if (file.isDirectory()) {
                MenuFunctions.zip(file, originSrcDir, dstStream);
            } else {
                FileInputStream fis = new FileInputStream(file);
                ZipEntry entry = new ZipEntry(TFileHandler.removeDirectoryPath(originSrcDir.getAbsolutePath(), file.getAbsolutePath()));
                dstStream.putNextEntry(entry);
                while ((bytes = fis.read(buffer)) != -1) {
                    dstStream.write(buffer, 0, bytes);
                }
                fis.close();
            }
            ++i;
        }
    }

    private static void unzip(File srcFile, File dstDir) throws IOException {
        byte[] buffer = new byte[2048];
        ZipFile zipFile = new ZipFile(srcFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            int bytes;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                File newDirectory = new File(entry.getName());
                if (newDirectory.exists()) continue;
                newDirectory.mkdirs();
                continue;
            }
            File newFile = new File(dstDir, entry.getName().replace('\\', '/'));
            File newFileDir = newFile.getParentFile();
            if (!newFileDir.exists()) {
                newFileDir.mkdirs();
            }
            InputStream in = zipFile.getInputStream(entry);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newFile));
            while ((bytes = in.read(buffer)) >= 0) {
                ((OutputStream)out).write(buffer, 0, bytes);
            }
            in.close();
            ((OutputStream)out).close();
        }
        zipFile.close();
    }

    class Task
    extends SwingWorker<Void, Void> {
        Task() {
        }

        @Override
        public Void doInBackground() {
            Random random = new Random();
            int progress = 0;
            this.setProgress(0);
            while (progress < 100) {
                try {
                    Thread.sleep(random.nextInt(1000));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.setProgress(Math.min(progress += random.nextInt(10), 100));
                System.out.println("background");
            }
            return null;
        }

        @Override
        public void done() {
            Toolkit.getDefaultToolkit().beep();
            System.out.println("Done!\n");
        }
    }
}

