/*
 * Decompiled with CFR 0.152.
 */
package araword.db;

import araword.G;
import araword.configuration.TLanguage;
import araword.db.DBResult;
import araword.gui.GUI;
import database.DB;
import database.ImageManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.ProgressMonitorInputStream;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class DBManagement {
    private static final int BUFFSIZE = 1024;
    private static byte[] buff1 = new byte[1024];
    private static byte[] buff2 = new byte[1024];

    public static void connectDB() {
    }

    public static void connectVerbsDB() {
        try {
            String verbs_data_base_name = new String(String.valueOf(G.documentLanguage) + "_verbs");
            String verbs_txt_file_name = new String(String.valueOf(G.documentLanguage) + "_verbs.txt");
            if (verbs_data_base_name.length() > 0) {
                Class.forName("org.sqlite.JDBC");
                String fileName = "resources" + File.separator + verbs_data_base_name + ".db";
                File dataBase = new File(fileName);
                File conjugated_verbs = new File("resources" + File.separator + verbs_txt_file_name);
                if (dataBase.exists()) {
                    G.connVerbsDB = DriverManager.getConnection("jdbc:sqlite:" + fileName);
                } else if (conjugated_verbs.exists()) {
                    G.connVerbsDB = DriverManager.getConnection("jdbc:sqlite:" + fileName);
                    DBManagement.createTablesVerbsDB(verbs_txt_file_name);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(e.toString());
        }
    }

    public static void closeDB() {
        try {
            DB.getInstance().close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(e.toString());
        }
    }

    public static void createAraWordView(String language) {
        try {
            String query = "DROP VIEW IF EXISTS ArawordView";
            DB.getInstance().update(query);
            query = "";
            query = language.equals("(todos // all)") ? "CREATE VIEW IF NOT EXISTS ArawordView AS SELECT M.word word, T.name type, M.name name FROM main M, type TWHERE M.idT = T.id ORDER BY word" : "CREATE VIEW IF NOT EXISTS ArawordView AS SELECT M.word word, T.name type, M.name name FROM main M, type T, language L WHERE M.idT = T.id AND M.idL = L.id AND L.name =\"" + language + "\" " + "ORDER BY word";
            DB.getInstance().update(query);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(e.toString());
        }
    }

    public static DBResult searchOnDB(String word, int numPictogram) {
        DBResult dbr = new DBResult();
        dbr.setImage(G.notFound);
        dbr.setBorder(G.borders.get("NO_BORDER"));
        dbr.setFileImage("");
        try {
            String fileName;
            File file;
            if (word.equals("")) {
                return dbr;
            }
            String str = word.toLowerCase();
            if (!(str.equals("\u00a1") || str.equals("\u00bf") || str.equals("!") || str.equals("?"))) {
                if (str.endsWith("...")) {
                    str = str.substring(0, str.length() - 3);
                } else if (str.endsWith(",") || str.endsWith(";") || str.endsWith(":") || str.endsWith(".")) {
                    str = str.substring(0, str.length() - 1);
                }
            }
            class TempClass {
                public String name;
                public String type;
                public String infinitive;

                TempClass() {
                }
            }
            ArrayList<TempClass> paths = new ArrayList<TempClass>();
            String query = "select * from ArawordView where word='" + str.replace("'", "''") + "'";
            ResultSet rs = DB.getInstance().query(query);
            while (rs.next()) {
                String name = rs.getString("name");
                String type = rs.getString("type");
                Object inf = null;
                TempClass t = new TempClass();
                t.name = name;
                t.type = type;
                t.infinitive = inf;
                paths.add(t);
            }
            String verbs_data_base_name = new String(String.valueOf(G.documentLanguage) + "_verbs");
            File dataBase = new File("resources" + File.separator + verbs_data_base_name + ".db");
            if (dataBase.exists()) {
                Statement statAux = G.connVerbsDB.createStatement();
                statAux.setEscapeProcessing(true);
                ResultSet rsAux = statAux.executeQuery("select * from verbs where form='" + str.replace("'", "''") + "'");
                while (rsAux.next()) {
                    String verb = rsAux.getString("verb");
                    System.out.println("VERB=" + verb);
                    rs = DB.getInstance().query("select * from ArawordView where word='" + verb.replace("'", "''") + "'");
                    while (rs.next()) {
                        String name = rs.getString("name");
                        System.out.println("name=" + name);
                        String type = rs.getString("type");
                        TempClass t = new TempClass();
                        t.name = name;
                        t.type = type;
                        t.infinitive = verb;
                        paths.add(t);
                    }
                }
            }
            if (paths.isEmpty()) {
                return dbr;
            }
            String name = "";
            String type = "";
            String inf = null;
            if (numPictogram < paths.size()) {
                name = ((TempClass)paths.get((int)numPictogram)).name;
                type = ((TempClass)paths.get((int)numPictogram)).type;
                if (((TempClass)paths.get((int)numPictogram)).infinitive != null) {
                    inf = ((TempClass)paths.get((int)numPictogram)).infinitive;
                    System.out.println("***** " + inf + " *********");
                }
            } else {
                name = ((TempClass)paths.get((int)0)).name;
                type = ((TempClass)paths.get((int)0)).type;
                if (((TempClass)paths.get((int)0)).infinitive != null) {
                    inf = ((TempClass)paths.get((int)0)).infinitive;
                    System.out.println("***** " + inf + " *********");
                }
            }
            if ((file = new File(fileName = String.valueOf(DB.getInstance().getImagesPath()) + File.separator + name)).exists()) {
                ImageIcon image2 = new ImageIcon(String.valueOf(DB.getInstance().getImagesPath()) + File.separator + name);
                dbr.setImage(new ImageIcon(image2.getImage().getScaledInstance(G.imagesSize, -1, 4)));
                dbr.setFileImage(name);
                dbr.setBorder(G.borders.get(type));
                dbr.setInfinitive(inf);
            }
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
        return dbr;
    }

    public static int searchnumPictoOnDB(String word, String filePictogram) {
        ArrayList<String> paths;
        int returnNumber;
        block13: {
            DBResult dbr = new DBResult();
            returnNumber = 0;
            String str = word.toLowerCase();
            if (!(str.equals("\u00a1") || str.equals("\u00bf") || str.equals("!") || str.equals("?"))) {
                if (str.endsWith("...")) {
                    str = str.substring(0, str.length() - 3);
                } else if (str.endsWith(",") || str.endsWith(";") || str.endsWith(":") || str.endsWith(".")) {
                    str = str.substring(0, str.length() - 1);
                }
            }
            paths = new ArrayList<String>();
            String query = "select * from ArawordView where word='" + str.replace("'", "''") + "'";
            ResultSet rs = DB.getInstance().query(query);
            while (rs.next()) {
                String name = rs.getString("name");
                paths.add(name);
            }
            String verbs_data_base_name = new String(String.valueOf(G.documentLanguage) + "_verbs");
            File dataBase = new File("resources" + File.separator + verbs_data_base_name + ".db");
            if (dataBase.exists()) {
                Statement statAux = G.connVerbsDB.createStatement();
                ResultSet rsAux = statAux.executeQuery("select * from verbs where form='" + str.replace("'", "''") + "'");
                while (rsAux.next()) {
                    String verb = rsAux.getString("verb");
                    rs = DB.getInstance().query("select * from ArawordView where word='" + verb.replace("'", "''") + "'");
                    while (rs.next()) {
                        String name = rs.getString("name");
                        paths.add(name);
                    }
                }
            }
            if (!paths.isEmpty()) break block13;
            return 0;
        }
        try {
            returnNumber = -1;
            int i = 0;
            do {
                if (!((String)paths.get(i)).equals(filePictogram)) continue;
                returnNumber = i;
            } while (returnNumber == -1 && ++i < paths.size());
            if (returnNumber == -1) {
                return 0;
            }
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
        return returnNumber;
    }

    public static void createTablesDB() {
        try {
            DB.getInstance().update("DROP TABLE IF EXISTS main;");
            String query = "CREATE TABLE main (word VARCHAR(50), idL INTEGER, idT INTEGER, name VARCHAR(50), nameNN VARCHAR(50))";
            DB.getInstance().update(query);
            DB.getInstance().update("DROP TABLE IF EXISTS language;");
            query = "CREATE TABLE IF NOT EXISTS language(id INTEGER PRIMARY KEY,name VARCHAR(45) NOT NULL)";
            DB.getInstance().update(query);
            DB.getInstance().update("DROP TABLE IF EXISTS type;");
            query = "CREATE TABLE IF NOT EXISTS type (id INTEGER PRIMARY KEY,name VARCHAR(45) NOT NULL)";
            DB.getInstance().update(query);
            DB.getInstance().update("CREATE UNIQUE INDEX main_index ON main (word, idL, idT, name, nameNN)");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(e.toString());
        }
    }

    private static void fillTableVerbsDB(final String verbs_txt_file_name) {
        try {
            new Thread(){

                @Override
                public void run() {
                    try {
                        String l;
                        G.connVerbsDB.setAutoCommit(false);
                        PreparedStatement stmt = G.connVerbsDB.prepareStatement("INSERT OR IGNORE INTO verbs (form,verb) VALUES (?,?)");
                        int numTransactions = 0;
                        FileInputStream fileInputStream = new FileInputStream("resources" + File.separator + verbs_txt_file_name);
                        ProgressMonitorInputStream pm = new ProgressMonitorInputStream(null, TLanguage.getString("VERB_DATABASE_CREATION_MESSAGE"), fileInputStream);
                        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)pm, "UTF-8"));
                        while ((l = br.readLine()) != null) {
                            String[] line = l.split(",");
                            String verb = line[0];
                            int i = 1;
                            while (i < line.length) {
                                String form = line[i];
                                stmt.setString(1, form);
                                stmt.setString(2, verb);
                                stmt.executeUpdate();
                                if (++numTransactions > 5000) {
                                    G.connVerbsDB.commit();
                                    numTransactions = 0;
                                }
                                ++i;
                            }
                        }
                        G.connVerbsDB.setAutoCommit(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    JOptionPane.showMessageDialog(null, TLanguage.getString("VERB_DATABASE_CREATION_MESSAGE_END"), TLanguage.getString("WARNING"), 1);
                }
            }.start();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(e.toString());
        }
    }

    public static void createTablesVerbsDB(String verbs_txt_file_name) {
        try {
            Statement stmt = G.connVerbsDB.createStatement();
            stmt.execute("DROP TABLE IF EXISTS verbs;");
            String query = "CREATE TABLE verbs (form VARCHAR(50),verb VARCHAR(50))";
            stmt.execute(query);
            stmt.execute("CREATE UNIQUE INDEX verbs_index ON verbs (form, verb)");
            DBManagement.fillTableVerbsDB(verbs_txt_file_name);
            stmt.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(e.toString());
        }
    }

    public static void exportDBAWZ(String output, JProgressBar progressBar, String queryLoaded, List<String> customs, List<String> customsWords, String docLang) {
        try {
            DB conn = DB.getInstance();
            HashMap languageIDs = new HashMap();
            HashMap<Integer, String> typeIDs = new HashMap<Integer, String>();
            long tiempoInicio = System.currentTimeMillis();
            Element dataBaseXML = new Element("database");
            Element languages = new Element("languages");
            Element Elanguage = new Element("language");
            Elanguage.setText(docLang);
            languages.addContent((Content)Elanguage);
            dataBaseXML.addContent((Content)languages);
            ResultSet rs = conn.query("select * from type order by id");
            while (rs.next()) {
                int id = rs.getInt("id");
                String name = rs.getString("name");
                typeIDs.put(id, name);
            }
            int currentImage = 0;
            progressBar.setMinimum(currentImage);
            progressBar.setMaximum(customs.size());
            int i = 0;
            while (i < customs.size()) {
                String name = customs.get(i);
                String wordBBDD = customsWords.get(i);
                Element image = new Element("image");
                image.setAttribute("id", name);
                ResultSet rs2 = conn.query("SELECT id FROM language WHERE name = '" + docLang + "'");
                while (rs2.next()) {
                    int idL = rs2.getInt("id");
                    Element language = new Element("language");
                    language.setAttribute("id", docLang);
                    ResultSet rs3 = conn.query("select * from main where word LIKE '" + wordBBDD.replace("'", "''") + "' and idL = " + idL + " order by idT");
                    int idT = 0;
                    if (rs3.next()) {
                        idT = rs3.getInt("idT");
                    }
                    Element wordE = new Element("word");
                    wordE.setAttribute("type", (String)typeIDs.get(idT));
                    wordE.setText(wordBBDD);
                    language.addContent((Content)wordE);
                    String pathSrc = String.valueOf(conn.getImagesPath()) + File.separator + name;
                    String pathDst = String.valueOf(output) + File.separator + name;
                    try {
                        FileChannel srcChannel = new FileInputStream(pathSrc).getChannel();
                        FileChannel dstChannel = new FileOutputStream(pathDst).getChannel();
                        dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                        srcChannel.close();
                        dstChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    rs3.close();
                    image.addContent((Content)language);
                }
                rs2.close();
                dataBaseXML.addContent((Content)image);
                progressBar.setValue(currentImage++);
                ++i;
            }
            rs.close();
            conn.close();
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
            FileOutputStream f = new FileOutputStream(String.valueOf(output) + File.separator + "images.xml");
            out.output(dataBaseXML, (OutputStream)f);
            f.flush();
            f.close();
            long totalTiempo = System.currentTimeMillis() - tiempoInicio;
            System.out.println("El tiempo total es :" + totalTiempo / 1000L + " segundos");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void exportPictosAWZ(String path, String language, List<String> customs, List<String> customsWords, JProgressBar progressBar) {
        File theDir = new File(path);
        if (!theDir.exists()) {
            System.out.println("creating directory: " + path);
            boolean result = theDir.mkdir();
            if (result) {
                System.out.println("DIR created");
            }
        }
        String customSet = "(";
        for (String customName : customs) {
            customSet = String.valueOf(customSet) + "'" + customName + "' , ";
        }
        customSet = String.valueOf(customSet.substring(0, customSet.length() - 2)) + ")";
        System.out.println("******** CUSTOM LIST ***********");
        System.out.println(customSet);
        String query = "SELECT COUNT(*) AS row_count, GROUP_CONCAT(main.word) AS terms, main.nameNN AS name FROM main               WHERE main.name IN (SELECT main.name FROM main WHERE name IN " + customSet + " AND idL = (SELECT id FROM language WHERE name LIKE '" + language + "')) GROUP BY main.name";
        DBManagement.exportDBAWZ(path, progressBar, query, customs, customsWords, language);
    }

    public static void importDB2(String input, JProgressBar progressBar, boolean doReplace) throws Exception {
        String pathSrc = "";
        DB conn = DB.getInstance();
        System.out.println("***** Importo nuevos pictos");
        long tiempoInicio = System.currentTimeMillis();
        String directoryPath = String.valueOf(input) + File.separator;
        File myDirectory = new File(directoryPath);
        String[] list = myDirectory.list();
        File fileXML = new File(String.valueOf(input) + File.separator + "images.xml");
        if (fileXML.exists()) {
            SAXBuilder builder = new SAXBuilder(false);
            Document docXML = builder.build(fileXML);
            Element root = docXML.getRootElement();
            List images = root.getChildren("image");
            Iterator j = images.iterator();
            List<Element> globalLanguages = DBManagement.getLanguagesFromDb();
            Iterator<Element> langsI = globalLanguages.iterator();
            HashMap<String, Integer> languageIDs = new HashMap<String, Integer>();
            HashMap<String, Integer> typeIDs = new HashMap<String, Integer>();
            int i = 0;
            int contTypes = 0;
            int contImages = 0;
            while (langsI.hasNext()) {
                Element e = langsI.next();
                languageIDs.put(e.getText(), i);
                PreparedStatement stmt = conn.prepareStatement("INSERT OR IGNORE INTO language (id,name) VALUES (?,?)");
                stmt.setInt(1, i);
                stmt.setString(2, e.getText());
                stmt.executeUpdate();
                stmt.close();
                ++i;
            }
            conn.activateTransactions();
            progressBar.setMaximum(images.size());
            progressBar.setValue(0);
            int pbval = 0;
            while (j.hasNext()) {
                boolean acceptImage;
                progressBar.setValue(++pbval);
                long periodTime = System.currentTimeMillis();
                System.out.println("***TOCO PROGRESSBAR***");
                Element image = (Element)j.next();
                String id = image.getAttributeValue("id");
                List languages = image.getChildren("language");
                Iterator k = languages.iterator();
                pathSrc = directoryPath.concat(id);
                if (DBManagement.checkImportedIMG(pathSrc, languages) || !(acceptImage = GUI.createCustomDialog(pathSrc, languages))) continue;
                if (doReplace && new File(String.valueOf(DB.getInstance().getImagesPath()) + File.separator + id).exists()) {
                    ImageManager.delete((String)id);
                    String query = "DELETE FROM main WHERE nameNN = '" + id + "'";
                    conn.update(query);
                }
                String newFileName = ImageManager.add((String)pathSrc);
                id = newFileName.substring(newFileName.lastIndexOf(File.separator) + 1);
                while (k.hasNext()) {
                    Element languageElement = (Element)k.next();
                    String language = languageElement.getAttributeValue("id");
                    List words = languageElement.getChildren("word");
                    for (Element wordElement : words) {
                        PreparedStatement stmt;
                        String type = wordElement.getAttributeValue("type");
                        System.out.println("before if type");
                        if (!typeIDs.containsKey(type)) {
                            typeIDs.put(type, contTypes);
                            conn = DB.getInstance();
                            stmt = conn.prepareStatement("INSERT OR IGNORE INTO type (id,name) VALUES (?,?)");
                            stmt.setInt(1, contTypes);
                            stmt.setString(2, type);
                            stmt.executeUpdate();
                            stmt.close();
                            ++contTypes;
                        }
                        conn = DB.getInstance();
                        stmt = conn.prepareStatement("INSERT OR IGNORE INTO main (word, idL, idT, name, nameNN) VALUES (?,?,?,?,?)");
                        stmt.setString(1, wordElement.getText().toLowerCase());
                        stmt.setInt(2, (Integer)languageIDs.get(language));
                        stmt.setInt(3, (Integer)typeIDs.get(type));
                        stmt.setString(4, id);
                        stmt.setString(5, id);
                        stmt.executeUpdate();
                        stmt.close();
                    }
                    if (contImages > 5000 && (System.currentTimeMillis() - periodTime) / (long)contImages > 100L) {
                        periodTime = System.currentTimeMillis();
                        conn.executeQueries();
                        contImages = 0;
                        continue;
                    }
                    ++contImages;
                }
            }
            try {
                conn = DB.getInstance();
                conn.executeQueries();
                conn.close();
            }
            catch (Exception ee) {
                System.out.println(ee.getMessage());
                System.out.println(ee.toString());
            }
            long totalTiempo = System.currentTimeMillis() - tiempoInicio;
            System.out.println("El tiempo total es :" + totalTiempo + " milisegundos");
        }
    }

    private static List<Element> getLanguagesFromDb() {
        ArrayList<Element> languageList = new ArrayList<Element>();
        String query = "SELECT name FROM language ORDER BY id";
        try {
            DB conn = DB.getInstance();
            ResultSet rs = conn.query(query);
            while (rs.next()) {
                String language = rs.getString("name");
                Element element = new Element("language");
                element.setText(language);
                languageList.add(element);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(e.toString());
        }
        return languageList;
    }

    private static boolean checkImportedIMG(String imageName, List l) {
        boolean result = true;
        for (Element languageElement : l) {
            String language = languageElement.getAttributeValue("id");
            List words = languageElement.getChildren("word");
            for (Element wordElement : words) {
                String word = wordElement.getText();
                String query = "SELECT GROUP_CONCAT(main.word) AS terms, main.nameNN AS name FROM main WHERE main.name IN (SELECT main.name FROM main WHERE word LIKE '" + word.replace("'", "''") + "' AND idL = (SELECT id FROM language WHERE name LIKE '" + language + "')) GROUP BY main.name";
                try {
                    DB conn = DB.getInstance();
                    ResultSet rs = conn.query(query);
                    boolean matched = false;
                    while (rs.next() && !matched) {
                        String name = rs.getString("name");
                        matched = DBManagement.compareIMG(imageName, String.valueOf(DB.getInstance().getImagesPath()) + File.separator + name);
                    }
                    conn.close();
                    if (matched) continue;
                    result = false;
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    System.out.println(e.toString());
                }
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean compareIMG(String newIMG, String BBDDIMG) {
        FileInputStream is1 = null;
        FileInputStream is2 = null;
        try {
            File f1 = new File(newIMG);
            File f2 = new File(BBDDIMG);
            if (f1.length() != f2.length()) {
                return false;
            }
            is1 = new FileInputStream(f1);
            is2 = new FileInputStream(f2);
            int read1 = -1;
            int read2 = -1;
            do {
                int offset1 = 0;
                while (offset1 < 1024 && (read1 = is1.read(buff1, offset1, 1024 - offset1)) >= 0) {
                    offset1 += read1;
                }
                int offset2 = 0;
                while (offset2 < 1024 && (read2 = is2.read(buff2, offset2, 1024 - offset2)) >= 0) {
                    offset2 += read2;
                }
                if (offset1 != offset2) {
                    return false;
                }
                if (offset1 != 1024) {
                    Arrays.fill(buff1, offset1, 1024, (byte)0);
                    Arrays.fill(buff2, offset2, 1024, (byte)0);
                }
                if (Arrays.equals(buff1, buff2)) continue;
                return false;
            } while (read1 >= 0 && read2 >= 0);
            if (read1 >= 0) return false;
            if (read2 >= 0) return false;
            return true;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            System.out.println(e.toString());
            return false;
        }
        finally {
            try {
                if (is1 != null) {
                    is1.close();
                }
                if (is2 != null) {
                    is2.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

