/*
 * Decompiled with CFR 0.152.
 */
package araword.classes;

import araword.G;
import araword.classes.AWTextField;
import araword.db.DBManagement;
import araword.db.DBResult;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class AWElement
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int position;
    private int type;
    private String separator;
    private JLabel image;
    private String imageName;
    private AWTextField textField;
    private int numPictogram;
    private boolean compound;
    private boolean visibleImage;
    private boolean visibleBorder;
    private boolean searchImageOnBD;
    private String wordSearchBD;
    private String infinitive;

    public AWElement() {
        this.addMouseListener(G.mouseListener);
        this.addMouseMotionListener(G.mouseMotionListener);
    }

    public static String filter(String text) {
        text = text.replace("!", "");
        text = text.replace("\u00a1", "");
        text = text.replace("?", "");
        text = text.replace("\u00bf", "");
        text = text.replace("(", "");
        text = text.replace(")", "");
        text = text.replace("\"", "");
        text = text.replace(",", "");
        text = text.replace(".", "");
        text = text.replace(";", "");
        text = text.replace(":", "");
        return text;
    }

    public static AWElement createPictogramElement(int pos, String text, int numPictogram, boolean visibleImage, boolean visibleBorder, boolean searchOnBD, String wordToSearch) {
        AWElement elem = new AWElement();
        try {
            DBResult dbr = null;
            dbr = searchOnBD ? DBManagement.searchOnDB(AWElement.filter(text), numPictogram) : DBManagement.searchOnDB(wordToSearch, 0);
            JLabel labelImage = new JLabel("", dbr.getImage(), 0);
            labelImage.setPreferredSize(new Dimension(G.imagesSize, G.imagesSize));
            AWTextField textField = new AWTextField(text);
            elem = new AWElement();
            elem.setInfinitive(dbr.getInfinitive());
            elem.setPosition(pos);
            elem.setTextField(textField);
            elem.setImage(labelImage);
            elem.imageName = dbr.getFileImage();
            elem.setNumPictogram(numPictogram);
            elem.setBackground(Color.WHITE);
            elem.setFocusable(true);
            elem.setLayout(new BorderLayout(0, 1));
            if (G.textBelowPictogram) {
                elem.add((Component)labelImage, "North");
                elem.add((Component)textField, "South");
            } else {
                elem.add((Component)textField, "North");
                elem.add((Component)labelImage, "South");
            }
            elem.setBorder(dbr.getBorder());
            elem.setMaximumSize(elem.getPreferredSize());
            elem.setType(0);
            elem.setCompound(false);
            elem.setVisibleImage(visibleImage);
            elem.setVisibleBorder(visibleBorder);
            elem.setSearchImageOnBD(searchOnBD);
            if (!searchOnBD) {
                elem.setWordSearchBD(wordToSearch);
            }
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
        return elem;
    }

    public static AWElement createPDFPrevPictogramElement(int pos, String text, int numPictogram, boolean visibleImage, boolean visibleBorder, boolean searchOnBD, String wordToSearch, boolean prev) {
        AWElement elem = new AWElement();
        try {
            DBResult dbr = null;
            dbr = searchOnBD ? DBManagement.searchOnDB(AWElement.filter(text), numPictogram) : DBManagement.searchOnDB(wordToSearch, 0);
            JLabel labelImage = new JLabel("", dbr.getImage(), 0);
            labelImage.setPreferredSize(new Dimension(G.imagesSize, G.imagesSize));
            AWTextField textField = new AWTextField(text);
            Font PDFFont = prev ? new Font(G.defaultFont.getName(), G.defaultFont.getStyle(), G.defaultFont.getSize() * 2 / G.numPictosLinePDF) : new Font(G.defaultFont.getName(), G.defaultFont.getStyle(), G.defaultFont.getSize() * 4 / G.numPictosLinePDF);
            textField.setFont(PDFFont);
            elem = new AWElement();
            elem.setPosition(pos);
            elem.setTextField(textField);
            elem.setImage(labelImage);
            elem.setNumPictogram(numPictogram);
            elem.setBackground(Color.WHITE);
            elem.setFocusable(true);
            elem.setLayout(new BorderLayout(0, 1));
            if (G.textBelowPictogram) {
                elem.add((Component)labelImage, "North");
                elem.add((Component)textField, "South");
            } else {
                elem.add((Component)textField, "North");
                elem.add((Component)labelImage, "South");
            }
            if (!prev) {
                Border PDFBorder = dbr.getBorder();
                elem.setBorder(PDFBorder);
            }
            elem.setMaximumSize(elem.getPreferredSize());
            elem.setType(0);
            elem.setCompound(false);
            elem.setVisibleImage(visibleImage);
            elem.setVisibleBorder(visibleBorder);
            elem.setSearchImageOnBD(searchOnBD);
            if (!searchOnBD) {
                elem.setWordSearchBD(wordToSearch);
            }
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
        return elem;
    }

    public static AWElement createPictogramElement(int pos, String text) {
        return AWElement.createPictogramElement(pos, text, 0, true, true, true, "");
    }

    public static AWElement createSeparatorElement(int pos, String separator) {
        AWElement elem = new AWElement();
        elem.setPosition(pos);
        elem.setSeparator(separator);
        elem.setType(1);
        elem.setCompound(false);
        elem.setVisibleImage(false);
        elem.setVisibleBorder(false);
        elem.setSearchImageOnBD(false);
        return elem;
    }

    public void regeneratePictogram() {
        try {
            DBResult dbr = null;
            dbr = this.isSearchImageOnBD() ? DBManagement.searchOnDB(AWElement.filter(this.getTextField().getText()), this.getNumPictogram()) : DBManagement.searchOnDB(AWElement.filter(this.getWordSearchBD()), this.getNumPictogram());
            this.setInfinitive(dbr.getInfinitive());
            if (this.isVisibleImage()) {
                this.getImage().setIcon(dbr.getImage());
                this.imageName = dbr.getFileImage();
            } else {
                this.getImage().setIcon(G.notFound);
            }
            if (this.isVisibleBorder()) {
                this.setBorder(dbr.getBorder());
            } else {
                this.setBorder(G.borders.get("NO_BORDER"));
            }
            this.setMaximumSize(this.getPreferredSize());
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getInfinitive() {
        return this.infinitive;
    }

    public void setInfinitive(String infinitive) {
        this.infinitive = infinitive;
    }

    public JLabel getImage() {
        return this.image;
    }

    public void setImage(JLabel image) {
        this.image = image;
    }

    public AWTextField getTextField() {
        return this.textField;
    }

    public void setTextField(AWTextField textField) {
        this.textField = textField;
    }

    public int getNumPictogram() {
        return this.numPictogram;
    }

    public void setNumPictogram(int numPictogram) {
        this.numPictogram = numPictogram;
    }

    public String getImageName() {
        return this.imageName;
    }

    public boolean isCompound() {
        return this.compound;
    }

    public void setCompound(boolean compound) {
        this.compound = compound;
    }

    public boolean isVisibleImage() {
        return this.visibleImage;
    }

    public void setVisibleImage(boolean visibleImage) {
        this.visibleImage = visibleImage;
    }

    public boolean isVisibleBorder() {
        return this.visibleBorder;
    }

    public void setVisibleBorder(boolean visibleBorder) {
        this.visibleBorder = visibleBorder;
    }

    public void setSearchImageOnBD(boolean searchImageOnBD) {
        this.searchImageOnBD = searchImageOnBD;
    }

    public boolean isSearchImageOnBD() {
        return this.searchImageOnBD;
    }

    public String getWordSearchBD() {
        return this.wordSearchBD;
    }

    public void setWordSearchBD(String wordSearchBD) {
        this.wordSearchBD = wordSearchBD;
    }
}

