/*
 * Decompiled with CFR 0.152.
 */
package javax.speech.recognition;

import java.util.Vector;
import javax.speech.recognition.Rule;
import javax.speech.recognition.RuleToken;

public class RuleSequence
extends Rule {
    Rule[] rules;

    public RuleSequence(Rule[] ruleArray) {
        this.setRules(ruleArray);
    }

    public RuleSequence(Rule rule) {
        this.rules = new Rule[1];
        this.rules[0] = rule;
    }

    public RuleSequence() {
        this.rules = new Rule[0];
    }

    public RuleSequence(String[] stringArray) {
        this.rules = new Rule[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.rules[n] = new RuleToken(stringArray[n]);
            ++n;
        }
    }

    public void append(Rule rule) {
        int n = this.rules.length;
        Rule[] ruleArray = new Rule[n + 1];
        System.arraycopy(this.rules, 0, ruleArray, 0, n);
        this.rules = ruleArray;
        this.rules[n] = rule;
    }

    public Rule copy() {
        RuleSequence ruleSequence = new RuleSequence();
        int n = 0;
        while (n < this.rules.length) {
            ruleSequence.append(this.rules[n].copy());
            ++n;
        }
        return ruleSequence;
    }

    public Rule[] getRules() {
        return this.rules;
    }

    public void setRules(Rule[] ruleArray) {
        this.rules = ruleArray;
    }

    public String toString() {
        String string = "(";
        int n = 0;
        while (n < this.rules.length) {
            string = String.valueOf(string) + this.rules[n].toString();
            if (n != this.rules.length - 1) {
                string = String.valueOf(string) + " ";
            }
            ++n;
        }
        return String.valueOf(string) + ")";
    }

    protected void getTagVector(Vector vector) {
        int n = 0;
        while (n < this.rules.length) {
            this.rules[n].getTagVector(vector);
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof RuleSequence)) {
            return false;
        }
        RuleSequence ruleSequence = (RuleSequence)object;
        Rule[] ruleArray = ruleSequence.getRules();
        if (ruleArray.length != this.rules.length) {
            return false;
        }
        int n = 0;
        while (n < this.rules.length) {
            if (!this.rules[n].equals(ruleArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

