/*
 * Decompiled with CFR 0.152.
 */
package javax.speech.recognition;

import java.util.Vector;
import javax.speech.recognition.Rule;

public class RuleName
extends Rule {
    String fullRuleName;
    public static final RuleName NULL = new RuleName("<NULL>");
    public static final RuleName VOID = new RuleName("<VOID>");
    String packageName;
    String simpleGrammarName;
    String simpleRuleName;
    static final String extraLegalChars = "+-:;,=|/\\()[]@#%!^&~";

    public RuleName(String string) throws IllegalArgumentException {
        this.setRuleName(string);
    }

    public RuleName() {
    }

    public RuleName(String string, String string2, String string3) throws IllegalArgumentException {
        this.setRuleName(string, string2, string3);
    }

    public Rule copy() {
        return new RuleName(this.packageName, this.simpleGrammarName, this.simpleRuleName);
    }

    public boolean equals(Object object) {
        if (!(object instanceof RuleName)) {
            return false;
        }
        RuleName ruleName = (RuleName)object;
        return ruleName.getRuleName().equals(this.fullRuleName);
    }

    public String getFullGrammarName() {
        if (this.packageName == null || this.packageName.equals("")) {
            return this.simpleGrammarName;
        }
        return String.valueOf(this.packageName) + "." + this.simpleGrammarName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getRuleName() {
        return this.fullRuleName;
    }

    public String getSimpleGrammarName() {
        return this.simpleGrammarName;
    }

    public String getSimpleRuleName() {
        return this.simpleRuleName;
    }

    public boolean isLegalRuleName() {
        boolean bl;
        boolean bl2 = this.packageName == null || this.packageName.equals("");
        boolean bl3 = this.simpleGrammarName == null || this.simpleGrammarName.equals("");
        boolean bl4 = bl = this.simpleRuleName == null || this.simpleRuleName.equals("");
        if (bl) {
            return false;
        }
        if (bl2 && bl3 && bl) {
            return false;
        }
        return bl2 || !bl3;
    }

    public static boolean isLegalRuleName(String string) {
        if (string == null) {
            return false;
        }
        if (RuleName.a(string)) {
            return false;
        }
        try {
            new RuleName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    private static boolean a(String string) {
        return RuleName.a(string, '+');
    }

    private static boolean a(String string, char c) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (!RuleName.isRuleNamePart(string.charAt(n)) && string.charAt(n) != c) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isRuleNamePart(char c) {
        return extraLegalChars.indexOf(c) >= 0 || Character.isJavaIdentifierPart(c);
    }

    public void setRuleName(String string) throws IllegalArgumentException {
        if (string.startsWith("<")) {
            string = string.substring(1);
        }
        if (string.endsWith(">")) {
            string = string.substring(0, string.length() - 1);
        }
        int n = string.lastIndexOf(".");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (n < 0) {
            string4 = string;
        } else {
            string4 = string.substring(n + 1);
            if ((n = (string = string.substring(0, n)).lastIndexOf(".")) < 0) {
                string3 = string;
            } else {
                string3 = string.substring(n + 1);
                string2 = string.substring(0, n);
            }
        }
        this.setRuleName(string2, string3, string4);
    }

    public void setRuleName(String string, String string2, String string3) throws IllegalArgumentException {
        boolean bl;
        if (RuleName.a(string, '.')) {
            throw new IllegalArgumentException("Illegal package name " + string);
        }
        if (RuleName.a(string2)) {
            throw new IllegalArgumentException("Illegal grammar name " + string2);
        }
        if (RuleName.a(string3, '*')) {
            throw new IllegalArgumentException("Illegal simpleRule name " + string3);
        }
        this.packageName = string;
        this.simpleGrammarName = string2;
        this.simpleRuleName = string3;
        boolean bl2 = string == null || string.equals("");
        boolean bl3 = string2 == null || string2.equals("");
        boolean bl4 = bl = string3 == null || string3.equals("");
        if (bl) {
            throw new IllegalArgumentException("Simple rule name is null");
        }
        if (bl2 && bl3 && bl) {
            throw new IllegalArgumentException("All names are null");
        }
        if (!bl2 && bl3) {
            throw new IllegalArgumentException("Grammar name cannot be null if package name is non-null");
        }
        this.fullRuleName = "<";
        if (!bl2) {
            this.fullRuleName = String.valueOf(this.fullRuleName) + string + ".";
        }
        if (!bl3) {
            this.fullRuleName = String.valueOf(this.fullRuleName) + string2 + ".";
        }
        this.fullRuleName = String.valueOf(this.fullRuleName) + string3;
        this.fullRuleName = String.valueOf(this.fullRuleName) + ">";
    }

    public String toString() {
        return this.fullRuleName;
    }

    protected void getTagVector(Vector vector) {
    }
}

