/*
 * Decompiled with CFR 0.152.
 */
package com.cloudgarden.speech.userinterface;

import com.cloudgarden.speech.userinterface.NodeRenderer;
import com.cloudgarden.speech.userinterface.SpeakerProfileNode;
import com.cloudgarden.speech.userinterface.SpeechNode;
import java.awt.Cursor;
import javax.speech.Central;
import javax.speech.recognition.Recognizer;
import javax.speech.recognition.RecognizerModeDesc;
import javax.speech.recognition.SpeakerProfile;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class RecognizerNode
extends SpeechNode {
    private RecognizerModeDesc e;
    private Recognizer c = null;
    private SpeakerProfile f;
    private boolean d = false;

    static {
        NodeRenderer.addImageIcon("recognizer.gif");
    }

    public String getIconName() {
        return "recognizer.gif";
    }

    public RecognizerNode(String string) {
        super(string);
    }

    public RecognizerModeDesc getDesc() {
        return this.e;
    }

    public Recognizer getRecognizer() {
        try {
            if (!this.d) {
                this.d = true;
                this.c = Central.createRecognizer(this.e);
            }
            if (this.c != null) {
                this.c.allocate();
                this.c.waitEngineState(4L);
                this.e = (RecognizerModeDesc)this.c.getEngineModeDesc();
            }
        }
        catch (Exception exception) {
            System.out.println("Error [ " + exception.getMessage() + " ]");
            this.c = null;
        }
        return this.c;
    }

    public void cleanup() {
        if (this.c == null) {
            return;
        }
        try {
            this.c.deallocate();
            this.c.waitEngineState(1L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public RecognizerNode(RecognizerModeDesc recognizerModeDesc) {
        this.e = recognizerModeDesc;
        if (recognizerModeDesc == null) {
            this.if = "Problem loading engine";
        } else {
            this.if = recognizerModeDesc.getEngineName();
            this.if = recognizerModeDesc.getLocale() != null ? String.valueOf(this.if) + ", " + recognizerModeDesc.getLocale().getDisplayName() : String.valueOf(this.if) + ", unable to get Locale";
        }
        this.add(new SpeechNode("...loading Profiles..."));
    }

    public void handleExpansion() {
        if (this.e == null) {
            return;
        }
        this.updateProfiles();
    }

    public void handleSelection() {
        if (this.e == null || this.getTree() == null) {
            return;
        }
        this.getTree().a(this.e);
    }

    public void updateProfiles() {
        if (this.getTree() != null) {
            this.getTree().setCursor(Cursor.getPredefinedCursor(3));
        }
        this.getRecognizer();
        SpeechNode speechNode = null;
        if (this.c == null) {
            this.removeAllChildren();
            speechNode = new SpeechNode("Error initializing recognizer");
            speechNode.setTree(this.getTree());
            this.add(speechNode);
        } else {
            SpeakerProfile[] speakerProfileArray = this.e.getSpeakerProfiles();
            this.removeAllChildren();
            if (speakerProfileArray == null || speakerProfileArray.length == 0) {
                speechNode = this.addProfile(null);
            } else {
                int n = 0;
                while (n < speakerProfileArray.length) {
                    speechNode = this.addProfile(speakerProfileArray[n]);
                    if (speakerProfileArray[n].equals(this.f)) {
                        speechNode.setSelected(true);
                    }
                    ++n;
                }
            }
        }
        if (this.getTree() != null) {
            this.getTree().expandPath(new TreePath(speechNode.getPath()));
            ((DefaultTreeModel)this.getTree().getModel()).nodeStructureChanged(this);
            this.getTree().setCursor(Cursor.getDefaultCursor());
        }
    }

    public void selectSpeaker(SpeakerProfile speakerProfile) {
        this.f = speakerProfile;
        int n = 0;
        while (n < this.getChildCount()) {
            if (this.getChildAt(n) instanceof SpeakerProfileNode) {
                SpeakerProfileNode speakerProfileNode = (SpeakerProfileNode)this.getChildAt(n);
                if (speakerProfileNode.getProfile().equals(speakerProfile)) {
                    speakerProfileNode.setSelected(true);
                } else {
                    speakerProfileNode.setSelected(false);
                }
            }
            ++n;
        }
    }

    public SpeakerProfileNode addProfile(SpeakerProfile speakerProfile) {
        SpeakerProfileNode speakerProfileNode = new SpeakerProfileNode(speakerProfile, this.e, this);
        speakerProfileNode.setTree(this.getTree());
        this.add(speakerProfileNode);
        return speakerProfileNode;
    }
}

