/*
 * Decompiled with CFR 0.152.
 */
package javax.speech.recognition;

import java.util.Vector;
import javax.speech.recognition.Rule;
import javax.speech.recognition.RuleToken;

public class RuleAlternatives
extends Rule {
    protected Rule[] rules;
    protected float[] weights = null;

    public RuleAlternatives(Rule[] ruleArray, float[] fArray) {
        this.weights = fArray;
        this.rules = ruleArray;
    }

    public RuleAlternatives(Rule[] ruleArray) {
        this.rules = ruleArray;
    }

    public RuleAlternatives(Rule rule) {
        this.rules = new Rule[1];
        this.rules[0] = rule;
    }

    public RuleAlternatives() {
        this.rules = new Rule[0];
    }

    public RuleAlternatives(String[] stringArray) {
        this.rules = new Rule[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.rules[n] = new RuleToken(stringArray[n]);
            ++n;
        }
    }

    public void append(Rule rule) {
        int n = this.rules.length;
        Rule[] ruleArray = new Rule[n + 1];
        System.arraycopy(this.rules, 0, ruleArray, 0, n);
        this.rules = ruleArray;
        this.rules[n] = rule;
    }

    public Rule copy() {
        RuleAlternatives ruleAlternatives = new RuleAlternatives();
        int n = 0;
        while (n < this.rules.length) {
            ruleAlternatives.append(this.rules[n].copy());
            ++n;
        }
        if (this.weights != null) {
            float[] fArray = new float[this.weights.length];
            System.arraycopy(this.weights, 0, fArray, 0, this.weights.length);
            ruleAlternatives.setWeights(fArray);
        }
        return ruleAlternatives;
    }

    public Rule[] getRules() {
        return this.rules;
    }

    public float[] getWeights() {
        return this.weights;
    }

    public void setRules(Rule[] ruleArray) {
        this.rules = ruleArray;
    }

    public void setWeights(float[] fArray) {
        this.weights = fArray;
    }

    public String toString() {
        String string = "( ";
        int n = 0;
        while (n < this.rules.length) {
            string = String.valueOf(string) + this.rules[n].toString();
            if (n != this.rules.length - 1) {
                string = String.valueOf(string) + " | ";
            }
            ++n;
        }
        return String.valueOf(string) + " ) ";
    }

    protected void getTagVector(Vector vector) {
        int n = 0;
        while (n < this.rules.length) {
            this.rules[n].getTagVector(vector);
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof RuleAlternatives)) {
            return false;
        }
        RuleAlternatives ruleAlternatives = (RuleAlternatives)object;
        Rule[] ruleArray = ruleAlternatives.getRules();
        if (ruleArray.length != this.rules.length) {
            return false;
        }
        int n = 0;
        while (n < this.rules.length) {
            if (!this.rules[n].equals(ruleArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

