/*
 * Decompiled with CFR 0.152.
 */
package javax.speech.recognition;

import java.util.Locale;
import java.util.Vector;
import javax.speech.EngineModeDesc;
import javax.speech.recognition.SpeakerProfile;

public class RecognizerModeDesc
extends EngineModeDesc {
    Boolean dictationGrammarSupported;
    SpeakerProfile[] profiles;
    Vector vprofiles;

    public RecognizerModeDesc() {
    }

    public RecognizerModeDesc(Locale locale, Boolean bl) {
        super(locale);
        this.dictationGrammarSupported = bl;
    }

    public RecognizerModeDesc(String string, String string2, Locale locale, Boolean bl, Boolean bl2, SpeakerProfile[] speakerProfileArray) {
        super(string, string2, locale, bl);
        this.dictationGrammarSupported = bl2;
        this.profiles = speakerProfileArray;
    }

    public boolean equals(Object object) {
        if (object == null || !super.equals(object)) {
            return false;
        }
        if (object instanceof RecognizerModeDesc) {
            RecognizerModeDesc recognizerModeDesc = (RecognizerModeDesc)object;
            if (recognizerModeDesc.dictationGrammarSupported != this.dictationGrammarSupported) {
                return false;
            }
            SpeakerProfile[] speakerProfileArray = recognizerModeDesc.getSpeakerProfiles();
            if (speakerProfileArray == null && this.profiles == null) {
                return true;
            }
            int n = 0;
            while (n < this.profiles.length) {
                if (!this.profiles[n].equals(speakerProfileArray[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public boolean match(EngineModeDesc engineModeDesc) {
        if (engineModeDesc == null) {
            return true;
        }
        if (!super.match(engineModeDesc)) {
            return false;
        }
        if (engineModeDesc instanceof RecognizerModeDesc) {
            RecognizerModeDesc recognizerModeDesc = (RecognizerModeDesc)engineModeDesc;
            if (recognizerModeDesc.isDictationGrammarSupported() != null && recognizerModeDesc.isDictationGrammarSupported() != this.dictationGrammarSupported) {
                return false;
            }
            SpeakerProfile[] speakerProfileArray = recognizerModeDesc.getSpeakerProfiles();
            if (speakerProfileArray == null) {
                return true;
            }
            if (this.getSpeakerProfiles() == null) {
                return false;
            }
            int n = 0;
            while (n < this.profiles.length) {
                if (speakerProfileArray[n] != null && !this.profiles[n].equals(speakerProfileArray[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public void addSpeakerProfile(SpeakerProfile speakerProfile) {
        if (this.vprofiles == null) {
            this.vprofiles = new Vector();
        }
        this.vprofiles.addElement(speakerProfile);
        this.profiles = new SpeakerProfile[this.vprofiles.size()];
        this.vprofiles.copyInto(this.profiles);
    }

    protected SpeakerProfile[] getSpeakerProfilesImpl() {
        return this.profiles;
    }

    public SpeakerProfile[] getSpeakerProfiles() {
        this.profiles = this.getSpeakerProfilesImpl();
        return this.profiles;
    }

    public Boolean isDictationGrammarSupported() {
        return this.dictationGrammarSupported;
    }

    public void setDictationGrammarSupported(Boolean bl) {
        this.dictationGrammarSupported = bl;
    }

    public void setSpeakerProfiles(SpeakerProfile[] speakerProfileArray) {
        this.profiles = speakerProfileArray;
    }

    public String toString() {
        String string = super.toString();
        string = String.valueOf(string) + "[ engineName=\"" + this.engineName + "\", modeName=" + this.modeName + ", Locale=" + this.locale + " running=" + this.running + ", dictationSupported=" + this.dictationGrammarSupported + " ]\n";
        if (this.profiles != null) {
            int n = 0;
            while (n < this.profiles.length) {
                string = String.valueOf(string) + "   -->" + this.profiles[n] + "\n";
                ++n;
            }
        }
        return string;
    }
}

