/*
 * Decompiled with CFR 0.152.
 */
package com.cloudgarden.audio;

import com.cloudgarden.audio.AudioConverter;
import com.cloudgarden.audio.AudioPipe;
import com.cloudgarden.audio.AudioSink;
import com.cloudgarden.audio.AudioSource;
import com.cloudgarden.audio.CGPullBufferDataSource;
import com.cloudgarden.audio.CGPullDataSource;
import com.cloudgarden.audio.DefaultAudioConverter;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaException;
import javax.media.Processor;
import javax.media.ProcessorModel;
import javax.media.StopByRequestEvent;
import javax.media.format.AudioFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import javax.sound.sampled.AudioFormat;

public class AudioMediaFormatConverter
extends DefaultAudioConverter
implements AudioConverter,
ControllerListener,
SourceTransferHandler,
BufferTransferHandler {
    int bD = 0;
    long bJ = 0L;
    final boolean bK = false;
    AudioPipe bH = new AudioPipe();
    Processor bI;
    DataSource bF;
    private boolean bE = false;
    int bG = 0;

    public AudioMediaFormatConverter() {
    }

    public AudioMediaFormatConverter(AudioSource audioSource, String string) throws IOException, MediaException {
        this.setContentType(string);
        this.setSource(audioSource);
    }

    public AudioMediaFormatConverter(AudioSource audioSource, AudioSink audioSink) throws IOException, MediaException {
        this.setSink(audioSink);
        this.setSource(audioSource);
    }

    public void setup() throws IOException {
        PushBufferStream pushBufferStream;
        PushBufferDataSource pushBufferDataSource;
        PushBufferStream[] pushBufferStreamArray;
        ProcessorModel processorModel;
        if (this.bH == null) {
            throw new IOException("The source must be set before this method is called");
        }
        if (this.bI != null) {
            return;
        }
        String string = this.getIncomingContentType();
        if (string == null) {
            string = "raw";
        }
        this.bH.setContentType(string);
        this.bH.setAudioFormat(this.getIncomingAudioFormat());
        Object object = this.bH.getContentType().equals("raw") ? new CGPullBufferDataSource(this.bH) : new CGPullDataSource(this.bH);
        string = this.getContentType();
        if (string == null) {
            string = "raw";
        }
        FileTypeDescriptor fileTypeDescriptor = new FileTypeDescriptor(string);
        if (this.bE) {
            System.out.println("incomingType=" + this.getIncomingContentType() + " outType=" + this.getContentType());
        }
        Format[] formatArray = null;
        int n = 0;
        int n2 = 1;
        javax.sound.sampled.AudioFormat audioFormat = this.getAudioFormat();
        if (this.bE) {
            System.out.println("op fmt = " + audioFormat);
        }
        if (audioFormat != null && (this.try == null || this.try.equals("raw"))) {
            if (audioFormat.isBigEndian()) {
                n = 1;
            }
            if (!audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                n2 = 0;
            }
            processorModel = new AudioFormat("LINEAR", (double)audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), n, n2);
            formatArray = new Format[]{processorModel};
        }
        processorModel = new ProcessorModel((DataSource)object, formatArray, (ContentDescriptor)fileTypeDescriptor);
        if (this.bE) {
            System.out.println("new ProcessorModel ds = " + object.getContentType() + " cd = " + fileTypeDescriptor);
            if (formatArray != null) {
                System.out.println(" fmtArray[0]=" + formatArray[0]);
            }
        }
        try {
            this.bI = Manager.createRealizedProcessor((ProcessorModel)processorModel);
        }
        catch (Exception exception) {
            String string2 = "\nProblem with ProcessorModel src = " + object.getContentType() + " ContentDescriptor = " + fileTypeDescriptor;
            if (formatArray != null) {
                string2 = String.valueOf(string2) + " fmt=" + formatArray[0];
            }
            throw new IOException(String.valueOf(string2) + "\n" + exception.toString());
        }
        if (this.bE) {
            System.out.println("\n*** Created processor " + this.bI + "\n");
        }
        this.bI.addControllerListener((ControllerListener)this);
        this.bF = this.bI.getDataOutput();
        if (this.bF instanceof PullBufferDataSource) {
            throw new IOException("PullBufferDataSource not supported");
        }
        if (this.bF instanceof PullDataSource) {
            throw new IOException("PullDataSource not supported");
        }
        if (this.bF instanceof PushBufferDataSource) {
            if (this.bE) {
                System.out.println("got PushBufferDataSource");
            }
            if ((pushBufferStreamArray = (pushBufferDataSource = (PushBufferDataSource)this.bF).getStreams()).length == 0) {
                throw new IOException("Zero output streams from this PushDataSource");
            }
            pushBufferStream = pushBufferStreamArray[0];
            pushBufferStream.setTransferHandler((BufferTransferHandler)this);
        }
        if (this.bF instanceof PushDataSource) {
            if (this.bE) {
                System.out.println("got PushDataSource");
            }
            if ((pushBufferStreamArray = (pushBufferDataSource = (PushDataSource)this.bF).getStreams()).length == 0) {
                throw new IOException("Zero output streams from this PushDataSource");
            }
            pushBufferStream = pushBufferStreamArray[0];
            pushBufferStream.setTransferHandler((SourceTransferHandler)this);
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        throw new IOException("This method cannot be used.\nYou must instead call the setSink method and provide an AudioSink (eg an AudioPipe) which can be written to");
    }

    public int write(byte[] byArray, int n, int n2) throws IOException {
        this.a(byArray, n, n2, 2);
        int n3 = this.bH.write(byArray, n, n2);
        return n3;
    }

    public void setSource(AudioSource audioSource) throws IOException {
        if (this.a1 == null || !this.a1.equals(audioSource)) {
            this.a1 = audioSource;
            this.bH.setAudioFormat(audioSource.getAudioFormat());
            this.bH.setContentType(audioSource.getContentType());
            audioSource.setSink(this);
        }
        if (audioSource != null) {
            this.setIncomingAudioFormat(audioSource.getAudioFormat());
            this.setIncomingContentType(audioSource.getContentType());
            if (this.bE) {
                System.out.println("setSource " + audioSource + " " + audioSource.getContentType() + " ICT=" + this.getIncomingContentType() + " " + this);
            }
        }
    }

    public void startSending() throws IOException {
        this.a = true;
        this.setup();
        this.bI.start();
        this.bF.connect();
        this.bF.start();
        if (this.ac != null && this.ac instanceof AudioSource) {
            ((AudioSource)((Object)this.ac)).startSending();
        }
    }

    public void stopSending() {
        this.a = false;
        try {
            this.bF.stop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.bF.disconnect();
        this.bI.stop();
        if (this.ac != null && this.ac instanceof AudioSource) {
            ((AudioSource)((Object)this.ac)).stopSending();
        }
    }

    public void controllerUpdate(ControllerEvent controllerEvent) {
        if (this.bE) {
            System.out.println("\ncontrollerUpdate " + controllerEvent);
        }
        if (controllerEvent instanceof EndOfMediaEvent) {
            controllerEvent.getSourceController().close();
        }
        if (controllerEvent instanceof StopByRequestEvent) {
            controllerEvent.getSourceController().stop();
            controllerEvent.getSourceController().close();
        }
        if (controllerEvent instanceof ControllerClosedEvent) {
            try {
                if (this.ac != null) {
                    this.ac.write(new byte[0], 0, -1);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.a = false;
        }
    }

    public void transferData(PushSourceStream pushSourceStream) {
        if (this.bE) {
            System.out.println("transferData " + pushSourceStream);
        }
        int n = pushSourceStream.getMinimumTransferSize();
        long l = pushSourceStream.getContentLength();
        try {
            if (n <= 0) {
                this.a = false;
                if (this.ac != null) {
                    this.ac.write(new byte[0], 0, -1);
                }
                return;
            }
            byte[] byArray = new byte[n];
            int n2 = pushSourceStream.read(byArray, 0, n);
            if (this.ac != null) {
                this.ac.write(byArray, 0, n2);
            }
            this.bG += n2;
            if (this.bE) {
                System.out.println("sum=" + this.bJ + " min=" + n + " cnt=" + this.bG + " sink=" + this.ac);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void transferData(PushBufferStream pushBufferStream) {
        if (this.bE) {
            System.out.println("transferData " + pushBufferStream);
        }
        try {
            Buffer buffer = new Buffer();
            Buffer buffer2 = new Buffer();
            pushBufferStream.read(buffer);
            buffer2.copy(buffer);
            int n = buffer2.getLength();
            int n2 = buffer2.getOffset();
            if (buffer2.isEOM()) {
                this.a = false;
                if (this.ac != null) {
                    this.ac.write(new byte[0], 0, -1);
                }
                return;
            }
            byte[] byArray = (byte[])buffer2.getData();
            if (this.ac != null) {
                this.ac.write(byArray, n2, n);
            }
            if (this.bE) {
                System.out.println("writing =" + n + " sum=" + this.bJ + " bytes, off=" + n2 + " sink = " + this.ac);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

