/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.dsj;

import de.humatic.dsj.AVCDevice;
import de.humatic.dsj.DSEnvironment;
import de.humatic.dsj.DSFilterInfo;
import de.humatic.dsj.DSFiltergraph;
import de.humatic.dsj.DSJException;
import de.humatic.dsj.util.MPEGProgram;
import de.humatic.dsj.util.MPEGSource;
import de.humatic.dsj.xml.XMLUtils;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import org.w3c.dom.Node;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DSHDVTape
extends DSFiltergraph
implements AVCDevice,
MPEGSource {
    public static final int CAMERA = 0;
    public static final int VCR = 1;
    public static final int PREVIEW = 0;
    public static final int T2TS = 1;
    public static final int T2F = 2;
    public static final int C2TS = 3;
    public static final int C2F = 4;
    public static final int AVC = 0;
    public static final int UVC = 1;
    private int s;
    private String b;
    private int[] d = new int[16];

    public DSHDVTape(int n2, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            this.addPropertyChangeListener(propertyChangeListener);
        }
        this.a(n2, DSFilterInfo.doNotRender(), DSFilterInfo.doNotRender(), DSFilterInfo.doNotRender());
    }

    public DSHDVTape(int n2, DSFilterInfo dSFilterInfo, DSFilterInfo dSFilterInfo2, DSFilterInfo dSFilterInfo3, PropertyChangeListener propertyChangeListener) {
        boolean bl;
        if (dSFilterInfo == null) {
            dSFilterInfo = DSFilterInfo.doNotRender();
        }
        if (!(bl = dSFilterInfo.getCLSID().equalsIgnoreCase("{8C0F6AF2-0EDB-44C1-8AEB-59040BD830ED}"))) {
            throw new DSJException("DSHDVTape: FilterInfo does not point to a HDV device", -1);
        }
        if (propertyChangeListener != null) {
            this.addPropertyChangeListener(propertyChangeListener);
        }
        this.a(n2, dSFilterInfo, dSFilterInfo2, dSFilterInfo3);
    }

    private void a(int n2, DSFilterInfo dSFilterInfo, DSFilterInfo dSFilterInfo2, DSFilterInfo dSFilterInfo3) {
        Object object;
        this.a(n2);
        this.type = 8;
        this.a = this.initInstance(8);
        this.setName(String.valueOf(this.a));
        this.initializeGraph(this.a, DSEnvironment.b());
        this.setBackground(Color.black);
        if (this.o) {
            this.j ^= 0x100;
        }
        if (dSFilterInfo2 == null || dSFilterInfo2.getName().equalsIgnoreCase("none")) {
            try {
                object = DSEnvironment.getClassNode("DSHDVTape", a);
                try {
                    dSFilterInfo2 = DSFilterInfo.filterInfoForName(XMLUtils.getElementByName((Node)object, "mpegdecoder", null, false).getAttribute("name"));
                }
                catch (Exception exception) {
                    dSFilterInfo2 = DSFilterInfo.doNotRender();
                }
                if (dSFilterInfo2 == null) {
                    dSFilterInfo2 = DSFilterInfo.doNotRender();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (dSFilterInfo3 == null || dSFilterInfo3.getName().equalsIgnoreCase("none")) {
            try {
                object = DSEnvironment.getClassNode("DSHDVTape", a);
                try {
                    dSFilterInfo3 = DSFilterInfo.filterInfoForName(XMLUtils.getElementByName((Node)object, "audiodecoder", null, false).getAttribute("name"));
                }
                catch (Exception exception) {
                    dSFilterInfo3 = DSFilterInfo.doNotRender();
                }
                if (dSFilterInfo3 == null) {
                    dSFilterInfo3 = DSFilterInfo.doNotRender();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.f = this.setupDSHDVTape(this.a, n2, dSFilterInfo, dSFilterInfo2, dSFilterInfo3);
        }
        catch (Exception exception) {
            this.e = true;
            throw new DSJException("dsj, unknown error in dll", -1);
        }
        object = "DSHDVTape, construction failed: " + DSJException.hresultToHexString(this.f);
        if (this.f < 0) {
            this.e = true;
            switch (this.f) {
                case -305: {
                    object = "DSHDVTape, device in VCR mode without tape";
                    break;
                }
                case -300: {
                    object = "DSHDVTape, no HDV device found";
                    break;
                }
                case -303: {
                    object = "DSHDVTape, device busy, cant render preview";
                }
            }
            throw new DSJException((String)object, this.f);
        }
        try {
            this.b = dSFilterInfo.getPath();
        }
        catch (Exception exception) {}
        DSHDVTape dSHDVTape = this;
        this.d = this.nativeGetPIDs(dSHDVTape.a);
        if (this.k) {
            this.getMovieInfo(this.a, this.a);
            this.a(this.a);
            this.d = (int[])true;
            if (this.getDeviceMode() > 0) {
                this.setRate(0.0f);
            }
            return;
        }
        if (this.l || this.m) {
            this.e();
            this.getMovieInfo(this.a, this.a);
            this.b();
            this.a(this.a);
            this.d = (int[])true;
            if (this.getDeviceMode() > 0) {
                this.setRate(0.0f);
            }
            return;
        }
        try {
            while (this.getBufferSize(this.a) == 0) {
                Thread.currentThread();
                Thread.sleep(100L);
            }
        }
        catch (Exception exception) {}
        this.e();
        this.getMovieInfo(this.a, this.a);
        this.b();
        this.a(this.a);
        this.d = (int[])true;
        if (this.getDeviceMode() > 0) {
            this.setRate(0.0f);
        }
        if (this.k || !this.g && !this.i && !this.n) {
            return;
        }
        this.c();
    }

    public int getDeviceMode() {
        return this.f >> 8 & 0xF;
    }

    public int getOperationMode() {
        return this.f & 0xFF;
    }

    public String getDeviceDescription() {
        String string = ((DSHDVTape)object).nativeGetDeviceDesc(((DSHDVTape)object).a);
        if (string.indexOf("?") != -1) {
            return string.substring(0, string.indexOf("?")).trim();
        }
        if (string.trim().length() == 0 && ((DSHDVTape)object).b != null) {
            try {
                int n2 = ((DSHDVTape)object).b.indexOf("#");
                string = ((DSHDVTape)object).b.substring(n2 + 1, ((DSHDVTape)object).b.indexOf("#", n2 + 1));
                Object object = string.getBytes();
                for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                    if (object[n2] != 38) continue;
                    object[n2] = 32;
                }
                string = new String((byte[])object);
            }
            catch (Exception exception) {}
        }
        return string.trim();
    }

    final void a() {
        this.a = -1L;
    }

    public void rewind() {
        if (this.d == false) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 1024;
        this.a[4] = 0;
        this.s = this.handleMovieTransport(this.a, this.a, this.e);
        if (this.s == -305) {
            throw new DSJException("DSHDVTape, device has no tape", -305);
        }
    }

    public void scanBwd() {
        if (this.d == false) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 1024;
        this.a[4] = 2;
        this.s = this.handleMovieTransport(this.a, this.a, this.e);
        if (this.s == -305) {
            throw new DSJException("DSHDVTape, device has no tape", -305);
        }
    }

    public void stepBwd() {
        if (this.d == false) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 1024;
        this.a[4] = 4;
        this.s = this.handleMovieTransport(this.a, this.a, this.e);
        if (this.s == -305) {
            throw new DSJException("DSHDVTape, device has no tape", -305);
        }
    }

    public void fastFwd() {
        if (this.d == false) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 1024;
        this.a[4] = 1;
        this.s = this.handleMovieTransport(this.a, this.a, this.e);
        if (this.s == -305) {
            throw new DSJException("DSHDVTape, device has no tape", -305);
        }
    }

    public void scanFwd() {
        if (this.d == false) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 1024;
        this.a[4] = 3;
        this.s = this.handleMovieTransport(this.a, this.a, this.e);
        if (this.s == -305) {
            throw new DSJException("DSHDVTape, device has no tape", -305);
        }
    }

    public void stepFwd() {
        if (this.d == false) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 1024;
        this.a[4] = 5;
        this.s = this.handleMovieTransport(this.a, this.a, this.e);
        if (this.s == -305) {
            throw new DSJException("DSHDVTape, device has no tape", -305);
        }
    }

    public void pause() {
        if (this.d == false) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 1024;
        this.a[4] = 6;
        this.a[0] = this.a[0] == 0 ? 1 : 0;
        this.s = this.handleMovieTransport(this.a, this.a, this.e);
        if (this.s == -305) {
            throw new DSJException("DSHDVTape, device has no tape", -305);
        }
    }

    public void stop() {
        if (this.d == false) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 1024;
        this.a[4] = 7;
        this.a[0] = 0;
        this.s = this.handleMovieTransport(this.a, this.a, this.e);
        if (this.s == -305) {
            throw new DSJException("DSHDVTape, device has no tape", -305);
        }
    }

    public void record() {
        if (this.d == false) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 1024;
        this.a[4] = 8;
        this.a[2] = this.a[2] == 0 ? 1 : 0;
        this.s = this.handleMovieTransport(this.a, this.a, this.e);
    }

    public void extRecord() {
        if (this.d == false) {
            throw new DSJException("Graph not active", -2);
        }
        this.e = 1024;
        this.a[4] = 10;
        this.s = this.handleMovieTransport(this.a, this.a, this.e);
    }

    public void seekToTime(int n2, int n3, int n4, int n5) {
        if (this.d == false) {
            throw new DSJException("Graph not active", -2);
        }
        if (this.getDeviceMode() != 1) {
            throw new DSJException("DSHDVTape: Device not in VCR mode", -4);
        }
        this.e = 2048;
        this.a[4] = n2;
        this.a[5] = n3;
        this.a[6] = n4;
        this.a[7] = n5;
        this.handleMovieTransport(this.a, this.a, this.e);
    }

    public void seekToTime(int n2) {
        int n3 = n2 / 3600000;
        int n4 = n2 % 3600000 / 60000;
        int n5 = n2 % 60000 / 1000;
        n2 = (int)((float)n2 % this.getFrameRate());
        this.seekToTime(n3, n4, n5, n2);
    }

    public int sendRawAVC(byte[] byArray) {
        if (this.d == false) {
            throw new DSJException("Graph not active", -2);
        }
        return this.nativeSendRawCommand(this.a, 8, 0, byArray);
    }

    public int getExtTransportState() {
        return this.nativeGetParameter(this.a, 1, -1);
    }

    native int setupDSHDVTape(long var1, int var3, DSFilterInfo var4, DSFilterInfo var5, DSFilterInfo var6);

    /*
     * WARNING - void declaration
     */
    public void captureTransportStream(String string, boolean bl, int n2) {
        void dSHDVTape;
        if (this.d == false) {
            throw new DSJException("Graph not active", -2);
        }
        int n3 = (bl ? 1 : 0) << 16 | dSHDVTape & 0xFF;
        DSHDVTape dSHDVTape2 = this;
        this.f = this.nativeCaptureTS(dSHDVTape2.a, string, n3);
        this.a[0] = 0;
        if (this.f < 0) {
            throw new DSJException("HDV, error setting up TS capture", this.f);
        }
        this.a(-1, 30);
    }

    public void captureElementaryStreams(String string, boolean bl) {
        if (this.d == false) {
            throw new DSJException("Graph not active", -2);
        }
        int n2 = 0x100 | (bl ? 1 : 0) << 4;
        if (string.indexOf(".") != -1) {
            string = string.substring(0, string.indexOf("."));
        }
        DSHDVTape dSHDVTape = this;
        this.f = this.nativeCaptureTS(dSHDVTape.a, string, n2);
        this.a[0] = 0;
        if (this.f < 0) {
            throw new DSJException("HDV, error setting up ES capture", this.f);
        }
        this.a(-1, 30);
    }

    public void setPreview() {
        if (this.d == false) {
            throw new DSJException("Graph not active", -2);
        }
        if (this.getOperationMode() == 0) {
            return;
        }
        this.f = this.nativeSetPreview(this.a);
        if (this.f < 0) {
            throw new DSJException("HDV, error setting preview", this.f);
        }
        this.a(-1, 30);
    }

    public static DSFilterInfo[] getHDVDevices() {
        DSEnvironment.loadDLL();
        int n2 = DSEnvironment.b();
        Vector vector = new Vector();
        n2 = DSHDVTape.nativeGetHDVDevices(vector, 0, n2);
        if (n2 < 0) {
            throw new DSJException("HDV, cant get devices", n2);
        }
        Object[] objectArray = new DSFilterInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int getPMT_PID() {
        return this.d[0];
    }

    public int[] getProgramPIDs() {
        return new int[]{this.d[2], this.d[4]};
    }

    public int[] getStreamTypes() {
        return new int[]{this.d[3], this.d[5]};
    }

    public MPEGProgram[] getPrograms() {
        MPEGProgram mPEGProgram = new MPEGProgram(0, this.d[0]);
        mPEGProgram.setStreams(this.getProgramPIDs(), this.getStreamTypes());
        return new MPEGProgram[]{mPEGProgram};
    }

    final long a() {
        return this.a;
    }

    native int nativeCaptureTS(long var1, String var3, int var4);

    native int nativeSetPreview(long var1);

    native String nativeGetDeviceDesc(long var1);

    static native int nativeGetHDVDevices(Vector var0, int var1, int var2);

    native int[] nativeGetPIDs(long var1);
}

