/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.dsj;

import de.humatic.dsj.A;
import de.humatic.dsj.B;
import de.humatic.dsj.C;
import de.humatic.dsj.DSJException;
import de.humatic.dsj.G;
import de.humatic.dsj.y;
import de.humatic.dsj.z;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CaptureDeviceControls {
    int[] a;
    private Vector a;
    private int a;
    private long a;
    public static final int BRIGHTNESS = 1;
    public static final int CONTRAST = 2;
    public static final int HUE = 3;
    public static final int SATURATION = 4;
    public static final int SHARPNESS = 5;
    public static final int GAMMA = 6;
    public static final int COLORENABLE = 7;
    public static final int WHITEBALANCE = 8;
    public static final int BACKLIGHTCOMPENSATION = 9;
    public static final int GAIN = 10;
    public static final int PAN = 11;
    public static final int TILT = 12;
    public static final int ROLL = 13;
    public static final int ZOOM = 14;
    public static final int EXPOSURE = 15;
    public static final int IRIS = 16;
    public static final int FOCUS = 17;
    public static final int MASTER_VOL = 18;
    public static final int MASTER_PAN = 19;
    public static final int INPUT_SELECT = 20;
    public static final int INPUT_LEVEL = 21;
    public static final int BALANCE = 22;
    public static final int BASS = 23;
    public static final int TREBLE = 24;
    public static final int DIGITAL = 0;
    public static final int MECHANICAL = 1;
    private String[] a = new String[]{"", "Brightness", "Contrast", "Hue", "Saturation", "Sharpness", "Gamma", "Color enable", "Whitebalance", "Backlight Compensation", "Gain", "Pan", "Tilt", "Roll", "Zoom", "Exposure", "Iris", "Focus", "Master volume", "Master pan", "Input select", "Input gain", "Pan", "Bass", "Treble"};

    public CaptureDeviceControls(int n2, long l2, int[] nArray, Vector vector) {
        this.a = n2;
        this.a = l2;
        this.a = nArray;
        this.a = vector;
    }

    public int[] getParameterRange(int n2) {
        int[] nArray = new int[5];
        System.arraycopy(this.a, n2 * 5, nArray, 0, 5);
        return nArray;
    }

    public int getCurrentValue(int n2) {
        if (this.a[n2 * 5 + 1] - this.a[n2 * 5] == 0 || this.a == 1 && n2 < 18 || this.a != 1 && n2 >= 18) {
            throw new DSJException("CaptureDeviceControls: parameter " + this.a[n2] + " not supported", -400);
        }
        if (n2 < 11) {
            return this.getVProcValue(this.a, n2);
        }
        if (n2 >= 11 && n2 < 18) {
            return this.getCamCtrlValue(this.a, n2 - 10);
        }
        return this.getAudioMixerValue(this.a, n2 - 20);
    }

    public boolean getAuto(int n2) {
        if (this.a[n2 * 5 + 1] - this.a[n2 * 5] == 0) {
            return false;
        }
        if (this.a != 1 && n2 < 11) {
            return (this.getVProcValue(this.a, -n2) & 1) != 0;
        }
        if (this.a != 1 && n2 >= 11 && n2 < 18) {
            return (this.getCamCtrlValue(this.a, -(n2 - 10)) & 1) != 0;
        }
        return false;
    }

    public void setAuto(int n2, boolean bl) {
        boolean bl2 = true;
        if (this.a != 1) {
            bl2 = this.setAutoControl(this.a, n2, bl);
        }
        if (!bl2) {
            throw new DSJException("CaptureDeviceControls: parameter " + this.a[n2] + " can not be controlled automatically", -400);
        }
    }

    public void setParameterValue(int n2, int n3) {
        if (this.a[n2 * 5 + 1] - this.a[n2 * 5] == 0) {
            throw new DSJException("CaptureDeviceControls: parameter " + this.a[n2] + " can not be controlled", -400);
        }
        if (n3 < this.a[n2 * 5] || n3 > 0 && (n3 & 0xFFFF) > this.a[n2 * 5 + 1]) {
            throw new DSJException("CaptureDeviceControls: value out of range for pparameter " + this.a[n2], -401);
        }
        if (this.a == 1 && n2 < 18 || this.a != 1 && n2 >= 18) {
            throw new DSJException("CaptureDeviceControls: parameter " + this.a[n2] + " not supported", -400);
        }
        if (n2 < 11) {
            this.setVProcValue(this.a, n2, n3);
            return;
        }
        if (n2 >= 11 && n2 < 18) {
            this.setCamCtrlValue(this.a, n2 - 10, n3);
            return;
        }
        int n4 = this.setAudioMixerValue(this.a, n2 - 20, n3);
        if (n4 != 0) {
            throw new DSJException("CaptureDeviceControl, cant set audio parameter: " + DSJException.hresultToHexString(n4), -400);
        }
    }

    public void resetDefaults(int n2) {
        try {
            ((CaptureDeviceControls)((Object)exception2)).setParameterValue(n2, ((CaptureDeviceControls)((Object)exception2)).a[n2 * 5 + 3] | ((CaptureDeviceControls)((Object)exception2)).a[n2 * 5 + 4] << 16);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    public void setPanTiltMode(int n2) {
        this.setCamCtrlValue(this.a, 0, n2);
    }

    public int getPanTiltMode() {
        return this.getCamCtrlValue(this.a, 0);
    }

    public boolean selectAudioInput(int n2) {
        boolean bl = this.activateAudioInput(this.a, n2);
        if (bl) {
            CaptureDeviceControls.getAudioInputMixer(this.a, n2, this.a);
        }
        return bl;
    }

    public JComponent getController(int n2, int n3, boolean bl) {
        if (this.a[n2 * 5 + 1] == this.a[n2 * 5]) {
            return null;
        }
        if ((Math.abs(this.a[n2 * 5 + 1] - this.a[n2 * 5]) > 1 || this.a[n2 * 5] > 0) && n2 != 20) {
            JSlider jSlider = new JSlider(n3, this.a[n2 * 5], this.a[n2 * 5 + 1], this.a[n2 * 5]);
            try {
                jSlider.setValue(this.getCurrentValue(n2));
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
            }
            jSlider.setMinorTickSpacing(this.a[n2 * 5 + 2]);
            jSlider.setSnapToTicks(true);
            jSlider.setEnabled(!this.getAuto(n2));
            if (n2 < 20) {
                jSlider.addMouseListener(new C(this, jSlider, n2));
            }
            if (bl) {
                jSlider.setBorder(new TitledBorder(this.a[n2]));
            }
            jSlider.addChangeListener(new z(this, jSlider, n2));
            return jSlider;
        }
        if (n2 == 20 && this.a.size() > 0) {
            JComboBox jComboBox = new JComboBox(this.a);
            if (bl) {
                jComboBox.setBorder(new TitledBorder(this.a[n2]));
                jComboBox.setBackground(null);
            }
            jComboBox.setSelectedIndex(this.a[n2 * 5 + 3]);
            jComboBox.addActionListener(new y(this, jComboBox));
            return jComboBox;
        }
        if (this.a[n2 * 5 + 1] - this.a[n2 * 5] == 1 && n2 != 20) {
            JCheckBox jCheckBox = new JCheckBox(bl ? this.a[n2] : "", this.getCurrentValue(n2) == 1);
            jCheckBox.addActionListener(new B(this, n2, jCheckBox));
            return jCheckBox;
        }
        return null;
    }

    public String[] getAudioInputNames() {
        try {
            String[] stringArray = new String[this.a.size()];
            this.a.toArray(stringArray);
            return stringArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static native boolean getVProcControls(long var0, int[] var2);

    native boolean setVProcValue(long var1, int var3, int var4);

    native int getVProcValue(long var1, int var3);

    native boolean setCamCtrlValue(long var1, int var3, int var4);

    native boolean setAutoControl(long var1, int var3, boolean var4);

    native int getCamCtrlValue(long var1, int var3);

    static native int getAudioInputs(long var0, int[] var2, Vector var3);

    static native boolean getAudioInputMixer(long var0, int var2, int[] var3);

    native int setAudioMixerValue(long var1, int var3, int var4);

    native int getAudioMixerValue(long var1, int var3);

    native boolean activateAudioInput(long var1, int var3);

    static void a(CaptureDeviceControls captureDeviceControls, JComponent jComponent, int n2, MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JCheckBoxMenuItem("auto", captureDeviceControls.getAuto(n2)));
        ((JCheckBoxMenuItem)jPopupMenu.getSubElements()[0]).addActionListener(new A(captureDeviceControls, n2, jPopupMenu, jComponent));
        if (jComponent instanceof JSlider) {
            jPopupMenu.add(new JMenuItem("reset defaults"));
            ((JMenuItem)jPopupMenu.getSubElements()[1]).addActionListener(new G(captureDeviceControls, n2, jComponent, jPopupMenu));
        }
        jPopupMenu.show(jComponent, mouseEvent.getX() + 2, mouseEvent.getY());
    }
}

