/*
 * Decompiled with CFR 0.152.
 */
package jess.xml;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jess.Accumulate;
import jess.Deffacts;
import jess.Deffunction;
import jess.Defglobal;
import jess.Defmodule;
import jess.Defquery;
import jess.Defrule;
import jess.Deftemplate;
import jess.Fact;
import jess.Funcall;
import jess.Group;
import jess.JessException;
import jess.Pattern;
import jess.RU;
import jess.Rete;
import jess.Test1;
import jess.Value;
import jess.ValueVector;
import jess.Visitor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLBuilder
implements Visitor {
    private Element m_rootElement;
    private Document m_document;
    public static final String NAMESPACE_URI = "http://www.jessrules.com/jessde";

    public XMLBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        this.m_document = dOMImplementation.createDocument(NAMESPACE_URI, "rulebase", null);
        this.m_rootElement = this.m_document.getDocumentElement();
        ProcessingInstruction processingInstruction = this.m_document.createProcessingInstruction("JessML-version", "1");
        this.m_rootElement.appendChild(processingInstruction);
    }

    public static void main(String[] stringArray) throws ParserConfigurationException, TransformerException, JessException {
        Rete rete = new Rete();
        rete.eval("(deftemplate foo (slot bar1 (default 23)) (slot bar2))");
        Deftemplate deftemplate = rete.findDeftemplate("foo");
        XMLBuilder xMLBuilder = new XMLBuilder();
        xMLBuilder.visitDeftemplate(deftemplate);
        DOMSource dOMSource = new DOMSource(xMLBuilder.getDocument());
        StreamResult streamResult = new StreamResult(System.out);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(dOMSource, streamResult);
    }

    private Document getDocument() {
        return this.m_document;
    }

    public Object visitDeffacts(Deffacts deffacts) {
        Element element = this.m_document.createElement("facts");
        element.appendChild(this.makeTextNode("name", deffacts.getName()));
        int n = deffacts.getNFacts();
        for (int i = 0; i < n; ++i) {
            Fact fact = deffacts.getFact(i);
            element.appendChild((Node)this.visitFact(fact));
        }
        return element;
    }

    public Object visitDeftemplate(Deftemplate deftemplate) {
        Element element = this.m_document.createElement("template");
        element.appendChild(this.makeTextNode("name", deftemplate.getName()));
        if (deftemplate.isShadowTemplate()) {
            element.appendChild(this.makeTextNode("from-class", deftemplate.getShadowClassName()));
        } else {
            for (int i = 0; i < deftemplate.getNSlots(); ++i) {
                try {
                    Element element2;
                    String string = deftemplate.getSlotName(i);
                    Value value = deftemplate.getSlotDefault(i);
                    if (deftemplate.getSlotType(i) == 32768) {
                        element2 = this.m_document.createElement("multislot");
                        element.appendChild(element2);
                        element2.appendChild(this.makeTextNode("name", string));
                        continue;
                    }
                    element2 = this.m_document.createElement("slot");
                    element.appendChild(element2);
                    element2.appendChild(this.makeTextNode("name", string));
                    element2.appendChild(this.visitValue(value));
                    continue;
                }
                catch (JessException jessException) {
                    return this.m_document.createTextNode(jessException.toString());
                }
            }
        }
        this.m_rootElement.appendChild(element);
        return element;
    }

    private Node visitValue(Value value) {
        try {
            String string;
            if (value.type() == 16) {
                return (Node)this.visitFact(value.factValue(null));
            }
            if (value.type() == 64) {
                return (Node)this.visitFuncall(value.funcallValue(null));
            }
            if (value.type() == 512) {
                return this.makeSlot(value.listValue(null));
            }
            Element element = this.m_document.createElement("value");
            Element element2 = this.makeTextNode("type", RU.getTypeName(value.type()));
            element.appendChild(element2);
            switch (value.type()) {
                case 1: 
                case 2: {
                    string = value.stringValue(null);
                    break;
                }
                case 8: 
                case 8192: {
                    string = value.variableValue(null);
                    break;
                }
                default: {
                    string = value.toString();
                }
            }
            element.appendChild(this.m_document.createTextNode(string));
            return element;
        }
        catch (JessException jessException) {
            return this.m_document.createTextNode(jessException.toString());
        }
    }

    private Node makeSlot(ValueVector valueVector) {
        Element element = this.m_document.createElement("slot");
        try {
            element.appendChild(this.makeTextNode("name", valueVector.get(0).symbolValue(null)));
            for (int i = 1; i < valueVector.size(); ++i) {
                element.appendChild(this.visitValue(valueVector.get(i)));
            }
        }
        catch (JessException jessException) {
            element.appendChild(this.m_document.createTextNode(jessException.getMessage()));
        }
        return element;
    }

    public Object visitFuncall(Funcall funcall) {
        Element element = this.m_document.createElement("funcall");
        try {
            element.appendChild(this.makeTextNode("name", XMLBuilder.escape(funcall.get(0).symbolValue(null))));
            for (int i = 1; i < funcall.size(); ++i) {
                element.appendChild(this.visitValue(funcall.get(i)));
            }
        }
        catch (JessException jessException) {
            element.appendChild(this.m_document.createTextNode(jessException.getMessage()));
        }
        return element;
    }

    private static String escape(String string) {
        if (XMLBuilder.needsNoEscaping(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        block5: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block5;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block5;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block5;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    private static boolean needsNoEscaping(String string) {
        return string.indexOf(60) < 0 && string.indexOf(62) < 0 && string.indexOf(38) < 0;
    }

    public Object visitFact(Fact fact) {
        Element element = this.m_document.createElement("fact");
        element.appendChild(this.makeTextNode("name", fact.getName()));
        try {
            Deftemplate deftemplate = fact.getDeftemplate();
            for (int i = 0; i < deftemplate.getNSlots(); ++i) {
                String string = deftemplate.getSlotName(i);
                Value value = fact.getSlotValue(string);
                if (deftemplate.getSlotDefault(i).equals(value)) continue;
                Element element2 = this.m_document.createElement("slot");
                element.appendChild(element2);
                element2.appendChild(this.makeTextNode("name", string));
                if (value.type() != 512) {
                    element2.appendChild(this.visitValue(value));
                    continue;
                }
                ValueVector valueVector = value.listValue(null);
                for (int j = 0; j < valueVector.size(); ++j) {
                    element2.appendChild(this.visitValue(valueVector.get(j)));
                }
            }
        }
        catch (JessException jessException) {
            element.appendChild(this.m_document.createTextNode(jessException.getMessage()));
        }
        return element;
    }

    private Element makeTextNode(String string, String string2) {
        Text text = this.m_document.createTextNode(string2);
        Element element = this.m_document.createElement(string);
        element.appendChild(text);
        return element;
    }

    public Object visitDeffunction(Deffunction deffunction) {
        return null;
    }

    public Object visitDefglobal(Defglobal defglobal) {
        return null;
    }

    public Object visitDefrule(Defrule defrule) {
        return null;
    }

    public Object visitDefquery(Defquery defquery) {
        return null;
    }

    public Object visitPattern(Pattern pattern) {
        return null;
    }

    public Object visitGroup(Group group) {
        return null;
    }

    public Object visitTest1(Test1 test1) {
        return null;
    }

    public Object visitAccumulate(Accumulate accumulate) {
        return null;
    }

    public Object visitDefmodule(Defmodule defmodule) {
        return null;
    }
}

