/*
 * Decompiled with CFR 0.152.
 */
package jess.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import jess.Accumulate;
import jess.ConditionalElement;
import jess.Deffacts;
import jess.Deffunction;
import jess.Defglobal;
import jess.Defmodule;
import jess.Defquery;
import jess.Defrule;
import jess.Deftemplate;
import jess.Fact;
import jess.FactIDValue;
import jess.Funcall;
import jess.FuncallValue;
import jess.Group;
import jess.JessException;
import jess.LongValue;
import jess.Pattern;
import jess.RU;
import jess.Rete;
import jess.Test1;
import jess.Value;
import jess.ValueVector;
import jess.Variable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JessSAXHandler
extends DefaultHandler {
    private final Rete m_sink;
    private final Stack m_scopes = new Stack();
    private final String m_topLevelElement;
    private StringBuffer m_text;
    private static final String PAYLOAD = "payload";
    private static final String COMMENT = "comment";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String CONJUNCTION = "conjunction";
    private static final String CONTENTS = "contents";
    private static final String BINDING = "binding";
    private static final String FROM_CLASS = "from-class";
    private static final String PROPERTY = "property";
    private static final String SALIENCE = "salience";
    private static final String NO_LOOP = "no-loop";
    private static final String NODE_INDEX_HASH = "node-index-hash";
    private static final String ACCUM_BODY = "accum-body";
    private static final String ACCUM_RETURN = "accum-return";
    private static final String ACCUMULATE = "accumulate";
    private static final String PATTERN = "pattern";
    private static final String AUTO_FOCUS = "auto-focus";
    private static final String MAX_BACKGROUND_RULES = "max-background-rules";
    private static final String ACCUM_INIT = "accum-init";
    private static final HashSet s_validTags = new HashSet();
    private static final String[] LHS_OR_PROPERTIES = new String[]{"lhs", "properties"};
    private static final String[] VALUE_OR_FUNCALL = new String[]{"value", "funcall"};
    public static final String RULEBASE = "rulebase";
    public static final String FACTLIST = "fact-list";

    public JessSAXHandler(Rete rete, String string) {
        this.m_sink = rete;
        this.m_topLevelElement = string;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!s_validTags.contains(string3)) {
            throw new SAXException("Unrecognized element \"" + string3 + "\" in startElement");
        }
        if (this.m_scopes.size() == 0 && !string3.equals(this.m_topLevelElement)) {
            throw new SAXException("Top-level element must be \"" + this.m_topLevelElement + "\"");
        }
        this.m_scopes.push(new Scope(string3, attributes));
        if (this.m_text != null) {
            this.m_text.setLength(0);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            Stack stack = new Stack();
            while (!((Scope)this.m_scopes.peek()).open) {
                stack.push(this.m_scopes.pop());
            }
            Scope scope = (Scope)this.m_scopes.peek();
            if (string3.equals("rule")) {
                Serializable serializable;
                Object object;
                String string4 = (String)scope.get(NAME);
                String string5 = (String)scope.get(COMMENT, "");
                Defrule defrule = new Defrule(string4, string5, this.m_sink);
                String string6 = JessSAXHandler.lookingAt(stack, LHS_OR_PROPERTIES);
                if (string6.equals("properties")) {
                    object = (Map)((Scope)stack.pop()).get(PAYLOAD);
                    if (object.get(SALIENCE) != null) {
                        serializable = (Value)object.get(SALIENCE);
                        defrule.setSalience((Value)serializable, this.m_sink);
                    }
                    if (object.get(AUTO_FOCUS) != null) {
                        serializable = (Value)object.get(AUTO_FOCUS);
                        defrule.setAutoFocus(Funcall.TRUE.equals((Value)serializable));
                    }
                    if (object.get(NO_LOOP) != null) {
                        serializable = (Value)object.get(NO_LOOP);
                        defrule.setNoLoop(Funcall.TRUE.equals((Value)serializable));
                    }
                    if (object.get(NODE_INDEX_HASH) != null) {
                        serializable = (Value)object.get(NODE_INDEX_HASH);
                        defrule.setNodeIndexHash(((Value)serializable).intValue(null));
                    }
                    JessSAXHandler.lookingAt(stack, "lhs");
                }
                object = (Group)((Scope)stack.pop()).get(PAYLOAD);
                defrule.setLHS((Group)object, this.m_sink);
                JessSAXHandler.lookingAt(stack, "rhs");
                serializable = (ArrayList)((Scope)stack.pop()).get(PAYLOAD);
                Iterator iterator = ((ArrayList)serializable).iterator();
                while (iterator.hasNext()) {
                    Funcall funcall = (Funcall)iterator.next();
                    defrule.addAction(funcall);
                }
                this.m_sink.addDefrule(defrule);
                this.m_scopes.pop();
            } else if (string3.equals("query")) {
                Object object;
                String string7 = (String)scope.get(NAME);
                String string8 = (String)scope.get(COMMENT, "");
                Defquery defquery = new Defquery(string7, string8, this.m_sink);
                JessSAXHandler.lookingAt(stack, "arguments");
                Scope scope2 = (Scope)stack.pop();
                List list = (List)scope2.get(PAYLOAD);
                Object object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (Variable)object2.next();
                    defquery.addQueryVariable((Variable)object);
                }
                object2 = JessSAXHandler.lookingAt(stack, LHS_OR_PROPERTIES);
                if (((String)object2).equals("properties")) {
                    Value value;
                    object = (Map)((Scope)stack.pop()).get(PAYLOAD);
                    if (object.get(MAX_BACKGROUND_RULES) != null) {
                        value = (Value)object.get(MAX_BACKGROUND_RULES);
                        defquery.setMaxBackgroundRules(value.intValue(null));
                    }
                    if (object.get(NODE_INDEX_HASH) != null) {
                        value = (Value)object.get(NODE_INDEX_HASH);
                        defquery.setNodeIndexHash(value.intValue(null));
                    }
                    JessSAXHandler.lookingAt(stack, "lhs");
                }
                object = (Group)((Scope)stack.pop()).get(PAYLOAD);
                defquery.setLHS((Group)object, this.m_sink);
                this.m_sink.addDefrule(defquery);
                this.m_scopes.pop();
            } else if (string3.equals(NAME)) {
                this.storeTextInParentScope(NAME);
            } else if (string3.equals(TYPE)) {
                this.storeTextInParentScope(TYPE);
            } else if (string3.equals(COMMENT)) {
                this.storeTextInParentScope(COMMENT);
            } else if (string3.equals(BINDING)) {
                this.storeTextInParentScope(BINDING);
            } else if (string3.equals("extends")) {
                this.storeTextInParentScope("extends");
            } else if (string3.equals("properties")) {
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                while (!stack.isEmpty()) {
                    Object[] objectArray = (Object[])((Scope)stack.pop()).get(PAYLOAD);
                    hashMap.put(objectArray[0], objectArray[1]);
                }
                scope.put(PAYLOAD, hashMap);
            } else if (string3.equals(PROPERTY)) {
                String string9 = (String)scope.get(NAME);
                String string10 = JessSAXHandler.lookingAt(stack, new String[]{"funcall", "value"});
                Object object = ((Scope)stack.pop()).get(PAYLOAD);
                Value value = string10.equals("value") ? (Value)object : new FuncallValue((Funcall)object);
                scope.put(PAYLOAD, new Object[]{string9, value});
            } else if (string3.equals(CONJUNCTION)) {
                this.storeTextInParentScope(CONJUNCTION);
            } else if (string3.equals("template")) {
                Deftemplate deftemplate;
                Object object;
                String string11 = (String)scope.get(NAME);
                Map map = new HashMap();
                if (stack.size() > 0) {
                    object = (Scope)stack.peek();
                    if (((Scope)object).name.equals("properties")) {
                        stack.pop();
                        map = (Map)((Scope)object).get(PAYLOAD);
                    }
                }
                object = (String)scope.get("extends", null);
                Value value = (Value)map.get(FROM_CLASS);
                Value value2 = (Value)map.get("include-variables");
                if (value != null) {
                    boolean bl = value2 != null && Funcall.TRUE.equals(value2);
                    this.m_sink.defclass(string11, value.stringValue(null), (String)object, bl);
                    deftemplate = this.m_sink.findDeftemplate(string11);
                } else {
                    Object object3;
                    String string12 = (String)scope.get(COMMENT, "");
                    if (object == null) {
                        deftemplate = new Deftemplate(string11, string12, this.m_sink);
                    } else {
                        object3 = this.m_sink.findDeftemplate((String)object);
                        deftemplate = new Deftemplate(string11, string12, (Deftemplate)object3, this.m_sink);
                    }
                    while (!stack.isEmpty()) {
                        JessSAXHandler.lookingAt(stack, new String[]{"slot", "multislot"});
                        object3 = (Scope)stack.pop();
                        boolean bl = ((Scope)object3).name.equals("multislot");
                        String string13 = (String)((Scope)object3).get(NAME);
                        ArrayList arrayList = (ArrayList)((Scope)object3).get(CONTENTS);
                        Value value3 = JessSAXHandler.defaultValue(arrayList, bl);
                        String string14 = "ANY";
                        if (((Scope)object3).getNullOK(TYPE) != null) {
                            string14 = (String)((Scope)object3).get(TYPE);
                        }
                        if (bl) {
                            deftemplate.addMultiSlot(string13, value3, string14);
                            continue;
                        }
                        deftemplate.addSlot(string13, value3, string14);
                    }
                }
                deftemplate.setSlotSpecific(Funcall.TRUE.equals(map.get("slot-specific")));
                if (Funcall.TRUE.equals(map.get("backchain-reactive"))) {
                    deftemplate.doBackwardChaining(this.m_sink);
                }
                this.m_sink.addDeftemplate(deftemplate);
                this.m_scopes.pop();
            } else if (string3.equals("lhs")) {
                Group group = new Group("and");
                while (!stack.isEmpty()) {
                    ConditionalElement conditionalElement = (ConditionalElement)((Scope)stack.pop()).get(PAYLOAD);
                    group.add(conditionalElement);
                }
                scope.put(PAYLOAD, group);
            } else if (string3.equals("group")) {
                String string15 = (String)scope.get(NAME);
                Group group = new Group(string15);
                while (!stack.isEmpty()) {
                    ConditionalElement conditionalElement = (ConditionalElement)((Scope)stack.pop()).get(PAYLOAD);
                    group.add(conditionalElement);
                }
                scope.put(PAYLOAD, group);
            } else if (string3.equals("function")) {
                Object object;
                String string16 = (String)scope.get(NAME);
                Deffunction deffunction = new Deffunction(string16, "");
                JessSAXHandler.lookingAt(stack, "arguments");
                Scope scope3 = (Scope)stack.pop();
                List list = (List)scope3.get(PAYLOAD);
                Object object4 = list.iterator();
                while (object4.hasNext()) {
                    object = (Variable)object4.next();
                    deffunction.addArgument(((Variable)object).variableValue(null), ((Value)object).type());
                }
                while (!stack.isEmpty()) {
                    JessSAXHandler.lookingAt(stack, new String[]{"funcall", "value"});
                    object4 = (Scope)stack.pop();
                    object = ((Scope)object4).get(PAYLOAD);
                    if (object instanceof Funcall) {
                        deffunction.addAction((Funcall)object);
                        continue;
                    }
                    deffunction.addValue((Value)object);
                }
                this.m_sink.addUserfunction(deffunction);
                this.m_scopes.pop();
            } else if (string3.equals("argument")) {
                String string17 = (String)scope.get(NAME);
                String string18 = (String)scope.get(TYPE);
                int n = RU.getTypeCode(string18);
                Variable variable = new Variable(string17, n);
                scope.put(PAYLOAD, variable);
            } else if (string3.equals("arguments")) {
                ArrayList<Variable> arrayList = new ArrayList<Variable>();
                while (!stack.isEmpty()) {
                    JessSAXHandler.lookingAt(stack, "argument");
                    Scope scope4 = (Scope)stack.pop();
                    Variable variable = (Variable)scope4.get(PAYLOAD);
                    arrayList.add(variable);
                }
                scope.put(PAYLOAD, arrayList);
            } else if (string3.equals(PATTERN)) {
                String string19 = (String)scope.get(NAME);
                String string20 = (String)scope.getNullOK(BINDING);
                Pattern pattern = new Pattern(string19, this.m_sink);
                if (string20 != null) {
                    pattern.setBoundName(string20);
                }
                Deftemplate deftemplate = pattern.getDeftemplate();
                if (stack.size() == 0 && deftemplate.isOrdered()) {
                    pattern.setSlotLength("__data", 0);
                } else {
                    while (!stack.isEmpty()) {
                        JessSAXHandler.lookingAt(stack, "slot");
                        Scope scope5 = (Scope)stack.pop();
                        String string21 = (String)scope5.get(NAME);
                        boolean bl = deftemplate.getSlotType(string21) == 32768;
                        int n = 0;
                        ArrayList arrayList = (ArrayList)scope5.get(CONTENTS);
                        boolean bl2 = true;
                        Iterator iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            Test1 test1 = (Test1)iterator.next();
                            if (bl) {
                                if (!bl2 && test1.getConjunction() == 0) {
                                    ++n;
                                }
                                test1.setMultiSlotIndex(n);
                            }
                            test1.setSlotName(string21);
                            pattern.addTest(test1);
                            bl2 = false;
                        }
                        if (!bl) continue;
                        pattern.setSlotLength(string21, n + 1);
                        int n2 = pattern.getDeftemplate().getSlotIndex(string21);
                        if (pattern.getNTests(n2) != 0) continue;
                        pattern.setSlotLength(string21, 0);
                    }
                }
                scope.put(PAYLOAD, pattern);
            } else if (string3.equals("slot") || string3.equals("multislot")) {
                String string22 = (String)scope.getNullOK(NAME);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                scope.put(NAME, string22);
                scope.put(CONTENTS, arrayList);
                while (!stack.isEmpty()) {
                    Scope scope6 = (Scope)stack.pop();
                    if (scope6.name.equals(TYPE)) {
                        scope.put(TYPE, scope6.get(TYPE));
                        continue;
                    }
                    arrayList.add(scope6.get(PAYLOAD));
                }
                scope.put(PAYLOAD, new Object[]{string22, arrayList});
            } else if (string3.equals("list")) {
                ValueVector valueVector = new ValueVector();
                while (!stack.isEmpty()) {
                    Scope scope7 = (Scope)stack.pop();
                    Object object = scope7.get(PAYLOAD);
                    if (object instanceof Funcall) {
                        valueVector.add(new FuncallValue((Funcall)object));
                        continue;
                    }
                    valueVector.add(object);
                }
                scope.put(PAYLOAD, new Value(valueVector, 512));
            } else if (string3.equals("global")) {
                String string23 = (String)scope.get(NAME);
                JessSAXHandler.lookingAt(stack, VALUE_OR_FUNCALL);
                Scope scope8 = (Scope)stack.pop();
                Value value = JessSAXHandler.makeValue(scope8.get(PAYLOAD));
                Defglobal defglobal = new Defglobal(string23, value);
                this.m_sink.addDefglobal(defglobal);
                this.m_scopes.pop();
            } else if (string3.equals("funcall")) {
                String string24 = (String)scope.get(NAME);
                Funcall funcall = new Funcall(string24, this.m_sink);
                while (!stack.isEmpty()) {
                    Scope scope9 = (Scope)stack.pop();
                    funcall.arg(JessSAXHandler.makeValue(scope9.get(PAYLOAD)));
                }
                if (this.isTopLevelFunction()) {
                    funcall.execute(this.m_sink.getGlobalContext());
                    this.m_scopes.pop();
                } else {
                    scope.put(PAYLOAD, funcall);
                }
            } else if (string3.equals(ACCUM_INIT)) {
                Scope scope10 = (Scope)stack.pop();
                Value value = JessSAXHandler.makeValue(scope10.get(PAYLOAD));
                scope.put(PAYLOAD, value);
            } else if (string3.equals(ACCUM_RETURN)) {
                Scope scope11 = (Scope)stack.pop();
                Value value = JessSAXHandler.makeValue(scope11.get(PAYLOAD));
                scope.put(PAYLOAD, value);
            } else if (string3.equals(ACCUM_BODY)) {
                Scope scope12 = (Scope)stack.pop();
                Value value = JessSAXHandler.makeValue(scope12.get(PAYLOAD));
                scope.put(PAYLOAD, value);
            } else if (string3.equals(ACCUMULATE)) {
                Accumulate accumulate = new Accumulate();
                String string25 = (String)scope.getNullOK(BINDING);
                if (string25 != null) {
                    accumulate.setBoundName(string25);
                }
                JessSAXHandler.lookingAt(stack, ACCUM_INIT);
                Scope scope13 = (Scope)stack.pop();
                accumulate.setInitializer((Value)scope13.get(PAYLOAD));
                JessSAXHandler.lookingAt(stack, ACCUM_BODY);
                Scope scope14 = (Scope)stack.pop();
                accumulate.setBody((Value)scope14.get(PAYLOAD));
                JessSAXHandler.lookingAt(stack, ACCUM_RETURN);
                Scope scope15 = (Scope)stack.pop();
                accumulate.setReturn((Value)scope15.get(PAYLOAD));
                JessSAXHandler.lookingAt(stack, PATTERN);
                Scope scope16 = (Scope)stack.pop();
                accumulate.add((Pattern)scope16.get(PAYLOAD));
                scope.put(PAYLOAD, accumulate);
            } else if (string3.equals("value")) {
                String string26 = scope.getAttribute(TYPE);
                if (string26 == null) {
                    throw new JessException("JessSAXHandler.endElement", "Element 'value' missing required attribute", "'type'");
                }
                int n = RU.getTypeCode(string26);
                Value value = JessSAXHandler.decodeValue(this.m_text.toString(), n);
                scope.put(PAYLOAD, value);
            } else if (!string3.equals(RULEBASE)) {
                if (string3.equals("module")) {
                    String string27 = (String)scope.get(NAME);
                    String string28 = (String)scope.get(COMMENT, "");
                    try {
                        this.m_sink.addDefmodule(new Defmodule(string27, string28));
                    }
                    catch (JessException jessException) {
                        this.m_sink.setCurrentModule(string27);
                    }
                    this.m_scopes.pop();
                } else if (string3.equals("rhs")) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    scope.put(PAYLOAD, arrayList);
                    while (!stack.isEmpty()) {
                        JessSAXHandler.lookingAt(stack, "funcall");
                        Scope scope17 = (Scope)stack.pop();
                        arrayList.add(scope17.get(PAYLOAD));
                    }
                } else if (string3.equals(FACTLIST)) {
                    while (!stack.isEmpty()) {
                        JessSAXHandler.lookingAt(stack, "fact");
                        Scope scope18 = (Scope)stack.pop();
                        this.m_sink.assertFact((Fact)scope18.get(PAYLOAD));
                    }
                } else if (string3.equals("facts")) {
                    String string29 = (String)scope.get(NAME);
                    Deffacts deffacts = new Deffacts(string29, "", this.m_sink);
                    while (!stack.isEmpty()) {
                        JessSAXHandler.lookingAt(stack, "fact");
                        Scope scope19 = (Scope)stack.pop();
                        deffacts.addFact((Fact)scope19.get(PAYLOAD));
                    }
                    this.m_sink.addDeffacts(deffacts);
                    this.m_scopes.pop();
                } else if (string3.equals("test")) {
                    int n;
                    String string30 = (String)scope.get(TYPE);
                    String string31 = (String)scope.getNullOK(CONJUNCTION);
                    if (string31 == null) {
                        string31 = "none";
                    }
                    int n3 = n = string30.equals("eq") ? 0 : 1;
                    int n4 = string31.equals("and") ? 1 : (string31.equals("or") ? 2 : 0);
                    Value value = JessSAXHandler.makeValue(((Scope)stack.pop()).get(PAYLOAD));
                    scope.put(PAYLOAD, new Test1(n, "", value, n4));
                } else if (string3.equals("fact")) {
                    String string32 = (String)scope.get(NAME);
                    Fact fact = new Fact(string32, this.m_sink);
                    while (!stack.isEmpty()) {
                        Scope scope20 = (Scope)stack.pop();
                        String string33 = (String)scope20.get(NAME);
                        ArrayList arrayList = (ArrayList)scope20.get(CONTENTS);
                        if (fact.getDeftemplate().getSlotType(string33) == 32768) {
                            ValueVector valueVector = new ValueVector(arrayList.size());
                            Iterator iterator = arrayList.iterator();
                            while (iterator.hasNext()) {
                                Value value = JessSAXHandler.makeValue(iterator.next());
                                valueVector.add(value);
                            }
                            fact.setSlotValue(string33, new Value(valueVector, 512));
                            continue;
                        }
                        fact.setSlotValue(string33, JessSAXHandler.makeValue(arrayList.get(0)));
                    }
                    scope.put(PAYLOAD, fact);
                } else {
                    throw new SAXException("Unrecognized element \"" + string3 + "\" in endElement");
                }
            }
            if (this.m_text != null) {
                this.m_text.setLength(0);
            }
            scope.close();
        }
        catch (JessException jessException) {
            throw new SAXException(jessException);
        }
    }

    private boolean isTopLevelFunction() {
        int n = this.m_scopes.size();
        int n2 = n - 2;
        String string = ((Scope)this.m_scopes.get((int)n2)).name;
        return RULEBASE.equals(string) || "module".equals(string);
    }

    private void storeTextInParentScope(String string) throws JessException {
        this.m_scopes.pop();
        if (this.m_scopes.isEmpty()) {
            throw new JessException("JessSAXHandler.storeTextInParentScope", "Element not allowed at outer scope", string);
        }
        String string2 = this.m_text.toString().trim();
        ((Scope)this.m_scopes.peek()).put(string, string2);
    }

    private static Value defaultValue(ArrayList arrayList, boolean bl) throws JessException {
        if (!bl) {
            return arrayList.size() == 0 ? Funcall.NIL : JessSAXHandler.makeValue(arrayList.get(0));
        }
        if (arrayList.size() == 0) {
            return Funcall.NILLIST;
        }
        ValueVector valueVector = new ValueVector();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Value value = JessSAXHandler.makeValue(iterator.next());
            valueVector.add(value);
        }
        return new Value(valueVector, 512);
    }

    private static Value makeValue(Object object) throws JessException {
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof Funcall) {
            return new FuncallValue((Funcall)object);
        }
        if (object instanceof Fact) {
            return new FactIDValue((Fact)object);
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            ValueVector valueVector = new ValueVector(2);
            if (objectArray[0] != null) {
                valueVector.add(new Value((String)objectArray[0], 1));
            }
            ArrayList arrayList = (ArrayList)objectArray[1];
            for (int i = 0; i < arrayList.size(); ++i) {
                valueVector.add(JessSAXHandler.makeValue(arrayList.get(i)));
            }
            return new Value(valueVector, 512);
        }
        throw new JessException("JessSAXHandler.makeValue", "Expected value, saw", object.getClass().getName() + ":" + object.toString());
    }

    private static void lookingAt(Stack stack, String string) throws JessException {
        Scope scope = (Scope)stack.peek();
        if (!scope.name.equals(string)) {
            throw new JessException("JessSAXHandler.endElement", "Unexpected element: wanted " + string + ", got ", scope.name);
        }
    }

    private static String lookingAt(Stack stack, String[] stringArray) throws JessException {
        Scope scope = (Scope)stack.peek();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.equals(scope.name)) continue;
            return string;
        }
        throw new JessException("JessSAXHandler.endElement", "Unexpected element: wanted " + Arrays.asList(stringArray) + ", got ", scope.name);
    }

    private static Value decodeValue(String string, int n) throws JessException {
        string = string.replaceAll("&gt;", ">");
        string = string.replaceAll("&lt;", "<");
        string = string.replaceAll("&amp;", "&");
        switch (n) {
            case 1: 
            case 2: {
                return new Value(string, n);
            }
            case 4: {
                return new Value(Integer.parseInt(string), n);
            }
            case 32: {
                return new Value(Double.parseDouble(string), n);
            }
            case 65536: {
                return new LongValue(Long.parseLong(string));
            }
            case 8: 
            case 8192: {
                string = RU.removePrefix(string);
                return new Variable(string, n);
            }
        }
        throw new JessException("JessSAXHandler.decodeValue", "Bad type", n);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_text == null) {
            this.m_text = new StringBuffer();
        }
        this.m_text.append(cArray, n, n2);
    }

    void dumpStack() {
        System.out.println(this.m_scopes);
    }

    static {
        s_validTags.add(ACCUMULATE);
        s_validTags.add(ACCUM_BODY);
        s_validTags.add(ACCUM_RETURN);
        s_validTags.add(ACCUM_INIT);
        s_validTags.add(COMMENT);
        s_validTags.add("properties");
        s_validTags.add(PROPERTY);
        s_validTags.add(PATTERN);
        s_validTags.add("function");
        s_validTags.add("arguments");
        s_validTags.add("argument");
        s_validTags.add(BINDING);
        s_validTags.add("test");
        s_validTags.add("value");
        s_validTags.add(TYPE);
        s_validTags.add(CONJUNCTION);
        s_validTags.add("rule");
        s_validTags.add("query");
        s_validTags.add("module");
        s_validTags.add("global");
        s_validTags.add("template");
        s_validTags.add("group");
        s_validTags.add("funcall");
        s_validTags.add("fact");
        s_validTags.add("facts");
        s_validTags.add("slot");
        s_validTags.add("multislot");
        s_validTags.add(NAME);
        s_validTags.add(RULEBASE);
        s_validTags.add("lhs");
        s_validTags.add("rhs");
        s_validTags.add("list");
        s_validTags.add("extends");
        s_validTags.add(FACTLIST);
        s_validTags.add(FROM_CLASS);
        s_validTags.add("slot-specific");
        s_validTags.add("backchain-reactive");
        s_validTags.add("include-variables");
        s_validTags.add("ordered");
    }

    static class Scope {
        String name;
        HashMap payload;
        boolean open = true;
        private HashMap m_attributes;

        public Scope(String string, Attributes attributes) {
            if (attributes.getLength() > 0) {
                this.m_attributes = new HashMap();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.m_attributes.put(attributes.getQName(i), attributes.getValue(i));
                }
            }
            this.name = string;
            this.payload = new HashMap();
        }

        public Object get(String string) throws SAXException {
            Object v = this.payload.get(string);
            if (v == null) {
                throw new SAXException("Missing child " + string + " in scope " + this.name);
            }
            return v;
        }

        public Object get(String string, Object object) {
            Object object2 = this.payload.get(string);
            if (object2 == null) {
                object2 = object;
            }
            return object2;
        }

        public Object getNullOK(String string) {
            return this.payload.get(string);
        }

        public void put(String string, Object object) {
            this.payload.put(string, object);
        }

        public void close() {
            this.open = false;
        }

        public String toString() {
            return "[" + this.name + ": " + this.payload + (this.open ? " (open)" : " (closed)") + "]";
        }

        public String getAttribute(String string) {
            return this.m_attributes == null ? null : this.m_attributes.get(string);
        }
    }
}

