/*
 * Decompiled with CFR 0.152.
 */
package jess.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import jess.Activation;
import jess.BindingValue;
import jess.Context;
import jess.Defglobal;
import jess.Deftemplate;
import jess.Fact;
import jess.FactIDValue;
import jess.Funcall;
import jess.JessEvent;
import jess.JessException;
import jess.JessListener;
import jess.Rete;
import jess.StackFrame;
import jess.TerminatedException;
import jess.Token;
import jess.Value;
import jess.server.CommandSocketConnector;
import jess.server.EventSocketConnector;
import jess.server.LineNumberRecord;
import jess.server.ThreadSerialNumber;
import jess.server.ThreadState;

public class DebugListener
extends Observable
implements JessListener,
Runnable {
    static final String STARTED = "STARTED";
    public static final String QUIT = "QUIT";
    static final String SUSPEND = "SUSPENDED";
    static final String RESUME = "RESUMED";
    static final String RESUME_STEP = "RESUMED_STEP";
    static final String SUSPEND_STEP = "SUSPENDED_STEP";
    static final String SUSPENDED_BREAK = "SUSPENDED_BREAK";
    static final String STACK = "STACK";
    static final String ERROR = "ERROR";
    static final String OK = "OK";
    static final String PRINT = "PRINT";
    static final String FACT = "FACT";
    private PrintWriter m_eventSink;
    private PrintWriter m_cmdSink;
    private BufferedReader m_cmdSource;
    private Map m_breakpoints = Collections.synchronizedMap(new HashMap());
    private Map m_contexts = Collections.synchronizedMap(new HashMap());
    private Map m_threads = Collections.synchronizedMap(new HashMap());
    private Map m_states = Collections.synchronizedMap(new HashMap());
    private Rete m_engine;
    private Thread m_thread;
    private boolean m_listeningForEvents = true;
    private boolean m_terminated;
    private String m_pushBack;
    private ThreadSerialNumber m_threadIds = new ThreadSerialNumber();
    private static final boolean DEBUG = false;
    private static final String THREAD_CREATE = "THREAD_CREATE";
    private static final String THREAD_DEAD = "THREAD_DEAD";

    DebugListener(Reader reader, Writer writer, Writer writer2, Rete rete) {
        this.m_engine = rete;
        this.setCmdSource(reader);
        this.setCmdSink(writer);
        this.setEventSink(writer2);
        this.start();
    }

    public DebugListener(Rete rete) {
        this.m_engine = rete;
    }

    public void eventHappened(JessEvent jessEvent) throws JessException {
        if (this.isTerminated()) {
            throw new TerminatedException("DebugListener", "Quit by user command", QUIT);
        }
        if (Thread.currentThread() == this.m_thread) {
            return;
        }
        if (this.isListeningForEvents()) {
            this.respond(jessEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordContext(JessEvent jessEvent) {
        Map map = this.m_contexts;
        synchronized (map) {
            int n = this.m_threadIds.get();
            Context context = jessEvent.getContext();
            if (context != null) {
                this.setContext(n, Thread.currentThread(), context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void respond(JessEvent jessEvent) throws JessException {
        int n = this.m_threadIds.get();
        switch (jessEvent.getType()) {
            case 524288: {
                this.sendRemark("About to call " + jessEvent.getObject() + " in " + n + "(" + this.getState(n) + ")");
                Map map = this.m_states;
                synchronized (map) {
                    this.recordContext(jessEvent);
                    this.checkForBreakpointHit(jessEvent, n);
                    this.checkForStepping(n);
                    while (this.isSuspended(n)) {
                        try {
                            this.m_states.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break;
                        }
                    }
                    break;
                }
            }
            case 0x200000: {
                this.sendRemark("Just called " + jessEvent.getObject() + " in " + n);
                Map map = this.m_states;
                synchronized (map) {
                    this.recordContext(jessEvent);
                    this.checkForExit(jessEvent);
                    if (this.isSteppingOverThis(n, jessEvent)) {
                        this.setState(n, ThreadState.SUSPENDED);
                        this.sendEvent("SUSPENDED_STEP " + n);
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForStepping(int n) {
        Map map = this.m_states;
        synchronized (map) {
            if (this.isStepping(n)) {
                this.setState(n, ThreadState.SUSPENDED);
                this.sendEvent("SUSPENDED_STEP " + n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSteppingOverThis(int n, JessEvent jessEvent) {
        Map map = this.m_states;
        synchronized (map) {
            ThreadState threadState = this.getState(n);
            if (threadState.isSteppingOver()) {
                return threadState.getStepOverTarget() == jessEvent.getObject();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadState getState(int n) {
        Map map = this.m_states;
        synchronized (map) {
            Integer n2 = new Integer(n);
            if (this.m_states.get(n2) == null) {
                this.m_states.put(n2, this.getInitialThreadState(n));
            }
            return (ThreadState)this.m_states.get(n2);
        }
    }

    private ThreadState getInitialThreadState(int n) {
        switch (n) {
            case 0: {
                return ThreadState.SUSPENDED;
            }
        }
        return ThreadState.RUNNING;
    }

    private void checkForExit(JessEvent jessEvent) {
        Funcall funcall = (Funcall)jessEvent.getObject();
        String string = funcall.getName();
        if (string.equals("exit")) {
            this.terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate() {
        Map map = this.m_states;
        synchronized (map) {
            this.setTerminated(true);
            this.setListeningForEvents(false);
            this.sendEvent(QUIT);
            Iterator iterator = this.m_states.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                this.m_states.put(k, ThreadState.RUNNING);
            }
            this.m_states.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForBreakpointHit(JessEvent jessEvent, int n) throws JessException {
        Map map = this.m_states;
        synchronized (map) {
            if (this.isSteppingOver(n)) {
                return;
            }
            Context context = jessEvent.getContext();
            LineNumberRecord lineNumberRecord = context.getLineNumberRecord();
            if (lineNumberRecord != null && this.shouldBreakAt(lineNumberRecord.getFileName(), lineNumberRecord.getLineno())) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                printWriter.print("SUSPENDED_BREAK ");
                printWriter.print(n + " ");
                printWriter.print(lineNumberRecord.getLineno() + " ");
                printWriter.print(lineNumberRecord.getFileName().length());
                printWriter.print('\n');
                printWriter.print(lineNumberRecord.getFileName());
                printWriter.flush();
                this.setState(n, ThreadState.SUSPENDED);
                this.sendEvent(stringWriter.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSteppingOver(int n) {
        Map map = this.m_states;
        synchronized (map) {
            ThreadState threadState = this.getState(n);
            return threadState.isSteppingOver();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSuspended(int n) {
        Map map = this.m_states;
        synchronized (map) {
            ThreadState threadState = this.getState(n);
            return threadState.isSuspended();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStepping(int n) {
        Map map = this.m_states;
        synchronized (map) {
            ThreadState threadState = this.getState(n);
            return threadState.isStepping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int n, ThreadState threadState) {
        Map map = this.m_states;
        synchronized (map) {
            this.sendRemark("Thread " + n + " state changed from " + this.getState(n) + " to " + threadState);
            this.m_states.put(new Integer(n), threadState);
            this.m_states.notifyAll();
        }
    }

    private void execute(String string) {
        this.sendRemark("executing command " + string);
        try {
            if (string.equals("quit")) {
                this.terminate();
            } else if (string.startsWith("join ")) {
                this.handleJoinCommand(string);
            } else if (string.startsWith("wait ")) {
                this.handleWaitCommand(string);
            } else if (string.startsWith("suspend ")) {
                this.handleSuspendCommand(string);
            } else if (string.startsWith("resume ")) {
                this.handleResumeCommand(string);
            } else if (string.startsWith("step ")) {
                this.handleStepCommand(string);
            } else if (string.startsWith("stepo ")) {
                this.handleStepOverCommand(string);
            } else if (string.startsWith("stack ")) {
                this.handleStackCommand(string);
            } else if (string.startsWith("print ")) {
                this.handlePrintCommand(string);
            } else if (string.startsWith("break ")) {
                this.handleBreakCommand(string);
            } else if (string.startsWith("unbreak ")) {
                this.handleUnbreakCommand(string);
            } else if (string.startsWith("fact ")) {
                this.handleFactCommand(string);
            } else if (string.startsWith("activation")) {
                this.handleActivationCommand(string);
            } else if (string.startsWith("agenda")) {
                this.handleAgendaCommand(string);
            }
            this.sendResponse(OK);
        }
        catch (JessException jessException) {
            this.sendResponse("ERROR: " + jessException.getMessage());
        }
    }

    private void handleWaitCommand(String string) throws JessException {
        int n = this.getThreadId(string, "handleWaitCommand");
        this.getContext(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJoinCommand(String string) throws JessException {
        int n = this.getThreadId(string, "handleJoinCommand");
        Map map = this.m_states;
        synchronized (map) {
            try {
                while (!this.isSuspended(n)) {
                    this.m_states.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStepOverCommand(String string) throws JessException {
        int n = this.getThreadId(string, "handleStepOverCommand");
        Map map = this.m_states;
        synchronized (map) {
            Context context;
            if (this.isSuspended(n) && (context = this.getContext(n)) != null) {
                Context context2 = context;
                synchronized (context2) {
                    Funcall funcall = this.getFuncall(context);
                    this.setState(n, ThreadState.makeSteppingOver(funcall));
                }
                this.sendEvent("RESUMED_STEP " + n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Funcall getFuncall(Context context) throws JessException {
        Context context2 = context;
        synchronized (context2) {
            while (context.getFuncall() == null) {
                try {
                    context.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
        }
        return context.getFuncall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContext(int n, Thread thread, Context context) {
        Map map = this.m_contexts;
        synchronized (map) {
            Integer n2 = new Integer(n);
            if (n > 0 && this.m_contexts.get(n2) == null) {
                this.sendEvent("THREAD_CREATE " + n);
            }
            this.m_contexts.put(n2, context);
            this.m_threads.put(n2, thread);
            this.m_contexts.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getContext(int n) {
        Map map = this.m_contexts;
        synchronized (map) {
            try {
                Integer n2 = new Integer(n);
                Thread thread = (Thread)this.m_threads.get(n2);
                if (thread != null && !thread.isAlive()) {
                    this.destroyThread(n);
                    return null;
                }
                while (this.m_contexts.get(n2) == null) {
                    if (thread != null) continue;
                    this.m_contexts.wait();
                }
                return (Context)this.m_contexts.get(n2);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }

    private void destroyThread(int n) {
        this.setState(n, ThreadState.DEAD);
        this.sendEvent("THREAD_DEAD " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStepCommand(String string) throws JessException {
        int n = this.getThreadId(string, "handleStepCommand");
        Context context = this.getContext(n);
        if (context != null) {
            Map map = this.m_states;
            synchronized (map) {
                if (this.isSuspended(n)) {
                    this.setState(n, ThreadState.STEPPING);
                    this.sendEvent("RESUMED_STEP " + n);
                }
            }
        }
    }

    private void handleResumeCommand(String string) throws JessException {
        int n = this.getThreadId(string, "handleResumeCommand");
        this.setState(n, ThreadState.RUNNING);
        this.sendEvent("RESUMED " + n);
    }

    private void handleSuspendCommand(String string) throws JessException {
        int n = this.getThreadId(string, "handleSuspendCommand");
        this.setState(n, ThreadState.SUSPENDED);
        this.sendEvent("SUSPENDED " + n);
    }

    private void handleAgendaCommand(String string) throws JessException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        if (stringTokenizer.countTokens() > 3) {
            throw new JessException("handleAgendaCommand", "Wrong number of arguments", stringTokenizer.countTokens());
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.countTokens() == 3 ? stringTokenizer.nextToken() : this.m_engine.getFocus();
        try {
            Object object;
            int n = Integer.parseInt(string3);
            Iterator iterator = this.m_engine.listActivations(string4);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
            int n2 = 0;
            while (n2 < n && iterator.hasNext()) {
                object = (Activation)iterator.next();
                if (((Activation)object).isInactive()) continue;
                this.printActivation((Activation)object, printWriter);
                ++n2;
            }
            object = new StringWriter();
            PrintWriter printWriter2 = new PrintWriter((Writer)object, true);
            printWriter2.print("AGENDA ");
            printWriter2.print(string4);
            printWriter2.print(" ");
            printWriter2.print(n2);
            printWriter2.print('\n');
            printWriter2.print(stringWriter.toString().trim());
            printWriter2.flush();
            this.sendEvent(((StringWriter)object).toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new JessException("handleAgendaCommand", "Bad argument", string3);
        }
    }

    private void handleActivationCommand(String string) throws JessException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        if (stringTokenizer.countTokens() != 1) {
            throw new JessException("handleActivationCommand", "Wrong number of arguments", stringTokenizer.countTokens());
        }
        Activation activation = this.m_engine.getThisActivation();
        if (activation == null) {
            this.sendEvent("ACTIVATION NONE");
        } else {
            StringWriter stringWriter = new StringWriter();
            this.printActivation(activation, new PrintWriter(stringWriter));
            this.sendEvent("ACTIVATION " + ((Object)stringWriter).toString().trim());
        }
    }

    private void printActivation(Activation activation, PrintWriter printWriter) throws JessException {
        printWriter.print(activation.getRule().getName());
        Token token = activation.getToken();
        int n = token.size();
        for (int i = 0; i < n; ++i) {
            printWriter.print(" ");
            printWriter.print(new FactIDValue(token.fact(i)));
        }
        printWriter.print('\n');
    }

    private void handleFactCommand(String string) throws JessException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        if (stringTokenizer.countTokens() != 2) {
            throw new JessException("handleFactCommand", "Wrong number of arguments", stringTokenizer.countTokens());
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        try {
            int n = Integer.parseInt(string3);
            Fact fact = this.m_engine.findFactByID(n);
            if (fact == null) {
                this.sendEvent("FACT " + n + " (retracted) " + 0 + '\n');
                return;
            }
            Deftemplate deftemplate = fact.getDeftemplate();
            int n2 = deftemplate.getNSlots();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.print("FACT " + n + " " + fact.getName() + " " + n2);
            printWriter.print('\n');
            for (int i = 0; i < n2; ++i) {
                String string4 = fact.get(i).toString();
                String string5 = deftemplate.getSlotName(i);
                printWriter.print(string5 + ' ' + String.valueOf(string4.length()));
                printWriter.print('\n');
                printWriter.write(string4);
                printWriter.flush();
            }
            this.sendEvent(stringWriter.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new JessException("handleFactCommand", "Bad argument", string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.sendEvent(STARTED);
        try {
            while (this.isListeningForEvents()) {
                try {
                    String string = this.readCommand();
                    if (string == null) {
                        this.terminate();
                        break;
                    }
                    this.execute(string);
                    Thread.yield();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    break;
                }
            }
        }
        finally {
            this.m_thread = null;
        }
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = new Thread(this);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }
    }

    public void join() throws InterruptedException {
        if (this.m_thread != null) {
            this.m_thread.join();
        }
    }

    void handleBreakCommand(String string) throws JessException {
        BreakCommandData breakCommandData = this.parseBreakCommand(string);
        this.addBreakpoint(breakCommandData.file, breakCommandData.line);
    }

    private BreakCommandData parseBreakCommand(String string) throws JessException {
        String string2 = null;
        try {
            String string3 = string.substring(string.indexOf(32) + 1);
            string2 = string3.substring(0, string3.indexOf(32));
            String string4 = string3.substring(string3.indexOf(32) + 1);
            int n = Integer.parseInt(string2);
            return new BreakCommandData(string4, n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JessException("parseBreakCommand", "Invalid line number", string2);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new JessException("parseBreakCommand", "Wrong number of arguments", string);
        }
    }

    private void handleUnbreakCommand(String string) throws JessException {
        BreakCommandData breakCommandData = this.parseBreakCommand(string);
        this.removeBreakpoint(breakCommandData.file, breakCommandData.line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePrintCommand(String string) throws JessException {
        Object object;
        Object object2;
        PrintableData printableData = this.parsePrintCommand(string);
        if (!this.isSuspended(printableData.thread)) {
            return;
        }
        String string2 = ERROR;
        int n = printableData.level;
        Context context = this.getContext(printableData.thread);
        if (context != null) {
            context = this.findRequestedStackFrame(context, n);
            object2 = context.getEngine();
            object = this;
            synchronized (object) {
                try {
                    this.setListeningForEvents(false);
                    string2 = ((Rete)object2).eval(printableData.expr, context).toStringWithParens();
                }
                finally {
                    this.setListeningForEvents(true);
                }
            }
        }
        object2 = new StringWriter();
        object = new PrintWriter((Writer)object2);
        ((PrintWriter)object).print("PRINT " + printableData.thread + " ");
        ((PrintWriter)object).print(printableData.level + " " + printableData.expr + " " + string2.length());
        ((PrintWriter)object).print('\n');
        ((PrintWriter)object).print(string2);
        ((PrintWriter)object).flush();
        this.sendEvent(((StringWriter)object2).toString());
    }

    private Context findRequestedStackFrame(Context context, int n) throws JessException {
        do {
            if (context == null) continue;
            int n2 = context.getStackData().size();
            if (n2 == 0) {
                return context;
            }
            if (n < n2) {
                return context;
            }
            n -= n2;
            context = context.getParent();
        } while (n > 0 && context != null);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrintableData parsePrintCommand(String string) throws JessException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        if (stringTokenizer.countTokens() != 4) {
            throw new JessException("parsePrintData", "Wrong number of arguments", stringTokenizer.countTokens());
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        try {
            int n;
            int n2;
            int n3;
            try {
                n3 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JessException("parsePrintData", "Thread id not an integer", string4);
            }
            try {
                n2 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JessException("parsePrintData", "Stack level not an integer", string4);
            }
            String string5 = stringTokenizer.nextToken();
            try {
                n = Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JessException("parsePrintData", "Char count not an integer", string5);
            }
            char[] cArray = new char[n];
            BufferedReader bufferedReader = this.m_cmdSource;
            synchronized (bufferedReader) {
                this.m_cmdSource.read(cArray);
            }
            return new PrintableData(n3, n2, new String(cArray));
        }
        catch (IOException iOException) {
            throw new JessException("parsePrintCommand", "I/O Error", iOException);
        }
    }

    private void handleStackCommand(String string) throws JessException {
        Object object;
        int n = this.getThreadId(string, "handleStackCommand");
        if (!this.isSuspended(n)) {
            return;
        }
        String string2 = "STACK " + n + " ";
        StringBuffer stringBuffer = new StringBuffer();
        for (Context context = this.getContext(n); context != null; context = context.getParent()) {
            object = context.getStackData();
            for (int i = ((Vector)object).size() - 1; i > -1; --i) {
                Object object2;
                String string3 = "<unknown>";
                String string4 = "<unknown>";
                int n2 = 0;
                StackFrame stackFrame = (StackFrame)((Vector)object).get(i);
                Funcall funcall = stackFrame.getFuncall();
                LineNumberRecord lineNumberRecord = stackFrame.getLineNumberRecord();
                if (lineNumberRecord != null) {
                    string3 = lineNumberRecord.getFileName();
                    n2 = lineNumberRecord.getLineno();
                    string4 = funcall.getName();
                }
                stringBuffer.append(string4).append(",").append(string3).append(",").append(n2);
                HashSet<String> hashSet = new HashSet<String>();
                Object object3 = context.getVariableNames();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    if (((String)object2).startsWith("%")) continue;
                    hashSet.add((String)object2);
                }
                DebugListener.addBindingValues(context, hashSet);
                DebugListener.addDefglobals(context, hashSet);
                object3 = new ArrayList(hashSet);
                Collections.sort(object3);
                object2 = ((ArrayList)object3).iterator();
                while (object2.hasNext()) {
                    stringBuffer.append(',');
                    stringBuffer.append(object2.next());
                }
                stringBuffer.append("|");
            }
        }
        object = stringBuffer.toString().trim();
        if (((String)object).length() == 0) {
            object = "<unknown>,<unknown>,0";
        }
        String string5 = string2 + ((String)object).length() + "\n" + (String)object;
        this.sendEvent(string5);
    }

    private int getThreadId(String string, String string2) throws JessException {
        int n;
        String[] stringArray = string.split(" ");
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JessException(string2, "Thread id not an integer", stringArray[1]);
        }
        return n;
    }

    static void addDefglobals(Context context, Set set) {
        Rete rete = context.getEngine();
        Iterator iterator = rete.listDefglobals();
        while (iterator.hasNext()) {
            Defglobal defglobal = (Defglobal)iterator.next();
            set.add(defglobal.getName());
        }
    }

    static void addBindingValues(Context context, Set set) throws JessException {
        Funcall funcall = context.getFuncall();
        if (funcall != null) {
            for (int i = 1; i < funcall.size(); ++i) {
                Value value = funcall.get(i);
                if (!(value instanceof BindingValue)) continue;
                BindingValue bindingValue = (BindingValue)value;
                set.add(bindingValue.getName());
            }
        }
    }

    void setCmdSource(Reader reader) {
        this.m_cmdSource = new BufferedReader(reader);
    }

    void setCmdSink(Writer writer) {
        this.m_cmdSink = new PrintWriter(writer, true);
    }

    void setEventSink(Writer writer) {
        this.m_eventSink = new PrintWriter(writer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendEvent(String string) {
        PrintWriter printWriter = this.m_eventSink;
        synchronized (printWriter) {
            this.m_eventSink.print(string.length() + 1);
            this.m_eventSink.print('\n');
            this.m_eventSink.print(string);
            this.m_eventSink.print('\n');
            this.m_eventSink.flush();
            this.setChanged();
            this.notifyObservers(string);
        }
    }

    private void sendRemark(String string) {
    }

    void sendResponse(String string) {
        this.m_cmdSink.print(string);
        this.m_cmdSink.print('\n');
        this.m_cmdSink.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readCommand() throws IOException {
        BufferedReader bufferedReader = this.m_cmdSource;
        synchronized (bufferedReader) {
            if (this.m_pushBack != null) {
                String string = this.m_pushBack;
                this.m_pushBack = null;
                return string;
            }
            return this.m_cmdSource.readLine();
        }
    }

    public boolean waitForConnections(int n, int n2) {
        boolean bl;
        CommandSocketConnector commandSocketConnector = new CommandSocketConnector(this, n);
        EventSocketConnector eventSocketConnector = new EventSocketConnector(this, n2);
        try {
            commandSocketConnector.start();
            eventSocketConnector.start();
            commandSocketConnector.join();
            eventSocketConnector.join();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        boolean bl2 = bl = this.m_cmdSink != null && this.m_cmdSource != null && this.m_eventSink != null;
        if (bl) {
            this.start();
        }
        return bl;
    }

    public void addBreakpoint(String string, int n) {
        File file = new File(string);
        String string2 = file.getName();
        HashSet<Integer> hashSet = (HashSet<Integer>)this.m_breakpoints.get(string2);
        if (hashSet == null) {
            hashSet = new HashSet<Integer>();
            this.m_breakpoints.put(string2, hashSet);
        }
        hashSet.add(new Integer(n));
    }

    public void removeBreakpoint(String string, int n) {
        File file = new File(string);
        String string2 = file.getName();
        Set set = (Set)this.m_breakpoints.get(string2);
        if (set == null) {
            return;
        }
        set.remove(new Integer(n));
    }

    public boolean shouldBreakAt(String string, int n) {
        if (string == null) {
            return false;
        }
        File file = new File(string);
        String string2 = file.getName();
        Set set = (Set)this.m_breakpoints.get(string2);
        if (set == null) {
            return false;
        }
        Integer n2 = new Integer(n);
        return set.contains(n2);
    }

    public synchronized boolean isTerminated() {
        return this.m_terminated;
    }

    synchronized void setTerminated(boolean bl) {
        this.m_terminated = bl;
    }

    synchronized boolean isListeningForEvents() {
        return this.m_listeningForEvents;
    }

    synchronized void setListeningForEvents(boolean bl) {
        this.m_listeningForEvents = bl;
    }

    static class PrintableData {
        String expr;
        int thread;
        int level;

        PrintableData(int n, int n2, String string) {
            this.thread = n;
            this.level = n2;
            this.expr = string;
        }
    }

    static class BreakCommandData {
        int line;
        String file;

        BreakCommandData(String string, int n) {
            this.file = string;
            this.line = n;
        }
    }
}

