/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import jess.Context;
import jess.Fact;
import jess.FactIDValue;
import jess.Funcall;
import jess.FuncallValue;
import jess.HashCodeComputer;
import jess.JessException;
import jess.LongValue;
import jess.RU;
import jess.ReaderTokenizer;
import jess.Userfunction;
import jess.ValueVector;
import jess.Variable;

public class Value
implements Serializable {
    private static final int STRING_TYPES = 57355;
    private static final int NUM_TYPES = 65572;
    private int m_type;
    private int m_intval;
    private double m_floatval;
    private Object m_objectval;

    public Value(int n, int n2) throws JessException {
        this.m_type = n2;
        switch (this.m_type) {
            case 0: 
            case 4: {
                this.m_intval = n;
                break;
            }
            default: {
                throw this.typeError("Value", "an integral type", n2);
            }
        }
    }

    Value(int n) {
        this.m_type = 4;
        this.m_intval = n;
    }

    public Value(Value value) {
        this.m_type = value.m_type;
        this.m_intval = value.m_intval;
        this.m_floatval = value.m_floatval;
        this.m_objectval = value.m_objectval;
    }

    public Value(String string, int n) throws JessException {
        if (!(this instanceof Variable || n != 8 && n != 8192)) {
            throw new JessException("Value.Value", "Cannot use jess.Value to represent variable " + string + ".", "You must use class jess.Variable");
        }
        if ((n & 0xE00B) == 0) {
            throw this.typeError("Value", "a string type", n);
        }
        this.m_type = n;
        this.m_objectval = string;
    }

    public Value(ValueVector valueVector, int n) throws JessException {
        if (valueVector instanceof Fact && n == 16) {
            throw new JessException("Value.Value", "Cannot use jess.Value to represent fact-ids.", "You must use class jess.FactIDValue");
        }
        if (!(this instanceof FuncallValue) && n == 64) {
            throw new JessException("Value.Value", "Cannot use jess.Value to represent the function call " + valueVector.toStringWithParens(), "You must use class jess.FuncallValue");
        }
        if (n != 64 && n != 512) {
            throw this.typeError("Value", "a vector type", n);
        }
        this.m_type = n;
        this.m_objectval = valueVector;
    }

    public Value(double d, int n) throws JessException {
        if (n == 65536 && !(this instanceof LongValue)) {
            throw this.typeError("Value", "You must use class jess.LongValue", n);
        }
        if ((n & 0x10024) == 0) {
            throw this.typeError("Value", "a float type", n);
        }
        this.m_type = n;
        if (n == 32 || n == 65536) {
            this.m_floatval = d;
        } else {
            this.m_intval = (int)d;
        }
    }

    public Value(boolean bl) {
        this.m_type = 1;
        this.m_objectval = bl ? Funcall.TRUE.m_objectval : Funcall.FALSE.m_objectval;
    }

    public Value(Object object) {
        if (object != null) {
            this.m_type = 2048;
            this.m_objectval = object;
        } else {
            this.m_type = Funcall.NIL.m_type;
            this.m_objectval = Funcall.NIL.m_objectval;
        }
    }

    Value(Userfunction userfunction) {
        this.m_type = 131072;
        this.m_objectval = userfunction;
    }

    Value(Fact fact) throws JessException {
        if (!(this instanceof FactIDValue)) {
            throw new JessException("Value.Value", "Cannot use jess.Value to represent fact-ids.", "You must use class jess.FactIDValue");
        }
        if (fact == null) {
            fact = Fact.getNullFact();
        } else {
            while (fact.getIcon() != fact) {
                fact = fact.getIcon();
            }
        }
        this.m_type = 16;
        this.m_objectval = fact;
        this.m_intval = fact.getFactId();
    }

    Value() {
        this.m_type = 4096;
    }

    public Object externalAddressValue(Context context) throws JessException {
        return this.javaObjectValue(context);
    }

    public Object javaObjectValue(Context context) throws JessException {
        switch (this.m_type) {
            case 1: 
            case 2: 
            case 16: 
            case 2048: 
            case 131072: {
                return this.m_objectval;
            }
        }
        throw this.typeError("javaObjectValue", "a Java object");
    }

    public Funcall funcallValue(Context context) throws JessException {
        if (this.m_type == 64) {
            return (Funcall)this.m_objectval;
        }
        throw this.typeError("funcallValue", "a function call");
    }

    public Fact factValue(Context context) throws JessException {
        if (this.m_type == 16 || this.m_type == 2048 && this.m_objectval instanceof Fact) {
            return (Fact)this.m_objectval;
        }
        throw this.typeError("factValue", "a fact");
    }

    public ValueVector listValue(Context context) throws JessException {
        if (this.m_type == 512) {
            return (ValueVector)this.m_objectval;
        }
        throw this.typeError("listValue", "a list");
    }

    public double numericValue(Context context) throws JessException {
        Value value = this.resolveValue(context);
        switch (value.m_type) {
            case 32: {
                return value.m_floatval;
            }
            case 4: 
            case 16: {
                return value.m_intval;
            }
            case 1: 
            case 2: {
                try {
                    return Double.parseDouble((String)this.m_objectval);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        throw this.typeError("numericValue", "a number");
    }

    public int intValue(Context context) throws JessException {
        switch (this.m_type) {
            case 32: {
                return (int)this.m_floatval;
            }
            case 4: {
                return this.m_intval;
            }
            case 1: 
            case 2: {
                try {
                    return Integer.parseInt((String)this.m_objectval);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        throw this.typeError("intValue", "an integer");
    }

    public long longValue(Context context) throws JessException {
        return (long)this.numericValue(context);
    }

    public double floatValue(Context context) throws JessException {
        return this.numericValue(context);
    }

    public final String atomValue(Context context) throws JessException {
        return this.symbolValue(context);
    }

    public String symbolValue(Context context) throws JessException {
        return this.stringValue(context);
    }

    public String variableValue(Context context) throws JessException {
        if (this.m_type != 8 && this.m_type != 8192) {
            throw this.typeError("variableValue", "a variable");
        }
        return this.stringValue(context);
    }

    public String stringValue(Context context) throws JessException {
        switch (this.m_type) {
            case 1: 
            case 2: 
            case 8: 
            case 4096: 
            case 8192: 
            case 16384: 
            case 32768: {
                return (String)this.m_objectval;
            }
            case 4: {
                return String.valueOf(this.m_intval);
            }
            case 32: {
                return String.valueOf(this.m_floatval);
            }
            case 2048: {
                return this.m_objectval.toString();
            }
        }
        throw this.typeError("stringValue", "a string");
    }

    public Userfunction functionValue(Context context) throws JessException {
        Userfunction userfunction;
        Value value = this.resolveValue(context);
        if (value.isLexeme(context)) {
            String string = value.symbolValue(context);
            userfunction = context.getEngine().findUserfunction(string);
            if (userfunction == null) {
                throw new JessException("functionValue", "No such function", string);
            }
        } else if (value.m_type == 131072) {
            userfunction = (Userfunction)value.m_objectval;
        } else {
            throw value.typeError("functionValue", "a function");
        }
        return userfunction;
    }

    private JessException typeError(String string, String string2) {
        return this.typeError(string, string2, this.m_type);
    }

    private JessException typeError(String string, String string2, int n) {
        return Value.typeError(this, "Value." + string, string2, n);
    }

    static JessException typeError(Value value, String string, String string2, int n) {
        return new JessException(string, "'" + value.toString() + "' is " + Value.getTypeName(n) + ", not ", string2);
    }

    private static String getTypeName(int n) {
        switch (n) {
            case 1: {
                return "a symbol";
            }
            case 2: {
                return "a string";
            }
            case 4: {
                return "an integer";
            }
            case 32: {
                return "a float";
            }
            case 512: {
                return "a list";
            }
            case 64: {
                return "a function call";
            }
            case 16: {
                return "a fact";
            }
            case 65536: {
                return "a long";
            }
        }
        return RU.getTypeName(n);
    }

    private static String escape(String string) {
        if (string.indexOf(34) == -1 && string.indexOf(92) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"' || c == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        switch (this.m_type) {
            case 4: {
                return String.valueOf(this.m_intval);
            }
            case 32: {
                return String.valueOf(this.m_floatval);
            }
            case 2: {
                return "\"" + Value.escape((String)this.m_objectval) + "\"";
            }
            case 1: 
            case 16384: 
            case 32768: {
                return (String)this.m_objectval;
            }
            case 8: {
                return "?" + this.m_objectval;
            }
            case 8192: {
                return "$?" + this.m_objectval;
            }
            case 16: {
                return "<Fact-" + this.m_intval + ">";
            }
            case 64: 
            case 512: {
                return this.m_objectval.toString();
            }
            case 2048: {
                return "<Java-Object:" + this.m_objectval.getClass().getName() + ">";
            }
            case 0: {
                return Funcall.NIL.toString();
            }
        }
        return "<UNKNOWN>";
    }

    public String toStringWithParens() {
        switch (this.m_type) {
            case 64: 
            case 512: {
                return ((ValueVector)this.m_objectval).toStringWithParens();
            }
        }
        return this.toString();
    }

    public int type() {
        return this.m_type;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Value) {
            return this.equals((Value)object);
        }
        if (object != null) {
            return object.equals(this.m_objectval);
        }
        return false;
    }

    public boolean equals(Value value) {
        if (this == value) {
            return true;
        }
        if (value.m_type != this.m_type) {
            return false;
        }
        switch (this.m_type) {
            case 4: 
            case 16: {
                return this.m_intval == value.m_intval;
            }
            case 32: {
                return this.m_floatval == value.m_floatval;
            }
        }
        return this.m_objectval.equals(value.m_objectval);
    }

    public boolean equalsStar(Value value) {
        if (this == value) {
            return true;
        }
        try {
            if ((this.m_type & 0x10024) != 0 && (value.m_type & 0x10024) != 0) {
                return this.numericValue(null) == value.numericValue(null);
            }
            return this.equals(value);
        }
        catch (JessException jessException) {
            return false;
        }
    }

    public int hashCode() {
        switch (this.m_type) {
            case 0: {
                return 0;
            }
            case 4: 
            case 16: {
                return this.m_intval;
            }
            case 32: {
                return (int)this.m_floatval;
            }
            case 64: 
            case 512: {
                this.m_objectval.hashCode();
            }
            case 1: 
            case 2: {
                return this.m_objectval != null ? this.m_objectval.hashCode() : 0;
            }
            case 2048: {
                return HashCodeComputer.hashCode(this.m_objectval);
            }
        }
        return 0;
    }

    public Value resolveValue(Context context) throws JessException {
        return this;
    }

    public boolean isNumeric(Context context) throws JessException {
        Value value = this.resolveValue(context);
        switch (value.m_type) {
            case 4: 
            case 16: 
            case 32: 
            case 65536: {
                return true;
            }
            case 1: 
            case 2: {
                String string = value.stringValue(context);
                if (ReaderTokenizer.isAnInteger(string) || ReaderTokenizer.isALong(string)) {
                    return true;
                }
                if (!ReaderTokenizer.couldBeADouble(string)) break;
                try {
                    Double.parseDouble(string);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public boolean isLexeme(Context context) throws JessException {
        Value value = this.resolveValue(context);
        switch (value.m_type) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }
}

