/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import jess.ArrayTokenList;
import jess.Deftemplate;
import jess.Fact;
import jess.JessException;
import jess.MutableTokenList;
import jess.Token;
import jess.TokenList;
import jess.Value;

class TokenTree
implements Serializable {
    private int m_hash;
    private MutableTokenList[] m_tokens;
    private boolean m_useSortcode;
    private int m_fact;
    private int m_slot;
    private int m_subSlot;
    private int m_size;
    private static final double THRESHOLD = 1.0;

    TokenTree(int n, boolean bl, int n2, int n3, int n4) {
        this.m_hash = n;
        this.m_useSortcode = bl;
        this.m_slot = n3;
        this.m_subSlot = n4;
        this.m_fact = n2;
        this.m_tokens = new MutableTokenList[this.m_hash];
    }

    int loadFactor() {
        return this.m_size / this.m_hash;
    }

    final void clear() {
        for (int i = 0; i < this.m_hash; ++i) {
            if (this.m_tokens[i] == null) continue;
            this.m_tokens[i].clear();
        }
        this.m_size = 0;
    }

    synchronized boolean add(Token token, boolean bl) throws JessException {
        boolean bl2 = this.doAdd(token, bl);
        if ((double)this.loadFactor() > 1.0) {
            this.rehash();
        }
        return bl2;
    }

    synchronized Token remove(Token token) throws JessException {
        int n = this.codeForToken(token);
        MutableTokenList mutableTokenList = this.findCodeInTree(n, false);
        if (mutableTokenList == null) {
            return null;
        }
        int n2 = mutableTokenList.size();
        for (int i = 0; i < n2; ++i) {
            Token token2 = mutableTokenList.get(i);
            if (!token.fastDataEquals(token2) || !token.dataEquals(token2)) continue;
            mutableTokenList.remove(i);
            --this.m_size;
            return token2;
        }
        return null;
    }

    synchronized TokenList findListForToken(Token token, boolean bl) throws JessException {
        int n = this.codeForToken(token);
        return this.findCodeInTree(n, bl);
    }

    TokenList getTestableTokens(Value value) throws JessException {
        int n = value.hashCode();
        n = this.conditionHash(n);
        return this.findCodeInTree(n, false);
    }

    Value extractKey(Token token) throws JessException {
        Value value = this.m_subSlot == -1 ? token.fact(this.m_fact).get(this.m_slot) : token.fact(this.m_fact).get(this.m_slot).listValue(null).get(this.m_subSlot);
        return value;
    }

    private Token subsetToken(Token token) {
        Token token2 = token;
        while (token2.size() > this.m_fact) {
            token2 = token2.getParent();
        }
        return token2;
    }

    private void rehash() throws JessException {
        MutableTokenList[] mutableTokenListArray = this.m_tokens;
        this.m_hash = (int)((double)this.m_hash * 1.7 + 1.0);
        this.m_tokens = new MutableTokenList[this.m_hash];
        this.m_size = 0;
        for (int i = 0; i < mutableTokenListArray.length; ++i) {
            MutableTokenList mutableTokenList = mutableTokenListArray[i];
            if (mutableTokenList == null) continue;
            int n = mutableTokenList.size();
            for (int j = 0; j < n; ++j) {
                this.doAdd(mutableTokenList.get(j), false);
            }
        }
    }

    private synchronized MutableTokenList findCodeInTree(int n, boolean bl) {
        if (bl && this.m_tokens[n] == null) {
            this.m_tokens[n] = new ArrayTokenList();
            return this.m_tokens[n];
        }
        return this.m_tokens[n];
    }

    private int conditionHash(int n) {
        if ((n += n >> 9) < 0) {
            n = -n;
        }
        return n %= this.m_hash;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_hash; ++i) {
            if (this.m_tokens[i] == null) continue;
            stringBuffer.append(i);
            stringBuffer.append(": ");
            stringBuffer.append(this.m_tokens[i]);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    void dumpMemory(StringBuffer stringBuffer) {
        for (int i = 0; i < this.m_hash; ++i) {
            MutableTokenList mutableTokenList = this.m_tokens[i];
            if (mutableTokenList == null) continue;
            for (int j = 0; j < mutableTokenList.size(); ++j) {
                stringBuffer.append(mutableTokenList.get(j));
                stringBuffer.append("\n");
            }
        }
    }

    int getHash() {
        return this.m_hash;
    }

    TokenList getTokenList(int n) {
        return this.m_tokens[n];
    }

    String getIndexingInfo() throws JessException {
        String string;
        if (this.m_useSortcode) {
            return "token sort code.";
        }
        Token token = this.findAnyToken();
        if (token == null) {
            string = "slot " + this.m_slot + " of fact " + this.m_fact + " in each token.";
        } else {
            Fact fact = token.fact(this.m_fact);
            Deftemplate deftemplate = fact.getDeftemplate();
            string = "the \"" + deftemplate.getSlotName(this.m_slot) + "\" slot of a \"" + deftemplate.getName() + "\" fact.";
        }
        if (this.m_subSlot != -1) {
            string = "subslot " + this.m_subSlot + " of " + string;
        }
        return string;
    }

    private synchronized boolean doAdd(Token token, boolean bl) throws JessException {
        int n = this.codeForToken(token);
        MutableTokenList mutableTokenList = this.findCodeInTree(n, true);
        if (bl) {
            int n2 = mutableTokenList.size();
            for (int i = 0; i < n2; ++i) {
                Token token2 = mutableTokenList.get(i);
                if (!token.dataEquals(token2)) continue;
                return false;
            }
        }
        mutableTokenList.add(token);
        ++this.m_size;
        return true;
    }

    private Token findAnyToken() {
        for (int i = 0; i < this.m_hash; ++i) {
            MutableTokenList mutableTokenList = this.m_tokens[i];
            if (mutableTokenList == null || mutableTokenList.size() <= 0) continue;
            return mutableTokenList.get(0);
        }
        return null;
    }

    private int codeForToken(Token token) throws JessException {
        int n = this.m_useSortcode ? (this.m_fact == 0 ? token.m_sortcode : this.subsetToken((Token)token).m_sortcode) : (this.m_slot == -1 ? token.fact(this.m_fact).getFactId() : (this.m_subSlot == -1 ? token.fact((int)this.m_fact).m_v[this.m_slot].hashCode() : token.fact((int)this.m_fact).m_v[this.m_slot].listValue(null).m_v[this.m_subSlot].hashCode()));
        return this.conditionHash(n);
    }

    static class Spy {
        boolean m_useSortcode;
        int m_fact;
        int m_slot;
        int m_subSlot;
        int m_size;

        Spy(TokenTree tokenTree) {
            this.m_useSortcode = tokenTree.m_useSortcode;
            this.m_fact = tokenTree.m_fact;
            this.m_slot = tokenTree.m_slot;
            this.m_subSlot = tokenTree.m_subSlot;
            this.m_size = tokenTree.m_size;
        }
    }
}

