/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jess.JessException;
import jess.RU;
import jess.Rete;
import jess.Value;
import jess.ValueVector;

class SerializableMD
implements Serializable {
    private String m_class;
    private String m_name;
    private transient List m_methods;

    SerializableMD(List list) {
        Method method = (Method)list.get(0);
        this.m_class = method.getDeclaringClass().getName();
        this.m_name = method.getName();
        this.m_methods = list;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Method method2 = (Method)iterator.next();
            method2.setAccessible(true);
        }
    }

    private void reload(Rete rete) throws JessException {
        try {
            this.m_methods = new ArrayList();
            Class clazz = rete.findClass(this.m_class);
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (!method.getName().equals(this.m_name) || !Modifier.isStatic(method.getModifiers())) continue;
                this.m_methods.add(method);
                method.setAccessible(true);
                return;
            }
        }
        catch (Exception exception) {
            throw new JessException("SerializableMD.reload", "Can't recreate method", exception);
        }
    }

    public String getName() {
        return this.m_name;
    }

    public Value invoke(List list, Rete rete) throws JessException {
        try {
            Object object = this.m_methods.iterator();
            while (object.hasNext()) {
                Method method = (Method)object.next();
                Class<?>[] classArray = method.getParameterTypes();
                if (list.size() != classArray.length) continue;
                Object[] objectArray = list.toArray(new Object[list.size()]);
                for (int i = 0; i < objectArray.length; ++i) {
                    Value value = (Value)objectArray[i];
                    objectArray[i] = RU.valueToObject(classArray[i], value, rete.getGlobalContext());
                }
                Object object2 = method.invoke(null, objectArray);
                return RU.objectToValue(method.getReturnType(), object2);
            }
            object = new ValueVector();
            ((ValueVector)object).addAll(list);
            throw new JessException(this.m_name, "No overloading I can call with these arguments", ((ValueVector)object).toStringWithParens());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JessException(this.m_name, "Access exception", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new JessException(this.m_name, "Called method threw an exception", invocationTargetException.getCause());
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof SerializableMD)) {
            return false;
        }
        SerializableMD serializableMD = (SerializableMD)object;
        return this.m_class.equals(serializableMD.m_class) && this.m_name.equals(serializableMD.m_name);
    }
}

