/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import jess.ReaderTokenizer;
import jess.Tokenizer;

class Routers {
    private Map m_outRouters = new HashMap(13);
    private Map m_inRouters = new HashMap(13);
    private Map m_inWrappers = new HashMap(13);
    private Map m_inModes = new HashMap(13);

    Routers() {
        this.addInputRouter("t", new InputStreamReader(System.in), true);
        this.addOutputRouter("t", new PrintWriter(System.out, false));
        this.addInputRouter("WSTDIN", this.getInputRouter("t"), true);
        this.addOutputRouter("WSTDOUT", this.getOutputRouter("t"));
        this.addOutputRouter("WSTDERR", this.getOutputRouter("t"));
    }

    synchronized void addInputRouter(String string, Reader reader, boolean bl) {
        Tokenizer tokenizer = (Tokenizer)this.m_inWrappers.get(reader);
        if (tokenizer == null) {
            tokenizer = new ReaderTokenizer(reader, false);
        }
        this.m_inRouters.put(string, reader);
        this.m_inWrappers.put(reader, tokenizer);
        this.m_inModes.put(string, bl);
    }

    synchronized void removeInputRouter(String string) {
        this.m_inRouters.remove(string);
    }

    synchronized Reader getInputRouter(String string) {
        return (Reader)this.m_inRouters.get(string);
    }

    synchronized Tokenizer getInputWrapper(Reader reader) {
        return (Tokenizer)this.m_inWrappers.get(reader);
    }

    synchronized boolean getInputMode(String string) {
        return (Boolean)this.m_inModes.get(string);
    }

    synchronized void addOutputRouter(String string, Writer writer) {
        this.m_outRouters.put(string, writer);
    }

    synchronized void removeOutputRouter(String string) {
        this.m_outRouters.remove(string);
    }

    synchronized Writer getOutputRouter(String string) {
        return (Writer)this.m_outRouters.get(string);
    }

    synchronized PrintWriter getErrStream() {
        return this.getOutputRouterAsPrintWriter("WSTDERR");
    }

    synchronized PrintWriter getOutStream() {
        return this.getOutputRouterAsPrintWriter("WSTDOUT");
    }

    synchronized PrintWriter getOutputRouterAsPrintWriter(String string) {
        PrintWriter printWriter;
        Writer writer = this.getOutputRouter(string);
        if (writer == null) {
            printWriter = null;
        } else if (writer instanceof PrintWriter) {
            printWriter = (PrintWriter)writer;
        } else {
            printWriter = new PrintWriter(writer);
            this.addOutputRouter(string, printWriter);
        }
        return printWriter;
    }
}

