/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jess.Activation;
import jess.Agenda;
import jess.Batch;
import jess.ClassResearcher;
import jess.ClassSource;
import jess.Context;
import jess.Deffacts;
import jess.Deffunction;
import jess.Defglobal;
import jess.Definstance;
import jess.DefinstanceList;
import jess.Defmodule;
import jess.Defquery;
import jess.Defrule;
import jess.Deftemplate;
import jess.Duplicate;
import jess.Fact;
import jess.FactList;
import jess.Filter;
import jess.Funcall;
import jess.FunctionHolder;
import jess.HasLHS;
import jess.IntMarkerImpl;
import jess.Jesp;
import jess.JessEvent;
import jess.JessEventSupport;
import jess.JessException;
import jess.JessListener;
import jess.QueryResult;
import jess.ReflectionClassResearcher;
import jess.ReteCompiler;
import jess.Routers;
import jess.RuleCompilerException;
import jess.Strategy;
import jess.Token;
import jess.Tokenizer;
import jess.Userfunction;
import jess.Userpackage;
import jess.Value;
import jess.ValueVector;
import jess.WorkingMemoryMarker;
import jess.awt.TextReader;
import jess.factory.Factory;
import jess.factory.FactoryImpl;
import jess.server.LineNumberRecord;

public class Rete
implements Serializable,
JessListener {
    private Context m_globalContext = new Context(this);
    private transient Routers m_routers = new Routers();
    private transient TextReader m_tis = new TextReader(true);
    private transient Jesp m_jesp = this.initInternalParser();
    private transient JessEventSupport m_jes = new JessEventSupport(this);
    private boolean m_resetGlobals = true;
    private List m_deffacts = Collections.synchronizedList(new ArrayList());
    private List m_defglobals = Collections.synchronizedList(new ArrayList());
    private Map m_functions = Collections.synchronizedMap(new HashMap(101));
    private FactList m_factList = new FactList();
    private DefinstanceList m_definstanceList = new DefinstanceList(this);
    private Map m_rules = Collections.synchronizedMap(new TreeMap());
    private ReteCompiler m_compiler = new ReteCompiler();
    private Map m_storage = Collections.synchronizedMap(new HashMap());
    private static Factory s_factory = new FactoryImpl();
    private Agenda m_agenda = new Agenda(this);
    private boolean[] m_watchInfo = new boolean[5];
    private static final String LIBRARY_NAME = "scriptlib.clp";
    private ClassSource m_classSource;
    public static Map s_lineNumberTable;
    private boolean m_passiveMode;
    private String m_watchRouter = "WSTDOUT";
    private HashSet m_features = new HashSet();
    private transient ClassResearcher m_classResearcher = new ReflectionClassResearcher(this);
    public static final int INSTALL = 0;
    public static final int ACTIVATE = 1;
    public static final int EVERY_TIME = 2;

    public Rete() {
        this(null);
    }

    public Rete(Applet applet) {
        this((Object)applet);
    }

    public Rete(Object object) {
        try {
            this.m_classSource = new ClassSource(object, this);
            Deftemplate.addStandardTemplates(this);
        }
        catch (JessException jessException) {
            throw new RuntimeException(jessException);
        }
        this.setEventMask(0);
        this.loadScriptlib();
    }

    public void addInputRouter(String string, Reader reader, boolean bl) {
        this.m_routers.addInputRouter(string, reader, bl);
    }

    public void removeInputRouter(String string) {
        this.m_routers.removeInputRouter(string);
    }

    public Reader getInputRouter(String string) {
        return this.m_routers.getInputRouter(string);
    }

    Tokenizer getInputWrapper(Reader reader) {
        return this.m_routers.getInputWrapper(reader);
    }

    public void addOutputRouter(String string, Writer writer) {
        this.m_routers.addOutputRouter(string, writer);
    }

    public void removeOutputRouter(String string) {
        this.m_routers.removeOutputRouter(string);
    }

    public boolean getInputMode(String string) {
        return this.m_routers.getInputMode(string);
    }

    public Writer getOutputRouter(String string) {
        return this.m_routers.getOutputRouter(string);
    }

    public PrintWriter getErrStream() {
        return this.m_routers.getErrStream();
    }

    public PrintWriter getOutStream() {
        return this.m_routers.getOutStream();
    }

    protected int doPreAssertionProcessing(Fact fact) throws JessException {
        return this.m_factList.doPreAssertionProcessing(fact);
    }

    public synchronized void clear() throws JessException {
        this.clearStorage();
        this.m_globalContext.clear();
        this.m_factList.clear(this);
        this.m_rules.clear();
        this.m_agenda.clear(this);
        this.m_definstanceList.clear();
        this.m_features.clear();
        this.keepJavaUserFunctionsOnly();
        Deftemplate.addStandardTemplates(this);
        this.m_compiler = new ReteCompiler();
        this.m_deffacts.clear();
        this.m_defglobals.clear();
        this.m_classSource.clear();
        this.broadcastEvent(2048, this, null);
        this.setEventMask(0);
        this.unwatchAll();
        this.loadScriptlib();
        System.gc();
    }

    private void keepJavaUserFunctionsOnly() {
        ArrayList<Userfunction> arrayList = new ArrayList<Userfunction>();
        Iterator<Object> iterator = this.m_functions.keySet().iterator();
        while (iterator.hasNext()) {
            Userfunction userfunction = this.findUserfunction((String)iterator.next());
            if (userfunction instanceof Deffunction) continue;
            arrayList.add(userfunction);
        }
        this.m_functions = Collections.synchronizedMap(new HashMap());
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.addUserfunction((Userfunction)iterator.next());
        }
    }

    void setPendingFact(Fact fact, boolean bl) {
        this.m_factList.setPendingFact(fact, bl);
    }

    void removeAllFacts() throws JessException {
        this.m_factList.clear(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws JessException {
        ReteCompiler reteCompiler = this.m_compiler;
        synchronized (reteCompiler) {
            this.removeAllFacts();
            this.m_globalContext.removeNonGlobals();
            this.m_agenda.reset(this);
            this.assertFact(Fact.getInitialFact(), this.getGlobalContext());
            this.resetDefglobals();
            this.resetDeffacts();
        }
        this.m_definstanceList.reset();
        this.broadcastEvent(4096, this, null);
    }

    private void resetDeffacts() throws JessException {
        Iterator iterator = this.m_deffacts.iterator();
        while (iterator.hasNext()) {
            ((Deffacts)iterator.next()).reset(this);
        }
    }

    private void resetDefglobals() throws JessException {
        if (this.getResetGlobals()) {
            Iterator iterator = this.m_defglobals.iterator();
            while (iterator.hasNext()) {
                ((Defglobal)iterator.next()).reset(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fact assertString(String string, Context context) throws JessException {
        TextReader textReader = this.m_tis;
        synchronized (textReader) {
            this.m_tis.clear();
            this.m_jesp.clear();
            this.m_tis.appendText("(assert " + string + ")");
            Value value = this.m_jesp.parseAndExecuteFuncall(null, context, this, this.m_jesp.getTokenStream(), false);
            if (value.type() == 16) {
                return value.factValue(context);
            }
            return null;
        }
    }

    public Fact assertString(String string) throws JessException {
        return this.assertString(string, this.getGlobalContext());
    }

    public Fact assertFact(Fact fact) throws JessException {
        return this.assertFact(fact, this.getGlobalContext());
    }

    public Fact assertFact(Fact fact, Context context) throws JessException {
        return this.m_factList.assertFact(fact, this, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fact retractString(String string) throws JessException {
        try {
            TextReader textReader = this.m_tis;
            synchronized (textReader) {
                this.m_tis.clear();
                this.m_jesp.clear();
                this.m_tis.appendText(string);
                Fact fact = this.m_jesp.parseFact(this, this.m_jesp.getTokenStream());
                return this.retract(fact);
            }
        }
        catch (Exception exception) {
            throw new JessException("Rete.retractString", string, exception);
        }
    }

    public Fact retract(Fact fact) throws JessException {
        if (fact.isShadow()) {
            Object object = fact.getSlotValue("OBJECT").javaObjectValue(null);
            return this.remove(object);
        }
        return this.m_factList.retract(fact, this);
    }

    public void removeFacts(String string) throws JessException {
        this.m_factList.removeFacts(string, this);
    }

    Fact retractNoUndefinstance(Fact fact) throws JessException {
        return this.m_factList.retract(fact, this);
    }

    public Fact modify(Fact fact, String string, Value value) throws JessException {
        return this.modify(fact, new String[]{string}, new Value[]{value});
    }

    public Fact modify(Fact fact, String string, Value value, Context context) throws JessException {
        return this.modify(fact, new String[]{string}, new Value[]{value}, context);
    }

    public Fact modify(Fact fact, String[] stringArray, Value[] valueArray) throws JessException {
        return this.modify(fact, stringArray, valueArray, this.m_globalContext);
    }

    public Fact modify(Fact fact, String[] stringArray, Value[] valueArray, Context context) throws JessException {
        return this.m_factList.modify(fact, stringArray, valueArray, context, this);
    }

    Fact modifyRegularFact(Fact fact, String[] stringArray, Value[] valueArray, Rete rete, Context context) throws JessException {
        return this.m_factList.modifyRegularFact(fact, stringArray, valueArray, rete, context);
    }

    Fact duplicate(ValueVector valueVector, Context context) throws JessException {
        return Duplicate.duplicate(valueVector, context);
    }

    public Fact findFactByID(int n) throws JessException {
        return this.m_factList.findFactByID(n);
    }

    public Fact findFactByFact(Fact fact) throws JessException {
        return this.m_factList.findFactByFact(fact);
    }

    public WorkingMemoryMarker mark() {
        return new IntMarkerImpl(this.m_factList.peekFactId());
    }

    public void resetToMark(WorkingMemoryMarker workingMemoryMarker) throws JessException {
        workingMemoryMarker.restore(this);
    }

    public Iterator getObjects(Filter filter) {
        return this.m_definstanceList.listDefinstances(filter).iterator();
    }

    public void ppFacts(String string, Writer writer) throws IOException {
        this.ppFacts(string, writer, false);
    }

    public void ppFacts(String string, Writer writer, boolean bl) throws IOException {
        this.m_factList.ppFacts(this.resolveName(string), writer, bl);
    }

    public void ppFacts(Writer writer) throws IOException {
        this.ppFacts(writer, false);
    }

    public void ppFacts(Writer writer, boolean bl) throws IOException {
        this.m_factList.ppFacts(writer, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator listDeffacts() {
        List list = this.m_deffacts;
        synchronized (list) {
            return new ArrayList(this.m_deffacts).iterator();
        }
    }

    public Deffacts findDeffacts(String string) {
        string = this.resolveName(string);
        Iterator iterator = this.listDeffacts();
        while (iterator.hasNext()) {
            Deffacts deffacts = (Deffacts)iterator.next();
            if (!deffacts.getName().equals(string)) continue;
            return deffacts;
        }
        return null;
    }

    public Iterator listDeftemplates() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.m_agenda.listModules();
        while (iterator.hasNext()) {
            try {
                Defmodule defmodule = this.m_agenda.getModule((String)iterator.next());
                Iterator iterator2 = defmodule.listDeftemplates();
                while (iterator2.hasNext()) {
                    arrayList.add(iterator2.next());
                }
            }
            catch (JessException jessException) {
            }
        }
        return arrayList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator listDefrules() {
        Map map = this.m_rules;
        synchronized (map) {
            return new ArrayList(this.m_rules.values()).iterator();
        }
    }

    public Iterator listFacts() {
        return this.m_factList.listFacts();
    }

    public Iterator listDefinstances() {
        return this.m_definstanceList.listDefinstances().iterator();
    }

    public boolean containsObject(Object object) {
        return this.m_definstanceList.containsObject(object);
    }

    public Iterator listDefclasses() {
        return this.m_definstanceList.listDefclasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator listDefglobals() {
        List list = this.m_defglobals;
        synchronized (list) {
            return new ArrayList(this.m_defglobals).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator listFunctions() {
        ArrayList<Userfunction> arrayList = new ArrayList<Userfunction>();
        Map map = this.m_functions;
        synchronized (map) {
            Iterator iterator = this.m_functions.keySet().iterator();
            while (iterator.hasNext()) {
                arrayList.add(this.findUserfunction((String)iterator.next()));
            }
        }
        return arrayList.iterator();
    }

    int countFunctions() {
        return this.m_functions.size();
    }

    public final HasLHS findDefrule(String string) {
        return (HasLHS)this.m_rules.get(this.resolveName(string));
    }

    public Class javaClassForDefclass(String string) {
        try {
            String string2 = this.m_definstanceList.jessNameToJavaName(string, this);
            if (string2 == null) {
                return null;
            }
            return this.findClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Deftemplate findDeftemplate(String string) throws JessException {
        if (Deftemplate.isSpecialName(string)) {
            return Deftemplate.getSpecialTemplate(string);
        }
        String string2 = this.resolveName(string);
        String string3 = string2.substring(0, string2.indexOf("::"));
        Deftemplate deftemplate = this.m_agenda.getModule(string3).getDeftemplate(string);
        if (deftemplate == null && !string2.equals(string)) {
            deftemplate = this.m_agenda.getModule("MAIN").getDeftemplate(string);
        }
        return deftemplate;
    }

    public Deftemplate createDeftemplate(String string) throws JessException {
        Deftemplate deftemplate = this.findDeftemplate(string);
        if (deftemplate == null) {
            deftemplate = this.addDeftemplate(new Deftemplate(string, "(Implied)", this));
            deftemplate.addMultiSlot("__data", Funcall.NILLIST, "ANY");
        }
        return deftemplate;
    }

    public Deftemplate addDeftemplate(Deftemplate deftemplate) throws JessException {
        Defmodule defmodule = this.m_agenda.getModule(deftemplate.getModule());
        return defmodule.addDeftemplate(deftemplate, this);
    }

    public Deffacts addDeffacts(Deffacts deffacts) throws JessException {
        this.broadcastEvent(8, deffacts, null);
        this.m_deffacts.add(deffacts);
        return deffacts;
    }

    public Defglobal addDefglobal(Defglobal defglobal) throws JessException {
        this.broadcastEvent(256, defglobal, this.m_globalContext);
        defglobal.reset(this);
        this.m_defglobals.add(defglobal);
        return defglobal;
    }

    public List addDefglobals(List list) throws JessException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addDefglobal((Defglobal)iterator.next());
        }
        return list;
    }

    public Defglobal findDefglobal(String string) {
        Iterator iterator = this.listDefglobals();
        while (iterator.hasNext()) {
            Defglobal defglobal = (Defglobal)iterator.next();
            if (!defglobal.getName().equals(string)) continue;
            return defglobal;
        }
        return null;
    }

    public void removeUserDefinedFunctions() {
        HashSet hashSet = new HashSet(this.m_functions.keySet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.removeUserfunction((String)iterator.next());
        }
        this.importPackage("java.lang.");
    }

    public Userfunction addUserfunction(Userfunction userfunction) {
        try {
            this.broadcastEvent(512, userfunction, null);
        }
        catch (JessException jessException) {
            return null;
        }
        FunctionHolder functionHolder = (FunctionHolder)this.m_functions.get(userfunction.getName());
        if (functionHolder != null) {
            functionHolder.setFunction(userfunction);
        } else {
            functionHolder = new FunctionHolder(userfunction);
        }
        this.m_functions.put(userfunction.getName(), functionHolder);
        return userfunction;
    }

    public void removeUserfunction(String string) {
        this.removeUserfunction(string, true);
    }

    void removeUserfunction(String string, boolean bl) {
        Userfunction userfunction;
        FunctionHolder functionHolder = (FunctionHolder)this.m_functions.get(string);
        if (functionHolder != null && (userfunction = functionHolder.getFunction()) != null) {
            if (bl) {
                try {
                    this.broadcastEvent(-2147483136, userfunction, null);
                }
                catch (JessException jessException) {
                    return;
                }
            }
            functionHolder.setFunction(null);
            this.m_functions.remove(string);
        }
    }

    public Userpackage addUserpackage(Userpackage userpackage) {
        try {
            this.broadcastEvent(1024, userpackage, null);
        }
        catch (JessException jessException) {
            return null;
        }
        userpackage.add(this);
        return userpackage;
    }

    public final Userfunction findUserfunction(String string) {
        FunctionHolder functionHolder = (FunctionHolder)this.m_functions.get(string);
        if (functionHolder != null) {
            return functionHolder.getFunction();
        }
        return Funcall.getIntrinsic(string);
    }

    final FunctionHolder findFunctionHolder(String string) {
        FunctionHolder functionHolder = (FunctionHolder)this.m_functions.get(string);
        if (functionHolder == null) {
            Userfunction userfunction = Funcall.getIntrinsic(string);
            if (userfunction != null) {
                this.addUserfunction(userfunction);
            }
            functionHolder = (FunctionHolder)this.m_functions.get(string);
        }
        return functionHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HasLHS addDefrule(HasLHS hasLHS) throws JessException {
        if (this.m_passiveMode) {
            return hasLHS;
        }
        ReteCompiler reteCompiler = this.m_compiler;
        synchronized (reteCompiler) {
            JessException jessException = null;
            this.unDefrule(hasLHS.getName());
            try {
                for (HasLHS hasLHS2 = hasLHS; hasLHS2 != null; hasLHS2 = hasLHS2.getNext()) {
                    this.m_compiler.addRule(hasLHS2, this);
                }
            }
            catch (RuleCompilerException ruleCompilerException) {
                hasLHS.remove(this.m_compiler.getRoot());
                throw ruleCompilerException;
            }
            catch (JessException jessException2) {
                jessException = jessException2;
            }
            this.m_rules.put(hasLHS.getName(), hasLHS);
            this.broadcastEvent(1, hasLHS, null);
            if (jessException != null) {
                throw jessException;
            }
            return hasLHS;
        }
    }

    public final Value unDeffacts(String string) {
        if (string.equals("*")) {
            this.m_deffacts.clear();
        } else {
            string = this.resolveName(string);
            Iterator iterator = this.m_deffacts.iterator();
            while (iterator.hasNext()) {
                Deffacts deffacts = (Deffacts)iterator.next();
                if (!deffacts.getName().equals(string)) continue;
                iterator.remove();
                return Funcall.TRUE;
            }
        }
        return Funcall.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Value unDefrule(String string) throws JessException {
        ReteCompiler reteCompiler = this.m_compiler;
        synchronized (reteCompiler) {
            HasLHS hasLHS = this.findDefrule(string);
            if (hasLHS != null) {
                this.m_rules.remove(this.resolveName(string));
                hasLHS.remove(this.m_compiler.getRoot());
                for (HasLHS hasLHS2 = hasLHS; hasLHS2 != null; hasLHS2 = hasLHS2.getNext()) {
                    if (!(hasLHS2 instanceof Defrule)) continue;
                    Iterator iterator = this.m_agenda.listActivations(hasLHS.getModule());
                    while (iterator.hasNext()) {
                        Activation activation = (Activation)iterator.next();
                        if (activation.getRule() != hasLHS2) continue;
                        this.removeActivation(activation);
                    }
                }
                this.commitActivations();
                this.broadcastEvent(-2147483647, hasLHS, null);
                return Funcall.TRUE;
            }
        }
        return Funcall.FALSE;
    }

    public void addDefmodule(Defmodule defmodule) throws JessException {
        this.m_agenda.addDefmodule(defmodule, this);
    }

    public void addDefmodule(String string) throws JessException {
        this.m_agenda.addDefmodule(new Defmodule(string, ""), this);
    }

    public void addDefmodule(String string, String string2) throws JessException {
        this.m_agenda.addDefmodule(new Defmodule(string, string2), this);
    }

    public String getCurrentModule() {
        return this.m_agenda.getCurrentModule();
    }

    public String setCurrentModule(String string) throws JessException {
        return this.m_agenda.setCurrentModule(string);
    }

    public Iterator listModules() throws JessException {
        return this.m_agenda.listModules();
    }

    public String getFocus() {
        return this.m_agenda.getFocus();
    }

    public void setFocus(String string) throws JessException {
        this.m_agenda.setFocus(string, this);
    }

    public Iterator listFocusStack() throws JessException {
        return this.m_agenda.listFocusStack();
    }

    public void clearFocusStack() {
        this.m_agenda.clearFocusStack();
    }

    public String popFocus(String string) throws JessException {
        return this.m_agenda.popFocus(this, string);
    }

    public void verifyModule(String string) throws JessException {
        this.m_agenda.verifyModule(string);
    }

    public String resolveName(String string) {
        return this.m_agenda.resolveName(string);
    }

    void updateNodes(Set set) throws JessException {
        this.m_factList.updateNodes(this, set);
    }

    void addActivation(Activation activation) throws JessException {
        this.broadcastEvent(4, activation, null);
        this.m_agenda.addActivation(activation);
    }

    void removeActivation(Activation activation) throws JessException {
        this.broadcastEvent(-2147483644, activation, null);
        this.m_agenda.removeActivation(activation);
    }

    void commitActivations() throws JessException {
        this.m_agenda.commitActivations(this);
    }

    public Iterator listActivations() {
        return this.m_agenda.listActivations();
    }

    public Iterator listActivations(String string) throws JessException {
        return this.m_agenda.listActivations(string);
    }

    public Activation peekNextActivation() throws JessException {
        return this.m_agenda.peekNextActivation(this);
    }

    public Object getActivationSemaphore() {
        return this.m_agenda.getActivationSemaphore();
    }

    public void waitForActivations() {
        this.m_agenda.waitForActivations();
    }

    public String setStrategy(Strategy strategy) throws JessException {
        return this.m_agenda.setStrategy(strategy, this);
    }

    public Strategy getStrategy() {
        return this.m_agenda.getStrategy();
    }

    public final void setEvalSalience(int n) throws JessException {
        this.m_agenda.setEvalSalience(n);
    }

    public final int getEvalSalience() {
        return this.m_agenda.getEvalSalience();
    }

    public int run() throws JessException {
        return this.run(this.getGlobalContext());
    }

    int run(Context context) throws JessException {
        this.broadcastEvent(8192, this, null);
        return this.m_agenda.run(this, context);
    }

    protected void aboutToFire(Activation activation) {
    }

    protected void justFired(Activation activation) {
    }

    public int run(int n) throws JessException {
        return this.run(n, this.getGlobalContext());
    }

    int run(int n, Context context) throws JessException {
        this.broadcastEvent(8192, this, null);
        return this.m_agenda.run(n, this, context);
    }

    public int runUntilHalt() throws JessException {
        return this.runUntilHalt(this.getGlobalContext());
    }

    int runUntilHalt(Context context) throws JessException {
        this.broadcastEvent(8192, this, null);
        return this.m_agenda.runUntilHalt(this, context);
    }

    public void halt() throws JessException {
        this.broadcastEvent(16384, this, null);
        this.m_agenda.halt();
    }

    public boolean isHalted() {
        return this.m_agenda.isHalted();
    }

    public String getThisRuleName() {
        Activation activation = this.getThisActivation();
        if (activation != null) {
            return activation.getRule().getName();
        }
        return null;
    }

    public Activation getThisActivation() {
        return this.m_agenda.getThisActivation();
    }

    public void addJessListener(JessListener jessListener) {
        this.m_jes.addJessListener(jessListener);
    }

    public void removeJessListener(JessListener jessListener) {
        this.m_jes.removeJessListener(jessListener);
    }

    public Iterator listJessListeners() {
        return this.m_jes.listJessListeners();
    }

    public int getEventMask() {
        return this.m_jes.getEventMask();
    }

    public void setEventMask(int n) {
        this.m_jes.setEventMask(n);
    }

    final void broadcastEvent(int n, Object object, Context context) throws JessException {
        this.m_jes.broadcastDebugEvent(this, n, object, context);
        this.m_jes.broadcastEvent(this, n, object, context);
    }

    public void setPassiveMode(boolean bl) {
        this.m_passiveMode = bl;
    }

    public boolean isDebug() {
        return this.m_jes.isDebug();
    }

    public void setDebug(boolean bl) {
        this.m_jes.setDebug(bl);
    }

    public static void recordFunction(Funcall funcall, String string, int n) {
        Rete.recordFunction(funcall, new LineNumberRecord(string, n));
    }

    public static void recordFunction(Funcall funcall, LineNumberRecord lineNumberRecord) {
        if (s_lineNumberTable == null) {
            s_lineNumberTable = Collections.synchronizedMap(new IdentityHashMap());
        }
        s_lineNumberTable.put(funcall, lineNumberRecord);
    }

    public static LineNumberRecord lookupFunction(Funcall funcall) {
        if (s_lineNumberTable != null) {
            return (LineNumberRecord)s_lineNumberTable.get(funcall);
        }
        return null;
    }

    public void removeDebugListener(JessListener jessListener) {
        this.m_jes.removeDebugListener(jessListener);
    }

    public void addDebugListener(JessListener jessListener) {
        this.m_jes.addDebugListener(jessListener);
    }

    public Iterator listDebugListeners() {
        return this.m_jes.listDebugListeners();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_routers = new Routers();
        this.m_tis = new TextReader(true);
        this.m_jesp = this.initInternalParser();
        this.m_jes = new JessEventSupport(this);
        this.m_definstanceList.setEngine(this);
        this.m_globalContext.setEngine(this);
        this.m_classSource.setEngine(this);
        this.m_classResearcher = new ReflectionClassResearcher(this);
    }

    public void bload(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        this.m_globalContext = (Context)objectInputStream.readObject();
        this.m_globalContext.setEngine(this);
        this.m_resetGlobals = objectInputStream.readBoolean();
        this.m_deffacts = (List)objectInputStream.readObject();
        this.m_defglobals = (List)objectInputStream.readObject();
        this.m_functions = (Map)objectInputStream.readObject();
        this.m_factList = (FactList)objectInputStream.readObject();
        this.m_definstanceList = (DefinstanceList)objectInputStream.readObject();
        this.m_definstanceList.setEngine(this);
        this.m_rules = (Map)objectInputStream.readObject();
        this.m_compiler = (ReteCompiler)objectInputStream.readObject();
        this.m_storage = (Map)objectInputStream.readObject();
        this.m_agenda = (Agenda)objectInputStream.readObject();
        this.m_classSource = (ClassSource)objectInputStream.readObject();
        this.m_classSource.setEngine(this);
        this.m_watchInfo = (boolean[])objectInputStream.readObject();
        this.m_features = (HashSet)objectInputStream.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bsave(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        ReteCompiler reteCompiler = this.getCompiler();
        synchronized (reteCompiler) {
            Object object = this.getActivationSemaphore();
            synchronized (object) {
                objectOutputStream.writeObject(this.m_globalContext);
                objectOutputStream.writeBoolean(this.m_resetGlobals);
                objectOutputStream.writeObject(this.m_deffacts);
                objectOutputStream.writeObject(this.m_defglobals);
                objectOutputStream.writeObject(this.m_functions);
                objectOutputStream.writeObject(this.m_factList);
                objectOutputStream.writeObject(this.m_definstanceList);
                objectOutputStream.writeObject(this.m_rules);
                objectOutputStream.writeObject(this.m_compiler);
                objectOutputStream.writeObject(this.m_storage);
                objectOutputStream.writeObject(this.m_agenda);
                objectOutputStream.writeObject(this.m_classSource);
                objectOutputStream.writeObject(this.m_watchInfo);
                objectOutputStream.writeObject(this.m_features);
            }
        }
        objectOutputStream.flush();
    }

    public Value definstance(String string, Object object, boolean bl) throws JessException {
        return this.definstance(string, object, bl, this.getGlobalContext());
    }

    public Value definstance(String string, Object object, boolean bl, Context context) throws JessException {
        this.broadcastEvent(32, object, context);
        string = this.resolveTemplateNameInFocusModule(string);
        return this.m_definstanceList.definstance(this.resolveTemplateNameInFocusModule(string), object, bl, context);
    }

    public Fact getShadowFactForObject(Object object) throws JessException {
        return this.m_definstanceList.getShadowFactForObject(object);
    }

    String resolveTemplateNameInFocusModule(String string) throws JessException {
        if (string.indexOf("::") != -1) {
            return string;
        }
        if (this.getFocus().equals(this.getCurrentModule())) {
            return string;
        }
        String string2 = this.getFocus() + "::" + string;
        if (this.findDeftemplate(string2) != null) {
            return string2;
        }
        return string;
    }

    public Fact remove(Object object) throws JessException {
        Fact fact = this.m_definstanceList.undefinstance(object);
        this.broadcastEvent(-2147483616, object, null);
        return fact;
    }

    public Fact undefinstance(Object object) throws JessException {
        return this.remove(object);
    }

    void undefinstanceNoRetract(Object object) throws JessException {
        this.m_definstanceList.undefinstanceNoRetract(object);
        this.broadcastEvent(-2147483616, object, null);
    }

    public Value updateObject(Object object) throws JessException {
        return this.m_definstanceList.updateObject(object);
    }

    public Value updateObject(Object object, String string) throws JessException {
        return this.m_definstanceList.updateObject(object, string);
    }

    public Value add(Object object) throws JessException {
        String string = object.getClass().getName();
        String string2 = ClassSource.classNameOnly(string);
        if (this.findDeftemplate(string2) == null) {
            this.defclass(string2, string, null);
        }
        boolean bl = Definstance.acceptsPropertyChangeListeners(object, this);
        return this.definstance(string2, object, bl);
    }

    public void addAll(Collection collection) throws JessException {
        this.addAll(collection.iterator());
    }

    public void removeAll(Collection collection) throws JessException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove(iterator.next());
        }
    }

    public void addAll(Iterator iterator) throws JessException {
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public Value defclass(String string, String string2, String string3, boolean bl) throws JessException {
        this.broadcastEvent(128, string, null);
        return this.m_definstanceList.defclass(string, string2, string3, bl);
    }

    public Value defclass(String string, String string2, String string3) throws JessException {
        this.broadcastEvent(128, string, null);
        return this.m_definstanceList.defclass(string, string2, string3, false);
    }

    FactList getFactList() {
        return this.m_factList;
    }

    DefinstanceList getDefinstanceList() {
        return this.m_definstanceList;
    }

    public final Context getGlobalContext() {
        return this.m_globalContext;
    }

    public Value eval(String string) throws JessException {
        return this.eval(string, this.m_globalContext);
    }

    public Value executeCommand(String string) throws JessException {
        return this.eval(string, this.m_globalContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value eval(String string, Context context) throws JessException {
        TextReader textReader = this.m_tis;
        synchronized (textReader) {
            this.m_tis.clear();
            this.m_jesp.clear();
            this.m_tis.appendText(string);
            return this.m_jesp.parse(false, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value executeCommand(String string, Context context) throws JessException {
        TextReader textReader = this.m_tis;
        synchronized (textReader) {
            this.m_tis.clear();
            this.m_jesp.clear();
            this.m_tis.appendText(string);
            return this.m_jesp.parse(false, context);
        }
    }

    private Jesp initInternalParser() {
        Jesp jesp = new Jesp(this.m_tis, this);
        jesp.setFileName("<eval pipe>");
        return jesp;
    }

    public final void setResetGlobals(boolean bl) {
        this.m_resetGlobals = bl;
    }

    public final boolean getResetGlobals() {
        return this.m_resetGlobals;
    }

    final ReteCompiler getCompiler() {
        return this.m_compiler;
    }

    public Value store(String string, Value value) {
        if (value == null) {
            return (Value)this.m_storage.remove(string);
        }
        return this.m_storage.put(string, value);
    }

    public Value store(String string, Object object) {
        if (object == null) {
            return (Value)this.m_storage.remove(string);
        }
        return this.m_storage.put(string, new Value(object));
    }

    public Value fetch(String string) {
        return (Value)this.m_storage.get(string);
    }

    public void clearStorage() {
        this.m_storage.clear();
    }

    int getTime() {
        return this.m_factList.getTime();
    }

    public static Factory getFactory() {
        return s_factory;
    }

    public static void setFactory(Factory factory) {
        s_factory = factory;
    }

    private void loadScriptlib() {
        try {
            this.batch(LIBRARY_NAME);
        }
        catch (JessException jessException) {
            jessException.printStackTrace();
        }
    }

    public Value batch(String string) throws JessException {
        return Batch.batch(string, this);
    }

    public QueryResult runQueryStar(String string, ValueVector valueVector) throws JessException {
        return this.runQueryStar(string, valueVector, this.getGlobalContext());
    }

    public QueryResult runQueryStar(String string, ValueVector valueVector, Context context) throws JessException {
        Iterator iterator = this.doRunQuery(string, valueVector, context);
        return new QueryResult(iterator, (Defquery)this.findDefrule(string), context);
    }

    public Iterator runQuery(String string, ValueVector valueVector) throws JessException {
        return this.doRunQuery(string, valueVector, this.getGlobalContext());
    }

    public Iterator runQuery(String string, ValueVector valueVector, Context context) throws JessException {
        return this.doRunQuery(string, valueVector, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator doRunQuery(String string, ValueVector valueVector, Context context) throws JessException {
        HasLHS hasLHS = this.findDefrule(string);
        if (hasLHS == null || !(hasLHS instanceof Defquery)) {
            throw new JessException("runQuery", "No such query:", string);
        }
        Defquery defquery = (Defquery)hasLHS;
        if (valueVector.size() != defquery.getNVariables()) {
            throw new JessException("runQuery", "Wrong number of variables for query", string);
        }
        Fact fact = new Fact(defquery.getQueryTriggerName(), this);
        fact.setSlotValue("__data", new Value(valueVector, 512));
        ReteCompiler reteCompiler = this.getCompiler();
        synchronized (reteCompiler) {
            Defquery defquery2 = defquery;
            synchronized (defquery2) {
                defquery.clearResults();
                this.assertFact(fact, context);
                if (defquery.getMaxBackgroundRules() > 0) {
                    this.run(defquery.getMaxBackgroundRules());
                }
                Iterator iterator = defquery.getResults();
                defquery.clearResults();
                this.retract(fact);
                return iterator;
            }
        }
    }

    public int countQueryResults(String string, ValueVector valueVector) throws JessException {
        return this.countQueryResults(string, valueVector, this.getGlobalContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countQueryResults(String string, ValueVector valueVector, Context context) throws JessException {
        HasLHS hasLHS = this.findDefrule(string);
        if (hasLHS == null || !(hasLHS instanceof Defquery)) {
            throw new JessException("countQueryResults", "No such query:", string);
        }
        Defquery defquery = (Defquery)hasLHS;
        if (valueVector.size() != defquery.getNVariables()) {
            throw new JessException("countQueryResults", "Wrong number of variables for query", string);
        }
        Fact fact = new Fact(defquery.getQueryTriggerName(), this);
        fact.setSlotValue("__data", new Value(valueVector, 512));
        ReteCompiler reteCompiler = this.getCompiler();
        synchronized (reteCompiler) {
            Defquery defquery2 = defquery;
            synchronized (defquery2) {
                defquery.clearResults();
                this.assertFact(fact, context);
                if (defquery.getMaxBackgroundRules() > 0) {
                    this.run(defquery.getMaxBackgroundRules());
                }
                int n = defquery.countResults();
                defquery.clearResults();
                this.retract(fact);
                return n;
            }
        }
    }

    public void watch(int n) throws JessException {
        int n2;
        this.m_watchInfo[n] = true;
        switch (n) {
            case 1: {
                n2 = 2;
                break;
            }
            case 0: {
                n2 = 16;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 0x100000;
                break;
            }
            default: {
                throw new JessException("watch", "Bad argument ", n);
            }
        }
        this.m_watchInfo[n] = true;
        n2 = this.getEventMask() | n2 | 0x800;
        this.setEventMask(n2);
    }

    public void unwatch(int n) throws JessException {
        int n2;
        switch (n) {
            case 1: {
                n2 = 2;
                break;
            }
            case 0: {
                n2 = 16;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 0x100000;
                break;
            }
            default: {
                throw new JessException("unwatch", "Bad argument ", n);
            }
        }
        this.m_watchInfo[n] = false;
        n2 = this.getEventMask() & ~n2;
        this.setEventMask(n2);
    }

    public void watchAll() {
        int n;
        for (n = 0; n < this.m_watchInfo.length; ++n) {
            this.m_watchInfo[n] = true;
        }
        n = 0x100017;
        n = this.getEventMask() | 0x800 | n;
        this.setEventMask(n);
    }

    public void unwatchAll() {
        int n;
        for (n = 0; n < this.m_watchInfo.length; ++n) {
            this.m_watchInfo[n] = false;
        }
        n = 0x100017;
        n = this.getEventMask() & ~n;
        this.setEventMask(n);
    }

    boolean watchingAny() {
        for (int i = 0; i < this.m_watchInfo.length; ++i) {
            if (!this.m_watchInfo[i]) continue;
            return true;
        }
        return false;
    }

    boolean watching(int n) {
        return this.m_watchInfo[n];
    }

    public void eventHappened(JessEvent jessEvent) {
        if (!this.watchingAny()) {
            return;
        }
        int n = jessEvent.getType();
        boolean bl = (n & Integer.MIN_VALUE) != 0;
        boolean bl2 = (n & 0x40000000) != 0;
        PrintWriter printWriter = this.getWatchRouter();
        if (printWriter == null) {
            return;
        }
        switch (n & Integer.MAX_VALUE & 0xBFFFFFFF) {
            case 16: {
                if (!this.watching(0)) break;
                Fact fact = (Fact)jessEvent.getObject();
                printWriter.print(bl ? " <== " : (bl2 ? " <=> " : " ==> "));
                printWriter.print("f-");
                printWriter.print(fact.getFactId());
                printWriter.print(" ");
                printWriter.println(fact);
                printWriter.flush();
                break;
            }
            case 0x100000: {
                if (!this.watching(4)) break;
                printWriter.print(bl ? " <== " : " ==> ");
                printWriter.print("Focus ");
                printWriter.println(jessEvent.getObject());
                printWriter.flush();
                break;
            }
            case 2: {
                if (!this.watching(1)) break;
                ((Activation)jessEvent.getObject()).debugPrint(printWriter);
                break;
            }
            case 4: {
                if (!this.watching(2)) break;
                Activation activation = (Activation)jessEvent.getObject();
                printWriter.print(bl ? "<== " : "==> ");
                printWriter.print("Activation: ");
                printWriter.print(activation.getRule().getDisplayName());
                printWriter.print(" : ");
                printWriter.println(activation.getToken().factList());
                printWriter.flush();
                break;
            }
            case 1: {
                if (!this.watching(3) || bl) break;
                printWriter.println(((HasLHS)jessEvent.getObject()).getCompilationTrace());
                printWriter.flush();
                break;
            }
        }
    }

    public String setWatchRouter(String string) throws JessException {
        if (this.m_routers.getOutputRouter(string) == null) {
            throw new JessException("Rete.setWatchRouter", "Invalid router name", string);
        }
        String string2 = this.m_watchRouter;
        this.m_watchRouter = string;
        return string2;
    }

    PrintWriter getWatchRouter() {
        return this.m_routers.getOutputRouterAsPrintWriter(this.m_watchRouter);
    }

    public void defineFeature(String string) {
        this.m_features.add(string);
    }

    public boolean isFeatureDefined(String string) {
        return this.m_features.contains(string);
    }

    void removeLogicalSupportFrom(Token token, Fact fact) {
        this.m_factList.removeLogicalSupportFrom(token, fact);
    }

    public List getSupportingTokens(Fact fact) {
        return this.m_factList.getSupportingTokens(fact);
    }

    public List getSupportedFacts(Fact fact) {
        return this.m_factList.getSupportedFacts(fact);
    }

    public Applet getApplet() {
        return this.m_classSource.getApplet();
    }

    public Class getAppObjectClass() {
        return this.m_classSource.getAppObjectClass();
    }

    public void setApplet(Applet applet) {
        this.m_classSource.setApplet(applet);
    }

    public void setAppObject(Object object) {
        this.m_classSource.setAppObject(object);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.m_classSource.setClassLoader(classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.m_classSource.getClassLoader();
    }

    public Class findClass(String string) throws ClassNotFoundException {
        return this.m_classSource.findClass(string);
    }

    public URL getResource(String string) {
        return this.m_classSource.getResource(string);
    }

    public void importPackage(String string) {
        this.m_classSource.importPackage(string);
    }

    public void importClass(String string) throws JessException {
        this.m_classSource.importClass(string);
    }

    public ClassResearcher getClassResearcher() {
        return this.m_classResearcher;
    }

    public void setClassResearcher(ClassResearcher classResearcher) {
        this.m_classResearcher = classResearcher;
    }

    public String toString() {
        return "[Rete]";
    }
}

