/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import jess.JessException;
import jess.JessToken;
import jess.RU;
import jess.Tokenizer;

public class ReaderTokenizer
implements Tokenizer {
    private static final int EOF = -1;
    private PushbackReader m_ios;
    private int m_line = 1;
    private boolean m_reportNewlines = false;
    private int m_streamIndex;
    private int m_tokenStart;
    private boolean m_returnComments = false;
    StringBuffer m_sb = new StringBuffer(5);

    public ReaderTokenizer(Reader reader, boolean bl) {
        this.m_returnComments = bl;
        this.m_ios = reader instanceof PushbackReader ? (PushbackReader)reader : (reader instanceof FileReader ? new PushbackReader(new BufferedReader(reader, 512)) : new PushbackReader(reader));
    }

    public void reportNewlines(boolean bl) {
        this.m_reportNewlines = bl;
    }

    public synchronized String readLine() throws JessException {
        int n;
        this.m_sb.setLength(0);
        while ((n = this.nextChar()) != 10 && n != -1) {
            this.m_sb.append((char)n);
        }
        if (this.m_reportNewlines && n == 10) {
            this.unread(n);
        }
        if (n == -1 && this.m_sb.length() == 0) {
            return null;
        }
        ++this.m_line;
        return this.m_sb.toString();
    }

    public synchronized JessToken nextToken() throws JessException {
        int n;
        this.m_sb.setLength(0);
        this.m_tokenStart = this.m_streamIndex;
        block18: do {
            n = this.nextChar();
            switch (n) {
                case -1: {
                    return this.finishToken(-1, this.m_sb);
                }
                case 10: {
                    ++this.m_line;
                    if (!this.m_reportNewlines) continue block18;
                    return this.finishToken(10, this.m_sb);
                }
                case 9: 
                case 13: 
                case 32: {
                    break;
                }
                default: {
                    this.unread(n);
                    break block18;
                }
            }
        } while (n != -1);
        this.m_tokenStart = this.m_streamIndex;
        n = this.nextChar();
        switch (n) {
            case -1: {
                return this.finishToken(-1, this.m_sb);
            }
            case 59: {
                String string = this.discardToEOL();
                if (this.m_returnComments) {
                    JessToken jessToken = new JessToken(this.m_tokenStart, this.m_streamIndex);
                    jessToken.m_ttype = 7;
                    jessToken.m_sval = ";" + string;
                    return jessToken;
                }
                return this.nextToken();
            }
            case 34: {
                this.readString(this.m_sb, '\"');
                return this.finishToken(34, this.m_sb);
            }
            case 47: {
                n = this.nextChar();
                if (Character.isWhitespace((char)n) || n == 41) {
                    this.unread(n);
                    return this.finishToken(47, this.m_sb);
                }
                if (n == 42) {
                    do {
                        this.readString(this.m_sb, '*');
                        n = this.nextChar();
                        if (n == 47) continue;
                        this.m_sb.append('*');
                        this.unread(n);
                    } while (n != -1 && n != 47);
                    this.m_sb.append('/');
                    return this.finishToken(11, this.m_sb);
                }
                this.unread(n);
                this.readString(this.m_sb, '/');
                return this.finishToken(8, this.m_sb);
            }
            case 40: 
            case 41: 
            case 91: 
            case 93: 
            case 123: 
            case 125: 
            case 126: {
                return this.finishToken(n, this.m_sb);
            }
            case 38: 
            case 61: 
            case 124: {
                int n2 = this.nextChar();
                if (n2 == n) {
                    this.m_sb.append((char)n);
                    this.m_sb.append((char)n);
                    return this.finishToken(0, this.m_sb);
                }
                this.unread(n2);
                return this.finishToken(n, this.m_sb);
            }
        }
        this.m_sb.append((char)n);
        block20: while (true) {
            if (Character.isWhitespace((char)(n = this.nextChar()))) {
                this.unread(n);
                return this.finishToken(0, this.m_sb);
            }
            switch (n) {
                case -1: {
                    return this.finishToken(-1, this.m_sb);
                }
                case 34: 
                case 38: 
                case 40: 
                case 41: 
                case 59: 
                case 60: 
                case 123: 
                case 124: 
                case 125: 
                case 126: {
                    this.unread(n);
                    return this.finishToken(0, this.m_sb);
                }
                case 92: {
                    n = this.nextChar();
                    if (n == -1) {
                        return this.finishToken(-1, this.m_sb);
                    }
                    this.m_sb.append((char)n);
                    continue block20;
                }
            }
            this.m_sb.append((char)n);
        }
    }

    int nextChar() throws JessException {
        try {
            int n = this.m_ios.read();
            if (n == 13) {
                if (this.m_ios.ready()) {
                    n = this.m_ios.read();
                    if (n != 10) {
                        this.m_ios.unread(n);
                    } else {
                        ++this.m_streamIndex;
                    }
                }
                n = 10;
            }
            if (n != -1) {
                ++this.m_streamIndex;
            }
            return n;
        }
        catch (IOException iOException) {
            throw new JessException("ReaderTokenizer.nextChar", "Error on input stream", iOException);
        }
    }

    public void eatWhitespace() throws JessException {
        try {
            int n = 0;
            if (this.m_ios.ready()) {
                while (this.m_ios.ready() && (n = this.nextChar()) != -1 && Character.isWhitespace((char)n)) {
                    if (n != 10) continue;
                    ++this.m_line;
                }
                if (n != -1 && !Character.isWhitespace((char)n)) {
                    this.unread(n);
                }
            }
        }
        catch (IOException iOException) {
            throw new JessException("ReaderTokenizer.eatWhitespace", "Error on input stream", iOException);
        }
    }

    private void unread(int n) throws JessException {
        try {
            this.m_ios.unread(n);
            --this.m_streamIndex;
        }
        catch (IOException iOException) {
            throw new JessException("ReaderTokenizer.unread", "Error unreading character", iOException);
        }
    }

    private JessToken finishToken(int n, StringBuffer stringBuffer) throws JessException {
        int n2 = this.m_streamIndex;
        JessToken jessToken = new JessToken(this.m_tokenStart, n2);
        jessToken.m_lineno = this.m_line;
        switch (n) {
            case 34: {
                jessToken.m_ttype = 3;
                jessToken.m_sval = stringBuffer.toString();
                break;
            }
            case 8: {
                jessToken.m_ttype = 8;
                jessToken.m_sval = stringBuffer.toString();
                break;
            }
            case 11: {
                jessToken.m_ttype = 11;
                jessToken.m_sval = stringBuffer.toString();
                break;
            }
            case 123: {
                jessToken.m_ttype = 123;
                jessToken.m_sval = "{";
                break;
            }
            case 125: {
                jessToken.m_ttype = 125;
                jessToken.m_sval = "}";
                break;
            }
            case 91: {
                jessToken.m_ttype = 91;
                jessToken.m_sval = "[";
                break;
            }
            case 93: {
                jessToken.m_ttype = 93;
                jessToken.m_sval = "]";
                break;
            }
            case 40: {
                jessToken.m_ttype = 40;
                jessToken.m_sval = "(";
                break;
            }
            case 41: {
                jessToken.m_ttype = 41;
                jessToken.m_sval = ")";
                break;
            }
            case 38: {
                jessToken.m_ttype = 38;
                jessToken.m_sval = "&";
                break;
            }
            case 126: {
                jessToken.m_ttype = 126;
                jessToken.m_sval = "~";
                break;
            }
            case 124: {
                jessToken.m_ttype = n;
                jessToken.m_sval = "|";
                break;
            }
            case 61: {
                jessToken.m_ttype = 61;
                jessToken.m_sval = "=";
                break;
            }
            case 47: {
                jessToken.m_ttype = 4;
                jessToken.m_sval = "/";
                break;
            }
            case 10: {
                jessToken.m_ttype = 10;
                jessToken.m_sval = "\n";
                break;
            }
            case -1: {
                if (stringBuffer.length() == 0) {
                    jessToken.m_ttype = 0;
                    jessToken.m_sval = "EOF";
                    jessToken.m_end = jessToken.m_start;
                    break;
                }
                return this.finishToken(0, stringBuffer);
            }
            case 0: {
                String string = stringBuffer.toString();
                char c = string.charAt(0);
                if (c == '?') {
                    jessToken.m_ttype = 2;
                    if (string.length() > 1) {
                        jessToken.m_sval = string.substring(1);
                        break;
                    }
                    jessToken.m_sval = RU.gensym("_blank_");
                    break;
                }
                if (c == '$' && string.length() > 1 && string.charAt(1) == '?') {
                    jessToken.m_ttype = 1;
                    if (string.length() > 2) {
                        jessToken.m_sval = string.substring(2);
                        break;
                    }
                    jessToken.m_sval = RU.gensym("_blank_mf");
                    break;
                }
                if (string.length() == 1 && (c == '-' || c == '.' || c == '+')) {
                    jessToken.m_ttype = 4;
                    jessToken.m_sval = string;
                    break;
                }
                if (ReaderTokenizer.isAnInteger(string)) {
                    try {
                        int n3 = Integer.parseInt(string, 10);
                        jessToken.m_ttype = 5;
                        jessToken.m_nval = n3;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (ReaderTokenizer.isALong(string)) {
                    try {
                        String string2 = string;
                        if (string2.toUpperCase().endsWith("L")) {
                            string2 = string2.substring(0, string2.length() - 1);
                        }
                        long l = Long.parseLong(string2, 10);
                        jessToken.m_ttype = 9;
                        jessToken.m_lval = l;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (ReaderTokenizer.couldBeADouble(string)) {
                    try {
                        double d = Double.valueOf(string);
                        jessToken.m_ttype = 6;
                        jessToken.m_nval = d;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                jessToken.m_sval = string;
                jessToken.m_ttype = 4;
                break;
            }
            default: {
                throw new JessException("ReaderTokenizer.finishToken", "Impossible tag:", "" + (char)n);
            }
        }
        return jessToken;
    }

    static boolean couldBeADouble(String string) {
        char c = string.charAt(0);
        return Character.isDigit(c) || c == '+' || c == '-' || c == '.';
    }

    public static boolean isAnInteger(String string) {
        if (string.length() > 11) {
            return false;
        }
        char c = string.charAt(0);
        if (!Character.isDigit(c) && c != '+' && c != '-') {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isALong(String string) {
        char c;
        int n = string.length();
        if (n > 21) {
            return false;
        }
        char c2 = string.charAt(0);
        if (!Character.isDigit(c2) && c2 != '+' && c2 != '-') {
            return false;
        }
        for (c = '\u0001'; c < n - 1; ++c) {
            if (Character.isDigit(string.charAt(c))) continue;
            return false;
        }
        c = string.charAt(n - 1);
        return Character.isDigit(c) || c == 'L' || c == 'l';
    }

    public String discardToEOL() throws JessException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = this.nextChar()) == 10 || n == -1) {
                ++this.m_line;
                if (!this.m_reportNewlines) break;
                this.unread(n);
                break;
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private void readString(StringBuffer stringBuffer, char c) throws JessException {
        int n;
        block5: do {
            n = this.nextChar();
            switch (n) {
                case -1: {
                    break;
                }
                case 92: {
                    n = this.nextChar();
                    stringBuffer.append((char)n);
                    break;
                }
                case 10: {
                    ++this.m_line;
                    stringBuffer.append((char)n);
                    break;
                }
                default: {
                    if (n == c) break block5;
                    stringBuffer.append((char)n);
                }
            }
        } while (n != -1);
    }

    public int getStreamPos() {
        return this.m_streamIndex;
    }
}

