/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import jess.BindingValue;
import jess.ConditionalElement;
import jess.ConditionalElementX;
import jess.Defglobal;
import jess.Deftemplate;
import jess.Funcall;
import jess.FuncallValue;
import jess.Group;
import jess.JessException;
import jess.RU;
import jess.Rete;
import jess.Test1;
import jess.TestedSlot;
import jess.Value;
import jess.Variable;
import jess.Visitable;
import jess.Visitor;

public class Pattern
implements ConditionalElement,
ConditionalElementX,
Serializable,
Visitable {
    private Deftemplate m_deft;
    private static final int INITSIZE = 1;
    private Test1[][] m_tests;
    private int[] m_slotLengths;
    private boolean m_negated;
    private boolean m_logical;
    private boolean m_explicit;
    private String m_name;
    private String m_boundName;

    public Object clone() {
        try {
            Pattern pattern = (Pattern)super.clone();
            if (this.m_slotLengths != null) {
                pattern.m_slotLengths = (int[])this.m_slotLengths.clone();
            }
            if (this.m_tests != null) {
                pattern.m_tests = (Test1[][])this.m_tests.clone();
                for (int i = 0; i < this.m_tests.length; ++i) {
                    if (this.m_tests[i] == null) continue;
                    pattern.m_tests[i] = (Test1[])this.m_tests[i].clone();
                    for (int j = 0; j < this.m_tests[i].length; ++j) {
                        pattern.m_tests[i][j] = (Test1)this.m_tests[i][j].clone();
                    }
                }
            }
            return pattern;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Pattern(String string, Rete rete) throws JessException {
        this(rete.createDeftemplate(string));
    }

    public Pattern(Deftemplate deftemplate) {
        this.m_name = deftemplate.getName();
        this.m_deft = deftemplate;
        int n = this.m_deft.getNSlots();
        this.m_tests = new Test1[n][];
        this.m_slotLengths = new int[n];
        for (int i = 0; i < n; ++i) {
            this.m_slotLengths[i] = -1;
        }
    }

    Pattern(Pattern pattern, String string) throws JessException {
        this.m_name = string;
        this.m_deft = pattern.m_deft;
        this.m_tests = new Test1[pattern.m_tests.length][];
        for (int i = 0; i < this.m_tests.length; ++i) {
            Test1[] test1Array = this.m_tests[i] = pattern.m_tests[i] == null ? null : new Test1[pattern.m_tests[i].length];
            if (this.m_tests[i] == null) continue;
            System.arraycopy(pattern.m_tests[i], 0, this.m_tests[i], 0, this.m_tests[i].length);
            for (int j = 0; j < this.m_tests[i].length; ++j) {
                Value value = this.m_tests[i][j].m_slotValue;
                if (!(value instanceof Variable) || !value.variableValue(null).startsWith("_blank_")) continue;
                this.m_tests[i][j] = new Test1(this.m_tests[i][j], new Variable(RU.gensym("_blank_"), value.type()));
            }
        }
        this.m_slotLengths = pattern.m_slotLengths;
    }

    public void setSlotLength(String string, int n) throws JessException {
        int n2 = this.m_deft.getSlotIndex(string);
        if (n2 == -1) {
            throw new JessException("Pattern.setSlotLength", "No such slot " + string + " in template", this.m_deft.getName());
        }
        this.m_slotLengths[n2] = n;
    }

    public void addTest(Test1 test1) throws JessException {
        int n;
        String string = test1.m_slot;
        int n2 = this.m_deft.getSlotIndex(string);
        if (n2 == -1) {
            throw new JessException("Pattern.addTest", "No such slot " + string + " in template ", this.m_deft.getName());
        }
        if (this.m_tests[n2] == null) {
            this.m_tests[n2] = new Test1[1];
        }
        for (n = 0; n < this.m_tests[n2].length && this.m_tests[n2][n] != null; ++n) {
        }
        if (n == this.m_tests[n2].length) {
            Test1[] test1Array = new Test1[n + 1];
            System.arraycopy(this.m_tests[n2], 0, test1Array, 0, n);
            this.m_tests[n2] = test1Array;
        }
        if (n > 0 && this.m_tests[n2][n - 1].m_subIdx > test1.m_subIdx) {
            throw new JessException("Pattern.addTest", "Attempt to add out-of-order test: index ", this.m_tests[n2][n - 1].m_subIdx + " > " + test1.m_subIdx);
        }
        this.m_tests[n2][n] = test1;
    }

    void replaceTests(int n, Test1[] test1Array) {
        this.m_tests[n] = test1Array;
    }

    public void addDirectlyMatchedVariables(Set set) throws JessException {
        for (int i = 0; i < this.getNSlots(); ++i) {
            for (int j = 0; j < this.getNTests(i); ++j) {
                boolean bl;
                Test1 test1 = this.getTest(i, j);
                Value value = test1.m_slotValue;
                boolean bl2 = bl = test1.m_test == 0;
                if (!(value instanceof Variable) || !bl) continue;
                String string = value.variableValue(null);
                set.add(string);
            }
        }
        if (this.getBoundName() != null) {
            set.add(this.getBoundName());
        }
    }

    public void renameUnmentionedVariables(Set set, Map map, int n) throws JessException {
        String string = "_" + n + "_";
        for (int i = 0; i < this.getNSlots(); ++i) {
            for (int j = 0; j < this.getNTests(i); ++j) {
                String string2;
                String string3;
                Test1 test1 = this.getTest(i, j);
                Value value = test1.m_slotValue;
                if (!(value instanceof Variable) || Defglobal.isADefglobalName(string3 = value.variableValue(null)) || set.contains(string3) || string3.startsWith(string)) continue;
                if (map.get(string3) == null) {
                    string2 = string + string3;
                    map.put(string3, string2);
                } else {
                    string2 = (String)map.get(string3);
                }
                test1.m_slotValue = new Variable(string2, value.type());
            }
        }
        this.substituteVariableNamesInFuncalls(map);
    }

    public void recordTestedSlots(int n, Set set) {
        for (int i = 0; i < this.getNSlots(); ++i) {
            if (this.m_tests[i] == null) continue;
            set.add(new TestedSlot(n, i));
        }
    }

    private void substituteVariableNamesInFuncalls(Map map) throws JessException {
        for (int i = 0; i < this.getNSlots(); ++i) {
            if (this.getNTests(i) == 0) continue;
            for (int j = 0; j < this.getNTests(i); ++j) {
                Value value = this.getTest((int)i, (int)j).m_slotValue;
                if (value.type() != 64) continue;
                this.substFuncall(value.funcallValue(null), map);
            }
        }
    }

    private void substFuncall(Funcall funcall, Map map) throws JessException {
        for (int i = 1; i < funcall.size(); ++i) {
            Value value = funcall.get(i);
            if (value instanceof Variable) {
                String string = (String)map.get(value.variableValue(null));
                if (string == null) continue;
                funcall.set(new Variable(string, value.type()), i);
                continue;
            }
            if (!(value instanceof FuncallValue)) continue;
            this.substFuncall(value.funcallValue(null), map);
        }
    }

    public void findVariableDefinitions(int n, Map map, Map map2) throws JessException {
        Serializable serializable;
        if (this.m_boundName != null && map.get(this.m_boundName) == null) {
            serializable = new BindingValue(this.m_boundName, this, n, -1, -1, 16);
            map2.put(this.m_boundName, serializable);
        }
        serializable = this.getDeftemplate();
        for (int i = 0; i < this.getNSlots(); ++i) {
            for (int j = 0; j < this.getNTests(i); ++j) {
                String string;
                boolean bl;
                Test1 test1 = this.getTest(i, j);
                Value value = test1.m_slotValue;
                boolean bl2 = bl = test1.m_test == 0;
                if (!(value instanceof Variable) || map.get(string = value.variableValue(null)) != null || map2.get(string) != null || Defglobal.isADefglobalName(string) || !bl) continue;
                int n2 = ((Deftemplate)serializable).getSlotDataType(i);
                map2.put(string, new BindingValue(string, this, n, i, test1.m_subIdx, n2));
            }
        }
    }

    public boolean getNegated() {
        return this.m_negated;
    }

    public void setNegated() {
        this.m_negated = true;
    }

    public void setLogical() {
        this.m_logical = true;
    }

    public boolean getLogical() {
        return this.m_logical;
    }

    public void setExplicit() {
        this.m_explicit = true;
    }

    public boolean getExplicit() {
        return this.m_explicit;
    }

    public boolean getBackwardChaining() {
        return this.m_deft.getBackwardChaining();
    }

    public String getName() {
        if (this.m_name.equals("MAIN::test")) {
            return "test";
        }
        return this.m_name;
    }

    public void setBoundName(String string) throws JessException {
        if ((this.m_negated || this.m_name.equals("test")) && string != null) {
            throw new JessException("Pattern.setBoundName", "Can't bind negated pattern to variable", string);
        }
        this.m_boundName = string;
    }

    public String getBoundName() {
        if (this.isBackwardChainingTrigger() && this.m_boundName == null) {
            this.m_boundName = RU.gensym("__factidx");
        }
        return this.m_boundName;
    }

    public int getNSlots() {
        return this.m_deft.getNSlots();
    }

    public int getNTests(int n) {
        if (this.m_tests[n] == null) {
            return 0;
        }
        return this.m_tests[n].length;
    }

    public int getSlotLength(int n) {
        return this.m_slotLengths[n];
    }

    public int getNMultifieldsInSlot(int n) {
        int n2 = 0;
        if (this.m_tests[n] == null) {
            return n2;
        }
        for (int i = 0; i < this.m_tests[n].length; ++i) {
            if (this.m_tests[n][i].m_slotValue.type() != 8192) continue;
            ++n2;
        }
        return n2;
    }

    public boolean isMultifieldSubslot(int n, int n2) {
        if (this.m_tests[n] == null) {
            return false;
        }
        for (int i = 0; i < this.m_tests[n].length; ++i) {
            if (this.m_tests[n][i].m_slotValue.type() != 8192 || this.m_tests[n][i].m_subIdx != n2) continue;
            return true;
        }
        return false;
    }

    boolean[] getMultifieldFlags(int n) {
        boolean[] blArray = new boolean[this.getSlotLength(n)];
        for (int i = 0; i < this.getSlotLength(n); ++i) {
            if (!this.isMultifieldSubslot(n, i)) continue;
            blArray[i] = true;
        }
        return blArray;
    }

    public Test1 getTest(int n, int n2) {
        return this.m_tests[n][n2];
    }

    public Deftemplate getDeftemplate() {
        return this.m_deft;
    }

    public void addToGroup(Group group) throws JessException {
        group.m_data.add((Pattern)this.clone());
    }

    public ConditionalElementX canonicalize() {
        return this;
    }

    public Object accept(Visitor visitor) {
        return visitor.visitPattern(this);
    }

    public int getGroupSize() {
        return 1;
    }

    public boolean isGroup() {
        return false;
    }

    public ConditionalElement getConditionalElement(int n) {
        return this.getConditionalElementX(n);
    }

    public int getPatternCount() {
        return 1;
    }

    public ConditionalElementX getConditionalElementX(int n) {
        if (n > 0) {
            throw new IllegalArgumentException();
        }
        return this;
    }

    public boolean equals(Object object) {
        int n;
        if (!(object instanceof Pattern)) {
            return false;
        }
        Pattern pattern = (Pattern)object;
        if (!this.getName().equals(pattern.getName())) {
            return false;
        }
        if (this.m_negated != pattern.m_negated) {
            return false;
        }
        for (n = 0; n < this.m_slotLengths.length; ++n) {
            if (this.m_slotLengths[n] == pattern.m_slotLengths[n]) continue;
            return false;
        }
        for (n = 0; n < this.m_tests.length; ++n) {
            if (this.m_tests[n] == null || pattern.m_tests[n] == null) {
                if (this.m_tests[n] == pattern.m_tests[n]) continue;
                return false;
            }
            if (this.m_tests[n].length != pattern.m_tests[n].length) {
                return false;
            }
            for (int i = 0; i < this.m_tests[n].length; ++i) {
                if ((this.m_tests[n][i] == null || pattern.m_tests[n][i] == null) && this.m_tests[n][i] != pattern.m_tests[n][i]) {
                    return false;
                }
                if (this.m_tests[n][i].equals(pattern.m_tests[n][i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isBackwardChainingTrigger() {
        return !this.m_negated && this.m_deft.isBackwardChainingTrigger();
    }

    public String getBackchainingTemplateName() {
        return this.m_deft.getBackchainingTemplateName();
    }

    public String getNameWithoutBackchainingPrefix() {
        return this.m_deft.getNameWithoutBackchainingPrefix();
    }

    public String toString() {
        return "(" + this.getName() + ")";
    }
}

