/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.util.HashMap;
import java.util.Iterator;
import jess.Context;
import jess.Deftemplate;
import jess.Fact;
import jess.JessException;
import jess.Node;
import jess.Node1;
import jess.Node1TECT;
import jess.NodeSink;
import jess.Token;

class NodeRoot
extends Node1 {
    private HashMap m_map = new HashMap();

    NodeRoot() {
    }

    void callNodeRight(int n, Token token, Context context) throws JessException {
        this.passAlong(n, token, context);
    }

    public Iterator successors() {
        return this.m_map.values().iterator();
    }

    void passAlong(int n, Token token, Context context) throws JessException {
        if (n == 3) {
            Iterator iterator = this.m_map.values().iterator();
            while (iterator.hasNext()) {
                ((Node)iterator.next()).callNodeRight(n, token, context);
            }
            return;
        }
        Fact fact = token.fact(0);
        for (Deftemplate deftemplate = fact.getDeftemplate(); deftemplate != null; deftemplate = deftemplate.getParent()) {
            String string = deftemplate.getName();
            Node node = (Node)this.m_map.get(string);
            if (node == null) continue;
            node.callNodeRight(n, token, context);
        }
    }

    Node mergeSuccessor(Node node, NodeSink nodeSink) throws JessException {
        Node1TECT node1TECT;
        Node node2;
        if (node instanceof Node1TECT && (node2 = (Node)this.m_map.get((node1TECT = (Node1TECT)node).getName())) != null) {
            nodeSink.addNode(node2);
            return node2;
        }
        this.addSuccessor(node, nodeSink);
        return node;
    }

    Node addSuccessor(Node node, NodeSink nodeSink) throws JessException {
        if (node instanceof Node1TECT) {
            Node1TECT node1TECT = (Node1TECT)node;
            String string = node1TECT.getName();
            this.m_map.put(string, node1TECT);
            nodeSink.addNode(node);
            return node;
        }
        return null;
    }

    void removeSuccessor(Node node) {
        if (node instanceof Node1TECT) {
            Node1TECT node1TECT = (Node1TECT)node;
            String string = node1TECT.getName();
            this.m_map.remove(string);
        }
    }

    public String toString() {
        return "The root of the Rete network";
    }
}

