/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import jess.Context;
import jess.JessException;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;

class JessSystem
implements Userfunction,
Serializable {
    JessSystem() {
    }

    public String getName() {
        return "system";
    }

    public Value call(ValueVector valueVector, Context context) throws JessException {
        try {
            boolean bl = false;
            int n = valueVector.size();
            if (valueVector.get(n - 1).stringValue(context).equals("&")) {
                bl = true;
                --n;
            }
            String[] stringArray = new String[n - 1];
            for (int i = 1; i < n; ++i) {
                stringArray[i - 1] = valueVector.get(i).stringValue(context);
            }
            Process process = Runtime.getRuntime().exec(stringArray);
            ReaderThread readerThread = new ReaderThread(process.getInputStream(), context.getEngine().getOutStream());
            readerThread.start();
            ReaderThread readerThread2 = new ReaderThread(process.getErrorStream(), context.getEngine().getErrStream());
            readerThread2.start();
            if (!bl) {
                try {
                    process.waitFor();
                    readerThread.join();
                    readerThread2.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return new Value(process);
        }
        catch (IOException iOException) {
            throw new JessException("system", valueVector.toStringWithParens(), iOException);
        }
        catch (SecurityException securityException) {
            throw new JessException("system", valueVector.toStringWithParens(), securityException);
        }
    }

    private class ReaderThread
    extends Thread {
        InputStream m_is;
        Writer m_os;

        ReaderThread(InputStream inputStream, Writer writer) {
            this.m_is = inputStream;
            this.m_os = writer;
            this.setDaemon(true);
        }

        public void run() {
            try {
                int n;
                while ((n = this.m_is.read()) != -1) {
                    this.m_os.write((char)n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

