/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.awt.Button;
import java.util.ArrayList;
import java.util.Arrays;
import jess.Fact;
import jess.Funcall;
import jess.JessEvent;
import jess.JessException;
import jess.JessListener;
import jess.MockBean;
import jess.Rete;
import jess.Value;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class JessEventTest
extends TestCase {
    private Rete m_engine;
    private MockListener m_listener;
    static /* synthetic */ Class class$jess$JessEventTest;

    public static TestSuite suite() {
        return new TestSuite(class$jess$JessEventTest == null ? (class$jess$JessEventTest = JessEventTest.class$("jess.JessEventTest")) : class$jess$JessEventTest);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_engine = new Rete();
        this.m_listener = new MockListener();
        this.m_engine.addJessListener(this.m_listener);
        this.m_engine.setEventMask(48);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.m_engine = null;
        this.m_listener = null;
    }

    public JessEventTest(String string) {
        super(string);
    }

    public void testFuncallEvents() throws JessException {
        Rete rete = new Rete();
        final ArrayList arrayList = new ArrayList();
        JessListener jessListener = new JessListener(){

            public void eventHappened(JessEvent jessEvent) {
                if (jessEvent.getType() == 524288) {
                    Funcall funcall = (Funcall)jessEvent.getObject();
                    arrayList.add(funcall.getName());
                }
            }
        };
        rete.addJessListener(jessListener);
        rete.setDebug(false);
        this.callSomeMethods(rete);
        JessEventTest.assertTrue((boolean)arrayList.isEmpty());
        rete.setDebug(true);
        this.callSomeMethods(rete);
        JessEventTest.assertTrue((boolean)arrayList.isEmpty());
        rete.removeJessListener(jessListener);
        rete.addDebugListener(jessListener);
        rete.setDebug(false);
        this.callSomeMethods(rete);
        JessEventTest.assertTrue((boolean)arrayList.isEmpty());
        rete.setDebug(true);
        this.callSomeMethods(rete);
        JessEventTest.assertEquals((int)4, (int)arrayList.size());
        JessEventTest.assertTrue((boolean)Arrays.equals(new String[]{"reset", "run", "assert", "+"}, arrayList.toArray()));
    }

    public void testFuncallReturnedEvents() throws JessException {
        Rete rete = new Rete();
        final ArrayList arrayList = new ArrayList();
        JessListener jessListener = new JessListener(){

            public void eventHappened(JessEvent jessEvent) {
                if (jessEvent.getType() == 0x200000) {
                    Funcall funcall = (Funcall)jessEvent.getObject();
                    arrayList.add(funcall.getName());
                }
            }
        };
        rete.addJessListener(jessListener);
        rete.setDebug(false);
        this.callSomeMethods(rete);
        JessEventTest.assertTrue((boolean)arrayList.isEmpty());
        rete.setDebug(true);
        this.callSomeMethods(rete);
        JessEventTest.assertTrue((boolean)arrayList.isEmpty());
        rete.removeJessListener(jessListener);
        rete.addDebugListener(jessListener);
        rete.setDebug(false);
        this.callSomeMethods(rete);
        JessEventTest.assertTrue((boolean)arrayList.isEmpty());
        rete.setDebug(true);
        this.callSomeMethods(rete);
        JessEventTest.assertEquals((int)4, (int)arrayList.size());
        JessEventTest.assertTrue((boolean)Arrays.equals(new String[]{"reset", "run", "assert", "+"}, arrayList.toArray()));
    }

    private void callSomeMethods(Rete rete) throws JessException {
        rete.eval("(reset)");
        rete.eval("(run)");
        rete.eval("(assert (foo))");
        rete.eval("(+ 2 2)");
    }

    public void testModifyPlain() throws Exception {
        this.m_engine.eval("(deftemplate foo (slot bar))");
        Fact fact = this.m_engine.assertString("(foo (bar 1))");
        this.m_engine.eval("(modify 0 (bar 2))");
        this.m_engine.retract(fact);
        JessEventTest.assertEquals((int)3, (int)this.m_listener.m_events.size());
        JessEventTest.assertEquals((Object)new Integer(16), this.m_listener.m_events.get(0));
        JessEventTest.assertEquals((Object)new Integer(0x40000010), this.m_listener.m_events.get(1));
        JessEventTest.assertEquals((Object)new Integer(-2147483632), this.m_listener.m_events.get(2));
    }

    public void testModifyCallPlain() throws Exception {
        this.m_engine.eval("(deftemplate foo (slot bar))");
        Fact fact = this.m_engine.assertString("(foo (bar 1))");
        this.m_engine.modify(fact, "bar", new Value(2, 4));
        this.m_engine.retract(fact);
        JessEventTest.assertEquals((int)3, (int)this.m_listener.m_events.size());
        JessEventTest.assertEquals((Object)new Integer(16), this.m_listener.m_events.get(0));
        JessEventTest.assertEquals((Object)new Integer(0x40000010), this.m_listener.m_events.get(1));
        JessEventTest.assertEquals((Object)new Integer(-2147483632), this.m_listener.m_events.get(2));
    }

    public void testRetractPlain() throws Exception {
        Fact fact = this.m_engine.assertString("(Hello)");
        this.m_engine.retract(fact);
        JessEventTest.assertEquals((int)2, (int)this.m_listener.m_events.size());
        JessEventTest.assertEquals((Object)new Integer(16), this.m_listener.m_events.get(0));
        JessEventTest.assertEquals((Object)new Integer(-2147483632), this.m_listener.m_events.get(1));
    }

    public void testAssert() throws Exception {
        this.m_engine.assertString("(Hello)");
        JessEventTest.assertEquals((int)1, (int)this.m_listener.m_events.size());
        JessEventTest.assertEquals((Object)new Integer(16), this.m_listener.m_events.get(0));
    }

    public void testDefinstanceStatic() throws Exception {
        this.m_engine.defclass("button", "java.awt.Button", null);
        Button button = new Button();
        this.m_engine.definstance("button", button, false);
        JessEventTest.assertEquals((int)2, (int)this.m_listener.m_events.size());
        JessEventTest.assertEquals((Object)new Integer(32), this.m_listener.m_events.get(0));
        JessEventTest.assertEquals((Object)new Integer(16), this.m_listener.m_events.get(1));
    }

    public void testDefinstanceDynamic() throws Exception {
        this.m_engine.defclass("bean", "jess.MockBean", null);
        MockBean mockBean = new MockBean();
        this.m_engine.definstance("bean", mockBean, true);
        JessEventTest.assertEquals((int)2, (int)this.m_listener.m_events.size());
        JessEventTest.assertEquals((Object)new Integer(32), this.m_listener.m_events.get(0));
        JessEventTest.assertEquals((Object)new Integer(16), this.m_listener.m_events.get(1));
    }

    public void testUndefinstanceDynamic() throws Exception {
        this.m_engine.defclass("bean", "jess.MockBean", null);
        MockBean mockBean = new MockBean();
        this.m_engine.definstance("bean", mockBean, true);
        this.m_engine.undefinstance(mockBean);
        JessEventTest.assertEquals((int)4, (int)this.m_listener.m_events.size());
        JessEventTest.assertEquals((Object)new Integer(32), this.m_listener.m_events.get(0));
        JessEventTest.assertEquals((Object)new Integer(16), this.m_listener.m_events.get(1));
        JessEventTest.assertEquals((Object)new Integer(-2147483632), this.m_listener.m_events.get(2));
        JessEventTest.assertEquals((Object)new Integer(-2147483616), this.m_listener.m_events.get(3));
    }

    public void testUndefinstanceStatic() throws Exception {
        this.m_engine.defclass("button", "java.awt.Button", null);
        Button button = new Button();
        this.m_engine.definstance("button", button, false);
        this.m_engine.undefinstance(button);
        JessEventTest.assertEquals((int)4, (int)this.m_listener.m_events.size());
        JessEventTest.assertEquals((Object)new Integer(32), this.m_listener.m_events.get(0));
        JessEventTest.assertEquals((Object)new Integer(16), this.m_listener.m_events.get(1));
        JessEventTest.assertEquals((Object)new Integer(-2147483632), this.m_listener.m_events.get(2));
        JessEventTest.assertEquals((Object)new Integer(-2147483616), this.m_listener.m_events.get(3));
    }

    public void testRetractDefinstanceStatic() throws Exception {
        this.m_engine.defclass("button", "java.awt.Button", null);
        Button button = new Button();
        Value value = this.m_engine.definstance("button", button, false);
        this.m_engine.retract(value.factValue(null));
        JessEventTest.assertEquals((int)4, (int)this.m_listener.m_events.size());
        JessEventTest.assertEquals((Object)new Integer(32), this.m_listener.m_events.get(0));
        JessEventTest.assertEquals((Object)new Integer(16), this.m_listener.m_events.get(1));
        JessEventTest.assertEquals((Object)new Integer(-2147483632), this.m_listener.m_events.get(2));
        JessEventTest.assertEquals((Object)new Integer(-2147483616), this.m_listener.m_events.get(3));
    }

    public void testRetractDefinstanceDynamic() throws Exception {
        this.m_engine.defclass("bean", "jess.MockBean", null);
        MockBean mockBean = new MockBean();
        Value value = this.m_engine.definstance("bean", mockBean, true);
        this.m_engine.retract(value.factValue(null));
        JessEventTest.assertEquals((int)4, (int)this.m_listener.m_events.size());
        JessEventTest.assertEquals((Object)new Integer(32), this.m_listener.m_events.get(0));
        JessEventTest.assertEquals((Object)new Integer(16), this.m_listener.m_events.get(1));
        JessEventTest.assertEquals((Object)new Integer(-2147483632), this.m_listener.m_events.get(2));
        JessEventTest.assertEquals((Object)new Integer(-2147483616), this.m_listener.m_events.get(3));
    }

    public void testModifyDefinstanceStatic() throws Exception {
        this.m_engine.defclass("button", "java.awt.Button", null);
        Button button = new Button("Hello");
        this.m_engine.definstance("button", button, false);
        this.m_engine.eval("(modify 0 (label Goodbye))");
        JessEventTest.assertEquals((int)3, (int)this.m_listener.m_events.size());
        JessEventTest.assertEquals((Object)new Integer(32), this.m_listener.m_events.get(0));
        JessEventTest.assertEquals((Object)new Integer(16), this.m_listener.m_events.get(1));
        JessEventTest.assertEquals((Object)new Integer(0x40000010), this.m_listener.m_events.get(2));
    }

    public void testModifyCallDefinstanceStatic() throws Exception {
        this.m_engine.defclass("button", "java.awt.Button", null);
        Button button = new Button("Hello");
        Fact fact = this.m_engine.definstance("button", button, false).factValue(null);
        this.m_engine.modify(fact, "label", new Value("Goodbye", 2));
        JessEventTest.assertEquals((int)3, (int)this.m_listener.m_events.size());
        JessEventTest.assertEquals((Object)new Integer(32), this.m_listener.m_events.get(0));
        JessEventTest.assertEquals((Object)new Integer(16), this.m_listener.m_events.get(1));
        JessEventTest.assertEquals((Object)new Integer(0x40000010), this.m_listener.m_events.get(2));
    }

    public void testModifyDefinstanceDynamic() throws Exception {
        this.m_engine.defclass("bean", "jess.MockBean", null);
        MockBean mockBean = new MockBean();
        this.m_engine.definstance("bean", mockBean, true);
        this.m_engine.eval("(modify 0 (foo zurbitz))");
        JessEventTest.assertEquals((int)3, (int)this.m_listener.m_events.size());
        JessEventTest.assertEquals((Object)new Integer(32), this.m_listener.m_events.get(0));
        JessEventTest.assertEquals((Object)new Integer(16), this.m_listener.m_events.get(1));
        JessEventTest.assertEquals((Object)new Integer(0x40000010), this.m_listener.m_events.get(2));
    }

    public void testModifyCallDefinstanceDynamic() throws Exception {
        this.m_engine.defclass("bean", "jess.MockBean", null);
        MockBean mockBean = new MockBean();
        Fact fact = this.m_engine.definstance("bean", mockBean, true).factValue(null);
        this.m_engine.modify(fact, "foo", new Value("zurbitz", 1));
        JessEventTest.assertEquals((int)3, (int)this.m_listener.m_events.size());
        JessEventTest.assertEquals((Object)new Integer(32), this.m_listener.m_events.get(0));
        JessEventTest.assertEquals((Object)new Integer(16), this.m_listener.m_events.get(1));
        JessEventTest.assertEquals((Object)new Integer(0x40000010), this.m_listener.m_events.get(2));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MockListener
    implements JessListener {
        ArrayList m_events = new ArrayList();

        private MockListener() {
        }

        public void eventHappened(JessEvent jessEvent) throws JessException {
            this.m_events.add(new Integer(jessEvent.getType()));
        }
    }
}

