/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Stack;
import jess.Deftemplate;
import jess.Funcall;
import jess.FuncallValue;
import jess.Jesp;
import jess.JessException;
import jess.JessToken;
import jess.JessTokenStream;
import jess.Pattern;
import jess.RU;
import jess.Rete;
import jess.Test1;
import jess.Value;
import jess.Variable;

class InfixSlotParser {
    private Jesp jesp;
    static final String[] INFIX_OPERATORS = new String[]{"==", "<=", ">=", "<", ">", "!=", "<>"};
    static final String[] LOGICAL_OPERATORS = new String[]{"&&", "||"};

    public InfixSlotParser(Jesp jesp) {
        this.jesp = jesp;
    }

    void parse(Pattern pattern, JessTokenStream jessTokenStream, Rete rete) throws JessException {
        Expr expr;
        boolean bl;
        Stack stack = new Stack();
        JessToken jessToken = this.parseLoop(jessTokenStream, pattern, rete, stack);
        if (stack.size() != 1) {
            this.jesp.error("Jesp.parseInfixExpression", "Syntax error", 1000, jessToken);
        }
        if (bl = (expr = (Expr)stack.pop()).hasOr()) {
            this.combineTestsOnHighestIndexedSlot(expr, pattern, rete);
        } else {
            this.addEachTestToItsOwnSlot(expr, pattern);
        }
    }

    private JessToken parseLoop(JessTokenStream jessTokenStream, Pattern pattern, Rete rete, Stack stack) throws JessException {
        JessToken jessToken;
        while (true) {
            jessToken = this.jesp.nextToken(jessTokenStream);
            if (jessToken.m_ttype == 125 || jessToken.m_ttype == 41) break;
            jessTokenStream.pushBack(jessToken);
            this.parseExpr(jessTokenStream, pattern, rete, stack);
        }
        return jessToken;
    }

    private void parseExpr(JessTokenStream jessTokenStream, Pattern pattern, Rete rete, Stack stack) throws JessException {
        JessToken jessToken = this.jesp.nextToken(jessTokenStream);
        if (jessToken.m_ttype == 40) {
            Stack stack2 = new Stack();
            jessToken = this.parseLoop(jessTokenStream, pattern, rete, stack2);
            if (stack2.isEmpty()) {
                this.jesp.error("Jesp.parseInfixExpression", "Unexpected token", 1000, jessToken);
            } else if (stack2.size() > 1) {
                this.jesp.error("Jesp.parseInfixExpression", "Unexpected token", 1000, jessToken);
            } else {
                Expr expr = (Expr)stack2.pop();
                this.combineExprOnStack(stack, expr, jessToken);
            }
        } else {
            if (jessToken.m_ttype == 41) {
                return;
            }
            if (this.isRelationalOperator(jessToken)) {
                if (stack.isEmpty()) {
                    this.jesp.error("Jesp.parseInfixExpression", "Unexpected token", 1000, jessToken);
                } else if (stack.peek() instanceof OperatorExpr) {
                    this.jesp.error("Jesp.parseInfixExpression", "Unexpected token", 1000, jessToken);
                } else {
                    OperatorExpr operatorExpr = new OperatorExpr(jessToken.m_sval);
                    stack.push(operatorExpr);
                }
            } else {
                jessTokenStream.pushBack(jessToken);
                Expr expr = this.parseOneTest(pattern, jessTokenStream, rete);
                this.combineExprOnStack(stack, expr, jessToken);
            }
        }
    }

    private void combineExprOnStack(Stack stack, Expr expr, JessToken jessToken) throws JessException {
        if (!stack.empty()) {
            if (stack.peek() instanceof OperatorExpr) {
                String string = ((OperatorExpr)stack.pop()).operator;
                Expr expr2 = (Expr)stack.pop();
                RelationExpr relationExpr = new RelationExpr(expr2, string, expr);
                stack.push(relationExpr);
            } else {
                this.jesp.error("Jesp.parseInfixExpression", "Logical operator expected", LOGICAL_OPERATORS, 1000, jessToken);
            }
        } else {
            stack.push(expr);
        }
    }

    private Expr parseOneTest(Pattern pattern, JessTokenStream jessTokenStream, Rete rete) throws JessException {
        InfixTest1 infixTest1;
        String string = this.parseSlotForInfixPattern(jessTokenStream, pattern);
        String string2 = this.parseOperatorForInfixPattern(jessTokenStream);
        Value value = this.parseOperandForInfixPattern(jessTokenStream, rete, pattern);
        if (value.type() != 64 && (string2.equals("==") || string2.equals("!=") || string2.equals("<>"))) {
            int n = string2.equals("==") ? 0 : 1;
            infixTest1 = new InfixTest1(n, -1, value, string);
            infixTest1.slotName = string;
        } else {
            if (string2.equals("==")) {
                string2 = "=";
            } else if (string2.equals("!=")) {
                string2 = "<>";
            }
            infixTest1 = this.buildFunctionForInfixPattern(pattern, string, string2, rete, value);
        }
        return new TestExpr(infixTest1);
    }

    private void addEachTestToItsOwnSlot(Expr expr, Pattern pattern) throws JessException {
        Iterator iterator = this.allTests(expr);
        while (iterator.hasNext()) {
            InfixTest1 infixTest1 = (InfixTest1)iterator.next();
            pattern.addTest(infixTest1);
        }
    }

    private Iterator allTests(Expr expr) {
        ArrayList arrayList = new ArrayList();
        this.addTestsToList(expr, arrayList);
        return arrayList.iterator();
    }

    private void addTestsToList(Expr expr, ArrayList arrayList) {
        if (expr instanceof TestExpr) {
            InfixTest1 infixTest1 = ((TestExpr)expr).test;
            arrayList.add(infixTest1);
        } else {
            RelationExpr relationExpr = (RelationExpr)expr;
            this.addTestsToList(relationExpr.left, arrayList);
            this.addTestsToList(relationExpr.right, arrayList);
        }
    }

    private void combineTestsOnHighestIndexedSlot(Expr expr, Pattern pattern, Rete rete) throws JessException {
        String string = this.highestIndexedSlot(this.allTests(expr), pattern.getDeftemplate());
        FuncallValue funcallValue = new FuncallValue(expr.getFuncall(rete));
        Test1 test1 = new Test1(0, string, funcallValue, 1);
        pattern.addTest(test1);
    }

    private String highestIndexedSlot(Iterator iterator, Deftemplate deftemplate) throws JessException {
        int n = 0;
        while (iterator.hasNext()) {
            String string = ((InfixTest1)iterator.next()).slotName;
            int n2 = deftemplate.getSlotIndex(string);
            if (n2 <= n) continue;
            n = n2;
        }
        return deftemplate.getSlotName(n);
    }

    private InfixTest1 buildFunctionForInfixPattern(Pattern pattern, String string, String string2, Rete rete, Value value) throws JessException {
        Deftemplate deftemplate = pattern.getDeftemplate();
        Value value2 = this.jesp.findAnyExistingVariable(pattern, deftemplate.getSlotIndex(string), -1);
        if (value2 == null) {
            value2 = new Variable(RU.gensym("__jesp"), 8);
            pattern.addTest(new Test1(0, string, -1, value2));
        }
        Funcall funcall = new Funcall(string2, rete);
        funcall.arg(value2);
        funcall.arg(value);
        return new InfixTest1(0, -1, (Value)new FuncallValue(funcall), string);
    }

    private boolean isInfixOperator(JessToken jessToken) {
        String string = jessToken.toString();
        return Arrays.binarySearch(INFIX_OPERATORS, string) > -1;
    }

    private boolean isRelationalOperator(JessToken jessToken) {
        String string = jessToken.toString();
        return string.equals("||") || string.equals("&&");
    }

    private String parseOperatorForInfixPattern(JessTokenStream jessTokenStream) throws JessException {
        JessToken jessToken = this.jesp.nextToken(jessTokenStream);
        if (!this.isInfixOperator(jessToken)) {
            this.jesp.error("parseInfixSlot", "Expected operator", INFIX_OPERATORS, 1000, jessToken);
        }
        return jessToken.m_sval;
    }

    private String parseSlotForInfixPattern(JessTokenStream jessTokenStream, Pattern pattern) throws JessException {
        int n;
        Value value;
        String string;
        Deftemplate deftemplate = pattern.getDeftemplate();
        if (deftemplate.getSlotType(string = this.jesp.checkForValidSlotName(jessTokenStream, deftemplate)) == 32768) {
            this.jesp.error("parseInfixSlot", "Can't use infix expressions with multislots", deftemplate.getSlotNames(), 1001, jessTokenStream.getLastToken());
        }
        if ((value = this.jesp.findAnyExistingVariable(pattern, n = pattern.getDeftemplate().getSlotIndex(string), -1)) == null) {
            value = new Variable(string, 8);
            pattern.addTest(new Test1(0, string, -1, value));
        }
        return string;
    }

    private Value parseOperandForInfixPattern(JessTokenStream jessTokenStream, Rete rete, Pattern pattern) throws JessException {
        String string;
        Deftemplate deftemplate;
        int n;
        JessToken jessToken = this.jesp.nextToken(jessTokenStream);
        Value value = this.jesp.tokenToValue(jessToken, rete, jessTokenStream);
        if (value.type() == 1 && (n = (deftemplate = pattern.getDeftemplate()).getSlotIndex(string = value.symbolValue(null))) != -1) {
            value = this.jesp.findAnyExistingVariable(pattern, n, -1);
            if (value == null) {
                value = new Variable(string, 8);
            }
            pattern.addTest(new Test1(0, string, -1, value));
        }
        return value;
    }

    static {
        Arrays.sort(INFIX_OPERATORS);
    }

    static class OperatorExpr
    implements Expr {
        String operator;

        public OperatorExpr(String string) {
            this.operator = string;
        }

        public boolean hasOr() {
            return this.operator.equals("||");
        }

        public Funcall getFuncall(Rete rete) {
            throw new RuntimeException("Operation not supported");
        }
    }

    static class RelationExpr
    implements Expr {
        Expr left;
        String operator;
        Expr right;

        public RelationExpr(Expr expr, String string, Expr expr2) {
            this.left = expr;
            this.operator = string;
            this.right = expr2;
        }

        public boolean hasOr() {
            return "||".equals(this.operator) || this.left.hasOr() || this.right.hasOr();
        }

        public Funcall getFuncall(Rete rete) throws JessException {
            String string = this.operator.equals("&&") ? "and" : "or";
            Funcall funcall = new Funcall(string, rete);
            funcall.arg(this.left.getFuncall(rete));
            funcall.arg(this.right.getFuncall(rete));
            return funcall;
        }
    }

    static class TestExpr
    implements Expr {
        InfixTest1 test;

        public TestExpr(InfixTest1 infixTest1) {
            this.test = infixTest1;
        }

        public boolean hasOr() {
            return false;
        }

        public Funcall getFuncall(Rete rete) throws JessException {
            if (this.test.m_slotValue instanceof FuncallValue) {
                return this.test.m_slotValue.funcallValue(null);
            }
            Funcall funcall = new Funcall("eq", rete);
            funcall.arg(new Variable(this.test.slotName, 8));
            funcall.arg(this.test.m_slotValue);
            return funcall;
        }
    }

    static interface Expr {
        public boolean hasOr();

        public Funcall getFuncall(Rete var1) throws JessException;
    }

    static class InfixTest1
    extends Test1 {
        private String slotName;

        public InfixTest1(int n, int n2, Value value, String string) {
            super(n, string, n2, value);
            this.slotName = string;
        }
    }
}

