/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import jess.And;
import jess.ArithmeticFunctions;
import jess.BagFunctions;
import jess.Batch;
import jess.Bind;
import jess.Context;
import jess.ControlFunctions;
import jess.DebugFunctions;
import jess.Defadvice;
import jess.DoBackwardChaining;
import jess.DumpFunctions;
import jess.FactFunctions;
import jess.FuncallValue;
import jess.FunctionHolder;
import jess.GensymStar;
import jess.HaltEtc;
import jess.Help;
import jess.IOFunctions;
import jess.Implement;
import jess.IntrinsicPackage;
import jess.Jesp;
import jess.JessException;
import jess.JessVersion;
import jess.Lambda;
import jess.LispFunctions;
import jess.ListRenderer;
import jess.LongValue;
import jess.MathFunctions;
import jess.MiscFunctions;
import jess.ModuleFunctions;
import jess.MultiFunctions;
import jess.Not;
import jess.Or;
import jess.PredFunctions;
import jess.Provide;
import jess.QueryFunctions;
import jess.ReflectFunctions;
import jess.RegexpFunctions;
import jess.Remove;
import jess.Require;
import jess.RequireStar;
import jess.Rete;
import jess.SetWatchRouter;
import jess.StoreFetch;
import jess.StringFunctions;
import jess.SymCat;
import jess.UnDeffacts;
import jess.UnDefrule;
import jess.Unwatch;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;
import jess.ViewFunctions;
import jess.Visitable;
import jess.Visitor;
import jess.Watch;
import jess.server.LineNumberRecord;

public class Funcall
extends ValueVector
implements Serializable,
Visitable {
    public static Value TRUE;
    public static Value FALSE;
    public static Value NIL;
    public static Value NILLIST;
    public static Value EOF;
    public static Value CRLF;
    public static Value T;
    static Value s_else;
    static Value s_then;
    static Value s_do;
    private static HashMap m_intrinsics;
    private FunctionHolder m_function;

    public String toString() {
        try {
            if (this.get(0).equals("assert")) {
                ListRenderer listRenderer = new ListRenderer("assert");
                for (int i = 1; i < this.size(); ++i) {
                    listRenderer.add(this.get(i).factValue(null));
                }
                return listRenderer.toString();
            }
            if (this.get(0).equals("modify") || this.get(0).equals("duplicate")) {
                ListRenderer listRenderer = new ListRenderer(this.get(0).symbolValue(null));
                listRenderer.add(this.get(1));
                for (int i = 2; i < this.size(); ++i) {
                    Value value = this.get(i);
                    listRenderer.add(value.toStringWithParens());
                }
                return listRenderer.toString();
            }
            return new ListRenderer(super.toString()).toString();
        }
        catch (JessException jessException) {
            return jessException.toString();
        }
    }

    public String toStringWithParens() {
        return this.toString();
    }

    static Userfunction getIntrinsic(String string) {
        return (Userfunction)m_intrinsics.get(string);
    }

    public static Iterator listIntrinsics() {
        return m_intrinsics.values().iterator();
    }

    private static void addIntrinsic(Userfunction userfunction) {
        m_intrinsics.put(userfunction.getName(), userfunction);
    }

    private static void addPackage(IntrinsicPackage intrinsicPackage) {
        intrinsicPackage.add(m_intrinsics);
    }

    private static void loadIntrinsics() throws JessException {
        try {
            Funcall.addIntrinsic(new Remove());
            Funcall.addIntrinsic(new Help());
            Funcall.addIntrinsic(new DoBackwardChaining());
            Funcall.addIntrinsic(new GensymStar());
            Funcall.addIntrinsic(new Bind());
            Funcall.addIntrinsic(new And());
            Funcall.addIntrinsic(new Or());
            Funcall.addIntrinsic(new Not());
            Funcall.addIntrinsic(new SymCat());
            Funcall.addIntrinsic(new UnDefrule());
            Funcall.addIntrinsic(new UnDeffacts());
            Funcall.addIntrinsic(new Batch());
            Funcall.addIntrinsic(new Implement());
            Funcall.addIntrinsic(new Lambda());
            Funcall.addIntrinsic(new Require());
            Funcall.addIntrinsic(new RequireStar());
            Funcall.addIntrinsic(new Provide());
            Funcall.addIntrinsic(new Watch());
            Funcall.addIntrinsic(new Unwatch());
            Funcall.addIntrinsic(new SetWatchRouter());
            Funcall.addIntrinsic(new JessVersion(0));
            Funcall.addIntrinsic(new JessVersion(1));
            Funcall.addIntrinsic(new HaltEtc(0));
            Funcall.addIntrinsic(new HaltEtc(1));
            Funcall.addIntrinsic(new HaltEtc(2));
            Funcall.addIntrinsic(new HaltEtc(3));
            Funcall.addIntrinsic(new HaltEtc(4));
            Funcall.addIntrinsic(new HaltEtc(5));
            Funcall.addIntrinsic(new StoreFetch(0));
            Funcall.addIntrinsic(new StoreFetch(1));
            Funcall.addIntrinsic(new StoreFetch(2));
            Funcall.addIntrinsic(new Defadvice("defadvice"));
            Funcall.addIntrinsic(new Defadvice("undefadvice"));
            Funcall.addPackage(new FactFunctions());
            Funcall.addPackage(new IOFunctions());
            Funcall.addPackage(new ControlFunctions());
            Funcall.addPackage(new ArithmeticFunctions());
            Funcall.addPackage(new ReflectFunctions());
            Funcall.addPackage(new StringFunctions());
            Funcall.addPackage(new PredFunctions());
            Funcall.addPackage(new MultiFunctions());
            Funcall.addPackage(new MiscFunctions());
            Funcall.addPackage(new ModuleFunctions());
            Funcall.addPackage(new MathFunctions());
            Funcall.addPackage(new LispFunctions());
            Funcall.addPackage(new DumpFunctions());
            Funcall.addPackage(new ReflectFunctions());
            Funcall.addPackage(new ViewFunctions());
            Funcall.addPackage(new BagFunctions());
            Funcall.addPackage(new RegexpFunctions());
            Funcall.addPackage(new DebugFunctions());
            Funcall.addPackage(new QueryFunctions());
        }
        catch (Throwable throwable) {
            throw new JessException("Funcall.loadIntrisics", "Missing non-optional function class", throwable);
        }
    }

    public Funcall(String string, Rete rete) throws JessException {
        this.add(new Value(string, 1));
        this.m_function = rete.findFunctionHolder(string);
    }

    private Funcall(int n) {
        super(n);
    }

    public String getName() {
        try {
            return this.get(0).stringValue(null);
        }
        catch (JessException jessException) {
            return null;
        }
    }

    public Object clone() {
        Funcall funcall = new Funcall(this.size());
        this.cloneInto(funcall);
        LineNumberRecord lineNumberRecord = Rete.lookupFunction(this);
        if (lineNumberRecord != null) {
            Rete.recordFunction(funcall, lineNumberRecord);
        }
        return funcall;
    }

    public Funcall cloneInto(Funcall funcall) {
        super.cloneInto(funcall);
        funcall.m_function = this.m_function;
        return funcall;
    }

    public final Value execute(Context context) throws JessException {
        Rete rete = context.getEngine();
        try {
            this.resolve(rete);
            rete.broadcastEvent(524288, this, context);
            Value value = this.m_function.call(this, context);
            return value;
        }
        catch (JessException jessException) {
            jessException.addContext(this.toStringWithParens());
            throw jessException;
        }
        catch (Exception exception) {
            String string = this.get(0).stringValue(context);
            JessException jessException = new JessException(string, "Error during execution", exception);
            jessException.addContext(this.toStringWithParens());
            throw jessException;
        }
        finally {
            rete.broadcastEvent(0x200000, this, context);
        }
    }

    public Userfunction getUserfunction(Rete rete) throws JessException {
        this.resolve(rete);
        return this.m_function.getFunction();
    }

    void resolve(Rete rete) throws JessException {
        if (this.m_function == null) {
            String string = this.get(0).stringValue(null);
            this.m_function = rete.findFunctionHolder(string);
            if (this.m_function == null) {
                this.undefinedFunction(string);
            }
        }
    }

    private void undefinedFunction(String string) throws JessException {
        String string2 = Jesp.isAConstructName(string) ? "This construct can only be used at the top level of a program; it can't be used as if it were a function:" : "Undefined function";
        throw new JessException("Funcall.execute", string2, string);
    }

    public Funcall arg(Value value) {
        this.add(value);
        return this;
    }

    public Funcall arg(String string) throws JessException {
        this.add(new Value(string, 1));
        return this;
    }

    public Funcall arg(int n) throws JessException {
        this.add(new Value(n, 4));
        return this;
    }

    public Funcall arg(double d) throws JessException {
        this.add(new Value(d, 32));
        return this;
    }

    public Funcall arg(long l) throws JessException {
        this.add(new LongValue(l));
        return this;
    }

    public Funcall arg(Funcall funcall) throws JessException {
        this.add(new FuncallValue(funcall));
        return this;
    }

    public Funcall arg(Object object) throws JessException {
        this.add(new Value(object));
        return this;
    }

    public Value get(int n) throws JessException {
        if (n < 0) {
            throw new JessException("Funcall.get", "Negative index " + n + " out of bounds on this Funcall:", this.toStringWithParens());
        }
        if (n >= this.m_ptr) {
            throw new JessException("Funcall.get", "Missing argument(s) in function call", this.toStringWithParens());
        }
        return this.m_v[n];
    }

    public Object accept(Visitor visitor) {
        return visitor.visitFuncall(this);
    }

    static {
        m_intrinsics = new HashMap();
        try {
            TRUE = new Value("TRUE", 1);
            FALSE = new Value("FALSE", 1);
            NIL = new Value("nil", 1);
            NILLIST = new Value(new ValueVector(), 512);
            EOF = new Value("EOF", 1);
            T = new Value("t", 1);
            CRLF = new Value("crlf", 1);
            s_else = new Value("else", 1);
            s_then = new Value("then", 1);
            s_do = new Value("do", 1);
            Funcall.loadIntrinsics();
        }
        catch (JessException jessException) {
            System.out.println("*** FATAL ***: Can't initialize Jess");
            jessException.printStackTrace();
            System.exit(0);
        }
    }
}

