/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeMap;
import jess.Activation;
import jess.Deftemplate;
import jess.HeapPriorityQueue;
import jess.JessException;
import jess.Named;
import jess.Rete;
import jess.Strategy;
import jess.Visitable;
import jess.Visitor;

public class Defmodule
implements Serializable,
Named,
Visitable {
    public static final String MAIN = "MAIN";
    private HeapPriorityQueue m_queue;
    private TreeMap m_deftemplates;
    private String m_name;
    private String m_comment;

    public Defmodule() {
        this(MAIN, "Default module");
    }

    public Defmodule(String string, String string2) {
        this.m_name = string;
        this.m_comment = string2;
        this.m_deftemplates = new TreeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String setStrategy(Strategy strategy, Rete rete) throws JessException {
        if (this.m_queue == null) {
            this.m_queue = new HeapPriorityQueue(strategy);
            return strategy.getName();
        }
        HeapPriorityQueue heapPriorityQueue = this.m_queue;
        synchronized (heapPriorityQueue) {
            Iterator iterator = this.m_queue.iterator();
            this.m_queue.clear();
            String string = this.m_queue.setStrategy(strategy).getName();
            while (iterator.hasNext()) {
                Activation activation = (Activation)iterator.next();
                if (activation.isInactive()) continue;
                rete.addActivation(activation);
            }
            return string;
        }
    }

    HeapPriorityQueue getQueue() {
        return this.m_queue;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDocstring() {
        return this.m_comment;
    }

    void reset() {
        this.m_queue.clear();
    }

    public Iterator listDeftemplates() {
        return this.m_deftemplates.values().iterator();
    }

    public Deftemplate getDeftemplate(String string) {
        int n = string.indexOf("::");
        if (n != -1) {
            string = string.substring(n + 2);
        }
        return (Deftemplate)this.m_deftemplates.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deftemplate addDeftemplate(Deftemplate deftemplate, Rete rete) throws JessException {
        TreeMap treeMap = this.m_deftemplates;
        synchronized (treeMap) {
            if (!deftemplate.getModule().equals(this.m_name)) {
                throw new JessException("Defmodule.addDeftemplate", "Wrong module name", deftemplate.getModule());
            }
            String string = deftemplate.getBaseName();
            Deftemplate deftemplate2 = (Deftemplate)this.m_deftemplates.get(string);
            if (deftemplate2 != null && !deftemplate2.equals(deftemplate)) {
                throw new JessException("Defmodule.addDeftemplate", "Cannot redefine deftemplate", deftemplate.getName());
            }
            rete.broadcastEvent(64, deftemplate, null);
            this.m_deftemplates.put(string, deftemplate);
            return deftemplate;
        }
    }

    public final String getConstructType() {
        return "defmodule";
    }

    public Object accept(Visitor visitor) {
        return visitor.visitDefmodule(this);
    }
}

