/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import jess.Rete;
import jess.Value;
import junit.framework.TestCase;

public class ControlFunctionsTest
extends TestCase {
    public ControlFunctionsTest(String string) {
        super(string);
    }

    public void testForeachIterator() throws Exception {
        List<String> list = Arrays.asList("1", "2", "3");
        Rete rete = new Rete();
        StringWriter stringWriter = new StringWriter();
        rete.addOutputRouter("t", stringWriter);
        rete.store("LIST", list);
        String string = "(foreach ?n (fetch LIST) (printout t ?n crlf))";
        rete.eval(string);
        ControlFunctionsTest.assertEquals((String)"1\n2\n3\n", (String)stringWriter.toString());
    }

    public void testForeachIteratorRules() throws Exception {
        Rete rete = new Rete();
        rete.eval("(defrule foo => )");
        rete.eval("(defrule bar => )");
        rete.eval("(defrule baz => )");
        StringWriter stringWriter = new StringWriter();
        rete.addOutputRouter("t", stringWriter);
        String string = "(foreach ?r ((engine) listDefrules) (printout t (?r getName) crlf))";
        rete.eval(string);
        ControlFunctionsTest.assertEquals((String)"MAIN::bar\nMAIN::baz\nMAIN::foo\n", (String)stringWriter.toString());
    }

    public void testForHappy() throws Exception {
        String string = "(for (bind ?i 0) (< ?i 5) (++ ?i) (printout t ?i crlf))";
        Rete rete = new Rete();
        StringWriter stringWriter = new StringWriter();
        rete.addOutputRouter("t", stringWriter);
        rete.eval(string);
        ControlFunctionsTest.assertEquals((String)"0\n1\n2\n3\n4\n", (String)stringWriter.toString());
    }

    public void testParentContextAccess() throws Exception {
        String string = "(for (bind ?i 0) (< ?i 5) (++ ?i) (printout t (+ ?j ?i) crlf))";
        Rete rete = new Rete();
        StringWriter stringWriter = new StringWriter();
        rete.addOutputRouter("t", stringWriter);
        rete.getGlobalContext().setVariable("j", new Value(10));
        rete.eval(string);
        ControlFunctionsTest.assertEquals((String)"10\n11\n12\n13\n14\n", (String)stringWriter.toString());
    }

    public void testForEmptyBody() throws Exception {
        String string = "(for (bind ?i 0) (< ?i 5) (progn (printout t ?i crlf) (++ ?i)))";
        Rete rete = new Rete();
        StringWriter stringWriter = new StringWriter();
        rete.addOutputRouter("t", stringWriter);
        rete.eval(string);
        ControlFunctionsTest.assertEquals((String)"0\n1\n2\n3\n4\n", (String)stringWriter.toString());
    }

    public void testForNilIncrement() throws Exception {
        String string = "(for (bind ?i 0) (< ?i 5) nil (printout t ?i crlf) (++ ?i))";
        Rete rete = new Rete();
        StringWriter stringWriter = new StringWriter();
        rete.addOutputRouter("t", stringWriter);
        rete.eval(string);
        ControlFunctionsTest.assertEquals((String)"0\n1\n2\n3\n4\n", (String)stringWriter.toString());
    }

    public void testForNilInitializer() throws Exception {
        String string = "(for nil (< ?i 5) (++ ?i) (printout t ?i crlf))";
        Rete rete = new Rete();
        StringWriter stringWriter = new StringWriter();
        rete.addOutputRouter("t", stringWriter);
        rete.getGlobalContext().setVariable("i", new Value(0));
        rete.eval(string);
        ControlFunctionsTest.assertEquals((String)"0\n1\n2\n3\n4\n", (String)stringWriter.toString());
    }

    public void testForNilTest() throws Exception {
        String string = "(for (bind ?i 0) nil (++ ?i) (printout t ?i crlf) (if (eq ?i 4) then (return)))";
        Rete rete = new Rete();
        StringWriter stringWriter = new StringWriter();
        rete.addOutputRouter("t", stringWriter);
        rete.getGlobalContext().setVariable("i", new Value(0));
        rete.eval(string);
        ControlFunctionsTest.assertEquals((String)"0\n1\n2\n3\n4\n", (String)stringWriter.toString());
    }
}

