/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import jess.ConsolePanel;
import jess.Main;
import jess.Rete;

public class Console
extends Frame
implements Serializable {
    ConsolePanel m_panel;
    Rete m_engine;
    boolean m_doEcho = true;

    public Console(String string) {
        this(string, true);
    }

    public Console(String string, boolean bl) {
        this(string, new Rete(), bl);
    }

    public Console(String string, Rete rete) {
        this(string, rete, true);
    }

    public Console(String string, Rete rete, boolean bl) {
        super(string);
        this.m_engine = rete;
        this.m_panel = new ConsolePanel(rete, bl);
        this.m_doEcho = bl;
        this.add("Center", this.m_panel);
        this.validate();
        this.setSize(500, 300);
        this.setVisible(true);
    }

    public Rete getEngine() {
        return this.m_engine;
    }

    public void execute(String[] stringArray) {
        Main main = new Main();
        main.initialize(stringArray, this.m_engine);
        this.m_panel.setFocus();
        while (true) {
            main.execute(this.m_doEcho);
        }
    }

    public static void main(String[] stringArray) {
        Console console = new Console("Jess Console");
        console.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        console.execute(stringArray);
    }
}

