/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.beans.IntrospectionException;
import java.util.Arrays;
import java.util.Comparator;
import jess.ClassResearcher;
import jess.Deftemplate;
import jess.Funcall;
import jess.JessException;
import jess.Rete;
import jess.SerializablePD;
import jess.SerializableVD;
import jess.Value;

class ClassTemplateMaker {
    private Rete m_engine;
    private String m_className;
    private final ClassResearcher m_classResearcher;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    ClassTemplateMaker(Rete rete, String string) throws ClassNotFoundException, JessException {
        this.m_classResearcher = rete.getClassResearcher();
        this.m_engine = rete;
        this.m_className = this.m_classResearcher.resolveClassName(string);
    }

    public String getClassName() {
        return this.m_className;
    }

    public Deftemplate createDeftemplate(String string, String string2, boolean bl) throws JessException {
        try {
            Deftemplate deftemplate;
            if (string2 != null) {
                Deftemplate deftemplate2 = this.m_engine.findDeftemplate(this.m_engine.resolveName(string2));
                if (deftemplate2 == null) {
                    throw new JessException("defclass", "No such parent template: ", string2);
                }
                deftemplate = new Deftemplate(string, "$JAVA-OBJECT$ " + this.m_className, deftemplate2, this.m_engine);
            } else {
                deftemplate = new Deftemplate(string, "$JAVA-OBJECT$ " + this.m_className, this.m_engine);
            }
            this.addBeanProperties(deftemplate);
            if (bl) {
                this.addPublicVariableSlots(deftemplate);
            }
            this.addActiveInstanceSlot(deftemplate);
            return deftemplate;
        }
        catch (IntrospectionException introspectionException) {
            throw new JessException("defclass", "Introspection error:", introspectionException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JessException("defclass", "Class not found:", classNotFoundException);
        }
    }

    private void addPublicVariableSlots(Deftemplate deftemplate) throws JessException, ClassNotFoundException, IntrospectionException {
        ClassResearcher.Property[] propertyArray = this.m_classResearcher.getPublicInstanceFields(this.m_className);
        Arrays.sort(propertyArray, new Comparator(){

            public int compare(Object object, Object object2) {
                ClassResearcher.Property property = (ClassResearcher.Property)object;
                ClassResearcher.Property property2 = (ClassResearcher.Property)object2;
                return property.name.compareTo(property2.name);
            }
        });
        for (int i = 0; i < propertyArray.length; ++i) {
            String string = propertyArray[i].name;
            String string2 = propertyArray[i].type;
            Value value = new Value(new SerializableVD(this.m_className, string));
            if (propertyArray[i].isArray) {
                deftemplate.addMultiSlot(string, value, string2);
                continue;
            }
            deftemplate.addSlot(string, value, string2);
        }
    }

    private void addActiveInstanceSlot(Deftemplate deftemplate) throws JessException {
        deftemplate.addSlot("OBJECT", Funcall.NIL, "OBJECT");
    }

    private void addBeanProperties(Deftemplate deftemplate) throws JessException, IntrospectionException, ClassNotFoundException {
        ClassResearcher.Property[] propertyArray = this.m_classResearcher.getBeanProperties(this.m_className);
        Arrays.sort(propertyArray, new Comparator(){

            public int compare(Object object, Object object2) {
                ClassResearcher.Property property = (ClassResearcher.Property)object;
                ClassResearcher.Property property2 = (ClassResearcher.Property)object2;
                return property.name.compareTo(property2.name);
            }
        });
        for (int i = 0; i < propertyArray.length; ++i) {
            String string = propertyArray[i].name;
            Value value = new Value(new SerializablePD(this.m_className, string));
            if (propertyArray[i].isArray) {
                deftemplate.addMultiSlot(string, value, propertyArray[i].type);
                continue;
            }
            deftemplate.addSlot(string, value, propertyArray[i].type);
        }
    }

    static String getSlotType(Class clazz) {
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = ClassTemplateMaker.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = ClassTemplateMaker.class$("java.lang.Short")) : class$java$lang$Short) || clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = ClassTemplateMaker.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return "INTEGER";
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ClassTemplateMaker.class$("java.lang.Long")) : class$java$lang$Long)) {
            return "LONG";
        }
        if (clazz == Boolean.TYPE || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassTemplateMaker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return "SYMBOL";
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ClassTemplateMaker.class$("java.lang.Float")) : class$java$lang$Float) || clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ClassTemplateMaker.class$("java.lang.Double")) : class$java$lang$Double)) {
            return "FLOAT";
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = ClassTemplateMaker.class$("java.lang.String")) : class$java$lang$String)) {
            return "STRING";
        }
        return "ANY";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

