/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import jess.Activation;
import jess.Context;
import jess.Defmodule;
import jess.HeapPriorityQueue;
import jess.JessException;
import jess.RU;
import jess.Rete;
import jess.Strategy;
import jess.depth;

class Agenda
implements Serializable {
    private final Object m_activationSemaphore = new String("ACTIVATION LOCK");
    private volatile boolean m_halt = false;
    private int m_evalSalience = 0;
    private HashMap m_modules = new HashMap();
    private String m_thisModule;
    private Strategy m_strategy = new depth();
    private final Stack m_focusStack = new Stack();
    private Activation m_thisActivation;
    private HashSet m_toAdd = new HashSet();
    private HashSet m_toRemove = new HashSet();

    Agenda(Rete rete) {
        try {
            this.addDefmodule(new Defmodule(), rete);
        }
        catch (JessException jessException) {
            throw new RuntimeException("Can't define module MAIN");
        }
    }

    void setEvalSalience(int n) throws JessException {
        if (n < 0 || n > 2) {
            throw new JessException("Agenda.setEvalSalience", "Invalid value", n);
        }
        this.m_evalSalience = n;
    }

    int getEvalSalience() {
        return this.m_evalSalience;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset(Rete rete) throws JessException {
        Object object = this.m_modules.values().iterator();
        while (object.hasNext()) {
            Defmodule defmodule = (Defmodule)object.next();
            defmodule.reset();
        }
        object = this.m_focusStack;
        synchronized (object) {
            this.m_focusStack.clear();
            this.m_focusStack.push("MAIN");
        }
        rete.broadcastEvent(0x100000, "MAIN", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear(Rete rete) throws JessException {
        this.m_modules.clear();
        this.m_strategy = new depth();
        this.addDefmodule(new Defmodule(), rete);
        this.m_focusStack.clear();
        Object object = this.m_activationSemaphore;
        synchronized (object) {
            this.m_halt = false;
            this.m_activationSemaphore.notifyAll();
        }
    }

    Object getActivationSemaphore() {
        return this.m_activationSemaphore;
    }

    HeapPriorityQueue getQueue() {
        return ((Defmodule)this.m_modules.get(this.m_thisModule)).getQueue();
    }

    HeapPriorityQueue getQueue(Object object) throws JessException {
        this.verifyModule(object);
        return ((Defmodule)this.m_modules.get(object)).getQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Activation getNextActivation(Rete rete) throws JessException {
        Object object = this.m_activationSemaphore;
        synchronized (object) {
            Stack stack = this.m_focusStack;
            synchronized (stack) {
                if (this.m_focusStack.empty()) {
                    return this.getQueue("MAIN").pop();
                }
                while (!this.m_focusStack.empty()) {
                    HeapPriorityQueue heapPriorityQueue = this.getQueue(this.m_focusStack.peek());
                    Activation activation = heapPriorityQueue.pop();
                    if (activation != null) {
                        return activation;
                    }
                    Object e = this.m_focusStack.pop();
                    rete.broadcastEvent(-2146435072, e, null);
                    if (this.getFocus().equals(e)) continue;
                    rete.broadcastEvent(0x100000, this.getFocus(), null);
                }
                return this.getQueue("MAIN").pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Activation peekNextActivation(Rete rete) throws JessException {
        Object object = this.m_activationSemaphore;
        synchronized (object) {
            Stack stack = this.m_focusStack;
            synchronized (stack) {
                if (this.m_focusStack.empty()) {
                    return this.getQueue("MAIN").peek();
                }
                while (!this.m_focusStack.empty()) {
                    HeapPriorityQueue heapPriorityQueue = this.getQueue(this.m_focusStack.peek());
                    Activation activation = heapPriorityQueue.peek();
                    if (activation != null) {
                        return activation;
                    }
                    Object e = this.m_focusStack.pop();
                    rete.broadcastEvent(-2146435072, e, null);
                    if (this.getFocus().equals(e)) continue;
                    rete.broadcastEvent(0x100000, this.getFocus(), null);
                }
                return this.getQueue("MAIN").peek();
            }
        }
    }

    Iterator listActivations() {
        return this.getQueue().iterator();
    }

    Iterator listActivations(String string) throws JessException {
        return this.getQueue(string).iterator();
    }

    Iterator listModules() {
        return this.m_modules.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActivation(Activation activation) {
        Object object = this.m_activationSemaphore;
        synchronized (object) {
            this.m_toAdd.add(activation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeActivation(Activation activation) {
        Object object = this.m_activationSemaphore;
        synchronized (object) {
            if (activation.getIndex() == -1) {
                this.m_toAdd.remove(activation);
            } else {
                this.m_toRemove.add(activation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitActivations(Rete rete) throws JessException {
        Object object = this.m_activationSemaphore;
        synchronized (object) {
            if (this.m_toAdd.size() == 0 && this.m_toRemove.size() == 0) {
                return;
            }
            try {
                Activation activation;
                Iterator iterator = this.m_toRemove.iterator();
                while (iterator.hasNext()) {
                    activation = (Activation)iterator.next();
                    if (activation.getIndex() <= -1) continue;
                    this.getQueue(activation.getModule()).remove(activation);
                }
                iterator = this.m_toAdd.iterator();
                while (iterator.hasNext()) {
                    activation = (Activation)iterator.next();
                    if (this.m_evalSalience != 0) {
                        activation.evalSalience(rete);
                    }
                    this.getQueue(activation.getModule()).push(activation);
                    if (!activation.getAutoFocus()) continue;
                    this.setFocus(activation.getModule(), rete);
                }
                Object var6_5 = null;
                if (this.m_toAdd.size() > 0) {
                    this.m_activationSemaphore.notifyAll();
                }
                this.m_toAdd.clear();
                this.m_toRemove.clear();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (this.m_toAdd.size() > 0) {
                    this.m_activationSemaphore.notifyAll();
                }
                this.m_toAdd.clear();
                this.m_toRemove.clear();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForActivations() {
        try {
            Object object = this.m_activationSemaphore;
            synchronized (object) {
                if (this.getQueue().isEmpty()) {
                    this.m_activationSemaphore.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    Strategy getStrategy() {
        return this.m_strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String setStrategy(Strategy strategy, Rete rete) throws JessException {
        String string = null;
        try {
            Iterator iterator = this.m_modules.values().iterator();
            while (iterator.hasNext()) {
                Defmodule defmodule = (Defmodule)iterator.next();
                string = defmodule.setStrategy(strategy, rete);
            }
        }
        finally {
            rete.commitActivations();
        }
        this.m_strategy = strategy;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void halt() {
        Object object = this.m_activationSemaphore;
        synchronized (object) {
            this.m_halt = true;
            this.m_activationSemaphore.notifyAll();
        }
    }

    public boolean isHalted() {
        return this.m_halt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int runUntilHalt(Rete rete, Context context) throws JessException {
        int n = 0;
        while (true) {
            n += this.run(rete, context);
            Object object = this.m_activationSemaphore;
            synchronized (object) {
                if (this.m_halt) {
                    break;
                }
                this.waitForActivations();
                if (this.m_halt) {
                    break;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int run(Rete rete, Context context) throws JessException {
        int n;
        int n2 = 0;
        do {
            n = this.run(Integer.MAX_VALUE, rete, context);
            n2 += n;
            Object object = this.m_activationSemaphore;
            synchronized (object) {
                if (this.m_halt) {
                    break;
                }
            }
        } while (n > 0);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int run(int n, Rete rete, Context context) throws JessException {
        Activation activation;
        int n2 = 0;
        this.m_halt = false;
        while (n2 < n && (activation = this.getNextActivation(rete)) != null) {
            if (!activation.isInactive()) {
                activation.setSequenceNumber(++n2);
                rete.broadcastEvent(2, activation, null);
                try {
                    rete.aboutToFire(activation);
                    this.m_thisActivation = activation;
                    activation.fire(rete, context);
                }
                finally {
                    this.m_thisActivation = null;
                    rete.justFired(activation);
                }
                if (this.m_evalSalience == 2) {
                    this.setStrategy(this.getQueue().getStrategy(), rete);
                }
            }
            Object object = this.m_activationSemaphore;
            synchronized (object) {
                if (this.m_halt) {
                    break;
                }
            }
        }
        return n2;
    }

    String getCurrentModule() {
        return this.m_thisModule;
    }

    Defmodule getModule(String string) throws JessException {
        this.verifyModule(string);
        return (Defmodule)this.m_modules.get(string);
    }

    Iterator listFocusStack() {
        return this.m_focusStack.iterator();
    }

    void clearFocusStack() {
        this.m_focusStack.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getFocus() {
        Stack stack = this.m_focusStack;
        synchronized (stack) {
            if (this.m_focusStack.empty()) {
                return "MAIN";
            }
            return (String)this.m_focusStack.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String popFocus(Rete rete, String string) throws JessException {
        Stack stack = this.m_focusStack;
        synchronized (stack) {
            if (this.m_focusStack.empty()) {
                return "MAIN";
            }
            if (string != null && !string.equals(this.getFocus())) {
                return string;
            }
            String string2 = (String)this.m_focusStack.pop();
            rete.broadcastEvent(-2146435072, string2, null);
            rete.broadcastEvent(0x100000, this.getFocus(), null);
            return string2;
        }
    }

    void setFocus(String string, Rete rete) throws JessException {
        if (this.getFocus().equals(string)) {
            return;
        }
        this.verifyModule(string);
        rete.broadcastEvent(-2146435072, this.getFocus(), null);
        rete.broadcastEvent(0x100000, string, null);
        this.m_focusStack.push(string);
    }

    String setCurrentModule(String string) throws JessException {
        String string2 = this.m_thisModule;
        this.verifyModule(string);
        this.m_thisModule = string;
        return string2;
    }

    void addDefmodule(Defmodule defmodule, Rete rete) throws JessException {
        if (this.m_modules.get(defmodule.getName()) != null) {
            throw new JessException("Agenda.addDefmodule", "Attempt to redefine defmodule", defmodule.getName());
        }
        this.m_thisModule = defmodule.getName();
        this.m_modules.put(defmodule.getName(), defmodule);
        defmodule.setStrategy(this.m_strategy, rete);
    }

    void verifyModule(Object object) throws JessException {
        if (this.m_modules.get(object) == null) {
            throw new JessException("Agenda.verifyModule", "Undefined module", object.toString());
        }
    }

    String resolveName(String string) {
        if (string.indexOf("::") == -1) {
            string = RU.scopeName(this.getCurrentModule(), string);
        }
        return string;
    }

    Activation getThisActivation() {
        return this.m_thisActivation;
    }
}

