/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.player;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;
import javazoom.jl.player.ThreadedPlayer;

public class SimpleMp3Player {
    private ThreadedPlayer player = null;
    private Thread playerThread = null;

    public SimpleMp3Player() {
        System.out.println("Creating mp3 player..\n");
    }

    public void play(String string) {
        if (this.player != null) {
            this.player.close();
        }
        try {
            InputStream inputStream = this.getInputStream(string);
            AudioDevice audioDevice = this.getAudioDevice();
            this.player = new ThreadedPlayer(inputStream, audioDevice);
            this.playerThread = new Thread(this.player);
            this.playerThread.start();
            System.out.println("Playing " + string + "...");
        }
        catch (Exception exception) {
            System.out.println("Problem playing..." + string);
        }
    }

    public void pause() {
        if (this.player != null && this.playerThread.isAlive()) {
            this.player.pause();
        }
    }

    public void stop() {
        if (this.player != null) {
            this.player.stop();
        }
        this.player = null;
    }

    private InputStream getInputStream(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        return bufferedInputStream;
    }

    private AudioDevice getAudioDevice() throws JavaLayerException {
        return FactoryRegistry.systemRegistry().createAudioDevice();
    }
}

