/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import configuration.TConfiguration;
import configuration.TLanguage;
import database.DBTasks;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ImportDatabaseFrame
extends JFrame {
    private JPanel contentPane;
    private JTextField textFieldPath;
    private JProgressBar progressBarStatus;
    private JFrame mainFrame;
    private JCheckBox chckbxReemplazar;
    private JButton btnNewButton_1;
    private String pathToImport;
    private Date releaseDate;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ImportDatabaseFrame frame = new ImportDatabaseFrame();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public ImportDatabaseFrame(String pathToImport, Date releaseDate) {
        this.pathToImport = pathToImport;
        this.releaseDate = releaseDate;
        this.init();
    }

    public ImportDatabaseFrame() {
        this.init();
    }

    private void init() {
        TLanguage.initLanguage(TConfiguration.getLanguage());
        this.mainFrame = this;
        this.setTitle(TLanguage.getString("IMPORT_DATABASE_FRAME.TITLE"));
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 450, 210);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), TLanguage.getString("IMPORT_DATABASE_FRAME.SELECT_SOURCE_FILE"), 4, 2, null, new Color(0, 0, 0)));
        this.contentPane.add(panel);
        panel.setLayout(new FlowLayout(1, 5, 5));
        JButton btnNewButton = new JButton(TLanguage.getString("IMPORT_DATABASE_FRAME.SELECT"));
        btnNewButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                JFileChooser f = new JFileChooser();
                f.setFileSelectionMode(1);
                int returnVal = f.showOpenDialog(ImportDatabaseFrame.this.contentPane);
                if (returnVal == 0) {
                    ImportDatabaseFrame.this.textFieldPath.setText(f.getSelectedFile().getAbsolutePath());
                }
            }
        });
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
            }
        });
        panel.add(btnNewButton);
        this.textFieldPath = new JTextField();
        if (this.pathToImport != null) {
            this.textFieldPath.setText(this.pathToImport);
            btnNewButton.setEnabled(false);
        }
        this.textFieldPath.setEditable(false);
        panel.add(this.textFieldPath);
        this.textFieldPath.setColumns(24);
        JPanel panel_3 = new JPanel();
        this.contentPane.add(panel_3);
        panel_3.setLayout(new FlowLayout(1, 5, 5));
        this.chckbxReemplazar = new JCheckBox(TLanguage.getString("IMPORT_DATABASE_FRAME.REPLACE"));
        panel_3.add(this.chckbxReemplazar);
        if (this.pathToImport != null) {
            this.chckbxReemplazar.setSelected(true);
            this.chckbxReemplazar.setEnabled(false);
        }
        JPanel panel_1 = new JPanel();
        this.contentPane.add(panel_1);
        this.btnNewButton_1 = new JButton(TLanguage.getString("IMPORT_DATABASE_FRAME.IMPORT"));
        if (this.pathToImport != null) {
            this.btnNewButton_1.setEnabled(false);
        }
        this.btnNewButton_1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (ImportDatabaseFrame.this.textFieldPath.getText().equals("")) {
                    JOptionPane.showMessageDialog(ImportDatabaseFrame.this.contentPane, TLanguage.getString("IMPORT_DATABASE_FRAME.DIRECTORY_MUST_BE_SELECTED_WARNING"));
                } else {
                    ImportDatabaseFrame.this.launchImport();
                }
            }
        });
        panel_1.setLayout(new FlowLayout(1, 5, 5));
        panel_1.add(this.btnNewButton_1);
        JPanel panel_2 = new JPanel();
        this.contentPane.add(panel_2);
        this.progressBarStatus = new JProgressBar();
        this.progressBarStatus.setPreferredSize(new Dimension(420, 30));
        panel_2.add(this.progressBarStatus);
    }

    public void launchImportFromUpdate() {
        this.launchImport();
    }

    private void launchImport() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ImportDatabaseFrame.this.mainFrame.setEnabled(false);
                try {
                    DBTasks.importDB(ImportDatabaseFrame.this.textFieldPath.getText(), ImportDatabaseFrame.this.progressBarStatus, ImportDatabaseFrame.this.chckbxReemplazar.isSelected());
                    JOptionPane.showMessageDialog(ImportDatabaseFrame.this.contentPane, TLanguage.getString("IMPORT_DATABASE_FRAME.IMPORT_OK"));
                    ImportDatabaseFrame.this.mainFrame.setEnabled(true);
                    if (ImportDatabaseFrame.this.pathToImport != null) {
                        SimpleDateFormat ft = new SimpleDateFormat("dd-MM-yyyy");
                        TConfiguration.setProperty("dbReleaseDate", ft.format(ImportDatabaseFrame.this.releaseDate));
                    }
                    ImportDatabaseFrame.this.mainFrame.dispose();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(ImportDatabaseFrame.this.contentPane, TLanguage.getString("IMPORT_DATABASE_FRAME.IMPORT_ERROR"));
                    ImportDatabaseFrame.this.mainFrame.dispose();
                }
            }
        });
        t.start();
    }
}

