/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import configuration.TConfiguration;
import configuration.TLanguage;
import database.DBTasks;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ExportDatabaseFrame
extends JFrame {
    private JPanel contentPane;
    private JTextField textFieldPath;
    private JProgressBar progressBarStatus;
    private JFrame mainFrame;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ExportDatabaseFrame frame = new ExportDatabaseFrame();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public ExportDatabaseFrame() {
        TLanguage.initLanguage(TConfiguration.getLanguage());
        this.mainFrame = this;
        this.setTitle(TLanguage.getString("EXPORT_DATABASE_FRAME.TITLE"));
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 450, 176);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), TLanguage.getString("EXPORT_DATABASE_FRAME.SELECT_DESTINATION_PATH"), 4, 2, null, new Color(0, 0, 0)));
        this.contentPane.add(panel);
        panel.setLayout(new FlowLayout(1, 5, 5));
        JButton btnNewButton = new JButton(TLanguage.getString("EXPORT_DATABASE_FRAME.SELECT"));
        btnNewButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                JFileChooser f = new JFileChooser();
                f.setFileSelectionMode(1);
                int returnVal = f.showOpenDialog(ExportDatabaseFrame.this.contentPane);
                if (returnVal == 0) {
                    ExportDatabaseFrame.this.textFieldPath.setText(f.getSelectedFile().getAbsolutePath());
                }
            }
        });
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
            }
        });
        panel.add(btnNewButton);
        this.textFieldPath = new JTextField();
        this.textFieldPath.setEditable(false);
        panel.add(this.textFieldPath);
        this.textFieldPath.setColumns(24);
        JPanel panel_1 = new JPanel();
        this.contentPane.add(panel_1);
        JButton btnNewButton_1 = new JButton(TLanguage.getString("EXPORT_DATABASE_FRAME.EXPORT"));
        btnNewButton_1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (ExportDatabaseFrame.this.textFieldPath.getText().equals("")) {
                    JOptionPane.showMessageDialog(ExportDatabaseFrame.this.contentPane, TLanguage.getString("EXPORT_DATABASE_FRAME.DIRECTORY_MUST_BE_SELECTED_WARNING"));
                } else {
                    System.out.println("Exporting to " + ExportDatabaseFrame.this.textFieldPath.getText());
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ExportDatabaseFrame.this.mainFrame.setEnabled(false);
                            DBTasks.exportDB(ExportDatabaseFrame.this.textFieldPath.getText(), ExportDatabaseFrame.this.progressBarStatus);
                            JOptionPane.showMessageDialog(ExportDatabaseFrame.this.contentPane, TLanguage.getString("EXPORT_DATABASE_FRAME.EXPORT_OK"));
                            ExportDatabaseFrame.this.mainFrame.setEnabled(true);
                        }
                    });
                    t.start();
                }
            }
        });
        panel_1.setLayout(new FlowLayout(1, 5, 5));
        panel_1.add(btnNewButton_1);
        JPanel panel_2 = new JPanel();
        this.contentPane.add(panel_2);
        this.progressBarStatus = new JProgressBar();
        this.progressBarStatus.setPreferredSize(new Dimension(420, 30));
        panel_2.add(this.progressBarStatus);
    }
}

