/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import components.ThumbnailPanel;
import configuration.TConfiguration;
import configuration.TLanguage;
import database.DB;
import database.DBTasks;
import database.ImageManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class AddImageFrame
extends JDialog {
    private JPanel contentPane;
    private JTextField imageTextField;
    private JPanel panel_1;
    private DefaultTableModel termTableModel;
    private JButton addRowTable;
    private JButton removeRowTable;
    private JTable termTable;
    private boolean replaceImage = false;
    private AddImageFrame mainFrame;
    private String nameNN = null;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AddImageFrame frame = new AddImageFrame();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public AddImageFrame() {
        this.init();
    }

    public AddImageFrame(String nameNN) {
        this.nameNN = nameNN;
        this.init();
    }

    public void init() {
        TLanguage.initLanguage(TConfiguration.getLanguage());
        this.mainFrame = this;
        if (this.nameNN == null) {
            this.setTitle(TLanguage.getString("ADD_IMAGE_FRAME.TITLE"));
        } else {
            this.setTitle(String.valueOf(TLanguage.getString("ADD_IMAGE_FRAME.EDIT_IMAGE_TITLE")) + " " + this.nameNN);
        }
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 450, 300);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(null, TLanguage.getString("ADD_IMAGE_FRAME.IMAGE"), 4, 2, null, null));
        this.contentPane.add(panel);
        this.imageTextField = new JTextField();
        this.imageTextField.setEditable(false);
        this.imageTextField.setColumns(24);
        JButton btnSeleccionar = new JButton(TLanguage.getString("ADD_IMAGE_FRAME.SELECT"));
        if (this.nameNN != null) {
            btnSeleccionar.setEnabled(false);
        }
        btnSeleccionar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser chooser = new JFileChooser();
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Images", "jpg", "gif", "png");
                chooser.setFileFilter(filter);
                ThumbnailPanel preview = new ThumbnailPanel(chooser);
                chooser.addPropertyChangeListener(preview);
                chooser.setAccessory(preview);
                int returnVal = chooser.showOpenDialog(AddImageFrame.this.contentPane);
                if (returnVal == 0) {
                    AddImageFrame.this.imageTextField.setText(chooser.getSelectedFile().getAbsolutePath());
                    try {
                        DB db = DB.getInstance();
                        PreparedStatement s = db.prepareStatement("SELECT word, language.name AS language, type.name AS type FROM main, language, type WHERE main.name = ? AND main.idL = language.id AND main.idT = type.id");
                        s.setString(1, new File(chooser.getSelectedFile().getAbsolutePath()).getName());
                        ResultSet rs = s.executeQuery();
                        if (rs.isBeforeFirst()) {
                            int i = JOptionPane.showConfirmDialog(null, TLanguage.getString("ADD_IMAGE_FRAME.REPLACE_IMAGE_WARNING"), TLanguage.getString("ADD_IMAGE_FRAME.REPLACE_IMAGE_WARNING_TITLE"), 0);
                            AddImageFrame.this.replaceImage = i == 0;
                        }
                        while (rs.next() && AddImageFrame.this.replaceImage) {
                            Object[] row = new Object[]{rs.getString("word"), rs.getString("language"), rs.getString("type")};
                            AddImageFrame.this.termTableModel.addRow(row);
                        }
                        AddImageFrame.this.removeRowTable.setEnabled(true);
                        AddImageFrame.this.addRowTable.setEnabled(true);
                        db.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        GroupLayout gl_panel = new GroupLayout(panel);
        gl_panel.setHorizontalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addGap(3).addComponent(this.imageTextField, -2, -1, -2).addGap(5).addComponent(btnSeleccionar)));
        gl_panel.setVerticalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addGap(5).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imageTextField, -2, -1, -2).addComponent(btnSeleccionar))));
        panel.setLayout(gl_panel);
        this.panel_1 = new JPanel();
        this.panel_1.setBorder(new TitledBorder(null, TLanguage.getString("ADD_IMAGE_FRAME.ASSOCIATED_TERMS"), 4, 2, null, null));
        this.contentPane.add(this.panel_1);
        Object[] columnNames = new Object[]{TLanguage.getString("ADD_IMAGE_FRAME.TERM"), TLanguage.getString("ADD_IMAGE_FRAME.LANGUAGE"), TLanguage.getString("ADD_IMAGE_FRAME.TYPE")};
        this.termTableModel = new DefaultTableModel(null, columnNames);
        this.panel_1.setLayout(new BorderLayout(0, 0));
        this.termTable = new JTable(this.termTableModel);
        TableColumn languageColumn = this.termTable.getColumnModel().getColumn(1);
        JComboBox<String> comboBox = new JComboBox<String>();
        try {
            DB db = DB.getInstance();
            ResultSet rs = db.query("SELECT name FROM language ORDER BY id ASC");
            while (rs.next()) {
                comboBox.addItem(rs.getString("name"));
            }
            db.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        languageColumn.setCellEditor(new DefaultCellEditor(comboBox));
        TableColumn typeColumn = this.termTable.getColumnModel().getColumn(2);
        JComboBox<String> comboBox1 = new JComboBox<String>();
        try {
            DB db = DB.getInstance();
            ResultSet rs = db.query("SELECT name FROM type ORDER BY id ASC");
            while (rs.next()) {
                comboBox1.addItem(rs.getString("name"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        typeColumn.setCellEditor(new DefaultCellEditor(comboBox1));
        this.termTable.setSelectionMode(0);
        this.termTable.setBackground(Color.WHITE);
        this.termTable.setGridColor(Color.GRAY);
        this.termTable.setSize(new Dimension(100, 200));
        JScrollPane scrollPane = new JScrollPane(this.termTable);
        this.panel_1.add(scrollPane);
        JPanel panel_2 = new JPanel();
        this.panel_1.add((Component)panel_2, "South");
        this.removeRowTable = new JButton(TLanguage.getString("ADD_IMAGE_FRAME.REMOVE_IMAGE_BUTTON"));
        this.removeRowTable.setToolTipText(TLanguage.getString("ADD_IMAGE_FRAME.REMOVE_ROW_TOOLTIP"));
        this.removeRowTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AddImageFrame.this.termTableModel.removeRow(AddImageFrame.this.termTable.getSelectedRow());
            }
        });
        this.removeRowTable.setEnabled(false);
        this.addRowTable = new JButton(TLanguage.getString("ADD_IMAGE_FRAME.ADD_IMAGE_BUTTON"));
        this.addRowTable.setEnabled(false);
        this.addRowTable.setToolTipText(TLanguage.getString("ADD_IMAGE_FRAME.ADD_ROW_TOOLTIP"));
        this.addRowTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (AddImageFrame.this.nameNN == null && AddImageFrame.this.imageTextField.getText().equals("")) {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("ADD_IMAGE_FRAME.IMAGE_NOT_SELECTED_WARNING"), TLanguage.getString("ADD_IMAGE_FRAME.IMAGE_NOT_SELECTED_WARNING_TITLE"), 2);
                } else {
                    AddImageFrame.this.termTableModel.addRow(new Object[0]);
                }
            }
        });
        FlowLayout fl_panel_2 = new FlowLayout(2, 5, 5);
        panel_2.setLayout(fl_panel_2);
        panel_2.add(this.addRowTable);
        panel_2.add(this.removeRowTable);
        JPanel panel_3 = new JPanel();
        this.contentPane.add(panel_3);
        JButton btnNewButton = new JButton(TLanguage.getString("ADD_IMAGE_FRAME.SAVE_CHANGES"));
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Vector<Vector> termData = AddImageFrame.this.termTableModel.getDataVector();
                    if (termData.size() > 0) {
                        Iterator<Vector> i = termData.iterator();
                        boolean incorrectTable = false;
                        while (i.hasNext() && !incorrectTable) {
                            Vector term = i.next();
                            if (!term.get(0).equals("") && !term.get(1).equals("") && !term.get(2).equals("")) continue;
                            incorrectTable = true;
                        }
                        if (incorrectTable) {
                            JOptionPane.showMessageDialog(null, TLanguage.getString("ADD_IMAGE_FRAME.ALL_TERMS_ASSIGNED_WARNING"), TLanguage.getString("ADD_IMAGE_FRAME.ALL_TERMS_ASSIGNED_WARNING_TITLE"), 2);
                        } else {
                            if (AddImageFrame.this.nameNN == null) {
                                String imageFileName;
                                if (AddImageFrame.this.replaceImage) {
                                    imageFileName = AddImageFrame.this.imageTextField.getText().substring(AddImageFrame.this.imageTextField.getText().lastIndexOf(File.separator) + 1);
                                    ImageManager.delete(imageFileName);
                                    ImageManager.add(AddImageFrame.this.imageTextField.getText());
                                } else {
                                    imageFileName = ImageManager.add(AddImageFrame.this.imageTextField.getText());
                                }
                                AddImageFrame.this.saveChanges(imageFileName);
                            } else {
                                AddImageFrame.this.saveChanges(AddImageFrame.this.nameNN);
                            }
                            JOptionPane.showMessageDialog(null, TLanguage.getString("ADD_IMAGE_FRAME.CHANGES_DONE_WARNING"), TLanguage.getString("ADD_IMAGE_FRAME.CHANGES_DONE_WARNING_TITLE"), 1);
                            AddImageFrame.this.mainFrame.dispose();
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, TLanguage.getString("ADD_IMAGE_FRAME.IMAGE_NOT_SELECTED_WARNING"), TLanguage.getString("ADD_IMAGE_FRAME.IMAGE_NOT_SELECTED_WARNING_TITLE"), 2);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
        panel_3.add(btnNewButton);
        JButton btnCancelar = new JButton(TLanguage.getString("ADD_IMAGE_FRAME.CANCEL_CHANGES"));
        btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AddImageFrame.this.mainFrame.dispose();
            }
        });
        panel_3.add(btnCancelar);
        if (this.nameNN != null) {
            JButton btnEliminar = new JButton(TLanguage.getString("ADD_IMAGE_FRAME.REMOVE_IMAGE"));
            btnEliminar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int i = JOptionPane.showConfirmDialog(null, TLanguage.getString("ADD_IMAGE_FRAME.REMOVE_IMAGE"), TLanguage.getString("ADD_IMAGE_FRAME.IMAGE_NOT_SELECTED_WARNING_TITLE"), 0);
                    if (i == 0) {
                        String query = "DELETE FROM main WHERE nameNN LIKE '" + AddImageFrame.this.nameNN + "'";
                        try {
                            DB.getInstance().update(query);
                            ImageManager.delete(AddImageFrame.this.nameNN);
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        AddImageFrame.this.dispose();
                    }
                }
            });
            panel_3.add(btnEliminar);
        }
        if (this.nameNN != null) {
            try {
                DB db = DB.getInstance();
                PreparedStatement s = db.prepareStatement("SELECT word, language.name AS language, type.name AS type FROM main, language, type WHERE main.name = ? AND main.idL = language.id AND main.idT = type.id");
                s.setString(1, this.nameNN);
                ResultSet rs = s.executeQuery();
                while (rs.next()) {
                    Object[] row = new Object[]{rs.getString("word"), rs.getString("language"), rs.getString("type")};
                    this.termTableModel.addRow(row);
                }
                this.removeRowTable.setEnabled(true);
                this.addRowTable.setEnabled(true);
                db.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void saveChanges(String imageFileName) throws SQLException {
        String query = "DELETE FROM main WHERE name = '" + imageFileName + "'";
        DB db = DB.getInstance();
        db.update(query);
        db.close();
        Vector<Vector> termData = this.termTableModel.getDataVector();
        termData = this.termTableModel.getDataVector();
        for (Vector term : termData) {
            DBTasks.addImageDB(imageFileName, (String)term.get(1), (String)term.get(2), (String)term.get(0));
        }
    }
}

