/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import components.Updater;
import configuration.TConfiguration;
import configuration.TLanguage;
import dialogs.ImportDatabaseFrame;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class UpdaterFrame
extends JFrame {
    private JPanel contentPane;
    private JFrame mainFrame;
    private Updater u;
    private JProgressBar progressBar;
    private JButton btnCancel;
    private JButton btnUpdate;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UpdaterFrame updaterFrame = new UpdaterFrame();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public UpdaterFrame() {
        try {
            Date lastImportedDate;
            this.u = new Updater();
            this.u.launchUpdate();
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
            Date releaseDate = sdf.parse(this.u.getProperty("RELEASE_DATE"));
            Date date = lastImportedDate = TConfiguration.getProperty("dbReleaseDate") != null ? sdf.parse(TConfiguration.getProperty("dbReleaseDate")) : null;
            if (lastImportedDate == null || releaseDate.after(lastImportedDate)) {
                this.init();
                this.setVisible(true);
            } else {
                TLanguage.initLanguage(TConfiguration.getLanguage());
                JOptionPane.showMessageDialog(this.mainFrame, TLanguage.getString("UPDATER_FRAME.LAST_VERSION_ALREADY_INSTALLED"));
                this.dispose();
            }
        }
        catch (Exception e) {
            TLanguage.initLanguage(TConfiguration.getLanguage());
            JOptionPane.showMessageDialog(this.mainFrame, TLanguage.getString("UPDATER_FRAME.ERROR_MESSAGE"));
            this.dispose();
        }
    }

    private void init() {
        TLanguage.initLanguage(TConfiguration.getLanguage());
        this.mainFrame = this;
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 450, 300);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        JPanel panel_1 = new JPanel();
        this.contentPane.add(panel_1);
        panel_1.setLayout(new FlowLayout(1, 5, 5));
        JLabel lblThereIsA = new JLabel(TLanguage.getString("UPDATER_FRAME.INFORMATION"));
        panel_1.add(lblThereIsA);
        JPanel panel = new JPanel();
        this.contentPane.add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        panel.add(scrollPane);
        JTextArea changeLog = new JTextArea();
        scrollPane.setViewportView(changeLog);
        changeLog.setLineWrap(true);
        changeLog.setRows(6);
        String text = this.u.getProperty("CHANGELOG");
        changeLog.setText(text);
        changeLog.setEditable(false);
        changeLog.setColumns(34);
        JPanel panel_2 = new JPanel();
        this.contentPane.add(panel_2);
        this.btnCancel = new JButton(TLanguage.getString("UPDATER_FRAME.CANCEL"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UpdaterFrame.this.mainFrame.dispose();
            }
        });
        this.btnUpdate = new JButton(TLanguage.getString("UPDATER_FRAME.UPDATE"));
        this.btnUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UpdaterFrame.this.mainFrame.setEnabled(false);
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        UpdaterFrame.this.doUpdate(UpdaterFrame.this.progressBar);
                    }
                });
                t.start();
            }
        });
        panel_2.setLayout(new FlowLayout(1, 5, 5));
        panel_2.add(this.btnCancel);
        JLabel label = new JLabel("");
        panel_2.add(label);
        panel_2.add(this.btnUpdate);
        JPanel panel_3 = new JPanel();
        this.contentPane.add(panel_3);
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(420, 30));
        panel_3.add(this.progressBar);
    }

    private void doUpdate(JProgressBar progressBar) {
        this.mainFrame.setEnabled(false);
        try {
            String pathToImport = this.u.performUpdate(progressBar);
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
            Date releaseDate = sdf.parse(this.u.getProperty("RELEASE_DATE"));
            ImportDatabaseFrame f = new ImportDatabaseFrame(pathToImport, releaseDate);
            f.setLocationRelativeTo(null);
            f.pack();
            f.setVisible(true);
            f.launchImportFromUpdate();
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    UpdaterFrame.this.mainFrame.dispose();
                    UpdaterFrame.this.u.removeTempFolder();
                }
            });
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.mainFrame, TLanguage.getString("UPDATER_FRAME.ERROR_MESSAGE"));
            this.dispose();
        }
        this.mainFrame.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.btnCancel.setEnabled(b);
        this.btnUpdate.setEnabled(b);
    }
}

